/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.models;

import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI;
import com.jurismarches.vradi.ui.helpers.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.models.ModifModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.treetable.NavigationTreeTableNode;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ModifThesaurusModel
extends ModifModel<ModifThesaurus> {
    static String I18N_PATTERN = "vradi.thesaurus.attribute.";
    private static final Log log = LogFactory.getLog(ModifThesaurusModel.class);
    protected JAXXContext context;
    protected ThesaurusTreeHelper helper;
    protected Map<String, AttributeModif> cachedAttributeModif = new HashMap<String, AttributeModif>();
    protected LinkedHashMap<String, ModifThesaurus> cachedModif = new LinkedHashMap();

    public ModifThesaurusModel(JAXXContext context, ThesaurusTreeHelper helper) {
        this.context = context;
        this.helper = helper;
    }

    public CreateModif addCreateModif(VradiThesaurusDTO created) {
        CreateModif createdModif = new CreateModif(created);
        this.add(createdModif);
        this.findLinkedModif(createdModif);
        this.cachedModif.put(created.getPath(this.helper.getPathSeparator()), createdModif);
        return createdModif;
    }

    public DeleteModif addDeleteModif(VradiThesaurusDTO deleted) {
        DeleteModif deleteModif = new DeleteModif(deleted);
        this.add(deleteModif);
        DeleteModif lastDeleteModif = deleteModif;
        for (VradiThesaurusDTO child : deleted.getChildren()) {
            lastDeleteModif = this.addDeleteModif(child);
            lastDeleteModif.link(deleteModif);
        }
        this.cachedModif.put(lastDeleteModif.getConcernedThesaurus().getPath(this.helper.getPathSeparator()), lastDeleteModif);
        return deleteModif;
    }

    public MoveModif addMoveModif(VradiThesaurusDTO moved, String parentNamePath, String parentPath, String newPath) {
        MoveModif moveModif = new MoveModif(moved, parentNamePath, parentPath, newPath);
        this.add(moveModif);
        this.findLinkedModif(moveModif);
        this.cachedModif.put(newPath, moveModif);
        return moveModif;
    }

    protected void findLinkedModif(ModifThesaurus toCheck) {
        ArrayList<String> keyList = new ArrayList<String>(this.cachedModif.keySet());
        Collections.reverse(keyList);
        for (String oldParentPath : keyList) {
        }
    }

    public String getAllMsgs() {
        StringBuffer buf = new StringBuffer();
        for (ModifThesaurus m : this.values) {
            buf.append(m.getMsg()).append("\n");
        }
        return buf.toString();
    }

    protected boolean askToCancelModifLinked(ModifThesaurus modif) {
        if (!modif.isLinked()) {
            return true;
        }
        ModifThesaurus linked = modif.getLink();
        int result = 2;
        result = JOptionPane.showConfirmDialog((Component)((Object)((AdminThesaurusUI)this.context)), I18n._((String)"vradi.thesaurus.askRevertModifThesaurus", (Object[])new Object[]{linked.getMsg()}));
        if (result == 1 || result == 2) {
            return false;
        }
        if (!linked.revert()) {
            return false;
        }
        this.remove(linked);
        return true;
    }

    public AttributeModif prepareAttributeModif(VradiThesaurusDTO modif, String attributeName, String oldValue) {
        AttributeModif oldModif = this.cachedAttributeModif.get(attributeName);
        if (oldModif != null) {
            oldValue = oldModif.getOldValue();
        }
        this.cachedAttributeModif.put(attributeName, new AttributeModif(modif, attributeName, oldValue));
        return oldModif;
    }

    public void confirmAttributeModif() {
        this.addAll(this.cachedAttributeModif.values());
        this.cachedAttributeModif.clear();
    }

    public void cancelAttributeModif() {
        this.cachedAttributeModif.clear();
    }

    protected VradiThesaurusDTO getConcernedThesaurus(int index) {
        ModifThesaurus value = (ModifThesaurus)this.get(index);
        return value.getConcernedThesaurus();
    }

    public List<VradiThesaurusDTO> getConcernedThesaurus(int[] index) {
        ArrayList<VradiThesaurusDTO> result = new ArrayList<VradiThesaurusDTO>();
        for (int i : index) {
            result.add(this.getConcernedThesaurus(i));
        }
        return result;
    }

    public class AttributeModif
    extends ModifThesaurus {
        protected VradiThesaurusDTO modif;
        protected String attributeName;
        protected String oldValue;
        protected String newValue;

        public AttributeModif(VradiThesaurusDTO modif, String attributeName, String oldValue) {
            this.modif = modif;
            this.attributeName = attributeName;
            this.oldValue = oldValue;
            try {
                this.newValue = BeanUtils.getProperty((Object)modif, (String)attributeName);
            }
            catch (Exception e) {
                log.error((Object)("Cant get new value for property " + attributeName + " of " + modif.getName()), (Throwable)e);
            }
        }

        protected String getOldValue() {
            return this.oldValue;
        }

        @Override
        public String getMsg() {
            return I18n._((String)"vradi.thesaurus.attributeModifMsg", (Object[])new Object[]{this.modif.getName(), I18n._((String)(I18N_PATTERN + this.attributeName)), this.oldValue, this.newValue});
        }

        @Override
        public boolean revert() {
            try {
                BeanUtils.setProperty((Object)this.modif, (String)this.attributeName, (Object)this.oldValue);
            }
            catch (Exception e) {
                log.error((Object)("Cant revert for property " + this.attributeName + " of " + this.modif.getName()), (Throwable)e);
                return false;
            }
            String path = this.modif.getPath(ThesaurusHandler.PREFIX_EDIT, ModifThesaurusModel.this.helper.getPathSeparator());
            NavigationNode modifNode = ModifThesaurusModel.this.helper.findNode(ModifThesaurusModel.this.context, path);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Repaint node : " + modifNode.getFullPath()));
            }
            ModifThesaurusModel.this.helper.repaintNode(ModifThesaurusModel.this.context, modifNode);
            ModifThesaurusModel.this.helper.selectNode(ModifThesaurusModel.this.context, modifNode);
            return true;
        }

        @Override
        public VradiThesaurusDTO getConcernedThesaurus() {
            return this.modif;
        }

        @Override
        public boolean canImpactRequest() {
            return this.attributeName.equals("name");
        }
    }

    public class MoveModif
    extends ModifThesaurus {
        VradiThesaurusDTO moved;
        String oldParentNamePath;
        String oldParentPath;
        String newParentPath;

        public MoveModif(VradiThesaurusDTO moved, String oldParentNamePath, String oldParentPath, String newParentPath) {
            this.moved = moved;
            this.oldParentNamePath = oldParentNamePath;
            this.oldParentPath = oldParentPath;
            this.newParentPath = newParentPath;
        }

        @Override
        public String getMsg() {
            return I18n._((String)"vradi.thesaurus.moveModifMsg", (Object[])new Object[]{this.moved.getName(), this.oldParentNamePath, this.moved.getNamePath(ModifThesaurusModel.this.helper.getPathSeparator())});
        }

        @Override
        public boolean revert() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finding old path " + this.oldParentNamePath));
            }
            NavigationTreeTableNode parentNode = (NavigationTreeTableNode)ModifThesaurusModel.this.helper.findNode(ModifThesaurusModel.this.context, this.oldParentPath);
            String path = this.moved.getPath(ThesaurusHandler.PREFIX_EDIT, ModifThesaurusModel.this.helper.getPathSeparator());
            NavigationTreeTableNode movedNode = (NavigationTreeTableNode)ModifThesaurusModel.this.helper.findNode(ModifThesaurusModel.this.context, path);
            if (parentNode == null || movedNode == null) {
                if (log.isDebugEnabled()) {
                    if (parentNode == null) {
                        log.debug((Object)("Cant find parent node " + this.oldParentNamePath));
                    }
                    if (movedNode == null) {
                        log.debug((Object)("Cant find moved node " + path));
                    }
                }
                return false;
            }
            if (!ModifThesaurusModel.this.askToCancelModifLinked(this)) {
                return false;
            }
            ModifThesaurusModel.this.helper.getModel(ModifThesaurusModel.this.context).removeNodeFromParent((NavigationNode)movedNode);
            VradiThesaurusDTO moved = (VradiThesaurusDTO)movedNode.getBean(ModifThesaurusModel.this.context);
            VradiThesaurusDTO oldParent = moved.getParentThesaurus();
            oldParent.removeChild(moved);
            VradiThesaurusDTO newParent = (VradiThesaurusDTO)parentNode.getBean(ModifThesaurusModel.this.context);
            moved.setParentThesaurus(newParent);
            newParent.addChild(moved);
            moved.setToSave(true);
            if (log.isDebugEnabled()) {
                VradiThesaurusDTO parent = (VradiThesaurusDTO)parentNode.getBean(ModifThesaurusModel.this.context);
                log.debug((Object)("Add thesaurus " + moved.getNamePath(ModifThesaurusModel.this.helper.getPathSeparator()) + " to parent " + parent.getNamePath(ModifThesaurusModel.this.helper.getPathSeparator())));
            }
            NavigationTreeTableNode newNode = ModifThesaurusModel.this.helper.getTreeTableBuilder().addThesaurusAndChildrenRecursivly(parentNode, moved);
            ModifThesaurusModel.this.helper.selectNode(ModifThesaurusModel.this.context, (NavigationNode)parentNode);
            return true;
        }

        @Override
        public VradiThesaurusDTO getConcernedThesaurus() {
            return this.moved;
        }

        @Override
        public boolean canImpactRequest() {
            return true;
        }
    }

    public class DeleteModif
    extends ModifThesaurus {
        VradiThesaurusDTO deleted;

        public DeleteModif(VradiThesaurusDTO deleted) {
            this.deleted = deleted;
        }

        @Override
        public String getMsg() {
            return I18n._((String)"vradi.thesaurus.deleteModifMsg", (Object[])new Object[]{this.deleted.getName()});
        }

        @Override
        public boolean revert() {
            NavigationTreeTableNode parentNode;
            String parentPath = this.deleted.getParentThesaurus().getPath(ThesaurusHandler.PREFIX_EDIT, ModifThesaurusModel.this.helper.getPathSeparator());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finding parent " + parentPath + "to add " + this.deleted.getName()));
            }
            if ((parentNode = (NavigationTreeTableNode)ModifThesaurusModel.this.helper.findNode(ModifThesaurusModel.this.context, parentPath)) == null) {
                return false;
            }
            if (!ModifThesaurusModel.this.askToCancelModifLinked(this)) {
                return false;
            }
            NavigationTreeTableNode navigationTreeNode = ModifThesaurusModel.this.helper.getTreeTableBuilder().addThesaurus(ModifThesaurusModel.this.context, parentNode, this.deleted);
            this.deleted.setToDelete(false);
            ModifThesaurusModel.this.helper.selectNode(ModifThesaurusModel.this.context, (NavigationNode)navigationTreeNode);
            return true;
        }

        @Override
        public VradiThesaurusDTO getConcernedThesaurus() {
            return this.deleted;
        }

        @Override
        public boolean canImpactRequest() {
            return true;
        }
    }

    public class CreateModif
    extends ModifThesaurus {
        VradiThesaurusDTO added;

        public CreateModif(VradiThesaurusDTO added) {
            this.added = added;
        }

        @Override
        public String getMsg() {
            return I18n._((String)"vradi.thesaurus.addModifMsg", (Object[])new Object[]{this.added.getName()});
        }

        @Override
        public boolean revert() {
            String path = this.added.getPath(ThesaurusHandler.PREFIX_EDIT, ModifThesaurusModel.this.helper.getPathSeparator());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finding parent " + path + "to add " + this.added.getName()));
            }
            NavigationTreeTableNode node = (NavigationTreeTableNode)ModifThesaurusModel.this.helper.findNode(ModifThesaurusModel.this.context, path);
            if (!ModifThesaurusModel.this.askToCancelModifLinked(this)) {
                return false;
            }
            NavigationTreeTableNode resultNode = (NavigationTreeTableNode)ModifThesaurusModel.this.helper.getTreeTableBuilder().removeChildNode((NavigationNode)node);
            this.added.setToDelete(true);
            return resultNode != null;
        }

        @Override
        public VradiThesaurusDTO getConcernedThesaurus() {
            return this.added;
        }

        @Override
        public boolean canImpactRequest() {
            return false;
        }
    }

    public abstract class ModifThesaurus
    implements ModifModel.Modif {
        protected ModifThesaurus linked;

        public ModifThesaurus getLink() {
            return this.linked;
        }

        public void link(ModifThesaurus linked) {
            this.linked = linked;
        }

        public boolean isLinked() {
            return this.linked != null;
        }

        public abstract VradiThesaurusDTO getConcernedThesaurus();

        public abstract boolean canImpactRequest();
    }
}

