/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.helpers;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.ThesaurusUI;
import com.jurismarches.vradi.ui.VradiComparators;
import com.jurismarches.vradi.ui.admin.ThesaurusPathChooserUI;
import com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.ThesaurusTreeTableModel;
import com.jurismarches.vradi.ui.renderer.ThesaurusHighlighter;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.AbstractNavigationHelper;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationModelBuilder;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.handler.NavigationHandler;
import jaxx.runtime.swing.navigation.handler.NavigationOneClicSelectionHandler;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModel;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModelBuilder;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import jaxx.runtime.swing.navigation.treetable.NavigationTreeTableModel;
import jaxx.runtime.swing.navigation.treetable.NavigationTreeTableModelBuilder;
import jaxx.runtime.swing.navigation.treetable.NavigationTreeTableNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.nuiton.i18n.I18n;

public class ThesaurusTreeHelper
extends AbstractNavigationHelper {
    private static final Log log = LogFactory.getLog(ThesaurusTreeHelper.class);
    public static String PATH_SEPARATOR = "/";
    private static final String THESAURUS_NAME = "vradi.thesaurus.name";
    private static final String THESAURUS_NB_FORMS = "vradi.thesaurus.nbforms";
    private static final String THESAURUS_TAGS = "vradi.thesaurus.tags";
    protected ThesaurusModelBuilder builder;
    protected VradiThesaurusDTO rootThesaurus;
    public JAXXContext context;
    protected String refName;
    protected JAXXContextEntryDef<VradiThesaurusDTO> THESAURUS;
    protected List<String> columnsName;
    protected NavigationModel<?> cachedModel;
    protected TreeSelectionListener listener;
    protected int selectionMode = 0;

    public ThesaurusTreeHelper(JAXXContext context, int selectionMode) {
        this(context, null, null, selectionMode);
    }

    public ThesaurusTreeHelper(JAXXContext context, String refName, int selectionMode) {
        this(context, null, refName, selectionMode);
    }

    public ThesaurusTreeHelper(JAXXContext context, VradiThesaurusDTO rootThesaurus, int selectionMode) {
        this(context, rootThesaurus, null, selectionMode);
    }

    public ThesaurusTreeHelper(JAXXContext context, VradiThesaurusDTO rootThesaurus, String refName, int selectionMode) {
        super(refName == null ? ThesaurusHandler.PREFIX_THESAURUS + rootThesaurus.getWikittyId() : refName);
        this.refName = refName;
        this.context = context;
        this.selectionMode = selectionMode;
        this.columnsName = new ArrayList<String>();
        if (this.isCopy()) {
            this.columnsName.add(I18n._((String)THESAURUS_NAME));
            this.columnsName.add(I18n._((String)THESAURUS_NB_FORMS));
            this.columnsName.add(I18n._((String)THESAURUS_TAGS));
        } else {
            this.columnsName.add("");
        }
        this.rootThesaurus = rootThesaurus != null ? rootThesaurus : (this.isCopy() ? this.getRootRefThesaurus(context).clone() : this.getRootRefThesaurus(context));
        if (this.isCopy()) {
            this.THESAURUS = SwingUtil.newContextEntryDef((String)refName, VradiThesaurusDTO.class);
            this.THESAURUS.setContextValue((JAXXContext)VradiContext.get(), (Object)this.rootThesaurus);
        }
    }

    protected void reloadTreeTable() {
        JXTreeTable treeTable = this.getTreeTable(this.context);
        NavigationNode selected = this.getSelectedNode(this.context);
        String selectedPath = null;
        if (selected != null) {
            VradiThesaurusDTO bean = (VradiThesaurusDTO)selected.getBean();
            selectedPath = bean.getPath(this.getPathSeparator());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Searching node whith path : " + selectedPath));
            }
        }
        treeTable.setTreeTableModel((TreeTableModel)((NavigationTreeTableModel)this.reloadModel()));
        if (selectedPath != null) {
            NavigationTreeTableNode toSelect = (NavigationTreeTableNode)this.findNode(this.context, selectedPath);
            this.selectNode(this.context, (NavigationNode)toSelect);
        }
    }

    protected NavigationModel reloadModel() {
        this.builder = this.isCopy() ? new ThesaurusTreeTableModelBuilder(this.context) : new ThesaurusTreeModelBuilder(this.context);
        Object rootNode = this.builder.buildRoot();
        this.builder.buildChildren(this.context, rootNode);
        this.cachedModel = this.builder.getModel();
        this.setModel(this.context, this.cachedModel);
        if (!this.isCopy()) {
            Map map = (Map)VradiContext.THESAURUS_NAVIGATION_MODEL.getContextValue((JAXXContext)VradiContext.get());
            map.put(this.rootThesaurus.getWikittyId(), this.cachedModel);
            VradiContext.THESAURUS_NAVIGATION_MODEL.setContextValue((JAXXContext)VradiContext.get(), (Object)map);
        }
        return this.cachedModel;
    }

    protected boolean isCopy() {
        return this.refName != null;
    }

    public void registerListener(TreeSelectionListener listener) {
        this.listener = listener;
    }

    public TreeSelectionListener getListener() {
        return this.listener;
    }

    public void desactiveListener() {
        this.getTree(this.context).removeTreeSelectionListener(this.listener);
    }

    public void activeListener() {
        this.getTree(this.context).addTreeSelectionListener(this.listener);
    }

    protected JAXXContextEntryDef<VradiThesaurusDTO> getThesaurusRef() {
        return this.getThesaurusRef(this.isCopy());
    }

    protected VradiThesaurusDTO getRootRefThesaurus(JAXXContext context) {
        return (VradiThesaurusDTO)this.getThesaurusRef(false).getContextValue(context);
    }

    protected JAXXContextEntryDef<VradiThesaurusDTO> getThesaurusRef(boolean copy) {
        if (copy) {
            return this.THESAURUS;
        }
        return VradiContext.getThesaurusEntryDef();
    }

    protected ThesaurusHandler getHandler(JAXXContext context) {
        return UIHelper.getHandler(context, ThesaurusHandler.class);
    }

    public ThesaurusModelBuilder<?> getBuilder() {
        return this.builder;
    }

    public ThesaurusModelBuilder<NavigationTreeTableNode> getTreeTableBuilder() {
        return this.builder;
    }

    public VradiThesaurusDTO getRootThesaurus() {
        return this.rootThesaurus;
    }

    public NavigationNode getRootNode() {
        return this.cachedModel.getRoot();
    }

    public String getRootName() {
        return this.rootThesaurus.getName();
    }

    public String getRootNamePath() {
        return this.rootThesaurus.getNamePath(this.getPathSeparator());
    }

    public String getPathSeparator() {
        return PATH_SEPARATOR;
    }

    public void reinitColors() {
        this.reinitColors(this.getHandler(this.context).getUI(this.context));
    }

    public void reinitColors(ThesaurusUI ui) {
        JXTreeTable treeTable = this.getTreeTable(this.context);
        if (treeTable != null) {
            treeTable.setHighlighters(new Highlighter[]{new ThesaurusHighlighter()});
        } else {
            ((ThesaurusHighlighter)this.getTree(this.context).getCellRenderer()).updateColors();
            JList thesaurusSelected = ui.getThesaurusSelected();
            ThesaurusHighlighter selectedRenderer = thesaurusSelected.getCellRenderer();
            if (!(selectedRenderer instanceof ThesaurusHighlighter)) {
                selectedRenderer = new ThesaurusHighlighter();
                thesaurusSelected.setCellRenderer(selectedRenderer);
            }
            ((ThesaurusHighlighter)selectedRenderer).updateColors();
            JList propositionList = ui.getParentUI().getPropositionList();
            ThesaurusHighlighter propositionRenderer = propositionList.getCellRenderer();
            if (!(propositionRenderer instanceof ThesaurusHighlighter)) {
                propositionRenderer = new ThesaurusHighlighter(true);
                thesaurusSelected.setCellRenderer(propositionRenderer);
            }
            ((ThesaurusHighlighter)propositionRenderer).updateColors();
        }
    }

    public NavigationModel createTreeModel(JAXXContext context) {
        if (this.cachedModel != null) {
            this.setModel(context, this.cachedModel);
            return this.cachedModel;
        }
        HashMap map = null;
        if (!this.isCopy()) {
            map = (HashMap)VradiContext.THESAURUS_NAVIGATION_MODEL.getContextValue((JAXXContext)VradiContext.get());
            if (map == null) {
                map = new HashMap();
                VradiContext.THESAURUS_NAVIGATION_MODEL.setContextValue((JAXXContext)VradiContext.get(), map);
            }
            this.cachedModel = (NavigationModel)map.get(this.rootThesaurus.getWikittyId());
            if (this.cachedModel != null) {
                this.setModel(context, this.cachedModel);
                return this.cachedModel;
            }
        }
        this.context = context;
        return this.reloadModel();
    }

    public NavigationHandler<?> createTreeHandler(JAXXObject context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"create handler");
        }
        if (context instanceof ThesaurusUI) {
            this.setTree((JAXXContext)context, ((ThesaurusUI)context).getThesaurus());
        } else if (context instanceof AdminThesaurusUI) {
            this.setTreeTable((JAXXContext)context, ((AdminThesaurusUI)context).getThesaurus());
        } else {
            this.setTreeTable((JAXXContext)context, ((ThesaurusPathChooserUI)context).getThesaurus());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Using default thesaurus handler");
        }
        NavigationOneClicSelectionHandler handler = new NavigationOneClicSelectionHandler(this.getPrefix(), context, NavigationHandler.Strategy.PER_NODE){
            private static final long serialVersionUID = 1L;

            public NavigationModel<?> getNavigationTreeModel() {
                NavigationModel model = ThesaurusTreeHelper.this.getSafeModel(this.getContext());
                return model;
            }

            public void treateError(Exception e) {
                ErrorDialogUI.showError((Exception)e);
            }

            public JAXXContext getContext() {
                return this.context;
            }

            public Component getCurrentUI() {
                return null;
            }

            public Component getUI(NavigationNode node) {
                return (Component)this.context;
            }

            public boolean closeUI(Component component) throws Exception {
                return true;
            }

            public Component createUI(NavigationNode node) throws Exception {
                return ThesaurusTreeHelper.this.getHandler(this.context).getUI(this.context);
            }

            public void openUI(Component newUI, NavigationNode node) throws Exception {
            }

            public void openUI(Component newUI, List nodes) throws Exception {
            }

            public Component createUI(List nodes) throws Exception {
                return ThesaurusTreeHelper.this.getHandler(this.context).getUI(this.context);
            }

            public Component getUI(List nodes) {
                return ThesaurusTreeHelper.this.getHandler(this.context).getUI(this.context);
            }
        };
        JXTreeTable treeTable = this.getTreeTable((JAXXContext)context);
        if (treeTable != null) {
            treeTable.setSelectionMode(this.selectionMode);
        } else {
            JTree tree = this.getTree((JAXXContext)context);
            tree.getSelectionModel().setSelectionMode(this.selectionMode);
        }
        this.setTreeHandler((JAXXContext)context, (NavigationHandler)handler);
        this.reinitColors();
        return handler;
    }

    public TreePath expendNode(NavigationNode<?> node) {
        Object[] treeNodes = node.getPath();
        TreePath path = new TreePath(treeNodes);
        JXTreeTable treeTable = this.getTreeTable(this.context);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Try to expend path : " + path));
        }
        if (treeTable != null) {
            treeTable.expandPath(path);
        } else {
            this.getTree(this.context).expandPath(path);
        }
        return path;
    }

    public void tryToUnselect(List<Object> beans) {
        this.tryToUnselect((Collection<String>)this.extractIds(beans));
    }

    public void tryToUnselect(Collection<String> thesaurusIds) {
        if (thesaurusIds != null) {
            ArrayList nodes = new ArrayList();
            for (String id : thesaurusIds) {
                this.findNode(id, this.getRootNode(), nodes);
            }
            TreePath[] paths = new TreePath[nodes.size()];
            int i = 0;
            for (NavigationNode navigationNode : nodes) {
                Object[] treeNodes = navigationNode.getPath();
                TreePath path = new TreePath(treeNodes);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Try to unselect path : " + path));
                }
                paths[i++] = path;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("path " + paths[i - 1] + " for node " + navigationNode));
                }
                this.getTree(this.context).removeSelectionPath(path);
                if (!log.isDebugEnabled()) continue;
                Object[] treePaths = this.getTree(this.context).getSelectionPaths();
                log.debug((Object)((treePaths == null ? 0 : treePaths.length) + " path unselected : " + Arrays.toString(treePaths)));
            }
            if (this.getSelectedNodes(this.context) != null) {
                this.getSelectedNodes(this.context).removeAll(nodes);
                this.getSelectedPaths(this.context).removeAll(this.extractPaths(nodes));
                this.getSelectedBeans(this.context).removeAll(this.extractBeans(nodes));
            }
        }
    }

    public List<String> extractIds(List<Object> beans) {
        ArrayList<String> ids = new ArrayList<String>();
        if (beans != null) {
            for (Object bean : beans) {
                ids.add(((VradiThesaurusDTO)bean).getWikittyId());
            }
        }
        return ids;
    }

    public void tryToSelect(List<Object> beans) {
        this.tryToSelect((Collection<String>)this.extractIds(beans));
    }

    public void tryToSelect(Collection<String> thesaurusIds) {
        if (thesaurusIds != null) {
            ArrayList nodes = new ArrayList();
            for (String id : thesaurusIds) {
                this.findNode(id, this.getRootNode(), nodes);
            }
            TreePath[] paths = new TreePath[nodes.size()];
            int i = 0;
            for (NavigationNode navigationNode : nodes) {
                Object[] treeNodes = navigationNode.getPath();
                TreePath path = new TreePath(treeNodes);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Try to select path : " + path));
                }
                paths[i++] = path;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("path " + paths[i - 1] + " for node " + navigationNode));
                }
                this.getTree(this.context).addSelectionPath(path);
                if (!log.isDebugEnabled()) continue;
                Object[] treePaths = this.getTree(this.context).getSelectionPaths();
                log.debug((Object)((treePaths == null ? 0 : treePaths.length) + " path selected : " + Arrays.toString(treePaths)));
            }
            List selectedNodes = this.getSelectedNodes(this.context);
            if (selectedNodes != null) {
                selectedNodes.addAll(nodes);
                List list = this.getSelectedPaths(this.context);
                list.addAll(this.extractPaths(nodes));
                List list2 = this.getSelectedBeans(this.context);
                list2.addAll(this.extractBeans(nodes));
            } else {
                this.setSelectedNodes(this.context, nodes);
                this.setSelectedPaths(this.context, this.extractPaths(nodes));
                this.setSelectedBeans(this.context, this.extractBeans(nodes));
            }
        }
    }

    protected TreeSelectionModel getSelectionModel() {
        JXTreeTable treeTable = this.getTreeTable(this.context);
        TreeSelectionModel selectionModel = treeTable == null ? this.getTree(this.context).getSelectionModel() : treeTable.getTreeSelectionModel();
        return selectionModel;
    }

    protected List<String> extractPaths(List<NavigationNode<?>> nodes) {
        ArrayList<String> paths = new ArrayList<String>();
        for (NavigationNode<?> node : nodes) {
            paths.add(node.getFullPath());
        }
        return paths;
    }

    protected List<Object> extractBeans(List<NavigationNode<?>> nodes) {
        ArrayList<Object> beans = new ArrayList<Object>();
        for (NavigationNode<?> node : nodes) {
            beans.add(node.getBean());
        }
        return beans;
    }

    public void findNode(String thesaurusId, NavigationNode<?> node, List<NavigationNode<?>> nodes) {
        if (thesaurusId != null) {
            if (thesaurusId.equals(this.getWikittyId(node))) {
                nodes.add(node);
            } else {
                Enumeration children = node.children();
                while (children.hasMoreElements()) {
                    NavigationNode child = (NavigationNode)children.nextElement();
                    this.findNode(thesaurusId, child, nodes);
                }
            }
        }
    }

    protected String getWikittyId(NavigationNode<?> node) {
        VradiThesaurusDTO thesaurus = (VradiThesaurusDTO)node.getBean();
        if (thesaurus == null) {
            return null;
        }
        return thesaurus.getWikittyId();
    }

    public NavigationTreeModelBuilder getTreeBuilder() {
        return (NavigationTreeModelBuilder)this.builder;
    }

    public void sort(JAXXContext context, NavigationNode node) {
        NavigationNode parent = node.getParent();
        if (parent == null) {
            parent = this.getRootNode();
        }
        Enumeration childEnum = parent.children();
        ArrayList<NavigationNode> children = Collections.list(childEnum);
        HashMap<VradiThesaurusDTO, NavigationNode> toSort = new HashMap<VradiThesaurusDTO, NavigationNode>();
        ArrayList<VradiThesaurusDTO> beans = new ArrayList<VradiThesaurusDTO>();
        int cnt = 0;
        for (NavigationNode child : children) {
            Object o = child.getBean(context);
            VradiThesaurusDTO casted = (VradiThesaurusDTO)o;
            beans.add(casted);
            toSort.put(casted, child);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Will sort : " + ++cnt + " - " + (casted == null ? "null" : casted.toString())));
        }
        Collections.sort(beans, VradiComparators.THESAURUS_COMPARATOR);
        children.clear();
        cnt = 0;
        for (VradiThesaurusDTO bean : beans) {
            NavigationNode retrieveNode = (NavigationNode)toSort.get(bean);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieve sorted bean : " + ++cnt + " - " + (bean == null ? "null" : bean.toString())));
            }
            children.add(retrieveNode);
        }
        for (NavigationNode child : children) {
            int index = children.indexOf(child);
            parent.remove(child);
            parent.insert(child, index);
        }
        this.builder.getModel().nodeStructureChanged(parent);
    }

    protected Decorator<VradiThesaurusDTO> getThesaurusDecorator() {
        Decorator tDecorator = VradiContext.get().getDecoratorProvider().getDecorator(VradiThesaurusDTO.class);
        return tDecorator;
    }

    public class ThesaurusTreeModelBuilder
    extends NavigationTreeModelBuilder
    implements ThesaurusModelBuilder<NavigationTreeNode> {
        public ThesaurusTreeModelBuilder(JAXXContext context) {
            super(null, null, new NavigationTreeModel(PATH_SEPARATOR, context));
        }

        public boolean removeNodeFromParent(JAXXContext context, NavigationTreeNode node) {
            NavigationTreeModel treeModel = this.getModel();
            treeModel.removeNodeFromParent((NavigationNode)node);
            return ((NavigationTreeNode)treeModel.getRoot()).getChildCount() == 0;
        }

        @Override
        public NavigationTreeNode addThesaurusToSelected(JAXXContext context, VradiThesaurusDTO thesaurus) {
            NavigationTreeNode selectedNode = (NavigationTreeNode)ThesaurusTreeHelper.this.getSelectedNode(context);
            return this.addThesaurus(context, selectedNode, thesaurus);
        }

        @Override
        public NavigationTreeNode addThesaurus(JAXXContext context, NavigationTreeNode parent, VradiThesaurusDTO thesaurus) {
            return this.addThesaurus(parent, thesaurus.getWikittyId());
        }

        @Override
        public NavigationTreeNode addThesaurusAndChildrenRecursivly(NavigationTreeNode parent, VradiThesaurusDTO thesaurus) {
            NavigationTreeNode newNode = this.addThesaurus(parent, thesaurus.getWikittyId());
            for (VradiThesaurusDTO child : thesaurus.getChildren()) {
                this.addThesaurusAndChildrenRecursivly(newNode, child);
            }
            return newNode;
        }

        @Override
        public NavigationTreeNode addThesaurus(NavigationTreeNode parent, String thesaurusId) {
            String path;
            Decorator<VradiThesaurusDTO> tDecorator = ThesaurusTreeHelper.this.getThesaurusDecorator();
            if (parent == null) {
                parent = (NavigationTreeNode)ThesaurusTreeHelper.this.getRootNode();
                path = "..children[@wikittyId=\"" + thesaurusId + "\"]";
            } else {
                path = ".." + PATH_SEPARATOR + "children[@wikittyId=\"" + thesaurusId + "\"]";
            }
            NavigationTreeNode result = (NavigationTreeNode)ThesaurusTreeHelper.this.getTreeBuilder().build((NavigationNode)parent, tDecorator, path, thesaurusId, null, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("addThesaurus : " + thesaurusId + " to parent : " + (parent == null ? "null" : parent.getFullPath()) + " fullPath : " + (result == null ? "result is null" : result.getFullPath())));
            }
            ThesaurusTreeHelper.this.sort(ThesaurusTreeHelper.this.context, (NavigationNode)result);
            return result;
        }

        @Override
        public NavigationTreeNode buildRoot() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Building root : " + ThesaurusTreeHelper.this.getRootName()));
            }
            NavigationTreeNode invisibleRootNode = (NavigationTreeNode)ThesaurusTreeHelper.this.getTreeBuilder().buildEmptyRoot(ThesaurusTreeHelper.this.getThesaurusRef(), ThesaurusTreeHelper.this.getThesaurusRef().getName());
            if (ThesaurusTreeHelper.this.rootThesaurus.getParentThesaurus() == null) {
                return invisibleRootNode;
            }
            return (NavigationTreeNode)ThesaurusTreeHelper.this.getTreeBuilder().build((NavigationNode)invisibleRootNode, ThesaurusTreeHelper.this.getThesaurusDecorator(), ThesaurusTreeHelper.this.rootThesaurus.getBuildPath(PATH_SEPARATOR), ThesaurusTreeHelper.this.rootThesaurus.getWikittyId(), null, null);
        }

        @Override
        public void buildChildren(JAXXContext context, NavigationTreeNode parentNode) {
            VradiThesaurusDTO parent;
            if (log.isDebugEnabled()) {
                log.debug((Object)("buildChildren of thesaurus " + parentNode.getFullPath()));
            }
            if ((parent = (VradiThesaurusDTO)parentNode.getBean(context)) != null) {
                for (VradiThesaurusDTO child : parent.getChildren()) {
                    NavigationTreeNode childNode = this.addThesaurus(context, parentNode, child);
                    if (child.getWikittyId() == null) continue;
                    this.buildChildren(context, childNode);
                }
            }
        }
    }

    public class ThesaurusTreeTableModelBuilder
    extends NavigationTreeTableModelBuilder
    implements ThesaurusModelBuilder<NavigationTreeTableNode> {
        public ThesaurusTreeTableModelBuilder(JAXXContext context) {
            super(null, null, new NavigationTreeTableModel((NavigationTreeTableModel.MyDefaultTreeTableModel)new ThesaurusTreeTableModel(), PATH_SEPARATOR, context, ThesaurusTreeHelper.this.columnsName));
        }

        public boolean removeNodeFromParent(JAXXContext context, NavigationTreeTableNode node) {
            NavigationTreeTableModel treeModel = this.getModel();
            treeModel.removeNodeFromParent((NavigationNode)node);
            return ((NavigationTreeTableNode)treeModel.getRoot()).getChildCount() == 0;
        }

        @Override
        public NavigationTreeTableNode addThesaurusToSelected(JAXXContext context, VradiThesaurusDTO thesaurus) {
            NavigationTreeTableNode selectedNode = (NavigationTreeTableNode)ThesaurusTreeHelper.this.getSelectedNode(context);
            return this.addThesaurus(context, selectedNode, thesaurus);
        }

        @Override
        public NavigationTreeTableNode addThesaurus(JAXXContext context, NavigationTreeTableNode parent, VradiThesaurusDTO thesaurus) {
            return this.addThesaurus(parent, thesaurus.getWikittyId());
        }

        @Override
        public NavigationTreeTableNode addThesaurusAndChildrenRecursivly(NavigationTreeTableNode parent, VradiThesaurusDTO thesaurus) {
            NavigationTreeTableNode newNode = this.addThesaurus(parent, thesaurus.getWikittyId());
            for (VradiThesaurusDTO child : thesaurus.getChildren()) {
                this.addThesaurusAndChildrenRecursivly(newNode, child);
            }
            return newNode;
        }

        @Override
        public NavigationTreeTableNode addThesaurus(NavigationTreeTableNode parent, String thesaurusId) {
            String path;
            Decorator<VradiThesaurusDTO> tDecorator = ThesaurusTreeHelper.this.getThesaurusDecorator();
            if (parent == null) {
                parent = (NavigationTreeTableNode)ThesaurusTreeHelper.this.getRootNode();
                path = "..children[@wikittyId=\"" + thesaurusId + "\"]";
            } else {
                path = ".." + PATH_SEPARATOR + "children[@wikittyId=\"" + thesaurusId + "\"]";
            }
            NavigationTreeTableNode result = (NavigationTreeTableNode)ThesaurusTreeHelper.this.getTreeTableBuilder().build((NavigationNode)parent, tDecorator, path, thesaurusId, null, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("addThesaurus : " + thesaurusId + " to parent : " + (parent == null ? "null" : parent.getFullPath()) + " fullPath : " + (result == null ? "result is null" : result.getFullPath())));
            }
            ThesaurusTreeHelper.this.sort(ThesaurusTreeHelper.this.context, (NavigationNode)result);
            return result;
        }

        @Override
        public NavigationTreeTableNode buildRoot() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Building root : " + ThesaurusTreeHelper.this.getRootName()));
            }
            NavigationTreeTableNode invisibleRootNode = (NavigationTreeTableNode)ThesaurusTreeHelper.this.getTreeTableBuilder().buildEmptyRoot(ThesaurusTreeHelper.this.getThesaurusRef(), ThesaurusTreeHelper.this.getThesaurusRef().getName());
            if (ThesaurusTreeHelper.this.rootThesaurus.getParentThesaurus() == null) {
                return invisibleRootNode;
            }
            return (NavigationTreeTableNode)ThesaurusTreeHelper.this.getTreeTableBuilder().build((NavigationNode)invisibleRootNode, ThesaurusTreeHelper.this.getThesaurusDecorator(), ThesaurusTreeHelper.this.rootThesaurus.getBuildPath(PATH_SEPARATOR), ThesaurusTreeHelper.this.rootThesaurus.getWikittyId(), null, null);
        }

        @Override
        public void buildChildren(JAXXContext context, NavigationTreeTableNode parentNode) {
            VradiThesaurusDTO parent;
            if (log.isDebugEnabled()) {
                log.debug((Object)("buildChildren of thesaurus " + parentNode.getFullPath()));
            }
            if ((parent = (VradiThesaurusDTO)parentNode.getBean(context)) != null) {
                for (VradiThesaurusDTO child : parent.getChildren()) {
                    NavigationTreeTableNode childNode = this.addThesaurus(context, parentNode, child);
                    if (child.getWikittyId() == null) continue;
                    this.buildChildren(context, childNode);
                }
            }
        }
    }

    public static interface ThesaurusModelBuilder<E extends NavigationNode<E>>
    extends NavigationModelBuilder<E> {
        public E addThesaurusToSelected(JAXXContext var1, VradiThesaurusDTO var2);

        public E addThesaurus(JAXXContext var1, E var2, VradiThesaurusDTO var3);

        public E addThesaurusAndChildrenRecursivly(E var1, VradiThesaurusDTO var2);

        public E addThesaurus(E var1, String var2);

        public E buildRoot();

        public void buildChildren(JAXXContext var1, E var2);

        public NavigationModel<E> getModel();
    }
}

