/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.helpers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.services.dto.SendingContainer;
import com.jurismarches.vradi.services.dto.VradiClientDTO;
import com.jurismarches.vradi.services.dto.VradiFormDTO;
import com.jurismarches.vradi.services.dto.VradiGroupDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import com.jurismarches.vradi.services.dto.VradiSessionDTO;
import com.jurismarches.vradi.services.dto.VradiUserDTO;
import com.jurismarches.vradi.ui.email.EmailHandler;
import com.jurismarches.vradi.ui.email.EmailPopupUI;
import com.jurismarches.vradi.ui.email.FormViewUI;
import com.jurismarches.vradi.ui.email.SessionsListUI;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.handler.NavigationHandler;
import jaxx.runtime.swing.navigation.handler.NavigationTreeHandlerWithCardLayout;
import jaxx.runtime.swing.navigation.tree.NavigationTreeHelper;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModel;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModelBuilder;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class EmailNavigationTreeHelper
extends NavigationTreeHelper {
    private static final Log log = LogFactory.getLog(EmailNavigationTreeHelper.class);
    protected NavigationTreeModel cachedModel;
    protected boolean datasChanged = false;
    public static String PATH_SEPARATOR = "/";
    protected NavigationTreeNode rootNode;
    protected EmailTreeModelBuilder builder;
    protected JAXXContext context;
    protected JTree tree;
    protected EmailFilterEnum filter = EmailFilterEnum.FILTER_BY_CLIENT;

    public EmailNavigationTreeHelper(JAXXContext context, JTree tree) {
        super("");
        this.context = context;
        this.tree = tree;
        JAXXContextEntryDef<List<VradiSessionDTO>> sessionsDTOEntryDef = VradiContext.getSessionDTOEntryDef();
        if (sessionsDTOEntryDef == null) {
            VradiContext.setSessionDTOEntryDef(new ArrayList<VradiSessionDTO>());
            sessionsDTOEntryDef = VradiContext.getSessionDTOEntryDef();
        }
        VradiContext.get().addPropertyChangeListener(sessionsDTOEntryDef, sessionsDTOEntryDef.getName(), new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EmailNavigationTreeHelper.this.datasChanged = true;
            }
        });
    }

    protected EmailHandler getHandler(JAXXContext context) {
        return UIHelper.getHandler(context, EmailHandler.class);
    }

    public EmailTreeModelBuilder getBuilder() {
        return this.builder;
    }

    public NavigationTreeNode getRootNode() {
        return this.rootNode;
    }

    public String getPathSeparator() {
        return PATH_SEPARATOR;
    }

    public boolean isByForm() {
        return this.filter.equals((Object)EmailFilterEnum.FILTER_BY_FORM);
    }

    public boolean isByUser() {
        return this.filter.equals((Object)EmailFilterEnum.FILTER_BY_USER);
    }

    public boolean isByClient() {
        return this.filter.equals((Object)EmailFilterEnum.FILTER_BY_CLIENT);
    }

    public boolean isByGroup() {
        return this.filter.equals((Object)EmailFilterEnum.FILTER_BY_GROUP);
    }

    public VradiSessionDTO getActiveSession() {
        List<VradiSessionDTO> datas = VradiContext.getSessionsDTOInEntryDef();
        for (VradiSessionDTO data : datas) {
            if (data.getStatus() == VradiConstants.SessionStatus.CLOSE.getValue() || data.getStatus() == VradiConstants.SessionStatus.SENT.getValue()) continue;
            return data;
        }
        return null;
    }

    public void updateData(List<VradiSessionDTO> datas, EmailFilterEnum filter) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("update data, nb sessions : " + datas.size()));
        }
        this.filter = filter;
        VradiContext.setSessionDTOEntryDef(datas);
    }

    public NavigationTreeModel createTreeModel(JAXXContext context) {
        this.context = context;
        if (this.builder == null) {
            this.builder = new EmailTreeModelBuilder(context);
        }
        if (this.cachedModel != null && !this.datasChanged) {
            return this.cachedModel;
        }
        this.getBuilder().buildModel(context);
        this.cachedModel = this.builder.getModel();
        this.setModel(context, (NavigationModel)this.cachedModel);
        this.setSelectedNode(context, (NavigationNode)this.rootNode);
        this.datasChanged = false;
        return this.cachedModel;
    }

    public void refreshModel() {
        String selectedPath = this.getSelectedPath(this.context);
        this.getSafeTree(this.context).setModel((TreeModel)this.createTreeModel(this.context));
        this.setSelectedPath(this.context, selectedPath);
    }

    public NavigationHandler<NavigationTreeNode> createTreeHandler(JAXXObject context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"create handler");
        }
        this.setTree((JAXXContext)context, this.tree);
        NavigationTreeHandlerWithCardLayout<NavigationTreeNode> handler = new NavigationTreeHandlerWithCardLayout<NavigationTreeNode>(this.getPrefix(), context, NavigationHandler.Strategy.PER_UI_TYPE){
            private static final long serialVersionUID = 1L;

            public NavigationModel<NavigationTreeNode> getNavigationTreeModel() {
                return EmailNavigationTreeHelper.this.getSafeModel((JAXXContext)this.getContext());
            }

            public void treateError(Exception e) {
                ErrorDialogUI.showError((Exception)e);
            }

            public EmailPopupUI getContext() {
                return (EmailPopupUI)this.context;
            }

            protected JPanel getContentContainer() {
                return this.getContext().getContent();
            }

            protected CardLayout2 getContentLayout() {
                return this.getContext().getContentLayout();
            }
        };
        this.setTreeHandler((JAXXContext)context, (NavigationHandler)handler);
        return handler;
    }

    public List<VradiSendingDTO> getSendingToDisplay(NavigationTreeNode node) {
        HashMap<String, VradiSendingDTO> result = new HashMap<String, VradiSendingDTO>();
        Object value = node.getBean();
        if (value instanceof VradiFormDTO) {
            VradiFormDTO formDTO = (VradiFormDTO)value;
            List sendingDTOs = formDTO.getSendingDTOs();
            for (VradiSendingDTO sending : sendingDTOs) {
                result.put(sending.getWikittyId(), sending);
            }
        } else if (value instanceof VradiSessionDTO) {
            List vradiSendingDTOs = ((VradiSessionDTO)value).getSendingList();
            for (VradiSendingDTO s : vradiSendingDTOs) {
                result.put(s.getWikittyId(), s);
            }
        } else if (value instanceof QueryMaker) {
            VradiSendingDTO sending = ((SendingContainer)value).getCurrentSending();
            result.put(sending.getWikittyId(), sending);
        }
        return new ArrayList<VradiSendingDTO>(result.values());
    }

    public class EmailTreeModelBuilder
    extends NavigationTreeModelBuilder {
        protected DecoratorProvider decoratorProvider;

        public EmailTreeModelBuilder(JAXXContext context) {
            super("/", context, null, null);
            this.decoratorProvider = null;
        }

        public boolean removeNodeFromParent(JAXXContext context, NavigationTreeNode node) {
            NavigationTreeModel treeModel = this.getModel();
            treeModel.removeNodeFromParent(node);
            return ((NavigationTreeNode)treeModel.getRoot()).getChildCount() == 0;
        }

        public void buildModel(JAXXContext context) {
            JAXXContextEntryDef<List<VradiSessionDTO>> SESSIONS_DTO_DEF = VradiContext.getSessionDTOEntryDef();
            EmailNavigationTreeHelper.this.rootNode = (NavigationTreeNode)EmailNavigationTreeHelper.this.builder.buildEmptyRoot(SESSIONS_DTO_DEF, "$root");
            if (SESSIONS_DTO_DEF != null) {
                List datas = (List)SESSIONS_DTO_DEF.getContextValue(context);
                for (VradiSessionDTO data : datas) {
                    this.addSession(EmailNavigationTreeHelper.this.rootNode, data);
                }
            }
        }

        public void addSession(NavigationTreeNode parentNode, VradiSessionDTO sessionDTO) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("createSession node " + sessionDTO.getSessionDate() + " num " + sessionDTO.getNum()));
            }
            String sessionId = sessionDTO.getWikittyId();
            NavigationTreeNode sessionNode = (NavigationTreeNode)this.build((NavigationNode)parentNode, this.getDecorator(VradiSessionDTO.class), "..[@wikittyId=\"" + sessionId + "\"]", sessionId, SessionsListUI.class, null);
            List vradiSendingDTOs = sessionDTO.getSendingList();
            if (log.isDebugEnabled()) {
                log.debug((Object)(vradiSendingDTOs.size() + " sending to display"));
            }
            if (EmailNavigationTreeHelper.this.isByForm()) {
                this.addAllForms(sessionNode, vradiSendingDTOs);
            } else {
                for (VradiSendingDTO sending : vradiSendingDTOs) {
                    if (EmailNavigationTreeHelper.this.isByClient()) {
                        this.addClient(sessionNode, sending);
                        continue;
                    }
                    if (EmailNavigationTreeHelper.this.isByUser()) {
                        this.addUser(sessionNode, sending);
                        continue;
                    }
                    if (!EmailNavigationTreeHelper.this.isByGroup()) continue;
                    this.addGroup(sessionNode, sending);
                }
            }
            this.sort(sessionNode);
        }

        public void addAllForms(NavigationTreeNode parentNode, List<VradiSendingDTO> sendingDTOs) {
            HashMap<String, VradiFormDTO> forms = new HashMap<String, VradiFormDTO>();
            HashMap<VradiFormDTO, VradiSendingDTO> sendings = new HashMap<VradiFormDTO, VradiSendingDTO>();
            for (VradiSendingDTO sending : sendingDTOs) {
                for (VradiFormDTO form : sending.getFormDTOs()) {
                    forms.put(form.getWikittyId(), form);
                    sendings.put(form, sending);
                }
            }
            for (VradiFormDTO formDTO : forms.values()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding form node " + formDTO.getObjet()));
                }
                String formId = formDTO.getWikittyId();
                NavigationTreeNode formNode = (NavigationTreeNode)this.build((NavigationNode)parentNode, this.getDecorator(VradiFormDTO.class), ".." + PATH_SEPARATOR + "sendingList[@wikittyId=\"" + ((VradiSendingDTO)sendings.get(formDTO)).getWikittyId() + "\"]" + PATH_SEPARATOR + "formDTOs[@wikittyId=\"" + formId + "\"]", formId, FormViewUI.class, null);
                this.sort(formNode);
            }
        }

        public void addClient(NavigationTreeNode parentNode, VradiSendingDTO sending) {
            VradiClientDTO clientDTO = sending.getClientDTO();
            if (clientDTO != null) {
                String clientId = clientDTO.getWikittyId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("create Client node " + clientId + " for sending " + sending.getWikittyId()));
                }
                NavigationTreeNode clientNode = (NavigationTreeNode)this.build((NavigationNode)parentNode, this.getDecorator(VradiClientDTO.class), ".." + PATH_SEPARATOR + "sendingList[@wikittyId=\"" + sending.getWikittyId() + "\"]" + PATH_SEPARATOR + "clientDTO", clientId, SessionsListUI.class, null);
                for (VradiUserDTO user : clientDTO.getUsersDTO()) {
                    this.addUser(clientNode, user);
                }
                this.sort(clientNode);
            }
        }

        public void addClient(NavigationTreeNode parentNode, VradiClientDTO clientDTO) {
            if (clientDTO != null) {
                String clientId = clientDTO.getWikittyId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("create Client node " + clientId));
                }
                NavigationTreeNode clientNode = (NavigationTreeNode)this.build((NavigationNode)parentNode, this.getDecorator(VradiUserDTO.class), ".." + PATH_SEPARATOR + "clientsDTO[@wikittyId=\"" + clientId + "\"]", clientId, SessionsListUI.class, null);
                for (VradiUserDTO user : clientDTO.getUsersDTO()) {
                    this.addUser(clientNode, user);
                }
                this.sort(clientNode);
            }
        }

        public void addUser(NavigationTreeNode parentNode, VradiSendingDTO sending) {
            VradiUserDTO userDTO = sending.getUserDTO();
            if (userDTO != null) {
                String userId = userDTO.getWikittyId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("createUser node " + userId + " for sending " + sending.getWikittyId()));
                }
                Decorator<VradiUserDTO> userDecorator = this.getDecorator(VradiUserDTO.class);
                if (EmailNavigationTreeHelper.this.isByUser()) {
                    userDecorator = this.getUserDTODecorator();
                }
                NavigationTreeNode userNode = (NavigationTreeNode)this.build((NavigationNode)parentNode, userDecorator, ".." + PATH_SEPARATOR + "sendingList[@wikittyId=\"" + sending.getWikittyId() + "\"]" + PATH_SEPARATOR + "userDTO", userId, SessionsListUI.class, null);
                this.sort(userNode);
            }
        }

        public void addUser(NavigationTreeNode parentNode, VradiUserDTO userDTO) {
            if (userDTO != null) {
                String userId = userDTO.getWikittyId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("createUser node " + userId));
                }
                NavigationTreeNode userNode = (NavigationTreeNode)this.build((NavigationNode)parentNode, this.getDecorator(VradiUserDTO.class), ".." + PATH_SEPARATOR + "usersDTO[@wikittyId=\"" + userId + "\"]", userId, SessionsListUI.class, null);
                this.sort(userNode);
            }
        }

        public void addGroup(NavigationTreeNode parentNode, VradiSendingDTO sending) {
            VradiGroupDTO groupDTO = sending.getGroupDTO();
            if (groupDTO != null) {
                String groupId = groupDTO.getWikittyId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("createGroup node " + groupId + " for sending " + sending.getWikittyId()));
                }
                NavigationTreeNode groupNode = (NavigationTreeNode)this.build((NavigationNode)parentNode, this.getDecorator(VradiGroupDTO.class), ".." + PATH_SEPARATOR + "sendingList[@wikittyId=\"" + sending.getWikittyId() + "\"]" + PATH_SEPARATOR + "groupDTO", groupId, SessionsListUI.class, null);
                for (VradiUserDTO userDTO : groupDTO.getUsersDTO()) {
                    this.addUser(groupNode, userDTO);
                }
                for (VradiClientDTO clientDTO : groupDTO.getClientsDTO()) {
                    this.addClient(groupNode, clientDTO);
                }
                this.sort(groupNode);
            }
        }

        protected void sort(NavigationTreeNode node) {
            NavigationTreeNode parent = node.getParent();
            if (parent == null) {
                parent = EmailNavigationTreeHelper.this.getRootNode();
            }
            Enumeration childEnum = parent.children();
            ArrayList<NavigationTreeNode> children = Collections.list(childEnum);
            HashMap<String, NavigationTreeNode> toSort = new HashMap<String, NavigationTreeNode>();
            ArrayList<String> valuesToSort = new ArrayList<String>();
            boolean cnt = false;
            for (NavigationTreeNode child : children) {
                String rendered = child.getRenderer().toString();
                toSort.put(rendered, child);
                valuesToSort.add(rendered);
            }
            Collections.sort(valuesToSort);
            children.clear();
            cnt = false;
            for (String sorted : valuesToSort) {
                NavigationTreeNode retrieveNode = (NavigationTreeNode)toSort.get(sorted);
                children.add(retrieveNode);
            }
            for (NavigationTreeNode child : children) {
                int index = children.indexOf(child);
                parent.remove(child);
                parent.insert(child, index);
            }
            EmailNavigationTreeHelper.this.builder.getModel().nodeStructureChanged(parent);
        }

        protected DecoratorProvider getDecoratorProvider() {
            if (this.decoratorProvider != null) {
                return this.decoratorProvider;
            }
            this.decoratorProvider = new DecoratorProvider(){

                protected void loadDecorators() {
                    this.registerMultiJXPathDecorator(VradiClientDTO.class, "${name}$s# (${nbFormToSend}$s)", "#", " - ");
                    this.registerMultiJXPathDecorator(VradiUserDTO.class, "userClientName", "${clientName}$s#${name}$s# (${nbFormToSend}$s)", "#", " - ");
                    this.registerMultiJXPathDecorator(VradiUserDTO.class, "${name}$s# (${nbFormToSend}$s)", "#", " - ");
                    this.registerMultiJXPathDecorator(VradiGroupDTO.class, "${name}$s# (${nbFormToSend}$s)", "#", " - ");
                    this.registerMultiJXPathDecorator(VradiFormDTO.class, "${objet}$s", "", "");
                    this.registerDecorator((Decorator)new Decorator<VradiSessionDTO>(VradiSessionDTO.class){

                        public String toString(Object bean) {
                            VradiSessionDTO session = (VradiSessionDTO)bean;
                            StringBuffer buffer = new StringBuffer();
                            buffer.append(session.getNum());
                            buffer.append(" - ");
                            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
                            buffer.append(format.format(session.getSessionDate()));
                            buffer.append(" (");
                            buffer.append(session.getNbFormToSend());
                            buffer.append(")");
                            buffer.append(" - ");
                            buffer.append(VradiConstants.SessionStatus.getStatus((int)session.getStatus()).getDescription());
                            return buffer.toString();
                        }
                    });
                }
            };
            return this.decoratorProvider;
        }

        public <O> Decorator<O> getDecorator(Class<O> type) {
            Decorator classDecorator = this.getDecoratorProvider().getDecorator(type);
            return classDecorator;
        }

        protected Decorator<VradiUserDTO> getUserDTODecorator() {
            return this.getDecoratorProvider().getDecorator(VradiUserDTO.class, "userClientName");
        }
    }

    public static enum EmailFilterEnum {
        FILTER_BY_CLIENT("vradi.email.clientFilter"),
        FILTER_BY_USER("vradi.email.userFilter"),
        FILTER_BY_GROUP("vradi.email.groupFilter"),
        FILTER_BY_FORM("vradi.email.formFilter");

        protected int value;
        protected String text;

        private EmailFilterEnum(String text) {
            this.text = text;
        }

        public String toString() {
            return I18n._((String)this.text);
        }
    }
}

