/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.editors;

import com.jurismarches.vradi.ui.editors.VradiEditorModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CurrencyEditorModel
extends VradiEditorModel<String> {
    private static final Log log = LogFactory.getLog(CurrencyEditorModel.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_AMOUNT = "amount";
    public static final String PROPERTY_CURRENCY = "currency";
    protected Float amount;
    protected String currency;

    public Float getAmount() {
        return this.amount;
    }

    public void setAmount(Float amount) {
        Float oldValue = this.amount;
        this.amount = amount;
        this.pcs.firePropertyChange(PROPERTY_AMOUNT, oldValue, amount);
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        String oldValue = this.currency;
        this.currency = currency;
        this.pcs.firePropertyChange(PROPERTY_CURRENCY, oldValue, currency);
    }

    @Override
    public String getValue() {
        return this.amount + " " + this.currency;
    }

    @Override
    public void setValue(String value) {
        String oldValue;
        block4: {
            oldValue = this.getValue();
            if (value != null) {
                String[] splitted = value.split("\\s+");
                try {
                    Float amount = Float.valueOf(Float.parseFloat(splitted[0]));
                    this.setAmount(amount);
                    StringBuffer currency = new StringBuffer();
                    for (int i = 1; i < splitted.length; ++i) {
                        currency.append(splitted[i]).append(" ");
                    }
                    this.setCurrency(currency.toString().trim());
                }
                catch (NumberFormatException eee) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)("the first token is not a number : " + eee));
                }
            }
        }
        this.pcs.firePropertyChange("value", oldValue, value);
    }
}

