/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.VradiService;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.ui.OfferEditHandler;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.OfferListColumnFactory;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.OfferTable;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import com.jurismarches.vradi.ui.VradiTabHeader;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.OfferListTableModel;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.table.TableColumnExt;
import org.nuiton.i18n.I18n;
import org.sharengo.wikitty.BusinessEntityWikitty;

public class OfferListHandler {
    private static final Log log = LogFactory.getLog(OfferListHandler.class);
    public static final int TABPANEL_LABEL_MAX_CHAR_NB = 30;

    public OfferListUI initUI(JAXXContext rootContext, VradiMainUIHandler rootHandler) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
        SearchHandler searchHandler = UIHelper.getHandler((JAXXContext)context, SearchHandler.class);
        OfferListTableModel offerListTableModel = new OfferListTableModel();
        OfferListColumnFactory offerListColumnFactory = new OfferListColumnFactory();
        context.add((Object)offerListTableModel);
        context.add((Object)offerListColumnFactory);
        OfferListUI ui = new OfferListUI((JAXXContext)context);
        VradiContext.OFFERT_LIST_UI_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), (Object)ui);
        OfferTable listTable = ui.getListTable();
        listTable.getColumnModel().addColumnModelListener((TableColumnModelListener)this.getOfferListTableColumnModelListener());
        MouseListener offerListTableMouseListener = this.getOfferListTableMouseListener();
        listTable.addMouseListener(offerListTableMouseListener);
        TableModelListener offerListTableModelListener = this.getOfferListTableModelListener(listTable);
        offerListTableModel.addTableModelListener(offerListTableModelListener);
        OfferListTableModel.OfferListTableCellRenderer renderer = new OfferListTableModel.OfferListTableCellRenderer();
        listTable.setDefaultRenderer(Boolean.class, renderer);
        listTable.setDefaultRenderer(Date.class, renderer);
        listTable.setDefaultRenderer(Double.class, renderer);
        listTable.setDefaultRenderer(String.class, renderer);
        Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)HighlighterFactory.NOTEPAD, (Color)HighlighterFactory.GENERIC_GRAY);
        listTable.addHighlighter(highlighter);
        SearchUI searchUI = searchHandler.initUI(rootContext, offerListTableModel);
        searchUI.setOfferListUI(true);
        ui.getSearchPanel().add((Component)((Object)searchUI), "Center");
        return ui;
    }

    private TableModelListener getOfferListTableModelListener(final JXTable listTable) {
        return new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                listTable.packAll();
            }
        };
    }

    private TableColumnModelExtListener getOfferListTableColumnModelListener() {
        return new TableColumnModelExtListener(){

            public void columnPropertyChange(PropertyChangeEvent paramPropertyChangeEvent) {
                String propertyName = paramPropertyChangeEvent.getPropertyName();
                if ("visible".equals(propertyName)) {
                    Boolean visible;
                    TableColumnExt column = (TableColumnExt)paramPropertyChangeEvent.getSource();
                    String fqFieldName = (String)column.getClientProperty((Object)"fqFieldName");
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("clientprop: " + fqFieldName));
                        log.trace((Object)("identifier: " + column.getIdentifier()));
                    }
                    if ((visible = (Boolean)paramPropertyChangeEvent.getNewValue()).booleanValue()) {
                        VradiHelper.addVradiListColumns(fqFieldName);
                    } else {
                        VradiHelper.removeVradiListColumns(fqFieldName);
                    }
                }
            }

            public void columnAdded(TableColumnModelEvent e) {
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
            }

            public void columnMarginChanged(ChangeEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        };
    }

    public MouseListener getOfferListTableMouseListener() {
        return new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                JTable listTable = (JTable)e.getSource();
                OfferListUI offerListUI = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    log.info((Object)"Click 2");
                    try {
                        offerListUI.setCursor(Cursor.getPredefinedCursor(3));
                        OfferListHandler.this.selectOffer((JAXXContext)offerListUI, listTable);
                    }
                    catch (Exception ee) {
                        log.error((Object)ee.getMessage(), (Throwable)ee);
                        ErrorDialogUI.showError((Exception)ee);
                    }
                    finally {
                        offerListUI.setCursor(null);
                    }
                } else if (e.getButton() == 3) {
                    log.info((Object)"Click 3");
                    int[] selectedRows = offerListUI.getListTable().getSelectedRows();
                    int rowClicked = offerListUI.getListTable().rowAtPoint(e.getPoint());
                    boolean rowClickedSelected = false;
                    if (selectedRows == null || selectedRows.length == 0) {
                        offerListUI.getListTable().getSelectionModel().setSelectionInterval(rowClicked, rowClicked);
                        rowClickedSelected = true;
                    } else {
                        int i = 0;
                        while (i < selectedRows.length && !rowClickedSelected) {
                            rowClickedSelected = rowClicked == selectedRows[i++];
                        }
                    }
                    if (rowClickedSelected) {
                        OfferListHandler.this.showOfferListContextMenu(offerListUI, e);
                    }
                }
            }
        };
    }

    private void showOfferListContextMenu(OfferListUI offerListUI, MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenu changeStatus = new JMenu(I18n._((String)"vradi.offer.status.change"));
        List<Status> statuses = VradiContext.getStatusInEntryDef();
        for (Status status : statuses) {
            JMenuItem statusItem = new JMenuItem(status.getName());
            statusItem.addActionListener(new StatusActionListener(offerListUI, status));
            changeStatus.add(statusItem);
        }
        menu.add(changeStatus);
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    private void changeStatus(JAXXContext context, Form form, Status status) {
        String intialStatus = form.getStatus();
        String updateStatus = status.getWikittyId();
        if (intialStatus == null || !updateStatus.equals(intialStatus)) {
            VradiUser vradiUser;
            if (!form.getExtensionNames().contains("ModificationTag")) {
                BusinessEntityWikitty entityWikitty = (BusinessEntityWikitty)form;
                entityWikitty.getWikitty().addExtension(ModificationTag.EXTENSION_MODIFICATION_TAG);
            }
            String modifier = (vradiUser = (VradiUser)context.getContextValue(VradiUser.class)) != null ? vradiUser.getName() : null;
            log.info((Object)String.format("Updating: statusModifier=%s on form: %s", modifier, form.getWikittyId()));
            log.info((Object)String.format("New Status: %s, Old Status: %s", intialStatus, updateStatus));
            form.setField("ModificationTag", "lastStatusModifier", (Object)modifier);
            form.setField("ModificationTag", "lastModifier", (Object)modifier);
        }
        form.setStatus(updateStatus);
    }

    public void addEditPane(JAXXContext context, final Form data) {
        final OfferListUI ui = this.getUI(context);
        ui.setDividerLocation(0);
        ui.setResizeWeight(0.0);
        ui.setDividerSize(12);
        JTabbedPane contentTabbedPane = ui.getEditTabs();
        String id = data.getWikittyId();
        if (contentTabbedPane.indexOfTab(id) < 0) {
            final OfferEditHandler handler = UIHelper.getHandler(context, OfferEditHandler.class);
            final OfferEditUI editUi = handler.initUI(context, data);
            contentTabbedPane.add(id, editUi);
            final VradiTabHeader panel = new VradiTabHeader();
            if (data.getObjet() != null) {
                String panelLabel = data.getObjet().length() < 30 ? data.getObjet() : data.getObjet().substring(0, 30) + "...";
                panel.getLabel().setText(panelLabel);
            }
            panel.setId(id);
            contentTabbedPane.setTabComponentAt(contentTabbedPane.indexOfTab(id), (Component)((Object)panel));
            panel.getCloseTab().addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    OfferListHandler.this.closePane((JAXXContext)editUi, panel.getId());
                }
            });
            panel.getDetachTab().addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    OfferListHandler.this.detachPane(e);
                }
            });
            List<Status> statuses = VradiContext.getStatusInEntryDef();
            Status[] orderedStatuses = new Status[statuses.size()];
            for (Status status : statuses) {
                int index = status.getValue();
                orderedStatuses[index] = status;
            }
            JPanel buttonPanel = editUi.getStatusButtonPanel();
            for (final Status status : orderedStatuses) {
                JButton statusButton = new JButton(status.getName());
                statusButton.setToolTipText(status.getDescription());
                if (status.getWikittyId().equals(data.getStatus())) {
                    Color newColor = new Color(110, 150, 200, statusButton.getBackground().getAlpha());
                    statusButton.setBackground(newColor);
                }
                statusButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        handler.changeStatusAndSave((JAXXContext)editUi, data, status);
                        OfferListHandler.this.closePane((JAXXContext)editUi, panel.getId());
                        SearchHandler handler2 = UIHelper.getHandler((JAXXContext)editUi, SearchHandler.class);
                        handler2.executeQuery((JAXXContext)ui);
                    }
                });
                buttonPanel.add(statusButton);
            }
            editUi.getAnnuler().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OfferListHandler.this.closePane((JAXXContext)editUi, panel.getId());
                }
            });
        }
        contentTabbedPane.setSelectedIndex(contentTabbedPane.indexOfTab(id));
    }

    protected VradiTabHeader getTabHeader(MouseEvent e) {
        JButton button = (JButton)e.getSource();
        return (VradiTabHeader)((Object)button.getParent());
    }

    protected void closePane(JAXXContext context, String id) {
        OfferListUI ui = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        JTabbedPane contentTabbedPane = this.getContentPane(ui);
        int index = contentTabbedPane.indexOfTab(id);
        if (index > -1) {
            contentTabbedPane.remove(index);
        }
        this.allEditPanelRemoved(contentTabbedPane, ui);
    }

    private void removeEditPaneFromRef(OfferEditUI ui) {
        ((List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get())).remove(ui);
    }

    protected void detachPane(MouseEvent e) {
        VradiTabHeader mytab = this.getTabHeader(e);
        String id = mytab.getId();
        String name = mytab.getLabel().getText();
        OfferListUI ui = mytab.getParentContainer(OfferListUI.class);
        JTabbedPane contentTabbedPane = this.getContentPane(ui);
        final OfferEditUI content = this.getOfferEdit(contentTabbedPane, id);
        final JFrame frame = new JFrame(name);
        content.getAnnuler().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfferListHandler.this.closeDetachedPane(frame, content);
            }
        });
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                OfferListHandler.this.closeDetachedPane(frame, content);
            }
        });
        frame.setLayout(new BorderLayout());
        frame.add((Component)content, "Center");
        frame.setVisible(true);
        frame.setSize(new Dimension(800, 800));
        this.allEditPanelRemoved(contentTabbedPane, ui);
    }

    protected OfferEditUI getOfferEdit(JTabbedPane contentTabbedPane, String id) {
        return (OfferEditUI)contentTabbedPane.getComponentAt(contentTabbedPane.indexOfTab(id));
    }

    protected void closeDetachedPane(JFrame f, OfferEditUI ui) {
        f.dispose();
        this.removeEditPaneFromRef(ui);
    }

    public void addEditPane(JAXXContext context, List<Form> datas) {
        for (Form data : datas) {
            this.addEditPane(context, data);
        }
    }

    protected void allEditPanelRemoved(JTabbedPane contentTabbedPane, OfferListUI ui) {
        if (contentTabbedPane.getTabCount() == 0) {
            ui.setDividerLocation(Integer.MAX_VALUE);
            ui.setResizeWeight(1.0);
            ui.setDividerSize(0);
        }
    }

    OfferListUI getUI(JAXXContext context) {
        if (context instanceof OfferListUI) {
            return (OfferListUI)context;
        }
        OfferListUI ui = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    JTabbedPane getContentPane(JAXXContext context) {
        OfferListUI ui = this.getUI(context);
        return ui.getEditTabs();
    }

    JTabbedPane getContentPane(OfferListUI ui) {
        return ui.getEditTabs();
    }

    protected void selectOffer(JAXXContext context, JTable listTable) {
        OfferListTableModel tableModel = (OfferListTableModel)listTable.getModel();
        int selectedRow = listTable.getSelectedRow();
        if (selectedRow >= 0 && selectedRow < tableModel.getRowCount()) {
            selectedRow = listTable.convertRowIndexToModel(selectedRow);
            VradiFormPageDTO formPageDTO = tableModel.getFormPageDTO();
            List formsToShow = formPageDTO.getFormsToShow();
            Form data = (Form)formsToShow.get(selectedRow);
            if (data != null) {
                log.info((Object)("Show Form: " + data.getObjet()));
                this.addEditPane(context, data);
            }
        }
    }

    class StatusActionListener
    implements ActionListener {
        final Status status;
        final OfferListUI offerListUI;

        public StatusActionListener(OfferListUI offerListUI, Status status) {
            this.offerListUI = offerListUI;
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int confirm = JOptionPane.showConfirmDialog(this.offerListUI, I18n._((String)"vradi.offerList.status.change.confirmation.message", (Object[])new Object[]{this.status.getName()}), I18n._((String)"vradi.offerList.status.change.confirmation.title"), 0);
            if (confirm == 0) {
                this.offerListUI.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    int[] selectedRows;
                    ArrayList<Form> formsToUpdate = new ArrayList<Form>();
                    for (int row : selectedRows = this.offerListUI.getListTable().getSelectedRows()) {
                        OfferTable listTable = this.offerListUI.getListTable();
                        OfferListTableModel tableModel = this.offerListUI.getOfferListTableModel();
                        row = listTable.convertRowIndexToModel(row);
                        VradiFormPageDTO formPageDTO = tableModel.getFormPageDTO();
                        List formsToShow = formPageDTO.getFormsToShow();
                        Form form = (Form)formsToShow.get(row);
                        if (form == null) continue;
                        OfferListHandler.this.changeStatus((JAXXContext)this.offerListUI, form, this.status);
                        formsToUpdate.add(form);
                    }
                    VradiService.getVradiStorageService().updateForms(formsToUpdate);
                    SearchHandler handler = this.offerListUI.getSearchHandler();
                    handler.executeQuery((JAXXContext)this.offerListUI);
                }
                catch (VradiException eee) {
                    log.error((Object)eee.getMessage(), (Throwable)eee);
                    ErrorDialogUI.showError((Exception)((Object)eee));
                }
                finally {
                    this.offerListUI.setCursor(null);
                }
            }
        }
    }
}

