package com.jurismarches.vradi.ui.renderer;

import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

import org.apache.commons.lang.math.NumberUtils;
import org.nuiton.i18n.I18n;

/**
 * NumberListCellRenderer.
 *
 * @author schorlet
 * @version $Revision: 645 $ $Date: 2010-03-24 14:36:45 +0100 (mer., 24 mars 2010) $
 * @since 24 mars 2010 12:26:58
 */
public class NumberListCellRenderer extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {
        String stringValue = String.valueOf(value);
        Object newValue = value;
        
        if (NumberUtils.isNumber(stringValue)) {
            Number number = NumberUtils.createNumber(stringValue);
            if (number.longValue() == Long.MAX_VALUE || number.intValue() == Integer.MAX_VALUE) {
                newValue = I18n._("vradi.common.alls");
            }
        }
        
        return super.getListCellRendererComponent(list, newValue, index, isSelected,
                cellHasFocus);
    }
}
