/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.helpers;

import static org.nuiton.i18n.I18n._;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.navigation.*;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;

/**
 * @author letellier
 */
public class XmlStreamNavigationTreeHelper extends AdminNavigationTreeHelper {

    protected NavigationModel<NavigationTreeNode> cachedModel;

    protected boolean datasChanged = false;
                        
    public XmlStreamNavigationTreeHelper(JAXXContext context) {
        super(VradiContext.getXmlStreamEntryDef().getName(), context);

        JAXXContextEntryDef<List<XmlStream>> xmlStreamEntryDef = VradiContext.getXmlStreamEntryDef();
        VradiContext.get().addPropertyChangeListener(xmlStreamEntryDef, xmlStreamEntryDef.getName(), new PropertyChangeListener(){
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                datasChanged = true;
            }
        });
    }

    @Override
    public NavigationModel<NavigationTreeNode> createTreeModel() {

        if (cachedModel != null && !datasChanged){
            return cachedModel;
        }
        
        JAXXContext context = getContext();
        List<XmlStream> xmlStreams = VradiContext.getXmlStreamInEntryDef();

        // construction du noeud root
        // il ne contient pas de context et ne sera pas visible
        NavigationTreeNode rootNode = builder.buildEmptyRoot(null, "$root");

        JAXXContextEntryDef<List<XmlStream>> xmlStreamEntryDef = VradiContext.getXmlStreamEntryDef();
        NavigationTreeNode xmlStreamNode = builder.build(rootNode,
                _(xmlStreamEntryDef.getName()),
                xmlStreamEntryDef, "xmlStreams",
                AdminXmlStreamUI.class, null);

        for (XmlStream x : xmlStreams) {
            builder.addXmlStream(context, xmlStreamNode, x);
        }

        // save tree model in context
        cachedModel = builder.getModel();
        setModel(context, cachedModel);

        setSelectedNode(context, xmlStreamNode);

        datasChanged = false;

        return cachedModel;
    }
    
    @Override
    public NavigationTreeNode removeChildNode(NavigationTreeNode node) {
        List<XmlStream> streams = VradiContext.getXmlStreamInEntryDef();
        
        XmlStream bean = (XmlStream) node.getBean();
        streams.remove(bean);
        
        return super.removeChildNode(node);
    }
}
