package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.OfferListColumnFactory;
import com.jurismarches.vradi.ui.OfferTable;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.email.*;
import com.jurismarches.vradi.ui.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.OfferListTableModel;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class FormViewUI extends jaxx.runtime.swing.Table implements jaxx.runtime.swing.navigation.NavigationContentUI<NavigationTreeNode>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_SESSION = "session";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLIENTS_FORM_FORM = "clientsForm.form";
    public static final String BINDING_CLIENTS_FORM_SESSION = "clientsForm.session";
    public static final String BINDING_GROUPS_FORM_FORM = "groupsForm.form";
    public static final String BINDING_GROUPS_FORM_SESSION = "groupsForm.session";
    public static final String BINDING_USERS_FORM_FORM = "usersForm.form";
    public static final String BINDING_USERS_FORM_SESSION = "usersForm.session";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUO28TQRDHxya2sR1eCVhBBBTCQwihMwgJikQhKJFFkENEDFGEG9Z3G3vDPTa7e86lQXwEPgL0NEh0VIiCmoIG8RUQoqBFzJ7tc0zOxsJX7Plmdn77n9kZv/kOKSng/DYJAkP4rmIONe7f3dxcq21TUy1TaQrGlSeg9SSSkKxC3orsUsGFalmHF9vhxSXP4Z5L3X3Rc2XISbVnU9mgVCk42xthSlmsRO65gPuiQ41ExVFf/fyRfGm9eJ0ECDiqS2MqM/+K6mYyVoYksxRM4ElNUrSJW0cZgrl11HtE25ZsIuUD4tAdeA6ZMqQ5EQhTMDt8yiEjjA+4gtyWJ5wNRncfryi4anqOse0LJh0izAaVRlMQixk+M6hDmG2Uos2ch4y0goykUjLPVXCzT7ikoslM/LSUZ2xoU6UVsvxorcsZq1GCkOtDQ7SYHkKuLjyfS23vz4lyeehTsbdKnlHRykhDshErb9oM6xfCtOlkrzvro54DTgFnem4b+8jo9lH3ohNVSAkfzQqmqgdbbx1draab+qvpNDD0/i5Mfnn/7V2p02njePap2K37BgU7gAuPU6GYPvpYq818xeziKuFzVchKauOUhVM0HSOs0najODzvhA43dLhxj8gGIlKZrx8+Fp5+PgTJEuRsj1glovevQFY1BFbBs62A31kMFY3vHsb1uNaGl78VXtrReYsoMlNjroVdvxBgCaZjShDpqGU//ZqsvF3slCGBsk733d4tReoJpJlrM5eGI9eeptgRy3NJfcvrTk3cHCX0e5K3W/FcuM7G5Znfibou3HQp8PXrcqhd/7oyNKozd6NiFFM21dM/Md8qyQxR+KdT8xVd+F+sNl8cIKwwFOHayIQbIxNu6eX2KIRBdZgauQ7DEQbVYTjCoDpowh9N9GjnuQcAAA==";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.email.FormViewUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.services.dto.VradiFormDTO bean;
    protected com.jurismarches.vradi.ui.email.QueryMakerViewUI< VradiClientDTO > clientsForm;
    protected FormViewUI formViewUI = this;
    protected com.jurismarches.vradi.ui.email.QueryMakerViewUI< VradiGroupDTO > groupsForm;
    protected com.jurismarches.vradi.services.dto.VradiSessionDTO session;
    protected com.jurismarches.vradi.ui.email.QueryMakerViewUI< VradiUserDTO > usersForm;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected EmailNavigationTreeHelper helper;
    
    
    public void setHelper(EmailNavigationTreeHelper helper){
        this.helper = helper;
    }
    
    public EmailNavigationTreeHelper getHelper(){
        if (helper != null){
            return helper;
        }
        jaxx.runtime.JAXXUtil.assignment(helper = getContextValue(EmailNavigationTreeHelper.class), "helper", com.jurismarches.vradi.ui.email.FormViewUI.this);
        if (helper != null){
            return helper;
        }
        return getParentContainer(EmailPopupUI.class).helper;
    }
    
    protected EmailHandler getHandler() {
        return UIHelper.getHandler(this, EmailHandler.class);
    }
    protected AdminHandler getAdminHandler() {
        return UIHelper.getHandler(this, AdminHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    @Override
    public void openUI(NavigationTreeNode node) throws Exception {
        // Get datas
        getHandler().displayForm(this, getHelper(), node);
        VradiFormDTO formSelected = getContextValue(VradiFormDTO.class);
        setBean(formSelected);
        
        VradiSessionDTO currentSession = getContextValue(VradiSessionDTO.class);
        updateSession(currentSession);
    
    }
    
    public void updateSession(VradiSessionDTO currentSession){   
        setSession(currentSession);
    
        // Get concerned queryMaker by form
        clientsForm.setBeans(session.getClientsSendingConcernedBy(bean));
        usersForm.setBeans(session.getUsersSendingConcernedBy(bean));
        groupsForm.setBeans(session.getGroupsSendingConcernedBy(bean));
    }
    
    @Override
    public void closeUI(NavigationTreeNode node) throws Exception {
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FormViewUI() {
        $initialize();
    }

    public FormViewUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.services.dto.VradiFormDTO getBean() {
        return bean;
    }

    public com.jurismarches.vradi.ui.email.QueryMakerViewUI< VradiClientDTO > getClientsForm() {
        return clientsForm;
    }

    public com.jurismarches.vradi.ui.email.QueryMakerViewUI< VradiGroupDTO > getGroupsForm() {
        return groupsForm;
    }

    public com.jurismarches.vradi.services.dto.VradiSessionDTO getSession() {
        return session;
    }

    public com.jurismarches.vradi.ui.email.QueryMakerViewUI< VradiUserDTO > getUsersForm() {
        return usersForm;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.services.dto.VradiFormDTO newValue) {
        com.jurismarches.vradi.services.dto.VradiFormDTO oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setSession(com.jurismarches.vradi.services.dto.VradiSessionDTO newValue) {
        com.jurismarches.vradi.services.dto.VradiSessionDTO oldValue = this.session;
        this.session = newValue;
        firePropertyChange(PROPERTY_SESSION, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFormViewUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(groupsForm, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(clientsForm, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(usersForm, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createClientsForm() {
        $objectMap.put("clientsForm", clientsForm = new com.jurismarches.vradi.ui.email.QueryMakerViewUI< VradiClientDTO >());
        clientsForm.setName("clientsForm");
        clientsForm.setTitleUI("vradi.email.formClientTitle");
    }

    protected void createGroupsForm() {
        $objectMap.put("groupsForm", groupsForm = new com.jurismarches.vradi.ui.email.QueryMakerViewUI< VradiGroupDTO >());
        groupsForm.setName("groupsForm");
        groupsForm.setTitleUI("vradi.email.formGroupTitle");
    }

    protected void createSession() {
        $objectMap.put("session", session = null);
    }

    protected void createUsersForm() {
        $objectMap.put("usersForm", usersForm = new com.jurismarches.vradi.ui.email.QueryMakerViewUI< VradiUserDTO >());
        usersForm.setName("usersForm");
        usersForm.setTitleUI("vradi.email.formUserTitle");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToFormViewUI();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        groupsForm.setQueryMakers(getHandler().getAllGroups());
        clientsForm.setQueryMakers(getHandler().getAllClients());
        usersForm.setQueryMakers(getHandler().getAllUsers());
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 6 data bindings
        $registerDefaultBindings();
        $objectMap.put("formViewUI", this);
        createSession();
        createBean();
        createGroupsForm();
        createClientsForm();
        createUsersForm();
        // inline creation of formViewUI
        setName("formViewUI");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROUPS_FORM_FORM, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                groupsForm.setForm(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROUPS_FORM_SESSION, true ,"session") {
        
            @Override
            public void processDataBinding() {
                groupsForm.setSession(getSession());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENTS_FORM_FORM, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                clientsForm.setForm(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENTS_FORM_SESSION, true ,"session") {
        
            @Override
            public void processDataBinding() {
                clientsForm.setSession(getSession());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USERS_FORM_FORM, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                usersForm.setForm(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USERS_FORM_SESSION, true ,"session") {
        
            @Override
            public void processDataBinding() {
                usersForm.setSession(getSession());
            }
        });
    }

}