package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.services.dto.VradiQueryBean;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class RequestSelectUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_QUERY_DESCRIPTION_TEXT = "queryDescription.text";
    public static final String BINDING_QUERY_DESCRIPTION_TOOL_TIP_TEXT = "queryDescription.toolTipText";
    public static final String BINDING_QUERY_NAME_TEXT = "queryName.text";
    public static final String BINDING_QUERY_NAME_TOOL_TIP_TEXT = "queryName.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_TOOL_TIP_TEXT = "$JButton0.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.RequestSelectUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.services.dto.VradiQueryBean bean;
    protected javax.swing.JTextArea queryDescription;
    protected javax.swing.JTextField queryName;
    protected RequestSelectUI requestSelectUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    public void confirmDeletion() {
        VradiQueryBean queryBean = getBean();
        if (StringUtils.isBlank(queryBean.getName())
                && StringUtils.isBlank(queryBean.getDescription())
                && StringUtils.isBlank(queryBean.getQuery())) {
            setBean(null);
            
        } else {
            int confirm = JOptionPane.showConfirmDialog(this,
                    _("vradi.admin.confirmDelete", VradiHelper.getEntityName(getBean())),
                    _("vradi.admin.deleteTitle"), JOptionPane.YES_NO_OPTION);
        
            if (confirm == JOptionPane.YES_OPTION) {
                setBean(null);
            }
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RequestSelectUI() {
        $initialize();
    }

    public RequestSelectUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().openRequest(this, getBean());
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        confirmDeletion();
    }

    public void doKeyReleased__on__queryDescription(java.awt.event.KeyEvent event) {
        setBean(getBean().setDescription(queryDescription.getText()));
    }

    public void doKeyReleased__on__queryName(java.awt.event.KeyEvent event) {
        setBean(getBean().setName(queryName.getText()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.services.dto.VradiQueryBean getBean() {
        return bean;
    }

    public javax.swing.JTextArea getQueryDescription() {
        return queryDescription;
    }

    public javax.swing.JTextField getQueryName() {
        return queryName;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.services.dto.VradiQueryBean newValue) {
        com.jurismarches.vradi.services.dto.VradiQueryBean oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToRequestSelectUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.3, 0.0, 11, 2, new Insets(0, 6, 0, 0), 0, 0));
        add($JLabel1, new GridBagConstraints(1, 0, 3, 1, 0.7, 0.0, 11, 2, new Insets(0, 6, 0, 0), 0, 0));
        add(queryName, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton0, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton1, new GridBagConstraints(3, 1, 1, 1, 0.1, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new VradiQueryBean());
    }

    protected void createQueryDescription() {
        $objectMap.put("queryDescription", queryDescription = new javax.swing.JTextArea());
        queryDescription.setName("queryDescription");
        queryDescription.setColumns(15);
        queryDescription.setLineWrap(true);
        queryDescription.setWrapStyleWord(true);
        queryDescription.setRows(2);
        queryDescription.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__queryDescription"));
    }

    protected void createQueryName() {
        $objectMap.put("queryName", queryName = new javax.swing.JTextField());
        queryName.setName("queryName");
        queryName.setColumns(15);
        queryName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__queryName"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToRequestSelectUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(queryDescription);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 5 data bindings
        $registerDefaultBindings();
        $objectMap.put("requestSelectUI", this);
        createBean();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.requestSelectUI.name"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.requestSelectUI.description"));
        createQueryName();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createQueryDescription();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminRequest.edit"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        $JButton1.setName("$JButton1");
        $JButton1.setToolTipText(_("vradi.adminRequest.remove"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of requestSelectUI
        setName("requestSelectUI");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_NAME_TOOL_TIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    queryName.setToolTipText(_(getBean().getQuery()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(queryName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_DESCRIPTION_TOOL_TIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    queryDescription.setToolTipText(_(getBean().getQuery()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_DESCRIPTION_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(queryDescription, getBean().getDescription());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_TOOL_TIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    $JButton0.setToolTipText(_(getBean().getQuery()));
                }
            }
        });
    }

}