package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.JListCellRenderer;
import com.jurismarches.vradi.ui.ProgressBarUI;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.editors.JListCellEditor;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.XmlStreamFieldTableModel;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import jaxx.runtime.validator.swing.SwingValidator;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminXmlStreamUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<XmlStream> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FORM_TYPE_SELECTION_MODEL = "formTypeSelectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADMIN_XML_STREAM_UI_ENABLED = "adminXmlStreamUI.enabled";
    public static final String BINDING_CREATE_FORMS_ENABLED = "createForms.enabled";
    public static final String BINDING_FORM_TYPE_COMBO_SELECTED_ITEM = "formTypeCombo.selectedItem";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_VALIDATE_URL_ENABLED = "validateUrl.enabled";
    public static final String BINDING_XML_STREAM_NAME_TEXT = "xmlStreamName.text";
    public static final String BINDING_XML_STREAM_PREVIEW_TOOL_TIP_TEXT = "xmlStreamPreview.toolTipText";
    public static final String BINDING_XML_STREAM_URL_TEXT = "xmlStreamUrl.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminXmlStreamForm;
    protected AdminXmlStreamUI adminXmlStreamUI = this;
    protected com.jurismarches.vradi.services.dto.VradiXmlStreamDTO bean;
    protected javax.swing.JButton config;
    protected javax.swing.JButton createForms;
    protected javax.swing.JButton createXmlStream;
    protected com.jurismarches.vradi.ui.models.XmlStreamFieldTableModel fieldsModel;
    protected org.jdesktop.swingx.JXTable fieldsTable;
    protected javax.swing.JComboBox formTypeCombo;
    protected javax.swing.ComboBoxModel formTypeSelectionModel;
    protected jaxx.runtime.swing.HBox lastModified;
    protected javax.swing.JLabel title;
    protected javax.swing.JButton validateUrl;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiXmlStreamDTO > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();
    protected javax.swing.JTextField xmlStreamName;
    protected javax.swing.JLabel xmlStreamPreview;
    protected javax.swing.JButton xmlStreamSite;
    protected javax.swing.JTextField xmlStreamUrl;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    void $afterCompleteSetup() {
        if (log.isDebugEnabled()) {
            addPCSLogger();
            addBeanPCSLogger(bean);
        }
        addBeanModifiedPCS(bean);
        SwingUtil.setI18nTableHeaderRenderer(fieldsTable,
            n_("vradi.adminXmlStream.table.field.name"),
            n_("vradi.adminXmlStream.table.field.name.tip"),
            n_("vradi.adminXmlStream.table.field.values"),
            n_("vradi.adminXmlStream.table.field.values.tip"),
            n_("vradi.adminXmlStream.table.field.defaultValue"),
            n_("vradi.adminXmlStream.table.field.defaultValue.tip"));
    
        TableCellRenderer tbc = new DefaultTableCellRenderer() {
            @Override
            public Component getTableCellRendererComponent(JTable table, Object value,
                      boolean isSelected, boolean hasFocus, int row, int column) {
                              
                String sTranslatedValue = null;
                if (column == 0 && value != null) {
                    String sValue = (String) value;
                    int dot = sValue.lastIndexOf(".");
                    String extName = sValue.substring(0, dot);
                    if (Infogene.EXT_INFOGENE.equals(extName) || Form.EXT_FORM.equals(extName)) {
                        sTranslatedValue = _(sValue);
                    } else {
                        sTranslatedValue = sValue.substring(dot + 1);
                    }
                }
                return super.getTableCellRendererComponent(table, sTranslatedValue, isSelected, hasFocus, row, column);
            }
        };
    
        JListCellRenderer render = new JListCellRenderer(fieldsTable.getDefaultRenderer(String.class));
        setContextValue(render);
    
        SwingUtil.setTableColumnRenderer(fieldsTable, 0, tbc);
        SwingUtil.setTableColumnRenderer(fieldsTable, 1, render);
    
        JListCellEditor editor = new JListCellEditor();
        setContextValue(editor);
        SwingUtil.setTableColumnEditor(fieldsTable, 1, editor);
        
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
            HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        fieldsTable.addHighlighter(highlighter);
        errorTable.registerValidator(validator);
    }
    
    protected void validateFormTypeChoice() {
        stopEditing();
        boolean modified = isModified();
        getHandler().updateXmlStreamFieldModel(this);
        setModified(modified);
        validate();
    }
    
    @Override
    public void openUI(final NavigationTreeNode node) throws Exception {
        super.openUI(node);
        getHandler().openAdminXmlStreamUI(this);
    }
    
    @Override
    public void save() {
        stopEditing();
        this.bean.setLastModified(new java.util.Date());
        this.bean.setLastModifier(getContextValue(VradiUser.class).getName());
        XmlStream xmlStream = (XmlStream) getHelper().getSelectedBean(this);
        if(!xmlStream.getExtensionNames().contains(ModificationTag.EXT_MODIFICATION_TAG)) {
            BusinessEntityWikitty entityWikitty = (BusinessEntityWikitty) xmlStream;
            entityWikitty.getWikitty().addExtension(ModificationTag.EXTENSION_MODIFICATION_TAG);
        }
        
        this.bean.toWikitty(xmlStream);
        xmlStream = getHandler().saveXmlStream(this, getHelper(), xmlStream, fieldsModel.getBindings());
    }
    
    @Override
    protected void updateBeanFromEntity(XmlStream bean) {
        this.bean.fromWikitty(bean);
    }
    
    protected void stopEditing() {
        //FIXME-TC20091116 il faut pouvoir annuler l'édition si on sort du tableau
        if (fieldsTable.getCellEditor() != null) {
            fieldsTable.getCellEditor().stopCellEditing();
        }
    }
    
    protected void createForms() {
        getHandler().createForms(this);
    }
    
    protected String updateTitle(String name) {         
       return _("vradi.adminXmlStream.title", SwingUtil.getStringValue(name));
    }
    
    protected void browseURI(String url) {
        UIHelper.browseURI(url);
    }
    
    protected void onFormTypeComboActionPerformed() {
        setModified(true);
        String extensionName = (String) formTypeCombo.getSelectedItem();
        bean.setFormTypeName(extensionName);
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                validateFormTypeChoice();
            }
        });
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminXmlStreamUI() {
        super();
        $initialize();
    }

    public AdminXmlStreamUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiXmlStreamDTO > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), bean);
    }

    public void doActionPerformed__on__config(java.awt.event.ActionEvent event) {
        XmlStreamConfigUI configUi = new XmlStreamConfigUI(this); configUi.setVisible(true);
    }

    public void doActionPerformed__on__createForms(java.awt.event.ActionEvent event) {
        createForms();
    }

    public void doActionPerformed__on__createXmlStream(java.awt.event.ActionEvent event) {
        getHandler().createXmlStream(this, getHelper());
    }

    public void doActionPerformed__on__formTypeCombo(java.awt.event.ActionEvent event) {
        onFormTypeComboActionPerformed();
    }

    public void doActionPerformed__on__validateUrl(java.awt.event.ActionEvent event) {
        validateFormTypeChoice();
    }

    public void doActionPerformed__on__xmlStreamSite(java.awt.event.ActionEvent event) {
        browseURI(bean.getUrl());
    }

    public void doKeyReleased__on__xmlStreamName(java.awt.event.KeyEvent event) {
        bean.setName(xmlStreamName.getText());
    }

    public void doKeyReleased__on__xmlStreamUrl(java.awt.event.KeyEvent event) {
        bean.setUrl(xmlStreamUrl.getText());
    }

    public void doTableChanged__on__fieldsModel(javax.swing.event.TableModelEvent event) {
        setModified(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminXmlStreamForm() {
        return adminXmlStreamForm;
    }

    public com.jurismarches.vradi.services.dto.VradiXmlStreamDTO getBean() {
        return bean;
    }

    public javax.swing.JButton getConfig() {
        return config;
    }

    public javax.swing.JButton getCreateForms() {
        return createForms;
    }

    public javax.swing.JButton getCreateXmlStream() {
        return createXmlStream;
    }

    public com.jurismarches.vradi.ui.models.XmlStreamFieldTableModel getFieldsModel() {
        return fieldsModel;
    }

    public org.jdesktop.swingx.JXTable getFieldsTable() {
        return fieldsTable;
    }

    public javax.swing.JComboBox getFormTypeCombo() {
        return formTypeCombo;
    }

    public javax.swing.ComboBoxModel getFormTypeSelectionModel() {
        return formTypeSelectionModel;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    public javax.swing.JButton getValidateUrl() {
        return validateUrl;
    }

    public javax.swing.JTextField getXmlStreamName() {
        return xmlStreamName;
    }

    public javax.swing.JLabel getXmlStreamPreview() {
        return xmlStreamPreview;
    }

    public javax.swing.JButton getXmlStreamSite() {
        return xmlStreamSite;
    }

    public javax.swing.JTextField getXmlStreamUrl() {
        return xmlStreamUrl;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setFormTypeSelectionModel(javax.swing.ComboBoxModel newValue) {
        javax.swing.ComboBoxModel oldValue = this.formTypeSelectionModel;
        this.formTypeSelectionModel = newValue;
        firePropertyChange(PROPERTY_FORM_TYPE_SELECTION_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminXmlStreamForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminXmlStreamForm.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(SwingUtil.boxComponentWithJxLayer(xmlStreamName), new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(SwingUtil.boxComponentWithJxLayer(xmlStreamUrl), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(xmlStreamPreview, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(xmlStreamSite, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(SwingUtil.boxComponentWithJxLayer(formTypeCombo), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(validateUrl, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminXmlStreamForm, BorderLayout.NORTH);
        body.add($JScrollPane0, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(bean);
        validator.setFieldRepresentation("formTypeName", formTypeCombo);
        validator.setFieldRepresentation("name", xmlStreamName);
        validator.setFieldRepresentation("url", xmlStreamUrl);
    }

    protected void createAdminXmlStreamForm() {
        $objectMap.put("adminXmlStreamForm", adminXmlStreamForm = new jaxx.runtime.swing.Table());
        adminXmlStreamForm.setName("adminXmlStreamForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.services.dto.VradiXmlStreamDTO());
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createConfig() {
        $objectMap.put("config", config = new javax.swing.JButton());
        config.setName("config");
        config.setText(_("vradi.adminXmlStream.config"));
        config.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__config"));
    }

    protected void createCreateForms() {
        $objectMap.put("createForms", createForms = new javax.swing.JButton());
        createForms.setName("createForms");
        createForms.setText(_("vradi.adminXmlStream.createForms"));
        createForms.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createForms"));
    }

    protected void createCreateXmlStream() {
        $objectMap.put("createXmlStream", createXmlStream = new javax.swing.JButton());
        createXmlStream.setName("createXmlStream");
        createXmlStream.setText(_("vradi.adminXmlStream.createXmlStream"));
        createXmlStream.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createXmlStream"));
    }

    protected void createFieldsModel() {
        $objectMap.put("fieldsModel", fieldsModel = new com.jurismarches.vradi.ui.models.XmlStreamFieldTableModel());
        fieldsModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__fieldsModel"));
    }

    protected void createFieldsTable() {
        $objectMap.put("fieldsTable", fieldsTable = new org.jdesktop.swingx.JXTable());
        fieldsTable.setName("fieldsTable");
        if (fieldsTable.getFont() != null) {
            fieldsTable.setFont(fieldsTable.getFont().deriveFont((float) 11));
        }
        fieldsTable.setRowSelectionAllowed(false);
    }

    protected void createFormTypeCombo() {
        $objectMap.put("formTypeCombo", formTypeCombo = new javax.swing.JComboBox());
        formTypeCombo.setName("formTypeCombo");
        formTypeCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__formTypeCombo"));
    }

    protected void createFormTypeSelectionModel() {
        $objectMap.put("formTypeSelectionModel", formTypeSelectionModel = UIHelper.getFormTypesNameModel(getHandler()));
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new jaxx.runtime.swing.Table());
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createValidateUrl() {
        $objectMap.put("validateUrl", validateUrl = new javax.swing.JButton());
        validateUrl.setName("validateUrl");
        validateUrl.setText(_("vradi.adminXmlStream.validateUrl"));
        validateUrl.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateUrl"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiXmlStreamDTO >(com.jurismarches.vradi.services.dto.VradiXmlStreamDTO.class, null));
    }

    protected void createXmlStreamName() {
        $objectMap.put("xmlStreamName", xmlStreamName = new javax.swing.JTextField());
        xmlStreamName.setName("xmlStreamName");
        xmlStreamName.setColumns(15);
        xmlStreamName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__xmlStreamName"));
    }

    protected void createXmlStreamPreview() {
        $objectMap.put("xmlStreamPreview", xmlStreamPreview = new javax.swing.JLabel());
        xmlStreamPreview.setName("xmlStreamPreview");
    }

    protected void createXmlStreamSite() {
        $objectMap.put("xmlStreamSite", xmlStreamSite = new javax.swing.JButton());
        xmlStreamSite.setName("xmlStreamSite");
        xmlStreamSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__xmlStreamSite"));
    }

    protected void createXmlStreamUrl() {
        $objectMap.put("xmlStreamUrl", xmlStreamUrl = new javax.swing.JTextField());
        xmlStreamUrl.setName("xmlStreamUrl");
        xmlStreamUrl.setColumns(15);
        xmlStreamUrl.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__xmlStreamUrl"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createXmlStream);
        $JPanel0.add(config);
        $JPanel0.add(createForms);
        $JPanel0.add($JButton0);
        $JPanel0.add($HidorButton0);
        addChildrenToBody();
        addChildrenToAdminXmlStreamForm();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fieldsTable);
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 16 property setters
        createXmlStream.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.add"));
        config.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("config"));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.delete"));
        $HidorButton0.setHideTip(_("vradi.adminXmlStream.hideForm"));
        $HidorButton0.setShowTip(_("vradi.adminXmlStream.showForm"));
        $HidorButton0.setTarget(adminXmlStreamForm);
        $HidorButton0.setTargetVisible(true);
        adminXmlStreamForm.setMinimumSize(SwingUtil.newMinDimension());
        xmlStreamPreview.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.magnify"));
        xmlStreamSite.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("site"));
        formTypeCombo.setModel(formTypeSelectionModel);
        fieldsTable.setModel(fieldsModel);
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 9 data bindings
        $registerDefaultBindings();
        $objectMap.put("adminXmlStreamUI", this);
        createBean();
        createFieldsModel();
        createFormTypeSelectionModel();
        createValidator();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        createCreateXmlStream();
        createConfig();
        createCreateForms();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminXmlStream.deleteXmlStream"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        $HidorButton0.setName("$HidorButton0");
        createAdminXmlStreamForm();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminXmlStream.name"));
        createXmlStreamName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminXmlStream.url"));
        createXmlStreamUrl();
        createXmlStreamPreview();
        createXmlStreamSite();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminXmlStream.formType"));
        createFormTypeCombo();
        createValidateUrl();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createFieldsTable();
        createLastModified();
        // inline creation of adminXmlStreamUI
        setName("adminXmlStreamUI");
        ((javax.swing.JPanel) adminXmlStreamUI.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 9 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADMIN_XML_STREAM_UI_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("wikittyId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    setEnabled(bean.getWikittyId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("wikittyId", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TITLE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    title.setText(_(updateTitle(bean.getName())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_FORMS_ENABLED, true ,"enabled" ,"valide") {
        
            @Override
            public void processDataBinding() {
                createForms.setEnabled(isEnabled() && isValide());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_XML_STREAM_NAME_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(xmlStreamName, bean.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_XML_STREAM_URL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("url", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(xmlStreamUrl, bean.getUrl());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("url", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_XML_STREAM_PREVIEW_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("url", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    xmlStreamPreview.setToolTipText(_(getHandler().getFirstElementPreview(AdminXmlStreamUI.this, bean.getUrl())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("url", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FORM_TYPE_COMBO_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("formTypeName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    formTypeCombo.setSelectedItem(bean.getFormTypeName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("formTypeName", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATE_URL_ENABLED, true ,"enabled" ,"valide") {
        
            @Override
            public void processDataBinding() {
                validateUrl.setEnabled(isEnabled() && isValide());
            }
        });
    }

}