package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.*;
import com.jurismarches.vradi.ui.helpers.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.renderer.ThesaurusHighlighter;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.handler.AbstractNavigationHandler;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModel;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_DELETABLE = "deletable";
    public static final String PROPERTY_EXPAND = "expand";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JLABEL0_TOOL_TIP_TEXT = "$JLabel0.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.ThesaurusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.Form bean;
    protected java.lang.Boolean deletable;
    protected java.lang.Boolean expand;
    protected javax.swing.JTree thesaurus;
    protected javax.swing.JList thesaurusSelected;
    protected ThesaurusUI thesaurusUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JScrollPane $JScrollPane1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected ThesaurusTreeHelper helper;
    protected DefaultListModel thesaurusSelectedModel;
    protected OfferEditUI ui;
    
    
    public  ThesaurusUI(jaxx.runtime.JAXXContext parentContext, OfferEditUI ui, VradiThesaurusDTO rootThesaurus) {
        jaxx.runtime.SwingUtil.initContext(this, parentContext);
        this.helper = new ThesaurusTreeHelper(this, rootThesaurus, TreeSelectionModel.DISCONTIGUOUS_TREE_SELECTION);
        this.ui = ui;
    
        ui.addThesaurusHelper(helper);
        setContextValue(helper);
    $initialize();
    }
    
    public OfferEditUI getParentUI(){
        return ui;
    }
    
    public ThesaurusTreeHelper getHelper(){
        return helper;
    }
    
    protected ThesaurusHandler getHandler() {
        return getContextValue(ThesaurusHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        SimpleJAXXObjectBinding sjob = new SimpleJAXXObjectBinding(this, PROPERTY_BEAN, false, "bean"){
            @Override
            public void processDataBinding() {
                if (log.isDebugEnabled()){
                    log.debug("tryToSelect");
                }
                helper.tryToSelect(getBean().getThesaurus());;
            }
        };
        registerDataBinding(sjob);
        sjob.applyDataBinding();
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
                JTree tree = (JTree) mouseEvent.getSource();
                TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
                // If node is selected
                boolean isSelected = path != null;
                if (mouseEvent.getButton() == MouseEvent.BUTTON3){
                    JPopupMenu popup = new JPopupMenu();
    
                    JMenuItem menuAddCriteria = new JMenuItem();
                    menuAddCriteria.setText(_("vradi.menu.addCriteria"));
                    menuAddCriteria.addActionListener(new ActionListener() {
    
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            addCriteriaSelected(getPathSelected(mouseEvent));
                        }
                    });
                    popup.add(menuAddCriteria);
    
    //                JMenuItem menuAddColumns = new JMenuItem();
    //                menuAddColumns.setText(_("vradi.menu.addColumns"));
    //                menuAddColumns.addActionListener(new ActionListener() {
    //
    //                    @Override
    //                    public void actionPerformed(ActionEvent actionEvent) {
    //                        addColumnSelected(getPathSelected(mouseEvent));
    //                    }
    //                });
    //                popup.add(menuAddColumns);
    
                    if (isSelected){
                        JMenuItem menuAddThesaurus = new JMenuItem();
                        menuAddThesaurus.setText(_("vradi.menu.addThesaurus"));
                        menuAddThesaurus.addActionListener(new ActionListener() {
    
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                addThesaurusSelected(getPathSelected(mouseEvent));
                            }
                        });
                        popup.add(menuAddThesaurus);
                    }
                    
                    popup.show(thesaurus, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        if (expand){
            SwingUtil.addExpandOnClickListener(thesaurus);
        }
    
        // Expends root
        helper.expendNode(helper.getRootNode());
    
        thesaurus.addTreeSelectionListener(new TreeSelectionListener(){
    
            @Override
            public void valueChanged(TreeSelectionEvent e) {
                thsaurusSelected();
            }
        });
    }
    
    public DefaultListModel getThesaurusSelectedModel(){
        return thesaurusSelectedModel;
    }
    
    protected void thsaurusSelected(){
        TreePath[] treePaths = thesaurus.getSelectionPaths();
        jaxx.runtime.JAXXUtil.assignment(thesaurusSelectedModel = new DefaultListModel(), "thesaurusSelectedModel", com.jurismarches.vradi.ui.ThesaurusUI.this);
        if (treePaths != null){
            for (TreePath path : treePaths){
                NavigationTreeNode selected = (NavigationTreeNode)path.getLastPathComponent();
                VradiThesaurusDTO thesaurusSelected = (VradiThesaurusDTO)selected.getBean(this);
                thesaurusSelectedModel.addElement(thesaurusSelected);
            }
        }
        thesaurusSelected.setModel(thesaurusSelectedModel);
    }
    
    protected TreePath getPathSelected(MouseEvent mouseEvent){
        JTree tree = (JTree) mouseEvent.getSource();
    
        // Recuperation du path selectionne
        TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
        return path;
    }
    
    protected void addCriteriaSelected(TreePath path){
        log.debug("addCriteriaSelected " + path);
        // Ajout dun nouveau thesaurus
        getHandler().addCriteria(this, helper, path);
    }
    
    protected void addThesaurusSelected(TreePath path){
        log.debug("addThesaurusSelected " + path);
        // Ajout dun nouveau thesaurus
        getHandler().addThesaurusUI(this, path);
    }
    
    protected void addColumnSelected(TreePath path){
        log.debug("addColumnSelected " + path);
        // Ajout dune nouvelle column
        getHandler().addColumn(this, helper, path);
    }
    
    protected String getRootNamePath(){
        String path = helper.getRootNamePath();
        return StringUtils.abbreviate(path, path.length() - 20, 23);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusUI() {
        $initialize();
    }

    public ThesaurusUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().closeThesaurus(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.Form getBean() {
        return bean;
    }

    public java.lang.Boolean getDeletable() {
        return deletable;
    }

    public java.lang.Boolean getExpand() {
        return expand;
    }

    public javax.swing.JTree getThesaurus() {
        return thesaurus;
    }

    public javax.swing.JList getThesaurusSelected() {
        return thesaurusSelected;
    }

    public java.lang.Boolean isDeletable() {
        return deletable !=null && deletable;
    }

    public java.lang.Boolean isExpand() {
        return expand !=null && expand;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Form newValue) {
        com.jurismarches.vradi.entities.Form oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setDeletable(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.deletable;
        this.deletable = newValue;
        firePropertyChange(PROPERTY_DELETABLE, oldValue, newValue);
    }

    public void setExpand(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.expand;
        this.expand = newValue;
        firePropertyChange(PROPERTY_EXPAND, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JButton0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane1, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void create$JButton0() {
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setBorderPainted(false);
        $JButton0.setFocusPainted(false);
        $JButton0.setHorizontalTextPosition(0);
        $JButton0.setOpaque(true);
        $JButton0.setVerticalAlignment(0);
        $JButton0.setVerticalTextPosition(0);
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createDeletable() {
        $objectMap.put("deletable", deletable = false);
    }

    protected void createExpand() {
        $objectMap.put("expand", expand = VradiHelper.isExpandSelected());
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new javax.swing.JTree());
        thesaurus.setName("thesaurus");
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    protected void createThesaurusSelected() {
        $objectMap.put("thesaurusSelected", thesaurusSelected = new javax.swing.JList());
        thesaurusSelected.setName("thesaurusSelected");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurusSelected);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(thesaurus);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        $JLabel0.setText(_(getRootNamePath()));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("closeTab"));
        $JButton0.setSize(new Dimension(16, 16));
        thesaurusSelected.setCellRenderer(new ThesaurusHighlighter());
        thesaurus.setCellRenderer(new ThesaurusHighlighter());
        thesaurus.setModel((NavigationTreeModel)helper.createTreeModel(this));
        thesaurus.setSelectionModel(getHelper().createTreeHandler(this));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 2 data bindings
        $registerDefaultBindings();
        $objectMap.put("thesaurusUI", this);
        createBean();
        createDeletable();
        thesaurusSelectedModel = new DefaultListModel();
        createExpand();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        create$JButton0();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurusSelected();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        $JScrollPane1.setName("$JScrollPane1");
        createThesaurus();
        // inline creation of thesaurusUI
        setName("thesaurusUI");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TOOL_TIP_TEXT, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    $JLabel0.setToolTipText(_(helper.getRootNamePath()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"deletable") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(isDeletable());
            }
        });
    }

}