package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.*;
import com.jurismarches.vradi.ui.editors.*;
import com.jurismarches.vradi.ui.helpers.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.renderer.ThesaurusHighlighter;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.OneClicListSelectionModel;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class OfferEditUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_VALIDE = "valide";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_PROPOSITION_LIST_SELECTION_MODEL = "propositionList.selectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.OfferEditUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table actionPanel;
    protected javax.swing.JButton addAttachment;
    protected javax.swing.JButton addFile;
    protected javax.swing.JButton annuler;
    protected javax.swing.JList attachmentList;
    protected javax.swing.DefaultListModel attachmentListModel;
    protected java.util.ArrayList attachmentsToUpload;
    protected javax.swing.JPanel content;
    protected com.jurismarches.vradi.ui.editors.StringEditor countryEditor;
    protected com.jurismarches.vradi.entities.Form data;
    protected com.jurismarches.vradi.ui.editors.DateTimeEditor datePeremeptionEditor;
    protected com.jurismarches.vradi.ui.editors.DateTimeEditor datePubEditor;
    protected com.jurismarches.vradi.ui.editors.StringEditor departmentEditor;
    protected com.jurismarches.vradi.ui.editors.TextEditor descriptionEditor;
    protected com.jurismarches.vradi.ui.editors.StringEditor entityEditor;
    protected jaxx.runtime.validator.swing.SwingValidatorMessageTableModel errorEditorTable;
    protected javax.swing.JList fileList;
    protected javax.swing.DefaultListModel fileListModel;
    protected java.util.ArrayList filesToUpload;
    protected jaxx.runtime.swing.Table formContentPane;
    protected javax.swing.JPanel formPane;
    protected javax.swing.JScrollPane formScrollPane;
    protected javax.swing.JSplitPane formSplitPane;
    protected com.jurismarches.vradi.ui.editors.IdEditor idEditor;
    protected jaxx.runtime.swing.HBox lastModified;
    protected com.jurismarches.vradi.ui.editors.StringEditor objetEditor;
    protected javax.swing.JSplitPane offerEdit;
    protected OfferEditUI offerEditUI = this;
    protected javax.swing.JList propositionList;
    protected javax.swing.DefaultListModel propositionListModel;
    protected javax.swing.JButton removeAttachment;
    protected javax.swing.JButton removeFile;
    protected com.jurismarches.vradi.ui.editors.StringEditor sourceTextEditor;
    protected com.jurismarches.vradi.ui.editors.UrlEditor sourceURLEditor;
    protected javax.swing.JPanel statusButtonPanel;
    protected javax.swing.JButton test;
    protected javax.swing.JPanel thesaurus;
    protected java.lang.Boolean valide;
    protected javax.swing.JButton viewPDF;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JSplitPane $JSplitPane0;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JScrollPane $JScrollPane1;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JScrollPane $JScrollPane2;
    private javax.swing.JLabel $JLabel3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<ThesaurusTreeHelper> listThesaurusHelpers;
    
    
    public OfferEditHandler getHandler() {
        return getContextValue(OfferEditHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public java.util.List<ThesaurusTreeHelper> getListThesaurusHelpers(){
        return listThesaurusHelpers;
    }
    
    public void addThesaurusHelper(ThesaurusTreeHelper helper){
        listThesaurusHelpers.add(helper);
    }
    
    public ThesaurusTreeHelper getRootThesaurusHelper(){
        return listThesaurusHelpers.get(0);
    }
    
    void $afterCompleteSetup() {
        if(data != null && data.getCreationDate() != null) {
            String creationDateText = String.format(_("vradi.entity.creation.date"),
                    data.getCreationDate());
            lastModified.add(new JLabel(creationDateText));
            if(data.getExtensionNames().contains(ModificationTag.EXT_MODIFICATION_TAG)) {
                Object date = data.getField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIED);
                Object user = data.getField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIER);
                if(date != null && user != null) {
                    String lastModifiedText = String.format(_("vradi.entity.lastModified.date.user"), date, user);
                    lastModified.add(new JLabel(lastModifiedText));
                }
            }
        }
        setContextValue(errorEditorTable, "errorEditorTable");
        formScrollPane.getVerticalScrollBar().setBlockIncrement(100);
        formScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        formSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                resize();
            }
        });
    }
    
    public void resize(){
        Dimension dimension = formContentPane.getSize();
        dimension.setSize(formSplitPane.getDividerLocation() - 20, formContentPane.getHeight());
        formContentPane.setPreferredSize(dimension);
        formContentPane.revalidate();
    }
    
    public void updateThesaurusSize(){
        double total = getSize().getWidth();
        Component[] thesPanels = thesaurus.getComponents();
        double width = total / thesPanels.length;
        for (Component c : thesPanels){
            ThesaurusUI thesaurus = (ThesaurusUI)c;
            Dimension d = thesaurus.getSize();
            if (log.isDebugEnabled()){
                log.debug("Resizing total width : " + total + " thesaurus width : " + width);
            }
            d.setSize(width, d.getHeight());
            thesaurus.setPreferredSize(d);
        }
        revalidate();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public OfferEditUI() {
        $initialize();
    }

    public OfferEditUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addAttachment(java.awt.event.ActionEvent event) {
        getHandler().addAttachment(this);
    }

    public void doActionPerformed__on__addFile(java.awt.event.ActionEvent event) {
        getHandler().addFile(this);
    }

    public void doActionPerformed__on__removeAttachment(java.awt.event.ActionEvent event) {
        getHandler().removeAttachment(this);
    }

    public void doActionPerformed__on__removeFile(java.awt.event.ActionEvent event) {
        getHandler().removeFile(this);
    }

    public void doActionPerformed__on__test(java.awt.event.ActionEvent event) {
        getHandler().findQueries(this);
    }

    public void doActionPerformed__on__viewPDF(java.awt.event.ActionEvent event) {
        getHandler().viewInPDF(this);
    }

    public void doComponentResized__on__formScrollPane(java.awt.event.ComponentEvent event) {
        resize();
    }

    public void doTableChanged__on__errorEditorTable(javax.swing.event.TableModelEvent event) {
        setValide(errorEditorTable.getRowCount()==0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getActionPanel() {
        return actionPanel;
    }

    public javax.swing.JButton getAddAttachment() {
        return addAttachment;
    }

    public javax.swing.JButton getAddFile() {
        return addFile;
    }

    public javax.swing.JButton getAnnuler() {
        return annuler;
    }

    public javax.swing.JList getAttachmentList() {
        return attachmentList;
    }

    public javax.swing.DefaultListModel getAttachmentListModel() {
        return attachmentListModel;
    }

    public java.util.ArrayList getAttachmentsToUpload() {
        return attachmentsToUpload;
    }

    public javax.swing.JPanel getContent() {
        return content;
    }

    public com.jurismarches.vradi.ui.editors.StringEditor getCountryEditor() {
        return countryEditor;
    }

    public com.jurismarches.vradi.entities.Form getData() {
        return data;
    }

    public com.jurismarches.vradi.ui.editors.DateTimeEditor getDatePeremeptionEditor() {
        return datePeremeptionEditor;
    }

    public com.jurismarches.vradi.ui.editors.DateTimeEditor getDatePubEditor() {
        return datePubEditor;
    }

    public com.jurismarches.vradi.ui.editors.StringEditor getDepartmentEditor() {
        return departmentEditor;
    }

    public com.jurismarches.vradi.ui.editors.TextEditor getDescriptionEditor() {
        return descriptionEditor;
    }

    public com.jurismarches.vradi.ui.editors.StringEditor getEntityEditor() {
        return entityEditor;
    }

    public jaxx.runtime.validator.swing.SwingValidatorMessageTableModel getErrorEditorTable() {
        return errorEditorTable;
    }

    public javax.swing.JList getFileList() {
        return fileList;
    }

    public javax.swing.DefaultListModel getFileListModel() {
        return fileListModel;
    }

    public java.util.ArrayList getFilesToUpload() {
        return filesToUpload;
    }

    public jaxx.runtime.swing.Table getFormContentPane() {
        return formContentPane;
    }

    public javax.swing.JPanel getFormPane() {
        return formPane;
    }

    public javax.swing.JScrollPane getFormScrollPane() {
        return formScrollPane;
    }

    public javax.swing.JSplitPane getFormSplitPane() {
        return formSplitPane;
    }

    public com.jurismarches.vradi.ui.editors.IdEditor getIdEditor() {
        return idEditor;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public com.jurismarches.vradi.ui.editors.StringEditor getObjetEditor() {
        return objetEditor;
    }

    public javax.swing.JSplitPane getOfferEdit() {
        return offerEdit;
    }

    public javax.swing.JList getPropositionList() {
        return propositionList;
    }

    public javax.swing.DefaultListModel getPropositionListModel() {
        return propositionListModel;
    }

    public javax.swing.JButton getRemoveAttachment() {
        return removeAttachment;
    }

    public javax.swing.JButton getRemoveFile() {
        return removeFile;
    }

    public com.jurismarches.vradi.ui.editors.StringEditor getSourceTextEditor() {
        return sourceTextEditor;
    }

    public com.jurismarches.vradi.ui.editors.UrlEditor getSourceURLEditor() {
        return sourceURLEditor;
    }

    public javax.swing.JPanel getStatusButtonPanel() {
        return statusButtonPanel;
    }

    public javax.swing.JButton getTest() {
        return test;
    }

    public javax.swing.JPanel getThesaurus() {
        return thesaurus;
    }

    public java.lang.Boolean getValide() {
        return valide;
    }

    public javax.swing.JButton getViewPDF() {
        return viewPDF;
    }

    public java.lang.Boolean isValide() {
        return valide !=null && valide;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setData(com.jurismarches.vradi.entities.Form newValue) {
        com.jurismarches.vradi.entities.Form oldValue = this.data;
        this.data = newValue;
        firePropertyChange(PROPERTY_DATA, oldValue, newValue);
    }

    public void setValide(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.valide;
        this.valide = newValue;
        firePropertyChange(PROPERTY_VALIDE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(statusButtonPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        actionPanel.add(lastModified, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        actionPanel.add(annuler, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        actionPanel.add(test, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        actionPanel.add(viewPDF, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToFormContentPane() {
        if (!allComponentsCreated) {
            return;
        }
        formContentPane.add(objetEditor, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(idEditor, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(entityEditor, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(countryEditor, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(departmentEditor, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(datePubEditor, new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(datePeremeptionEditor, new GridBagConstraints(1, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(sourceTextEditor, new GridBagConstraints(0, 4, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(sourceURLEditor, new GridBagConstraints(1, 4, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(content, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(descriptionEditor, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToFormPane() {
        if (!allComponentsCreated) {
            return;
        }
        formPane.add(formScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToFormScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        formScrollPane.getViewport().add(formContentPane);
    }

    protected void addChildrenToFormSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        formSplitPane.add(formPane, JSplitPane.LEFT);
        formSplitPane.add($JSplitPane0, JSplitPane.RIGHT);
    }

    protected void addChildrenToOfferEdit() {
        if (!allComponentsCreated) {
            return;
        }
        offerEdit.add(formSplitPane, JSplitPane.LEFT);
        offerEdit.add(thesaurus, JSplitPane.RIGHT);
    }

    protected void addChildrenToOfferEditUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(offerEdit, BorderLayout.CENTER);
        add(actionPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToStatusButtonPanel() {
        if (!allComponentsCreated) {
            return;
        }
        statusButtonPanel.add($JLabel3);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new jaxx.runtime.swing.Table());
        actionPanel.setName("actionPanel");
    }

    protected void createAddAttachment() {
        $objectMap.put("addAttachment", addAttachment = new javax.swing.JButton());
        addAttachment.setName("addAttachment");
        addAttachment.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addAttachment"));
    }

    protected void createAddFile() {
        $objectMap.put("addFile", addFile = new javax.swing.JButton());
        addFile.setName("addFile");
        addFile.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addFile"));
    }

    protected void createAnnuler() {
        $objectMap.put("annuler", annuler = new javax.swing.JButton());
        annuler.setName("annuler");
        annuler.setText(_("vradi.action.cancel"));
    }

    protected void createAttachmentList() {
        $objectMap.put("attachmentList", attachmentList = new javax.swing.JList());
        attachmentList.setName("attachmentList");
    }

    protected void createAttachmentListModel() {
        $objectMap.put("attachmentListModel", attachmentListModel = new javax.swing.DefaultListModel());
    }

    protected void createAttachmentsToUpload() {
        $objectMap.put("attachmentsToUpload", attachmentsToUpload = new java.util.ArrayList());
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        content.setName("content");
        content.setLayout(new BoxLayout(content, BoxLayout.Y_AXIS));
    }

    protected void createCountryEditor() {
        $objectMap.put("countryEditor", countryEditor = new com.jurismarches.vradi.ui.editors.StringEditor());
        countryEditor.setName("countryEditor");
        countryEditor.setFieldName("Form.FIELD_COUNTRY");
    }

    protected void createData() {
        $objectMap.put("data", data = getContextValue(Form.class));
    }

    protected void createDatePeremeptionEditor() {
        $objectMap.put("datePeremeptionEditor", datePeremeptionEditor = new com.jurismarches.vradi.ui.editors.DateTimeEditor());
        datePeremeptionEditor.setName("datePeremeptionEditor");
        datePeremeptionEditor.setFieldName("Form.FIELD_DATEPEREMPTION");
    }

    protected void createDatePubEditor() {
        $objectMap.put("datePubEditor", datePubEditor = new com.jurismarches.vradi.ui.editors.DateTimeEditor());
        datePubEditor.setName("datePubEditor");
        datePubEditor.setFieldName("Form.FIELD_DATEPUB");
    }

    protected void createDepartmentEditor() {
        $objectMap.put("departmentEditor", departmentEditor = new com.jurismarches.vradi.ui.editors.StringEditor());
        departmentEditor.setName("departmentEditor");
        departmentEditor.setFieldName("Form.FIELD_DEPARTMENT");
    }

    protected void createDescriptionEditor() {
        $objectMap.put("descriptionEditor", descriptionEditor = new com.jurismarches.vradi.ui.editors.TextEditor());
        descriptionEditor.setName("descriptionEditor");
        descriptionEditor.setFieldName("Form.FIELD_DESCRIPTION");
    }

    protected void createEntityEditor() {
        $objectMap.put("entityEditor", entityEditor = new com.jurismarches.vradi.ui.editors.StringEditor());
        entityEditor.setName("entityEditor");
        entityEditor.setFieldName("Form.FIELD_ENTITY");
    }

    protected void createErrorEditorTable() {
        $objectMap.put("errorEditorTable", errorEditorTable = new jaxx.runtime.validator.swing.SwingValidatorMessageTableModel());
        errorEditorTable.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorEditorTable"));
    }

    protected void createFileList() {
        $objectMap.put("fileList", fileList = new javax.swing.JList());
        fileList.setName("fileList");
    }

    protected void createFileListModel() {
        $objectMap.put("fileListModel", fileListModel = new javax.swing.DefaultListModel());
    }

    protected void createFilesToUpload() {
        $objectMap.put("filesToUpload", filesToUpload = new java.util.ArrayList());
    }

    protected void createFormContentPane() {
        $objectMap.put("formContentPane", formContentPane = new jaxx.runtime.swing.Table());
        formContentPane.setName("formContentPane");
    }

    protected void createFormPane() {
        $objectMap.put("formPane", formPane = new javax.swing.JPanel());
        formPane.setName("formPane");
        formPane.setLayout(new BorderLayout());
    }

    protected void createFormScrollPane() {
        $objectMap.put("formScrollPane", formScrollPane = new javax.swing.JScrollPane());
        formScrollPane.setName("formScrollPane");
        formScrollPane.addComponentListener(JAXXUtil.getEventListener(ComponentListener.class, "componentResized", this, "doComponentResized__on__formScrollPane"));
    }

    protected void createFormSplitPane() {
        $objectMap.put("formSplitPane", formSplitPane = new javax.swing.JSplitPane());
        formSplitPane.setName("formSplitPane");
        formSplitPane.setContinuousLayout(true);
        formSplitPane.setDividerLocation(750);
        formSplitPane.setOneTouchExpandable(true);
        formSplitPane.setResizeWeight(0.8);
        formSplitPane.setDividerSize(12);
    }

    protected void createIdEditor() {
        $objectMap.put("idEditor", idEditor = new com.jurismarches.vradi.ui.editors.IdEditor());
        idEditor.setName("idEditor");
        idEditor.setFieldName("Form.FIELD_ID");
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createObjetEditor() {
        $objectMap.put("objetEditor", objetEditor = new com.jurismarches.vradi.ui.editors.StringEditor());
        objetEditor.setName("objetEditor");
        objetEditor.setFieldName("Form.FIELD_OBJET");
    }

    protected void createOfferEdit() {
        $objectMap.put("offerEdit", offerEdit = new javax.swing.JSplitPane());
        offerEdit.setName("offerEdit");
        offerEdit.setOneTouchExpandable(true);
        offerEdit.setResizeWeight(0.3);
        offerEdit.setContinuousLayout(true);
        offerEdit.setDividerSize(12);
    }

    protected void createPropositionList() {
        $objectMap.put("propositionList", propositionList = new javax.swing.JList());
        propositionList.setName("propositionList");
    }

    protected void createPropositionListModel() {
        $objectMap.put("propositionListModel", propositionListModel = new javax.swing.DefaultListModel());
    }

    protected void createRemoveAttachment() {
        $objectMap.put("removeAttachment", removeAttachment = new javax.swing.JButton());
        removeAttachment.setName("removeAttachment");
        removeAttachment.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeAttachment"));
    }

    protected void createRemoveFile() {
        $objectMap.put("removeFile", removeFile = new javax.swing.JButton());
        removeFile.setName("removeFile");
        removeFile.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeFile"));
    }

    protected void createSourceTextEditor() {
        $objectMap.put("sourceTextEditor", sourceTextEditor = new com.jurismarches.vradi.ui.editors.StringEditor());
        sourceTextEditor.setName("sourceTextEditor");
        sourceTextEditor.setFieldName("Form.FIELD_SOURCETEXT");
    }

    protected void createSourceURLEditor() {
        $objectMap.put("sourceURLEditor", sourceURLEditor = new com.jurismarches.vradi.ui.editors.UrlEditor());
        sourceURLEditor.setName("sourceURLEditor");
        sourceURLEditor.setFieldName("Form.FIELD_SOURCEURL");
    }

    protected void createStatusButtonPanel() {
        $objectMap.put("statusButtonPanel", statusButtonPanel = new javax.swing.JPanel());
        statusButtonPanel.setName("statusButtonPanel");
        statusButtonPanel.setLayout(new FlowLayout(FlowLayout.LEADING));
    }

    protected void createTest() {
        $objectMap.put("test", test = new javax.swing.JButton());
        test.setName("test");
        test.setText(_("vradi.action.test"));
        test.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__test"));
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new javax.swing.JPanel());
        thesaurus.setName("thesaurus");
        thesaurus.setLayout(new BoxLayout(thesaurus, BoxLayout.X_AXIS));
    }

    protected void createValide() {
        $objectMap.put("valide", valide = true);
    }

    protected void createViewPDF() {
        $objectMap.put("viewPDF", viewPDF = new javax.swing.JButton());
        viewPDF.setName("viewPDF");
        viewPDF.setText(_("vradi.offerEdit.view.pdf"));
        viewPDF.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__viewPDF"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToOfferEditUI();
        addChildrenToOfferEdit();
        addChildrenToFormSplitPane();
        addChildrenToFormPane();
        addChildrenToFormScrollPane();
        addChildrenToFormContentPane();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($Table0, JSplitPane.LEFT);
        $JSplitPane0.add($Table1, JSplitPane.RIGHT);
        // inline complete setup of $Table0
        $Table0.add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add($JLabel0);
        $JPanel0.add(addFile);
        $JPanel0.add(removeFile);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fileList);
        // inline complete setup of $JPanel1
        $JPanel1.add($JLabel1);
        $JPanel1.add(addAttachment);
        $JPanel1.add(removeAttachment);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(attachmentList);
        // inline complete setup of $Table1
        $Table1.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($JScrollPane2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(propositionList);
        addChildrenToActionPanel();
        addChildrenToStatusButtonPanel();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 62 property setters
        offerEdit.setOrientation(JSplitPane.VERTICAL_SPLIT);
        formPane.setMinimumSize(new Dimension(0,0));
        formPane.setPreferredSize(new Dimension(0,0));
        formScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        formContentPane.setPreferredSize(new Dimension(0,0));
        objetEditor.setExtensionFieldName(Form.FIELD_OBJET);
        objetEditor.setExtensionName(Form.EXT_INFOGENE);
        objetEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        objetEditor.setValue(data.getObjet());
        idEditor.setExtensionFieldName(Form.FIELD_ID);
        idEditor.setExtensionName(Form.EXT_INFOGENE);
        idEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        idEditor.setValue(data.getId());
        entityEditor.setExtensionFieldName(Form.FIELD_ENTITY);
        entityEditor.setExtensionName(Form.EXT_INFOGENE);
        entityEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        entityEditor.setValue(data.getEntity());
        countryEditor.setExtensionFieldName(Form.FIELD_COUNTRY);
        countryEditor.setExtensionName(Form.EXT_INFOGENE);
        countryEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        countryEditor.setValue(data.getCountry());
        departmentEditor.setExtensionFieldName(Form.FIELD_DEPARTMENT);
        departmentEditor.setExtensionName(Form.EXT_INFOGENE);
        departmentEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        departmentEditor.setValue(data.getDepartment());
        datePubEditor.setExtensionFieldName(Form.FIELD_DATEPUB);
        datePubEditor.setExtensionName(Form.EXT_FORM);
        datePubEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.DATE_TIME.getFieldType()));
        datePubEditor.setValue(data.getDatePub());
        datePeremeptionEditor.setExtensionFieldName(Form.FIELD_DATEPEREMPTION);
        datePeremeptionEditor.setExtensionName(Form.EXT_FORM);
        datePeremeptionEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.DATE_TIME.getFieldType()));
        datePeremeptionEditor.setValue(data.getDatePeremption());
        sourceTextEditor.setExtensionFieldName(Form.FIELD_SOURCETEXT);
        sourceTextEditor.setExtensionName(Form.EXT_INFOGENE);
        sourceTextEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        sourceTextEditor.setValue(data.getSourceText());
        sourceURLEditor.setExtensionFieldName(Form.FIELD_SOURCEURL);
        sourceURLEditor.setExtensionName(Form.EXT_INFOGENE);
        sourceURLEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.URL.getFieldType()));
        sourceURLEditor.setValue(data.getSourceURL());
        descriptionEditor.setExtensionFieldName(Form.FIELD_DESCRIPTION);
        descriptionEditor.setExtensionName(Form.EXT_INFOGENE);
        descriptionEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.TEXT.getFieldType()));
        descriptionEditor.setValue(data.getDescription());
        $JSplitPane0.setOrientation(JSplitPane.VERTICAL_SPLIT);
        $Table0.setMinimumSize(new Dimension(0,0));
        addFile.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        removeFile.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("remove"));
        fileList.setCellRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        fileList.setModel(fileListModel);
        addAttachment.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        removeAttachment.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("remove"));
        attachmentList.setCellRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        attachmentList.setModel(attachmentListModel);
        propositionList.setCellRenderer(new ThesaurusHighlighter(true));
        propositionList.setModel(getPropositionListModel());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 1 data bindings
        $registerDefaultBindings();
        $objectMap.put("offerEditUI", this);
        listThesaurusHelpers = new java.util.ArrayList<ThesaurusTreeHelper>();
        createData();
        createPropositionListModel();
        createFileListModel();
        createAttachmentListModel();
        createFilesToUpload();
        createAttachmentsToUpload();
        createValide();
        createErrorEditorTable();
        createOfferEdit();
        createFormSplitPane();
        createFormPane();
        createFormScrollPane();
        createFormContentPane();
        createObjetEditor();
        createIdEditor();
        createEntityEditor();
        createCountryEditor();
        createDepartmentEditor();
        createDatePubEditor();
        createDatePeremeptionEditor();
        createSourceTextEditor();
        createSourceURLEditor();
        createContent();
        createDescriptionEditor();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new javax.swing.JSplitPane());
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setResizeWeight(0.8);
        $JSplitPane0.setContinuousLayout(true);
        $JSplitPane0.setDividerSize(12);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        $Table0.setName("$Table0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.offerEdit.file"));
        createAddFile();
        createRemoveFile();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createFileList();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.offerEdit.attachment"));
        createAddAttachment();
        createRemoveAttachment();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        $JScrollPane1.setName("$JScrollPane1");
        createAttachmentList();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        $Table1.setName("$Table1");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.edit.proposition"));
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new javax.swing.JScrollPane());
        $JScrollPane2.setName("$JScrollPane2");
        createPropositionList();
        createThesaurus();
        createActionPanel();
        createStatusButtonPanel();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.status.validate"));
        createLastModified();
        createAnnuler();
        createTest();
        createViewPDF();
        // inline creation of offerEditUI
        setName("offerEditUI");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROPOSITION_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (propositionList != null) {
                    propositionList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (propositionList != null) {
                    propositionList.setSelectionModel(new OneClicListSelectionModel(propositionList.getSelectionModel(), propositionListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (propositionList != null) {
                    propositionList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
    }

}