package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public abstract class AbstractProgressBarUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MSG = "msg";
    public static final String PROPERTY_SHOW_CANCEL_BUTTON = "showCancelButton";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_BUTTON_VISIBLE = "cancelButton.visible";
    public static final String BINDING_MSG_LABEL_TEXT = "msgLabel.text";
    public static final String BINDING_MSG_LABEL_VISIBLE = "msgLabel.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTPW8TQRBdO7ET5wNCrESJCJL5kEAU54YGJQpJjCISGYKIkCLcsHe32Bvt3S67c8mlQfwEfgL0NEh0VIiCmoIG8RcQoqBFzN45vhguiQVX3J1m3nv7Znbm9TdSMppc3KVx7OgoBB4wZ3N1Z2fL3WUe3GbG01yB1CR9CkVSbJFxvxc3QC63mpZe79LrDRkoGbLwCHuxScYMHAhmOowBkAv9DM+Y+nYvvRirSB+q9kzlqb788b34wn/+qkhIrNBdGUupncbKKhlukiL3gUzjSXu0LmjYRhuah230O2ljDUGNuUcD9pQ8IyNNUlZUoxiQS4OXnGgk/FgBmaGuAU09uK9lWzNj1qh+uAGk7snA2Y00NwHVXocZZ09TnzsRd1bzGEolmmUgU6Yj9xs09JhYiwBkCOSc9e7Yepw1KQWjYQYfCkwbSRkirTgDjCKgSV0msDEWFTtmHwHOZhK0oEoPO64yT0Dm+uBH7PaTJrw+s9U+VhrtEjQ533ebOCdONifZRRZapKQjDKOH1t+j9QBT6VDN/TFUVjDJ/pqtfn739e364SRV8OyZXOiRRcAbxvoV08Dt0WfTMYqAi/pdqhZbqMIEblGyJQs5xra7aTSH56W3ZunOHWo6KFEa+fL+w+zjT0OkuE7GhKT+OrX4DVKBDva2I4Ufq1sriaOJ/VF8T1lvOGY+e0IjAQ0hDdtCixS4bfaZJZ8Crbk89LHdyzH2ZCGnJz1jbuXjz+r2m5XDvhTQ5/yx8Kw3pUekzEPBQ5bsWHd9cndqXBkW+TJbk7zFKdjvmOpOaS15X8krvCzogYzA5q/Gkf1cS2zbv+sDq5SAg8AJm15Ki6hRwC1xI2DL/y46DCw+yVh1AI2RPW64K9h/ykzi/TNgOuAhhUTsRr7Y7CB1cS/d2GMMzZ+qYcM3T3AxmMLyKR5+Ay0YaTHsBgAA";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.AbstractProgressBarUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AbstractProgressBarUI abstractProgressBarUI = this;
    protected javax.swing.JButton cancelButton;
    protected java.lang.String msg;
    protected javax.swing.JLabel msgLabel;
    protected javax.swing.JProgressBar progressBar;
    protected java.lang.Boolean showCancelButton;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void $afterCompleteSetup() {
        }
        
        public abstract void cancel();

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AbstractProgressBarUI() {
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(java.awt.event.ActionEvent event) {
        cancel();
    }

    public void doWindowClosing__on__abstractProgressBarUI(java.awt.event.WindowEvent event) {
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCancelButton() {
        return cancelButton;
    }

    public java.lang.String getMsg() {
        return msg;
    }

    public javax.swing.JLabel getMsgLabel() {
        return msgLabel;
    }

    public javax.swing.JProgressBar getProgressBar() {
        return progressBar;
    }

    public java.lang.Boolean getShowCancelButton() {
        return showCancelButton;
    }

    public java.lang.Boolean isShowCancelButton() {
        return showCancelButton !=null && showCancelButton;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setMsg(java.lang.String newValue) {
        java.lang.String oldValue = this.msg;
        this.msg = newValue;
        firePropertyChange(PROPERTY_MSG, oldValue, newValue);
    }

    public void setShowCancelButton(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showCancelButton;
        this.showCancelButton = newValue;
        firePropertyChange(PROPERTY_SHOW_CANCEL_BUTTON, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAbstractProgressBarUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(msgLabel, BorderLayout.NORTH);
        add(progressBar, BorderLayout.CENTER);
        add(cancelButton, BorderLayout.SOUTH);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new javax.swing.JButton());
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("vradi.common.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createMsg() {
        $objectMap.put("msg", msg = null);
    }

    protected void createMsgLabel() {
        $objectMap.put("msgLabel", msgLabel = new javax.swing.JLabel());
        msgLabel.setName("msgLabel");
    }

    protected void createProgressBar() {
        $objectMap.put("progressBar", progressBar = new javax.swing.JProgressBar());
        progressBar.setName("progressBar");
        progressBar.setIndeterminate(true);
    }

    protected void createShowCancelButton() {
        $objectMap.put("showCancelButton", showCancelButton = true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAbstractProgressBarUI();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        cancelButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        // late initializer
        abstractProgressBarUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 3 data bindings
        $registerDefaultBindings();
        $objectMap.put("abstractProgressBarUI", this);
        createShowCancelButton();
        createMsg();
        createMsgLabel();
        createProgressBar();
        createCancelButton();
        // inline creation of abstractProgressBarUI
        setName("abstractProgressBarUI");
        abstractProgressBarUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.progressBar.title"));
        abstractProgressBarUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__abstractProgressBarUI"));
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MSG_LABEL_TEXT, true ,"msg") {
        
            @Override
            public void processDataBinding() {
                msgLabel.setText(_(getMsg()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MSG_LABEL_VISIBLE, true ,"msg") {
        
            @Override
            public void processDataBinding() {
                msgLabel.setVisible(getMsg() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CANCEL_BUTTON_VISIBLE, true ,"showCancelButton") {
        
            @Override
            public void processDataBinding() {
                cancelButton.setVisible(isShowCancelButton());
            }
        });
    }

}