package com.jurismarches.vradi;

import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

import com.caucho.hessian.server.HessianServlet;
import com.jurismarches.vradi.services.MailingService;
import com.jurismarches.vradi.services.MailingServiceImpl;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.VradiStorageServiceImpl;
import com.jurismarches.vradi.services.XmlStreamService;
import com.jurismarches.vradi.services.XmlStreamServiceImpl;

/**
 * VradiEmbededHessian.
 *
 * @author $Author: schorlet $
 * @version $Revision: 547 $ $Date: 2010-02-23 11:43:13 +0100 (mar., 23 févr. 2010) $
 * @since 22 févr. 2010 20:35:42
 */
public class VradiEmbededHessian {
    final Server server;

    public VradiEmbededHessian(int port) throws Exception {
        server = new Server(port);
        server.setStopAtShutdown(true);
    }

    protected void start() throws Exception {
        HessianServlet storageServlet = new HessianServlet();
        storageServlet.setHomeAPI(VradiStorageService.class);
        storageServlet.setHome(new VradiStorageServiceImpl());

        HessianServlet xmlStreamServlet = new HessianServlet();
        xmlStreamServlet.setHomeAPI(XmlStreamService.class);
        xmlStreamServlet.setHome(new XmlStreamServiceImpl());

        HessianServlet mailingServlet = new HessianServlet();
        mailingServlet.setHomeAPI(MailingService.class);
        mailingServlet.setHome(new MailingServiceImpl());

        Context root = new Context(server, "/");
        root.addServlet(new ServletHolder(storageServlet), "/storage");
        root.addServlet(new ServletHolder(xmlStreamServlet), "/xmlstream");
        root.addServlet(new ServletHolder(mailingServlet), "/mailing");

        server.start();
    }

    protected void stop() throws Exception {
        server.stop();
    }

    public static void main(String args[]) throws Exception {
        VradiEmbededHessian server = new VradiEmbededHessian(9000);
        server.start();
        Thread.sleep(5 * 60 * 1000);
        server.stop();
        System.exit(0);
    }

}
