/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi;

import static org.nuiton.i18n.I18n.n_;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.renderer.DecoratorProviderListCellRenderer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.WikittyExtension;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiFormDTO;
import com.jurismarches.vradi.services.dto.VradiSessionDTO;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.VradiComparators;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.email.EmailPopupUI;
import com.jurismarches.vradi.ui.search.SearchUI;

public class VradiContext extends DefaultApplicationContext {

    static private Log log = LogFactory.getLog(VradiContext.class);

    public static final JAXXContextEntryDef<VradiMainUI> MAIN_UI_ENTRY_DEF =
            SwingUtil.newContextEntryDef("mainui", VradiMainUI.class);

    public static final JAXXContextEntryDef<OfferListUI> OFFERT_LIST_UI_ENTRY_DEF =
            SwingUtil.newContextEntryDef("offerList", OfferListUI.class);

    public static final JAXXContextEntryDef<List<OfferEditUI>> OFFERT_EDIT_UI_ENTRY_DEF =
            SwingUtil.newListContextEntryDef("offerEdit");

    public static final JAXXContextEntryDef<SearchUI> SEARCH_UI_ENTRY_DEF =
            SwingUtil.newContextEntryDef("searchUI", SearchUI.class);

    public static final JAXXContextEntryDef<AdminPopupUI> ADMIN_UI_ENTRY_DEF =
            SwingUtil.newContextEntryDef("adminPopupUI", AdminPopupUI.class);

    public static final JAXXContextEntryDef<EmailPopupUI> EMAIL_UI_ENTRY_DEF =
            SwingUtil.newContextEntryDef("emailViewUI", EmailPopupUI.class);

    public static final JAXXContextEntryDef<Map<String, NavigationModel>> THESAURUS_NAVIGATION_MODEL =
            SwingUtil.newMapContextEntryDef(n_("vradi.thesaurus.models"));

    public static final JAXXContextEntryDef<TreeNodeImpl> ROOT_TREE_NODE_ENTRY_DEF =
            SwingUtil.newContextEntryDef(n_("vradi.thesaurus.root"), TreeNodeImpl.class);
    /**
     * where the thesaurus are hold in context
     */
    protected static final JAXXContextEntryDef<VradiThesaurusDTO> THESAURUS_ENTRY_DEF =
            SwingUtil.newContextEntryDef(ThesaurusHandler.PREFIX_THESAURUS, VradiThesaurusDTO.class);

    /**
     * where the clients are hold in context
     */
    protected static final JAXXContextEntryDef<Map<String, TreeNodeImpl>> TREE_NODE_ENTRY_DEF =
            SwingUtil.newMapContextEntryDef(n_("vradi.cache.categoryTreeNode"));
    /**
     * where the clients are hold in context
     */
    protected static final JAXXContextEntryDef<List<Client>> CLIENTS_ENTRY_DEF =
            SwingUtil.newListContextEntryDef(n_("vradi.adminClient.categoryClient"));
    /**
     * where the users are hold in context
     */
    protected static final JAXXContextEntryDef<List<User>> USERS_ENTRY_DEF =
            SwingUtil.newListContextEntryDef(n_("vradi.adminUser.categoryUser"));
    /**
     * where the groups are hold in context
     */
    protected static final JAXXContextEntryDef<List<Group>> GROUPS_ENTRY_DEF =
            SwingUtil.newListContextEntryDef(n_("vradi.adminGroup.categoryGroup"));
    /**
     * where the statuses are hold in context
     */
    protected static final JAXXContextEntryDef<List<Status>> STATUSES_ENTRY_DEF =
            SwingUtil.newListContextEntryDef(n_("vradi.adminStatus.categoryStatus"));
    /**
     * where the forms type are hold in context
     */
    protected static final JAXXContextEntryDef<List<WikittyExtension>> FORMS_TYPE_ENTRY_DEF =
            SwingUtil.newListContextEntryDef(n_("vradi.adminForm.categoryFormType"));
    /**
     * where the forms are hold in context
     */
    protected static final JAXXContextEntryDef<Map<String, Form>> FORMS_ENTRY_DEF =
            SwingUtil.newMapContextEntryDef(n_("vradi.adminForm.categoryForm"));
    /**
     * where the forms dto are hold in context
     */
    protected static final JAXXContextEntryDef<Map<String, VradiFormDTO>> FORMS_DTO_ENTRY_DEF =
            SwingUtil.newMapContextEntryDef(n_("vradi.adminForm.categoryFormDTO"));
    /**
     * where the xmlStreams are hold in context
     */
    protected static final JAXXContextEntryDef<List<XmlStream>> XMLSTREAMS_ENTRY_DEF =
            SwingUtil.newListContextEntryDef(n_("vradi.adminXmlStream.categoryXmlStream"));
    /**
     * where the session are hold in context
     */
    protected static final JAXXContextEntryDef<List <VradiSessionDTO>> SESSIONS_DTO_ENTRY_DEF =
            SwingUtil.newListContextEntryDef(n_("vradi.email.categorySessionDTO"));
    /**
     * where the session are hold in context
     */
    protected static final JAXXContextEntryDef<Map<String, Session>> SESSIONS_ENTRY_DEF =
            SwingUtil.newMapContextEntryDef(n_("vradi.email.categorySession"));
    /**
     * where the session are hold in context
     */
    protected static final JAXXContextEntryDef<Map<String, Sending>> SENDING_ENTRY_DEF =
            SwingUtil.newMapContextEntryDef(n_("vradi.email.categorySending"));

    /**
     * l'intance partagée accessible après un appel à la méthode
     * {@link #init()}
     */
    protected static VradiContext instance;

    /**
     * @return <code>true</code> si le context a été initialisé via la méthode
     *         {@link #init()}, <ocde>false</code> autrement.
     */
    public static boolean isInit() {
        return instance != null;
    }

    /**
     * Permet l'initialisation du contexte applicatif et positionne
     * l'instance partagée.
     * <p/>
     * Note : Cette méthode ne peut être appelée qu'une seule fois.
     *
     * @return l'instance partagée
     * @throws IllegalStateException si un contexte applicatif a déja été positionné.
     */
    public static synchronized VradiContext init() throws IllegalStateException {
        if (isInit()) {
            throw new IllegalStateException("there is an already application context registred.");
        }
        instance = new VradiContext();
        return instance;
    }

    /**
     * Récupération du contexte applicatif.
     *
     * @return l'instance partagé du contexte.
     * @throws IllegalStateException si le contexte n'a pas été initialisé via
     *                               la méthode {@link #init()}
     */
    public static VradiContext get() throws IllegalStateException {
        if (!isInit()) {
            throw new IllegalStateException("no application context registred.");
        }
        return instance;
    }

    /**
     * Un objet pour bloquer le context
     */
    protected final Object lock = new Object();

    protected VradiContext() {
        super();
    }

    public void lock() throws InterruptedException {
        synchronized (lock) {
            lock.wait();
        }
    }

    public void releaseLock() {
        synchronized (lock) {
            lock.notify();
        }
    }

    /**
     * close the application's context.
     *
     * @throws java.lang.Exception if any pb while closing
     */
    public void close() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("closing context " + this);
        }

        // fermeture du context principal
        clear();
    }

    public static JAXXContextEntryDef<VradiThesaurusDTO> getThesaurusEntryDef(){
        return get().getContextValue(JAXXContextEntryDef.class,
                        THESAURUS_ENTRY_DEF.getName());
    }

    public static JAXXContextEntryDef<Map<String, TreeNodeImpl>> getTreeNodeEntryDef(){
        JAXXContextEntryDef contextEntryDef = get().getContextValue(JAXXContextEntryDef.class,
                TREE_NODE_ENTRY_DEF.getName());
        return contextEntryDef;
    }

    public static JAXXContextEntryDef<List<Client>> getClientsEntryDef(){
        return get().getContextValue(JAXXContextEntryDef.class,
                        CLIENTS_ENTRY_DEF.getName());
    }

    public static JAXXContextEntryDef<List<User>> getUsersEntryDef(){
        return get().getContextValue(JAXXContextEntryDef.class,
                        USERS_ENTRY_DEF.getName());
    }

    public static JAXXContextEntryDef<List<Group>> getGroupsEntryDef(){
        return get().getContextValue(JAXXContextEntryDef.class,
                        GROUPS_ENTRY_DEF.getName());
    }

    public static JAXXContextEntryDef<List<Status>> getStatusEntryDef(){
        return get().getContextValue(JAXXContextEntryDef.class,
                        STATUSES_ENTRY_DEF.getName());
    }

    public static JAXXContextEntryDef<List<WikittyExtension>> getFormsTypeEntryDef(){
        return get().getContextValue(JAXXContextEntryDef.class,
                        FORMS_TYPE_ENTRY_DEF.getName());
    }

    public static JAXXContextEntryDef<Map<String, Form>> getFormsEntryDef(){
        JAXXContextEntryDef contextEntryDef = get().getContextValue(JAXXContextEntryDef.class,
                FORMS_ENTRY_DEF.getName());
        return contextEntryDef;
    }

    public static JAXXContextEntryDef<Map<String, VradiFormDTO>> getFormsDTOEntryDef(){
        JAXXContextEntryDef contextEntryDef = get().getContextValue(JAXXContextEntryDef.class,
                FORMS_DTO_ENTRY_DEF.getName());
        return contextEntryDef;
    }

    public static JAXXContextEntryDef<List<XmlStream>> getXmlStreamEntryDef(){
        return get().getContextValue(JAXXContextEntryDef.class,
                        XMLSTREAMS_ENTRY_DEF.getName());
    }

    public static JAXXContextEntryDef<Map<String, Session>> getSessionEntryDef(){
        JAXXContextEntryDef contextEntryDef = get().getContextValue(JAXXContextEntryDef.class,
                SESSIONS_ENTRY_DEF.getName());
        if (contextEntryDef == null){
            setSessionEntryDef(new ArrayList<Session>());
        }
        return contextEntryDef;
    }

    public static JAXXContextEntryDef<List<VradiSessionDTO>> getSessionDTOEntryDef(){
        JAXXContextEntryDef contextEntryDef = get().getContextValue(JAXXContextEntryDef.class,
                SESSIONS_DTO_ENTRY_DEF.getName());
        return contextEntryDef;
    }

    public static JAXXContextEntryDef<Map<String, Sending>> getSendingEntryDef(){
        JAXXContextEntryDef contextEntryDef = get().getContextValue(JAXXContextEntryDef.class,
                SENDING_ENTRY_DEF.getName());
        return contextEntryDef;
    }

    public static JAXXContextEntryDef<TreeNodeImpl> getRootTreeNodeEntryDef(){
        JAXXContextEntryDef contextEntryDef = get().getContextValue(JAXXContextEntryDef.class,
                ROOT_TREE_NODE_ENTRY_DEF.getName());
        return contextEntryDef;
    }

    public static VradiThesaurusDTO getThesaurusInEntryDef(){
        return getThesaurusEntryDef()
                .getContextValue(get());
    }

    public static List<TreeNodeImpl> getTreeNodeInEntryDef(){
        Map<String, TreeNodeImpl> map = getTreeNodeEntryDef()
                .getContextValue(get());
        return new ArrayList<TreeNodeImpl>(map.values());
    }

    public static List<Client> getClientsInEntryDef(){
        return getClientsEntryDef()
                .getContextValue(get());
    }

    public static List<User> getUsersInEntryDef(){
        return getUsersEntryDef()
                .getContextValue(get());
    }

    public static List<Group> getGroupsInEntryDef(){
        return getGroupsEntryDef()
                .getContextValue(get());
    }

    public static List<Status> getStatusInEntryDef(){
        return getStatusEntryDef()
                .getContextValue(get());
    }

    public static List<WikittyExtension> getFormsTypeInEntryDef(){
        return getFormsTypeEntryDef()
                .getContextValue(get());
    }

    public static List<Form> getFormsInEntryDef(){
        JAXXContextEntryDef<Map<String, Form>> contextEntryDef = getFormsEntryDef();
        if (contextEntryDef == null){
            ArrayList<Form> forms = new ArrayList<Form>();
            setFormsEntryDef(forms);
            return forms;
        }
        Map<String, Form> map = contextEntryDef.getContextValue(get());
        return new ArrayList<Form>(map.values());
    }

    public static List<VradiFormDTO> getFormsDTOInEntryDef(){
        JAXXContextEntryDef<Map<String, VradiFormDTO>> contextEntryDef = getFormsDTOEntryDef();
        if (contextEntryDef == null){
            ArrayList<VradiFormDTO> forms = new ArrayList<VradiFormDTO>();
            setFormsDTOEntryDef(forms);
            return forms;
        }
        Map<String, VradiFormDTO> map = contextEntryDef.getContextValue(get());
        return new ArrayList<VradiFormDTO>(map.values());
    }

    public static List<XmlStream> getXmlStreamInEntryDef(){
        return getXmlStreamEntryDef()
                .getContextValue(get());
    }

    public static List<VradiSessionDTO> getSessionsDTOInEntryDef(){
        JAXXContextEntryDef<List<VradiSessionDTO>> contextEntryDef = getSessionDTOEntryDef();
        if (contextEntryDef == null){
            ArrayList<VradiSessionDTO> sessions = new ArrayList<VradiSessionDTO>();
            setSessionDTOEntryDef(sessions);
            return sessions;
        }
        return contextEntryDef
                .getContextValue(get());
    }

    public static List<Session> getSessionsInEntryDef(){
        JAXXContextEntryDef<Map<String, Session>> contextEntryDef = getSessionEntryDef();
        if (contextEntryDef == null){
            ArrayList<Session> sessions = new ArrayList<Session>();
            setSessionEntryDef(sessions);
            return sessions;
        }
        Map<String, Session> map = contextEntryDef
                .getContextValue(get());
        return new ArrayList<Session>(map.values());
    }

    public static List<Sending> getSendingInEntryDef(){
        JAXXContextEntryDef<Map<String, Sending>> contextEntryDef = getSendingEntryDef();
        if (contextEntryDef == null){
            ArrayList<Sending> sendings = new ArrayList<Sending>();
            setSendingEntryDef(sendings);
            return sendings;
        }
        Map<String, Sending> map = contextEntryDef
                .getContextValue(get());
        return new ArrayList<Sending>(map.values());
    }

    public static TreeNodeImpl getRootTreeNodeInEntryDef(){
        JAXXContextEntryDef<TreeNodeImpl> contextEntryDef = getRootTreeNodeEntryDef();
        return contextEntryDef.getContextValue(get());
    }

    public static void setThesaurusEntryDef(VradiThesaurusDTO value){
        THESAURUS_ENTRY_DEF.setContextValue(get(), value);
        get().setContextValue(THESAURUS_ENTRY_DEF,
                THESAURUS_ENTRY_DEF.getName());
    }

    public static void setTreeNodeEntryDef(List<TreeNodeImpl> value){
        Map<String, TreeNodeImpl> map = fillMap(value);

        TREE_NODE_ENTRY_DEF.setContextValue(get(), map);
        get().setContextValue(TREE_NODE_ENTRY_DEF,
                TREE_NODE_ENTRY_DEF.getName());
    }

    public static void setClientsEntryDef(List<Client> values){
        CLIENTS_ENTRY_DEF.setContextValue(get(), new ArrayList<Client>(values));
        get().setContextValue(CLIENTS_ENTRY_DEF,
                CLIENTS_ENTRY_DEF.getName());
    }

    public static void setUsersEntryDef(List<User> values){
        USERS_ENTRY_DEF.setContextValue(get(), new ArrayList<User>(values));
        get().setContextValue(USERS_ENTRY_DEF,
                USERS_ENTRY_DEF.getName());
    }

    public static void setGroupsEntryDef(List<Group> values){
        GROUPS_ENTRY_DEF.setContextValue(get(), new ArrayList<Group>(values));
        get().setContextValue(GROUPS_ENTRY_DEF,
                GROUPS_ENTRY_DEF.getName());
    }

    public static void setStatusEntryDef(List<Status> values){
        STATUSES_ENTRY_DEF.setContextValue(get(), new ArrayList<Status>(values));
        get().setContextValue(STATUSES_ENTRY_DEF,
                STATUSES_ENTRY_DEF.getName());
    }

    public static void setFormsTypeEntryDef(List<WikittyExtension> values){
        FORMS_TYPE_ENTRY_DEF.setContextValue(get(), new ArrayList<WikittyExtension>(values));
        get().setContextValue(FORMS_TYPE_ENTRY_DEF,
                FORMS_TYPE_ENTRY_DEF.getName());
    }

    public static void setFormsEntryDef(List<Form> values){
        Map<String, Form> map = fillMap(values);
        FORMS_ENTRY_DEF.setContextValue(get(), map);
        get().setContextValue(FORMS_ENTRY_DEF,
                FORMS_ENTRY_DEF.getName());
    }

    public static void setFormsDTOEntryDef(List<VradiFormDTO> values){
        Map<String, VradiFormDTO> map = fillMap(values);
        FORMS_DTO_ENTRY_DEF.setContextValue(get(), map);
        get().setContextValue(FORMS_DTO_ENTRY_DEF,
                FORMS_DTO_ENTRY_DEF.getName());
    }

    public static void setXmlStreamEntryDef(List<XmlStream> values){
        XMLSTREAMS_ENTRY_DEF.setContextValue(get(), new ArrayList<XmlStream>(values));
        get().setContextValue(XMLSTREAMS_ENTRY_DEF,
                XMLSTREAMS_ENTRY_DEF.getName());
    }

    public static void setSessionDTOEntryDef(List<VradiSessionDTO> values){
        SESSIONS_DTO_ENTRY_DEF.setContextValue(get(), new ArrayList<VradiSessionDTO>(values));
        get().setContextValue(SESSIONS_DTO_ENTRY_DEF,
                SESSIONS_DTO_ENTRY_DEF.getName());
    }

    public static void setSessionEntryDef(List<Session> values){
        Map<String, Session> map = fillMap(values);
        SESSIONS_ENTRY_DEF.setContextValue(get(), map);
        get().setContextValue(SESSIONS_ENTRY_DEF,
                SESSIONS_ENTRY_DEF.getName());
    }

    public static void setSendingEntryDef(List<Sending> values){
        Map<String, Sending> map = fillMap(values);
        SENDING_ENTRY_DEF.setContextValue(get(), map);
        get().setContextValue(SENDING_ENTRY_DEF,
                SENDING_ENTRY_DEF.getName());
    }

    public static void setRootTreeNodeEntryDef(TreeNodeImpl rootThesaurus) {
        ROOT_TREE_NODE_ENTRY_DEF.setContextValue(get(), rootThesaurus);
        get().setContextValue(ROOT_TREE_NODE_ENTRY_DEF,
                ROOT_TREE_NODE_ENTRY_DEF.getName());
    }

    // Find in ref
    public static TreeNodeImpl findTreeNodeInEntryDef(String id){
        TreeNodeImpl result = null;

        TreeNodeImpl root = VradiContext.getRootTreeNodeInEntryDef();
        if (root.getWikittyId().equals(id)){
            result = root;
        } else {
            result = findInMapRef(getTreeNodeEntryDef(), id);
        }

        return result;
    }

    public static List<TreeNodeImpl> findAllTreeNodeInEntryDef(List<String> ids){
        List<TreeNodeImpl> result = new ArrayList<TreeNodeImpl>();
        for (String id : ids){
            result.add(findTreeNodeInEntryDef(id));
        }
        return result;
    }

    public static Form findFormsInEntryDef(String id){
        return findInMapRef(getFormsEntryDef(), id);
    }

    public static List<Form> findAllFormsInEntryDef(List<VradiFormDTO> formDTOs) {
        // Extract ids
        List<String> ids = VradiHelper.extractDTOIds(formDTOs);
        return findAllInMapRef(getFormsEntryDef(), ids);
    }

    public static VradiFormDTO findFormsDTOInEntryDef(String id){
        return findInMapRef(getFormsDTOEntryDef(), id);
    }

    public static Session findSessionInEntryDef(String id){
        return findInMapRef(getSessionEntryDef(), id);
    }

    public static Sending findSendingInEntryDef(String id){
        return findInMapRef(getSendingEntryDef(), id);
    }

    public static void addFormInEntryDef(Form form) {
        List<Form> forms = getFormsInEntryDef();
        forms.add(form);
        setFormsEntryDef(forms);
    }

    public static void addAllFormsInEntryDef(List<Form> formList) {
        List<Form> forms = getFormsInEntryDef();
        forms.addAll(formList);
        setFormsEntryDef(forms);
    }

    public static void addFormDTOInEntryDef(VradiFormDTO form) {
        List<VradiFormDTO> forms = getFormsDTOInEntryDef();
        forms.add(form);
        setFormsDTOEntryDef(forms);
    }

    public static void addAllFormsDTOInEntryDef(List<VradiFormDTO> formList) {
        List<VradiFormDTO> forms = getFormsDTOInEntryDef();
        forms.addAll(formList);
        setFormsDTOEntryDef(forms);
    }

    public static void addAllSendingInEntryDef(List<Sending> sendingList) {
        List<Sending> sendings = getSendingInEntryDef();
        sendings.addAll(sendingList);
        setSendingEntryDef(sendings);
    }

    public static void addAllSessionEntryDef(List<Session> sessions) {
        List<Session> cached = getSessionsInEntryDef();
        cached.addAll(sessions);
        setSessionEntryDef(cached);
    }

    public static void addAllSessionDTOEntryDef(List<VradiSessionDTO> sessions) {
        List<VradiSessionDTO> cached = getSessionsDTOInEntryDef();
        cached.addAll(sessions);
        setSessionDTOEntryDef(cached);
    }

    protected static <E extends BusinessEntity> E findInMapRef(JAXXContextEntryDef<Map<String, E>> ref, String id) {
        if (ref == null){
            return null;
        }
        Map<String, E> map = ref.getContextValue(get());
        return map.get(id);
    }

    private static <E extends BusinessEntity> List<E> findAllInMapRef(JAXXContextEntryDef<Map<String, E>> ref, List<String> ids) {
        List<E> result = new ArrayList<E>();
        for (String id : ids){
            result.add(findInMapRef(ref, id));
        }
        return result;
    }

    protected static <E extends BusinessEntity> Map<String, E> fillMap(List<E> value) {
        Map<String, E> result = new HashMap<String, E>();
        for (E v : value){
            result.put(v.getWikittyId(), v);
        }
        return result;
    }

    public VradiConfig getVradiConfig() {
        return getContextValue(VradiConfig.class);
    }

    public DecoratorProvider getDecoratorProvider() {
        return getContextValue(DecoratorProvider.class);
    }

    public DecoratorProviderListCellRenderer getDecoratorProviderListCellRenderer() {
        return getContextValue(DecoratorProviderListCellRenderer.class);
    }

    public static <T> void addIfNecessary(JAXXContextEntryDef<List<T>> entryDef, T o) {
        List<T> values = entryDef.getContextValue(VradiContext.get());
        if (!values.contains(o)) {
            values.add(o);
            entryDef.setContextValue(VradiContext.get(), new ArrayList<T>(values));
        }
    }

    // Init thesaurus entry def
    public static void initThesaurusDef() throws VradiException {
        VradiStorageService service = VradiService.getVradiStorageService();
        TreeNodeImpl rootThesaurus;
        try {
            List<TreeNodeImpl> thesaurusList = new ArrayList<TreeNodeImpl>(service.getAllThesaurus());
            rootThesaurus = service.getRootThesaurus();
//            thesaurusList.add(rootThesaurus);
            setRootTreeNodeEntryDef(rootThesaurus);
            setTreeNodeEntryDef(thesaurusList);
        } catch (VradiException eee) {
            log.error(eee.getMessage(), eee);
            throw eee;
        }

        VradiThesaurusDTO vradiThesaurusDTO = new VradiThesaurusDTO();
        vradiThesaurusDTO.fromWikitty(rootThesaurus);
        loadAllChildrenThesaurus(vradiThesaurusDTO);

        setThesaurusEntryDef(vradiThesaurusDTO);
    }

    protected static void loadAllChildrenThesaurus(VradiThesaurusDTO thesaurusDTO) {
        // Get service
        VradiStorageService service = VradiService.getVradiStorageService();
        try {
            // Number of forms atached to thesaurus
            int nbForms = service.getNbFormsForThesaurus(thesaurusDTO.getWikittyId());
            thesaurusDTO.setFormsForThesaurus(nbForms);

            // Get children
            List<TreeNodeImpl> childrenTreeNode = service.getChildrenThesaurus(
                    thesaurusDTO.getWikittyId());

            if (childrenTreeNode != null) {
                // loading thesaurus recursivly
                for (TreeNodeImpl child : childrenTreeNode) {
                    VradiThesaurusDTO childThesaurus = new VradiThesaurusDTO();
                    childThesaurus.fromWikitty(child);

                    childThesaurus.setParentThesaurus(thesaurusDTO);
                    thesaurusDTO.addChild(childThesaurus);

                    loadAllChildrenThesaurus(childThesaurus);
                }
            }

        } catch (VradiException eee) {
            log.error("Cant find thesaurus ", eee);
        }
    }

    public static void initEntryDef() {
        VradiStorageService service = VradiService.getVradiStorageService();

        try {
            List<WikittyExtension> allFormTypes = service.getAllFormTypes();
            Collections.sort(allFormTypes, VradiComparators.EXTENSION_COMPARATOR);

            List<Status> allStatuses = service.getAllStatuses();
            Collections.sort(allStatuses, VradiComparators.STATUSES_COMPARATOR);

            List<Group> allGroups = service.getAllGroups();
            Collections.sort(allGroups, VradiComparators.GROUP_COMPARATOR);

            List<Client> clients = service.getAllClients();
            Collections.sort(clients, VradiComparators.CLIENT_COMPARATOR);

            List<XmlStream> xmlStreams = service.getAllXmlStreams();
            Collections.sort(xmlStreams, VradiComparators.XML_STREAM_COMPARATOR);

            List<User> users = service.getAllUsers();
            Collections.sort(users, VradiComparators.USER_COMPARATOR);

            setFormsTypeEntryDef(allFormTypes);
            setStatusEntryDef(allStatuses);
            setGroupsEntryDef(allGroups);
            setClientsEntryDef(clients);
            setXmlStreamEntryDef(xmlStreams);
            setUsersEntryDef(users);

            // Init thesaurus
            initThesaurusDef();

        } catch (VradiException ex) {
            log.error(ex);
            ErrorDialogUI.showError(ex);
            //FIXME should we do something ??? (return an empty model for example)
        }
    }

    public static void replace(BusinessEntity entity) {
        if (entity instanceof Client) {
            VradiContext.updateClient((Client) entity, true);
        } else if (entity instanceof User) {
            VradiContext.updateUser((User) entity, true);
        } else if (entity instanceof Group) {
            VradiContext.updateGroup((Group) entity, true);
        } else if (entity instanceof XmlStream) {
            VradiContext.updateXmlStream((XmlStream) entity, true);
        }
    }

    public static void remove(BusinessEntity entity) {
        if (entity instanceof Client) {
            VradiContext.updateClient((Client) entity, false);
        } else if (entity instanceof User) {
            VradiContext.updateUser((User) entity, false);
        } else if (entity instanceof Group) {
            VradiContext.updateGroup((Group) entity, false);
        } else if (entity instanceof XmlStream) {
            VradiContext.updateXmlStream((XmlStream) entity, false);
        }
    }

    static void updateClient(Client client, boolean replace) {
        List<Client> clients = VradiContext.getClientsInEntryDef();
        ListIterator<Client> listIterator = clients.listIterator();
        while (listIterator.hasNext()) {
            Client item = listIterator.next();
            if (item.getWikittyId().equals(client.getWikittyId())) {
                listIterator.remove();
                break;
            }
        }
        if (replace) {
            clients.add(client);
        }
        VradiContext.setClientsEntryDef(clients);
    }

    static void updateUser(User user, boolean replace) {
        List<User> users = VradiContext.getUsersInEntryDef();
        ListIterator<User> listIterator = users.listIterator();
        while (listIterator.hasNext()) {
            User item = listIterator.next();
            if (item.getWikittyId().equals(user.getWikittyId())) {
                listIterator.remove();
                break;
            }
        }
        if (replace) {
            users.add(user);
        }
        VradiContext.setUsersEntryDef(users);
    }

    static void updateGroup(Group group, boolean replace) {
        List<Group> groups = VradiContext.getGroupsInEntryDef();
        ListIterator<Group> listIterator = groups.listIterator();
        while (listIterator.hasNext()) {
            Group item = listIterator.next();
            if (item.getWikittyId().equals(group.getWikittyId())) {
                listIterator.remove();
                break;
            }
        }
        if (replace) {
            groups.add(group);
        }
        VradiContext.setGroupsEntryDef(groups);
    }

    static void updateXmlStream(XmlStream xmlStream, boolean replace) {
    List<XmlStream> streams = VradiContext.getXmlStreamInEntryDef();
        ListIterator<XmlStream> listIterator = streams.listIterator();
        while (listIterator.hasNext()) {
            XmlStream item = listIterator.next();
            if (item.getWikittyId().equals(xmlStream.getWikittyId())) {
                listIterator.remove();
                break;
            }
        }
        if (replace) {
            streams.add(xmlStream);
        }
        VradiContext.setXmlStreamEntryDef(streams);
    }
}
