/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.search;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.OfferListTableModel;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.search.CriteriaField;
import com.jurismarches.vradi.ui.search.CriteriaUI;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.WikittyExtension;

public class SearchHandler {
    private static final Log log = LogFactory.getLog(SearchHandler.class);
    public static final String CSV_FILE_EXTENSION = ".csv";

    public SearchUI initUI(JAXXContext rootContext, OfferListTableModel resultTableModel) {
        SearchUI ui = this.getUI(rootContext);
        if (ui == null) {
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
            context.add((Object)this);
            context.add((Object)resultTableModel);
            ui = new SearchUI((JAXXContext)context);
            this.initCriteria((JAXXContext)ui);
            VradiContext.SEARCH_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        }
        return ui;
    }

    public SearchUI initCloneUI(JAXXContext rootContext, OfferListTableModel resultTableModel) {
        return this.initCloneUI(rootContext, resultTableModel, null);
    }

    public SearchUI initCloneUI(JAXXContext rootContext, OfferListTableModel resultTableModel, List<VradiThesaurusDTO> thesaurus) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        context.add((Object)this);
        context.add((Object)resultTableModel);
        SearchUI ui = new SearchUI((JAXXContext)context);
        this.initCriteria((JAXXContext)ui, thesaurus);
        return ui;
    }

    SearchUI getUI(JAXXContext context) {
        if (context instanceof SearchUI) {
            return (SearchUI)context;
        }
        SearchUI ui = (SearchUI)((Object)VradiContext.SEARCH_UI_ENTRY_DEF.getContextValue(context));
        return ui;
    }

    public ComboBoxModel getRequestModel() {
        return new DefaultComboBoxModel();
    }

    public void executeQuery(JAXXContext context) {
        SearchUI searchUI = this.getUI(context);
        if (searchUI != null) {
            String query = searchUI.getRequest();
            JComboBox combo = searchUI.isOfferListUI() != false ? searchUI.getRequests() : null;
            CriteriaUI criterias = searchUI.getCriterias().isVisible() ? searchUI.getCriterias() : null;
            OfferListTableModel listTableModel = searchUI.getResultTableModel();
            VradiFormPageDTO formPageDTO = listTableModel.getFormPageDTO();
            this.executeQuery((JAXXContext)searchUI, criterias, formPageDTO, combo, query);
            listTableModel.setFormPageDTO(formPageDTO);
        } else {
            log.warn((Object)"searchUI is null !");
        }
    }

    public void executeQuery(JAXXContext context, int pageToShow) {
        SearchUI searchUI = this.getUI(context);
        if (searchUI != null) {
            OfferListTableModel listTableModel = searchUI.getResultTableModel();
            listTableModel.setPageToShow(pageToShow);
        } else {
            log.warn((Object)"searchUI is null !");
        }
    }

    public List<String> loadRequests() {
        return VradiHelper.loadRequests();
    }

    public JPanel getCriteriaPanel(JAXXContext context) {
        SearchUI ui = this.getUI(context);
        CriteriaUI criterias = ui.getCriterias();
        return criterias.getCriteriaPanel();
    }

    public CriteriaUI getCriterias(JAXXContext context) {
        return this.getUI(context).getCriterias();
    }

    public void initCriteria(JAXXContext context) {
        this.initCriteria(context, null);
    }

    public void initCriteria(JAXXContext context, List<VradiThesaurusDTO> thesaurus) {
        this.getCriteriaPanel(context).removeAll();
        VradiThesaurusDTO root = (VradiThesaurusDTO)VradiContext.THESAURUS_ENTRY_DEF.getContextValue(context);
        this.addCriteria(context, root, false, true);
        List<String> vradiListCriteria = VradiHelper.getVradiListCriteria();
        for (String value : vradiListCriteria) {
            this.addCriteria(context, value, true);
        }
        if (thesaurus != null) {
            for (VradiThesaurusDTO t : thesaurus) {
                this.addUnmodifiableCriteria(context, t);
            }
        }
    }

    public void removeCriteria(JAXXContext context, CriteriaField criteriaField) {
        this.getCriteriaPanel(context).remove((Component)((Object)criteriaField));
        this.getUI(context).validate();
    }

    public void removeCriteriaAndPersist(JAXXContext context, TreeNode bean) {
        CriteriaField criteriaField = (CriteriaField)context;
        VradiHelper.removeVradiListCriteria(bean);
        this.removeCriteria(context, criteriaField);
        this.getUI(context).validate();
    }

    public void addUnmodifiableCriteria(JAXXContext context, VradiThesaurusDTO thesaurusDTO) {
        CriteriaField criteriaField = this.addCriteria(context, thesaurusDTO.getParentThesaurus(), false, false);
        JComboBox combo = criteriaField.getCombo();
        combo.setSelectedItem(thesaurusDTO.getBean());
    }

    public void addAndPersistCriteria(JAXXContext context, VradiThesaurusDTO thesaurus) {
        VradiHelper.addVradiListCriteria(thesaurus.getBean());
        this.addCriteria(context, thesaurus, true, true);
    }

    protected void addCriteria(JAXXContext context, String wikittyId, boolean deletable) {
        if (wikittyId == null || wikittyId.isEmpty()) {
            return;
        }
        VradiThesaurusDTO criteriaThes = UIHelper.getHandler(context, ThesaurusHandler.class).findThesaurusInRef(context, wikittyId);
        if (criteriaThes != null) {
            this.addCriteria(context, criteriaThes, deletable, true);
        }
    }

    protected CriteriaField addCriteria(JAXXContext context, VradiThesaurusDTO thesCriteria, boolean deletable, boolean enabled) {
        TreeNode criteria = thesCriteria.getBean();
        CriteriaField criteriaField = new CriteriaField(context);
        criteriaField.setLabelName(criteria.getName());
        criteriaField.setBean(criteria);
        criteriaField.setDeletable(deletable);
        criteriaField.setActif(enabled);
        JComboBox combo = criteriaField.getCombo();
        List children = thesCriteria.getChildren();
        TreeNode[] thesArray = new TreeNode[children.size() + 1];
        int i = 0;
        TreeNodeImpl empty = new TreeNodeImpl();
        empty.setName(" ");
        thesArray[i] = empty;
        for (VradiThesaurusDTO child : children) {
            thesArray[++i] = child.getBean();
        }
        combo.setModel(new DefaultComboBoxModel<TreeNode>(thesArray));
        combo.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        criteriaField.init();
        JPanel criteriaPanel = this.getCriteriaPanel(context);
        criteriaPanel.add((Component)((Object)criteriaField));
        this.getUI(context).validate();
        return criteriaField;
    }

    protected List<String> getDateFormType(WikittyExtension formType) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Infogene.creationDate");
        result.add("Form.datePub");
        result.add("Form.datePeremption");
        if (formType != null) {
            for (String name : formType.getFieldNames()) {
                FieldType type = formType.getFieldType(name);
                if (type.getType() != FieldType.TYPE.DATE) continue;
                result.add(formType.getName() + "." + name);
            }
        }
        return result;
    }

    public DefaultComboBoxModel updateDateSelectionModel(WikittyExtension selected) {
        List<String> datas = this.getDateFormType(selected);
        return new DefaultComboBoxModel<String>(datas.toArray(new String[datas.size()]));
    }

    public void executeQuery(JAXXContext context, CriteriaUI criterias, VradiFormPageDTO formPageDTO, JComboBox combo, String request) {
        if (criterias == null) {
            VradiHelper.executeQuery(request, null, null, null, null, null, formPageDTO);
        } else {
            Component[] thesaurusCriteria = this.getCriteriaPanel(context).getComponents();
            ArrayList[] thesaurus = new ArrayList[thesaurusCriteria.length];
            for (int i = 0; i < thesaurus.length; ++i) {
                TreeNode tn = (TreeNode)((CriteriaField)((Object)thesaurusCriteria[i])).getCombo().getSelectedItem();
                if (tn == null || tn.getName().trim().isEmpty()) continue;
                thesaurus[i] = new ArrayList();
                String wikittyId = tn.getWikittyId();
                thesaurus[i].add(wikittyId);
                VradiThesaurusDTO parent = UIHelper.getHandler(context, ThesaurusHandler.class).findThesaurusInRef(context, wikittyId);
                thesaurus[i].addAll(parent.getChildrenRecursif());
            }
            GregorianCalendar beginDate = new GregorianCalendar();
            beginDate.setTime(criterias.getFromDate().getDate());
            beginDate.set(11, (Integer)criterias.getFromHour().getSelectedItem());
            beginDate.set(12, (Integer)criterias.getFromMinute().getSelectedItem());
            GregorianCalendar endDate = new GregorianCalendar();
            endDate.setTime(criterias.getToDate().getDate());
            endDate.set(11, (Integer)criterias.getToHour().getSelectedItem());
            endDate.set(12, (Integer)criterias.getToMinute().getSelectedItem());
            VradiHelper.executeQuery(request, (WikittyExtension)criterias.getFormTypeSelection().getSelectedItem(), (String)criterias.getDateTypeSelection().getSelectedItem(), beginDate.getTime(), endDate.getTime(), thesaurus, formPageDTO);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Total forms found        : " + formPageDTO.getTotalFoundFormNb()));
            log.info((Object)("Number of forms per page : " + formPageDTO.getNbFormsToShow()));
            log.info((Object)("Actual page              : " + formPageDTO.getPageToShow()));
        }
        if (context instanceof OfferListUI) {
            VradiHelper.addRequestToProperties(request);
        }
        if (combo != null) {
            ((DefaultComboBoxModel)combo.getModel()).removeElement(request);
            combo.insertItemAt(request, 0);
            combo.setSelectedIndex(0);
        }
    }

    public ListCellRenderer getDateTypeComboBoxRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String stringValue = null;
                if (value != null) {
                    stringValue = value.toString();
                    stringValue = stringValue.substring(stringValue.indexOf(46) + 1);
                }
                return super.getListCellRendererComponent((JList<?>)list, stringValue, index, isSelected, cellHasFocus);
            }
        };
    }

    public void exportToCSV(JAXXContext context) {
        SearchUI searchUI = this.getUI(context);
        File file = UIHelper.openFileChooser(CSV_FILE_EXTENSION, "vradi.export.filter.csv", (Component)((Object)searchUI), "vradi.export.validate.label");
        if (file != null) {
            VradiFormPageDTO formPageDTO = new VradiFormPageDTO();
            formPageDTO.setNbFormsToShow(1000000);
            formPageDTO.setPageToShow(1);
            OfferListTableModel tableModel = new OfferListTableModel(formPageDTO);
            if (searchUI != null) {
                CriteriaUI criterias = searchUI.getCriterias();
                String request = searchUI.getRequest();
                this.executeQuery(context, criterias, formPageDTO, null, request);
            } else {
                this.executeQuery(context, null, formPageDTO, null, null);
            }
            UIHelper.exportToCSV(file, tableModel);
        }
    }
}

