/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.ThesaurusUI;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.admin.ThesaurusPathChooserUI;
import com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeHandler;
import jaxx.runtime.swing.navigation.NavigationTreeHelper;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeModelBuilder;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThesaurusTreeHelper
extends NavigationTreeHelper {
    private static final Log log = LogFactory.getLog(ThesaurusTreeHelper.class);
    public static String PATH_SEPARATOR = "/";
    protected NavigationTreeNode rootNode = null;
    protected ThesaurusTreeModelBuilder builder = null;
    protected VradiThesaurusDTO rootThesaurus = null;
    protected JAXXContext context = null;
    protected String refName = null;
    protected JAXXContextEntryDef<VradiThesaurusDTO> THESAURUS;

    public ThesaurusTreeHelper(JAXXContext context) {
        this(context, null, null);
    }

    public ThesaurusTreeHelper(JAXXContext context, String refName) {
        this(context, null, refName);
    }

    public ThesaurusTreeHelper(JAXXContext context, VradiThesaurusDTO rootThesaurus) {
        this(context, rootThesaurus, null);
    }

    public ThesaurusTreeHelper(JAXXContext context, VradiThesaurusDTO rootThesaurus, String refName) {
        super(refName == null ? ThesaurusHandler.PREFIX_THESAURUS + rootThesaurus.getWikittyId() : refName);
        this.refName = refName;
        this.context = context;
        this.rootThesaurus = rootThesaurus != null ? rootThesaurus : (this.isCopy() ? this.getRootRefThesaurus(context).clone() : this.getRootRefThesaurus(context));
        if (this.isCopy()) {
            this.THESAURUS = SwingUtil.newContextEntryDef((String)refName, VradiThesaurusDTO.class);
            this.THESAURUS.setContextValue(context, (Object)this.rootThesaurus);
        }
    }

    protected boolean isCopy() {
        return this.refName != null;
    }

    protected JAXXContextEntryDef<VradiThesaurusDTO> getThesaurusRef() {
        return this.getThesaurusRef(this.isCopy());
    }

    protected VradiThesaurusDTO getRootRefThesaurus(JAXXContext context) {
        return (VradiThesaurusDTO)this.getThesaurusRef(false).getContextValue(context);
    }

    protected JAXXContextEntryDef<VradiThesaurusDTO> getThesaurusRef(boolean copy) {
        if (copy) {
            return this.THESAURUS;
        }
        return VradiContext.THESAURUS_ENTRY_DEF;
    }

    protected ThesaurusHandler getHandler(JAXXContext context) {
        return UIHelper.getHandler(context, ThesaurusHandler.class);
    }

    public ThesaurusTreeModelBuilder getBuilder() {
        return this.builder;
    }

    public VradiThesaurusDTO getRootThesaurus() {
        return this.rootThesaurus;
    }

    public NavigationTreeNode getRootNode() {
        return this.rootNode;
    }

    public String getRootName() {
        return this.rootThesaurus.getName();
    }

    public String getRootNamePath() {
        return this.rootThesaurus.getNamePath(this.getPathSeparator());
    }

    public String getPathSeparator() {
        return PATH_SEPARATOR;
    }

    public NavigationTreeModel createTreeModel(JAXXContext context) {
        this.context = context;
        if (this.builder == null) {
            this.builder = new ThesaurusTreeModelBuilder(context);
        }
        this.builder.buildRoot();
        this.getBuilder().buildChildren(context, this.rootNode);
        NavigationTreeModel model = this.builder.getModel();
        if (log.isInfoEnabled()) {
            this.builder.printModel(model.getRoot());
        }
        this.setTreeModel(context, model);
        return model;
    }

    public NavigationTreeHandler createTreeHandler(JAXXObject context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"create handler");
        }
        NavigationTreeHandler handler = new NavigationTreeHandler(this.getPrefix(), context, NavigationTreeHandler.Strategy.PER_NODE){
            private static final long serialVersionUID = 1L;

            protected NavigationTreeModel getNavigationTreeModel() {
                return ThesaurusTreeHelper.this.getSafeTreeModel(this.getContext());
            }

            protected void treateError(Exception e) {
                ErrorDialogUI.showError((Exception)e);
            }

            public JAXXContext getContext() {
                return this.context;
            }

            protected Component getCurrentUI() {
                return null;
            }

            protected Component getUI(NavigationTreeNode node) {
                return (Component)this.context;
            }

            protected boolean closeUI(Component component) throws Exception {
                return true;
            }

            protected Component createUI(NavigationTreeNode node) throws Exception {
                return ThesaurusTreeHelper.this.getHandler(this.context).getUI(this.context);
            }

            protected void openUI(Component newUI, NavigationTreeNode node) throws Exception {
            }
        };
        handler.setSelectionMode(4);
        this.setTreeHandler((JAXXContext)context, handler);
        if (context instanceof ThesaurusUI) {
            this.setTree((JAXXContext)context, ((ThesaurusUI)context).getThesaurus());
        } else if (context instanceof AdminThesaurusUI) {
            this.setTree((JAXXContext)context, ((AdminThesaurusUI)context).getThesaurus());
        } else {
            this.setTree((JAXXContext)context, ((ThesaurusPathChooserUI)context).getThesaurus());
        }
        return handler;
    }

    public TreePath expendNode(JAXXContext context, NavigationTreeNode node) {
        Object[] treeNodes = node.getPath();
        TreePath path = new TreePath(treeNodes);
        this.getTree(context).expandPath(path);
        return path;
    }

    public void tryToSelect(JAXXContext context, Set<String> thesaurusId) {
        if (thesaurusId != null) {
            ArrayList<NavigationTreeNode> nodes = new ArrayList<NavigationTreeNode>();
            for (String id : thesaurusId) {
                this.tryToSelect(id, this.getRootNode(), nodes);
            }
            JTree tree = this.getTree(context);
            TreePath[] paths = new TreePath[nodes.size()];
            int i = 0;
            for (NavigationTreeNode node : nodes) {
                TreePath path = this.expendNode(context, node);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Try to select path : " + path));
                }
                paths[i++] = path;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("path " + paths[i - 1] + " for node " + node));
            }
            tree.setSelectionPaths(paths);
        }
    }

    public void tryToSelect(String thesaurusId, NavigationTreeNode node, List<NavigationTreeNode> nodes) {
        if (thesaurusId != null) {
            if (thesaurusId.equals(this.getWikittyId(node))) {
                nodes.add(node);
            } else {
                Enumeration children = node.children();
                while (children.hasMoreElements()) {
                    NavigationTreeNode child = (NavigationTreeNode)children.nextElement();
                    this.tryToSelect(thesaurusId, child, nodes);
                }
            }
        }
    }

    protected String getWikittyId(NavigationTreeNode node) {
        VradiThesaurusDTO thesaurus = (VradiThesaurusDTO)node.getBean();
        return thesaurus.getWikittyId();
    }

    protected Decorator<VradiThesaurusDTO> getThesaurusDecorator() {
        Decorator tDecorator = VradiContext.get().getDecorateurProvinder().getDecorator(VradiThesaurusDTO.class);
        return tDecorator;
    }

    public class ThesaurusTreeModelBuilder
    extends NavigationTreeModelBuilder {
        public ThesaurusTreeModelBuilder(JAXXContext context) {
            super(PATH_SEPARATOR, context, null, null);
        }

        public boolean removeNodeFromParent(JAXXContext context, NavigationTreeNode node) {
            NavigationTreeModel treeModel = ThesaurusTreeHelper.this.getTreeModel(context);
            treeModel.removeNodeFromParent((MutableTreeNode)node);
            return treeModel.getRoot().getChildCount() == 0;
        }

        public NavigationTreeNode addThesaurusToSelected(JAXXContext context, VradiThesaurusDTO thesaurus) {
            NavigationTreeNode selectedNode = ThesaurusTreeHelper.this.getSelectedNode(context);
            return this.addThesaurus(context, selectedNode, thesaurus);
        }

        public NavigationTreeNode addThesaurus(JAXXContext context, NavigationTreeNode parent, VradiThesaurusDTO thesaurus) {
            return this.addThesaurus(parent, thesaurus.getWikittyId());
        }

        public NavigationTreeNode addThesaurusAndChildrenRecursivly(NavigationTreeNode parent, VradiThesaurusDTO thesaurus) {
            NavigationTreeNode newNode = this.addThesaurus(parent, thesaurus.getWikittyId());
            for (VradiThesaurusDTO child : thesaurus.getChildren()) {
                this.addThesaurusAndChildrenRecursivly(newNode, child);
            }
            return newNode;
        }

        public NavigationTreeNode addThesaurus(NavigationTreeNode parent, String thesaurusId) {
            NavigationTreeNode result = null;
            Decorator<VradiThesaurusDTO> tDecorator = ThesaurusTreeHelper.this.getThesaurusDecorator();
            String path = "";
            if (parent == null) {
                parent = ThesaurusTreeHelper.this.getRootNode();
                path = "..children[@wikittyId=\"" + thesaurusId + "\"]";
            } else {
                path = ".." + PATH_SEPARATOR + "children[@wikittyId=\"" + thesaurusId + "\"]";
            }
            result = ThesaurusTreeHelper.this.builder.build(parent, tDecorator, path, thesaurusId, null, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("addThesaurus : " + thesaurusId + " to parent : " + (parent == null ? "null" : parent.getFullPath()) + " fullPath : " + (result == null ? "result is null" : result.getFullPath())));
            }
            return result;
        }

        public void buildRoot() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Building root : " + ThesaurusTreeHelper.this.getRootName()));
            }
            NavigationTreeNode invisibleRootNode = ThesaurusTreeHelper.this.builder.buildEmptyRoot(ThesaurusTreeHelper.this.getThesaurusRef(), ThesaurusTreeHelper.this.getThesaurusRef().getName());
            if (ThesaurusTreeHelper.this.rootThesaurus.getParentThesaurus() == null) {
                ThesaurusTreeHelper.this.rootNode = invisibleRootNode;
                return;
            }
            ThesaurusTreeHelper.this.rootNode = ThesaurusTreeHelper.this.builder.build(invisibleRootNode, ThesaurusTreeHelper.this.getThesaurusDecorator(), ThesaurusTreeHelper.this.rootThesaurus.getBuildPath(PATH_SEPARATOR), ThesaurusTreeHelper.this.rootThesaurus.getWikittyId(), null, null);
        }

        public void buildChildren(JAXXContext context, NavigationTreeNode parentNode) {
            VradiThesaurusDTO parent;
            if (log.isDebugEnabled()) {
                log.debug((Object)("buildChildren of thesaurus " + parentNode.getFullPath()));
            }
            if ((parent = (VradiThesaurusDTO)parentNode.getBean(context)) != null) {
                for (VradiThesaurusDTO child : parent.getChildren()) {
                    NavigationTreeNode childNode = this.addThesaurus(context, parentNode, child);
                    if (child.getWikittyId() == null) continue;
                    this.buildChildren(context, childNode);
                }
            }
        }
    }
}

