package com.jurismarches.vradi.ui.search;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.OfferListTableModel;
import com.jurismarches.vradi.ui.search.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.AbstractTableModel;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class SearchUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HIDABLE = "hidable";
    public static final String PROPERTY_OFFER_LIST_UI = "offerListUI";
    public static final String PROPERTY_REQUEST = "request";
    public static final String PROPERTY_REQUEST_MODEL = "requestModel";
    public static final String PROPERTY_RESULT_TABLE_MODEL = "resultTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_REQUESTS_VISIBLE = "requests.visible";
    public static final String BINDING_REQUEST_AREA_TEXT = "requestArea.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$HIDOR_BUTTON0_VISIBLE = "$HidorButton0.visible";
    private static final String BINDING_$JLABEL0_VISIBLE = "$JLabel0.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz08TQRQeKm0pUOVHQAhIEEgMUbbiFSLQKqFNUWPBEHtx2h3okO3OMjML68X4J/gn6N2LiTdPxoNnD16M/4IxHrwa3+xuu9260Jr20O2++d73vvfmvde3P1BccHT9GDuOxm1T0jrRClsHBw8rx6Qq7xFR5dSSjCPv0xdDsTIa0pt2IdFiuajcM757JsfqFjOJ2eK9VkSDQj43iKgRIiW6FvaoCpEpNY/XHMvmDdamqCjW179+xl7pL9/EEHIsUDcCqcx38goy6S+iGNUlGoNIpzhjYPMIZHBqHoHetLLlDCzEA1wnJ+gFShZRwsIcyCRa6D5ll8P1dyyJkkt7uGKQ2xItV1ldO7Y5FXXMqzUitFOOdarZVBNEWbSS+9jPW5brnwBvTk5sIkDAiJKnKcmaJzkADbHDQ8KLVMj9vESjATDLmEGw2UJXo7pSo15HA/MIJ8I2pCt0l+nEkGjlfLEPG9ECfEA17Av2aaaVGEcTZyBY3U2FZZnT5jKwVCjiCjGgRGOtcM+qQKkA69NDF06EsA3uMNwv/qpEU6Eu8Zz2GqUIHNJLhVKVM8N4hE11Z1dDQYIjBZ8PLsBXtcUJbhe2RxzXrqCL7cLuqNeFMFnCawaJxkM8WVtKZirMchMar8L1cvWyEj5IL+1QnXHPB9KYi8i+BRF2TkFDS8IphiLf7NizOR+8n/crydFMKBrMuhbMejCMfWUU5zaY4XLK/66Hx3DkLYaptsWgCN3TP5PjXz98f7/d2AZpiD0RCW1ZZjClFmcW4ZKq0Fe8VWBLamR2sbVWRilBDNiE7qabjRBW8o9BHMTzpk25aztY1IAinvz28dPksy+XUGwbDRoM69tY4fMoJWswaDVm6I61sekqGj4bUGtMaZOoX0KvwBCsU9OgJpnHEga9Ykty14EyzEaUoamlkvr8e7z0brNRij6QNn0uPChH/ClKeNHc1ehvvchVOGQJYuss2G5R+65PPWcsf7jX3O+NqFyTp1RQmACJLq/rWOL5CjV1aEtIVfnk3BzUr/tdU8braq+o40I0yVxHEmXO98QAt8jZmXuajea40ZWKrQtU/AfDORpu9cyQ6eaO4d+G7FHrglRWu6GBkTnrnSYhMT8iskeWtMfyxOvensg6NZti+AvTzHI/rwkAAA==";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.search.SearchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton clear;
    protected com.jurismarches.vradi.ui.search.CriteriaUI criterias;
    protected java.lang.Boolean hidable;
    protected java.lang.Boolean offerListUI;
    protected java.lang.String request;
    protected javax.swing.JTextArea requestArea;
    protected javax.swing.ComboBoxModel requestModel;
    protected javax.swing.JComboBox requests;
    protected com.jurismarches.vradi.ui.OfferListTableModel resultTableModel;
    protected javax.swing.JButton search;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SearchUI $Table0 = this;
    private javax.swing.JLabel $JLabel0;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JScrollPane $JScrollPane0;
    private jaxx.runtime.swing.Table $Table2;
    private jaxx.runtime.swing.HidorButton $HidorButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public SearchHandler getHandler() {
        return getContextValue(SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        java.util.List<String> queries = getHandler().loadRequests();
        requests.removeAllItems();
        for(String query : queries) {
            requests.addItem(query);
        }
    }
    
    protected void keyReleased(KeyEvent keyEvent) {
        if(keyEvent.getKeyCode() == KeyEvent.VK_ENTER) {
            executeQuery();
        }
        setRequest(requestArea.getText());
    }
    
    protected void executeQuery() {
        getHandler().executeQuery(this, 1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SearchUI() {
        $initialize();
    }

    public SearchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__clear(java.awt.event.ActionEvent event) {
        setRequest("");
    }

    public void doActionPerformed__on__requests(java.awt.event.ActionEvent event) {
        setRequest(getStringValue(requests.getSelectedItem()));
    }

    public void doActionPerformed__on__search(java.awt.event.ActionEvent event) {
        executeQuery();
    }

    public void doKeyReleased__on__requestArea(java.awt.event.KeyEvent event) {
        keyReleased(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getClear() {
        return clear;
    }

    public com.jurismarches.vradi.ui.search.CriteriaUI getCriterias() {
        return criterias;
    }

    public java.lang.Boolean getHidable() {
        return hidable;
    }

    public java.lang.Boolean getOfferListUI() {
        return offerListUI;
    }

    public java.lang.String getRequest() {
        return request;
    }

    public javax.swing.JTextArea getRequestArea() {
        return requestArea;
    }

    public javax.swing.ComboBoxModel getRequestModel() {
        return requestModel;
    }

    public javax.swing.JComboBox getRequests() {
        return requests;
    }

    public com.jurismarches.vradi.ui.OfferListTableModel getResultTableModel() {
        return resultTableModel;
    }

    public javax.swing.JButton getSearch() {
        return search;
    }

    public java.lang.Boolean isHidable() {
        return hidable !=null && hidable;
    }

    public java.lang.Boolean isOfferListUI() {
        return offerListUI !=null && offerListUI;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHidable(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.hidable;
        this.hidable = newValue;
        firePropertyChange(PROPERTY_HIDABLE, oldValue, newValue);
    }

    public void setOfferListUI(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.offerListUI;
        this.offerListUI = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_UI, oldValue, newValue);
    }

    public void setRequest(java.lang.String newValue) {
        java.lang.String oldValue = this.request;
        this.request = newValue;
        firePropertyChange(PROPERTY_REQUEST, oldValue, newValue);
    }

    public void setRequestModel(javax.swing.ComboBoxModel newValue) {
        javax.swing.ComboBoxModel oldValue = this.requestModel;
        this.requestModel = newValue;
        firePropertyChange(PROPERTY_REQUEST_MODEL, oldValue, newValue);
    }

    public void setResultTableModel(com.jurismarches.vradi.ui.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.OfferListTableModel oldValue = this.resultTableModel;
        this.resultTableModel = newValue;
        firePropertyChange(PROPERTY_RESULT_TABLE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createClear() {
        $objectMap.put("clear", clear = new javax.swing.JButton());
        clear.setName("clear");
        clear.setText(_("vradi.criteria.clear"));
        clear.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clear"));
    }

    protected void createCriterias() {
        $objectMap.put("criterias", criterias = new com.jurismarches.vradi.ui.search.CriteriaUI(this));
        criterias.setName("criterias");
    }

    protected void createHidable() {
        $objectMap.put("hidable", hidable = true);
    }

    protected void createOfferListUI() {
        $objectMap.put("offerListUI", offerListUI = false);
    }

    protected void createRequest() {
        $objectMap.put("request", request = "");
    }

    protected void createRequestArea() {
        $objectMap.put("requestArea", requestArea = new javax.swing.JTextArea());
        requestArea.setName("requestArea");
        requestArea.setColumns(15);
        requestArea.setLineWrap(true);
        requestArea.setWrapStyleWord(true);
        requestArea.setRows(3);
        requestArea.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__requestArea"));
    }

    protected void createRequestModel() {
        $objectMap.put("requestModel", requestModel = getHandler().getRequestModel());
    }

    protected void createRequests() {
        $objectMap.put("requests", requests = new javax.swing.JComboBox());
        requests.setName("requests");
        requests.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__requests"));
    }

    protected void createResultTableModel() {
        $objectMap.put("resultTableModel", resultTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createSearch() {
        $objectMap.put("search", search = new javax.swing.JButton());
        search.setName("search");
        search.setText(_("vradi.criteria.search"));
        search.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__search"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        add(requests, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($Table1, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(criterias, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JScrollPane0, new GridBagConstraints(0, 0, 1, 1, 0.9, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($Table2, new GridBagConstraints(1, 0, 1, 1, 0.1, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(requestArea);
        // inline complete setup of $Table2
        $Table2.add(search, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add(clear, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add($HidorButton0, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        requests.setModel(requestModel);
        $HidorButton0.setHideTip(_("vradi.criteria.collapse"));
        $HidorButton0.setShowTip(_("vradi.criteria.notCollapse"));
        $HidorButton0.setTarget(criterias);
        $HidorButton0.setTargetVisible(true);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 4 data bindings
        $registerDefaultBindings();
        $objectMap.put("$Table0", this);
        createRequest();
        createOfferListUI();
        createHidable();
        createResultTableModel();
        createRequestModel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.list.requests"));
        createRequests();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        $Table1.setName("$Table1");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createRequestArea();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new jaxx.runtime.swing.Table());
        $Table2.setName("$Table2");
        createSearch();
        createClear();
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        $HidorButton0.setName("$HidorButton0");
        createCriterias();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_VISIBLE, true ,"offerListUI") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setVisible(isOfferListUI());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUESTS_VISIBLE, true ,"offerListUI") {
        
            @Override
            public void processDataBinding() {
                requests.setVisible(isOfferListUI());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUEST_AREA_TEXT, true ,"request") {
        
            @Override
            public void processDataBinding() {
                jaxx.runtime.SwingUtil.setText(requestArea, getRequest());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$HIDOR_BUTTON0_VISIBLE, true ,"hidable") {
        
            @Override
            public void processDataBinding() {
                $HidorButton0.setVisible(isHidable());
            }
        });
    }

}