package com.jurismarches.vradi.ui.editors;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiStorageServiceImpl;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.editors.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class IdEditor extends com.jurismarches.vradi.ui.editors.VradiEditor<String, StringEditorModel> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_TEXT = "editor.text";
    public static final String BINDING_WIKITTY_ID_TEXT = "wikittyId.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TTW/TQBCdpE1KWsJHK6JWFClAD6hINvdWUBSISJWCRKqqIhc28arZsraX3XHrXhA/gZ8Ady5I3DghDpw5cEH8BYQ4cEXM2kncgBH1YW3tzHvzZvzm9TcoGQ2X91kcOzoKUPjc2by9u/ugt8/7eIebvhYKQw3pUyhCsQtz3vjeIFztti3cHcLdRuirMODBMfRaG2YNHkluBpwjwqVJRN8YtzMOr8Uq0iPWsag81pc/vhdfeM9fFQFiRerK1Er9f6isk+k2FIWHME+VDpgrWbBHMrQI9khv1d41JDPmPvP5U3gGM20oK6aJDOHKyVtOOBJ8rBCqKzuaeeKuJyjnBsJqP/Sd/UgL4zPdH3DjHNi4EwmHJznGaXlptlIJTRmh5IcelwjuycFbFpExVA6YFB6jAML1iYmNA445pEk4HXvujC4zhmpaoREGmExkcYIlxW6znuQZpJxCEGp2tvEwaXObx9gUXHo2bT6TeCieCMSjlv1DE4A263E5TNZwcaIwWcnJrJT960IXSjqia1La/dt9DymU+m7xD99ZwiT6q7bw+d3Xt82R2aao9oXc1GO7QiZQOlRco7Clz6ZOi1BId4uptS5UDJe0aMkiLecI6wzDJI7qnbdwx8Kde8wMiKI08+X9h9rjT1NQbMKsDJnXZDa/BRUcaJpCKL1Y3dpIFJ0+PEXnOasNYaYfysgPqO78ugikCHidIbm/FyG/GdMklnMmMZbTq3z8udB5szGaRoHULf0zPZtI6RGU02rJ8g33KnfZ5pThkRdm+5O3UQX7rqmhyerJuZLX7jSSzRDOrJOPWb0nAo+8RH1awLWkAfu1ekI+e+3Yw81nWCKG37A4UFFcBQAA";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTextField editor;
    protected com.jurismarches.vradi.ui.editors.IdEditorModel model;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.editors.IdEditorModel > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();
    protected javax.swing.JLabel wikittyId;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private IdEditor $VradiEditor0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
            void registerValidator() {
                validator.setContextName(model.getValidatorContext());
                validator.setBean(model);
                getContextValue(jaxx.runtime.validator.swing.SwingValidatorMessageTableModel.class,"errorEditorTable")
                        .registerValidator(validator);
    
                log.debug("registration : " + validator.getContextName());
            }
    
            public String getModifiablePartOfValue(String value) {
                if(value == null) {
                    return null;
                }
                int modifiablePartLength =
                        VradiStorageServiceImpl.FORM_ID_DATE_FORMAT.toPattern().length();
                return value.substring(0, modifiablePartLength);
            }
    
            public String getUnmodifiablePartOfValue(String value) {
                if(value == null) {
                    return null;
                }
                int unmodifiablePartLength =
                        VradiStorageServiceImpl.FORM_ID_DATE_FORMAT.toPattern().length();
                return value.substring(unmodifiablePartLength);
            }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public IdEditor() {
        super();
        $initialize();
    }

    public IdEditor(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.editors.IdEditorModel > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doKeyReleased__on__editor(java.awt.event.KeyEvent event) {
        setValue(editor.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTextField getEditor() {
        return editor;
    }

    public com.jurismarches.vradi.ui.editors.IdEditorModel getModel() {
        return model;
    }

    public javax.swing.JLabel getWikittyId() {
        return wikittyId;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(SwingUtil.boxComponentWithJxLayer(editor), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        editorContent.add(wikittyId, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(model);
        validator.setFieldRepresentation("value", editor);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new javax.swing.JTextField());
        editor.setName("editor");
        editor.setColumns(15);
        editor.setColumns(10);
        editor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__editor"));
    }

    @Override
    protected void createEditorContent() {
        $objectMap.put("editorContent", editorContent = new jaxx.runtime.swing.Table());
        editorContent.setName("editorContent");
    }

    protected void createModel() {
        $objectMap.put("model", model = new com.jurismarches.vradi.ui.editors.IdEditorModel());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.editors.IdEditorModel >(com.jurismarches.vradi.ui.editors.IdEditorModel.class, null));
    }

    protected void createWikittyId() {
        $objectMap.put("wikittyId", wikittyId = new javax.swing.JLabel());
        wikittyId.setName("wikittyId");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToEditorContent();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // late initializer
        // register 1 validator(s)
        validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 2 data bindings
        $registerDefaultBindings();
        $objectMap.put("$VradiEditor0", this);
        createModel();
        createValidator();
        createEditor();
        createWikittyId();
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    jaxx.runtime.SwingUtil.setText(editor, getModifiablePartOfValue(model.getValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WIKITTY_ID_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    wikittyId.setText(_(getUnmodifiablePartOfValue(model.getValue())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
    }

}