package com.jurismarches.vradi.ui.editors;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.editors.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class CurrencyEditor extends com.jurismarches.vradi.ui.editors.VradiEditor<String, CurrencyEditorModel> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODEL = "model";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CURRENCY_COMBO_BOX_SELECTED_ITEM = "currencyComboBox.selectedItem";
    public static final String BINDING_EDITOR_MODEL = "editor.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTU8TURS9rbRQPgQlEIyQgKLupmxcQRCpNkIKGkoMsRvfzLzQITPznu8DphvjT/An6N6NiTtXxoVrF26Mf8EYF26N981MW9BR0elipnn3nnPPvXPue/EZSlLAwgGJIkvoUHkBtTZv7u3dtQ+oo25R6QiPKyYg+RWKUGzBiNs7lwoutxoGXk3h1RoLOAtpeAy93IBhqTo+lW1KlYK5kwhHymqzF16OuBZd1p6oLNZnX78Un7pPnhcBIo7qTCvzf0P1OxloQNFzFZzHSoek6pNwH2UIL9xHvWPmrOYTKbdJQB/BYxhsQJkTgWQKLp2+5ZgjxkdcwdjifUFc77brYc6SgiWHBdaBFp4MiHDaVFqHJm5pz6JxjrRqWmBRp5NgOI/JygpKAXOpr+D6v1JsGVyfZyzJqrFQxb3NnJigPMJ5WLvE9mkfUk4gCq5m5CYxa1sHNhVJRQMb76EnnFQOjs1m6yxSMGWmHaUEm93zFCbg4okyaBerb5f+9yy0oCQ0HmMPrV8dtoOhxFszP3nLEMbR79OTH15/elXvGmoUa09lph7bB/zQXDBOhfJM6fHETVp5fnWL8OUWVCT1cZniZZnNENZMwygO650zcMvArTtEtpGiNPjxzdvph+/PQLEOwz4jbp2Y/A2oqLbAKTDfjfiNtVjR6NEQPieMNgUVohW7x7hG551dcYki87YXujjk1QjnMJsxh54Yu/Lu22Tz5Vp3FgXUduG36f15lB5A2Qt9L6TxeqWbk7lOI1xS7bL+hmTtTMG8J3lqvrn4uZDV7IBNSWiii5E2ryuxaPPv2qk5kp3KSVKJSXY7nOYkGkp91cE7aiWZ6TxReEPZWtHV/+cdR8scxbZY10qxvEOrGLodKqnK26+WtI7+zssziDxNbz9fX+Z46Q8M06dpCK85lwoqcvKMJjcIdTcUDf7C9QOuzkRS0wcAAA==";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JComboBox currencyComboBox;
    protected jaxx.runtime.swing.editor.NumberEditor editor;
    protected com.jurismarches.vradi.ui.editors.CurrencyEditorModel model;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CurrencyEditor $VradiEditor0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    @Override
    public void init() {
        super.init();
        editor.init();
    }
    
    @Override
    void registerValidator() {
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CurrencyEditor() {
        super();
        $initialize();
    }

    public CurrencyEditor(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__currencyComboBox(java.awt.event.ActionEvent event) {
        if(currencyComboBox.getSelectedItem() != null)                            {model.setCurrency(currencyComboBox.getSelectedItem().toString());};
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JComboBox getCurrencyComboBox() {
        return currencyComboBox;
    }

    public jaxx.runtime.swing.editor.NumberEditor getEditor() {
        return editor;
    }

    public com.jurismarches.vradi.ui.editors.CurrencyEditorModel getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModel(com.jurismarches.vradi.ui.editors.CurrencyEditorModel newValue) {
        com.jurismarches.vradi.ui.editors.CurrencyEditorModel oldValue = this.model;
        this.model = newValue;
        firePropertyChange(PROPERTY_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(editor, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        editorContent.add(currencyComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createCurrencyComboBox() {
        $objectMap.put("currencyComboBox", currencyComboBox = new javax.swing.JComboBox());
        currencyComboBox.setName("currencyComboBox");
        currencyComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__currencyComboBox"));
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new jaxx.runtime.swing.editor.NumberEditor());
        editor.setName("editor");
        editor.setProperty("amount");
    }

    @Override
    protected void createEditorContent() {
        $objectMap.put("editorContent", editorContent = new jaxx.runtime.swing.Table());
        editorContent.setName("editorContent");
    }

    protected void createModel() {
        $objectMap.put("model", model = new CurrencyEditorModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToEditorContent();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 9 property setters
        editor.setAutoPopup(true);
        editor.setBean(model);
        editor.setModelType(Float.class);
        editor.setShowPopupButton(true);
        editor.setShowReset(true);
        editor.setUseFloat(true);
        editor.setUseSign(false);
        currencyComboBox.setModel(new DefaultComboBoxModel(FieldTypeEnum.Currency.values()));
        currencyComboBox.setRenderer(UIHelper.getTranslationListCellRenderer());
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 2 data bindings
        $registerDefaultBindings();
        $objectMap.put("$VradiEditor0", this);
        createModel();
        createEditor();
        createCurrencyComboBox();
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("amount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setModel(model.getAmount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("amount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CURRENCY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currency", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    currencyComboBox.setSelectedItem(FieldTypeEnum.getCurrency(model.getCurrency()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currency", this);
                }
            }
        });
    }

}