package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.JListCellRenderer;
import com.jurismarches.vradi.ui.ProgressBarUI;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.editors.JListCellEditor;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.swing.SwingValidator;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.sharengo.wikitty.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminXmlStreamUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<XmlStream> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADMIN_XML_STREAM_ENABLED = "adminXmlStream.enabled";
    public static final String BINDING_FORM_TYPE_COMBO_SELECTED_ITEM = "formTypeCombo.selectedItem";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_VALIDATE_URL_ENABLED = "validateUrl.enabled";
    public static final String BINDING_XML_STREAM_NAME_TEXT = "xmlStreamName.text";
    public static final String BINDING_XML_STREAM_PREVIEW_TOOL_TIP_TEXT = "xmlStreamPreview.toolTipText";
    public static final String BINDING_XML_STREAM_URL_TEXT = "xmlStreamUrl.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminXmlStreamUI adminXmlStream = this;
    protected jaxx.runtime.swing.Table adminXmlStreamForm;
    protected com.jurismarches.vradi.services.dto.VradiXmlStreamDTO bean;
    protected javax.swing.JButton createForms;
    protected javax.swing.JButton createXmlStream;
    protected com.jurismarches.vradi.ui.admin.content.XmlStreamFieldTableModel fieldsModel;
    protected org.jdesktop.swingx.JXTable fieldsTable;
    protected javax.swing.JComboBox formTypeCombo;
    protected jaxx.runtime.swing.HBox lastModified;
    protected javax.swing.JLabel title;
    protected javax.swing.JButton validateUrl;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiXmlStreamDTO > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();
    protected javax.swing.JTextField xmlStreamName;
    protected javax.swing.JLabel xmlStreamPreview;
    protected javax.swing.JTextField xmlStreamUrl;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    void $afterCompleteSetup() {
        addPCSLogger();
        addBeanPCSLogger(bean);
        addBeanModifiedPCS(bean);
        SwingUtil.setI18nTableHeaderRenderer(fieldsTable,
                n_("vradi.table.field.name"),
                n_("vradi.table.field.name.tip"),
                n_("vradi.table.field.values"),
                n_("vradi.table.field.values.tip"));
    
        JListCellRenderer render= new JListCellRenderer(fieldsTable.getDefaultRenderer(String.class));
    
        setContextValue(render);
        SwingUtil.setTableColumnRenderer(fieldsTable, 0, fieldsTable.getDefaultRenderer(String.class));
        SwingUtil.setTableColumnRenderer(fieldsTable, 1, render);
    
        JListCellEditor editor = new JListCellEditor();
        setContextValue(editor);
        SwingUtil.setTableColumnEditor(fieldsTable, 1, editor);
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
                HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        fieldsTable.addHighlighter(highlighter);
        errorTable.registerValidator(validator);
    }
    
    protected void validateFormTypeChoice() {
        stopEditing();
        boolean m = isModified();
        getHandler().updateFieldsModel(this);    
        setModified(m);
        validate();
    }
    
    protected void superOpenUI(NavigationTreeNode node) throws Exception {
        super.openUI(node);
    }
    
    @Override
    public void openUI(final NavigationTreeNode node) throws Exception {
        final ProgressBarUI pb = new ProgressBarUI(this);
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        SwingWorker task = new SwingWorker<Void, Void>(){
            /*
             * Main task. Executed in background thread.
             */
            @Override
            public Void doInBackground() throws Exception {
                superOpenUI(node);
                java.util.List<WikittyExtension> forms = getHandler().getAllForms(adminXmlStream);
                SwingUtil.fillComboBox(formTypeCombo, forms, null);
                WikittyExtension formType = getHandler().getFormType(bean);
                if (log.isDebugEnabled()) {
                    log.debug("form type = " + formType);
                }
                bean.setFormType(formType);
                getHandler().updateFieldsModel(adminXmlStream);
                lastModified.removeAll();
                if(bean != null && bean.getLastModified() != null && bean.getLastModifier() != null) {
                    String labelText = String.format(_("vradi.entity.lastModified.date.user"), bean.getLastModified(), bean.getLastModifier());
                    lastModified.add(new JLabel(labelText));
                }
                setModified(false);
                return null;
            }
    
            /*
             * Executed in event dispatching thread
             */
            @Override
            public void done() {
                adminXmlStream.validate();
                setCursor(null); //turn off the wait cursor
                pb.dispose();
            }
        };
        task.execute();
        SwingUtil.center(getContextValue(AdminPopupUI.class), pb);
        pb.setVisible(true);
    }
    
    @Override
    public void save(){
        stopEditing();
        this.bean.setLastModified(new java.util.Date());
        this.bean.setLastModifier(getContextValue(VradiUser.class).getName());
        XmlStream bean = (XmlStream) getHelper().getSelectedBean(this);
        if(!bean.getExtensions().contains(ModificationTag.MODIFICATION_TAG)) {
            bean.addExtension(ModificationTag.MODIFICATION_TAG);
        }
        this.bean.toWikitty(bean);
        XmlStream savedStream = getHandler().saveXmlStream(this, getHelper(), bean, fieldsModel.getData());
        if(savedStream != null) {
            this.bean.fromWikitty(savedStream);
        }
        //bean = getHandler().saveXmlStream(this, getHelper(), bean, fieldsModel.getData());
        //updateBeanFromEntity(bean);
    }
    
    protected void updateBeanFromEntity(XmlStream bean) {
        this.bean.fromWikitty(bean);
    }
    
    protected void stopEditing() {
        //FIXME-TC20091116 il faut pouvoir annuler l'édition si on sort du tableau
        if (fieldsTable.getCellEditor()!=null) {
            fieldsTable.getCellEditor().stopCellEditing();
        }
    }
    
    protected void createForms() {
        createForms.setEnabled(false);
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        final ProgressBarUI pb = new ProgressBarUI(this);
        SwingWorker task = new SwingWorker<Void, Void>(){
            /*
             * Main task. Executed in background thread.
             */
            @Override
            public Void doInBackground() {
                getHandler().createForms(adminXmlStream);
                return null;
            }
    
            /*
             * Executed in event dispatching thread
             */
            @Override
            public void done() {
                createForms.setEnabled(true);
                setCursor(null); //turn off the wait cursor
                pb.dispose();
            }
        };
        task.execute();
        SwingUtil.center(getParentContainer(AdminPopupUI.class), pb);
        pb.setVisible(true);
    }
    
    protected String updateTitle(String name) {         
       return _("vradi.adminXmlStream.title", SwingUtil.getStringValue(name));
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminXmlStreamUI() {
        super();
        $initialize();
    }

    public AdminXmlStreamUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiXmlStreamDTO > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), bean);
    }

    public void doActionPerformed__on__createForms(java.awt.event.ActionEvent event) {
        createForms();
    }

    public void doActionPerformed__on__createXmlStream(java.awt.event.ActionEvent event) {
        getHandler().createXmlStream(this, getHelper());
    }

    public void doActionPerformed__on__formTypeCombo(java.awt.event.ActionEvent event) {
        bean.setFormType((WikittyExtension) formTypeCombo.getSelectedItem());
    }

    public void doActionPerformed__on__validateUrl(java.awt.event.ActionEvent event) {
        validateFormTypeChoice();
    }

    public void doKeyReleased__on__xmlStreamName(java.awt.event.KeyEvent event) {
        bean.setName(xmlStreamName.getText());
    }

    public void doKeyReleased__on__xmlStreamUrl(java.awt.event.KeyEvent event) {
        bean.setUrl(xmlStreamUrl.getText());
    }

    public void doTableChanged__on__fieldsModel(javax.swing.event.TableModelEvent event) {
        setModified(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminXmlStreamForm() {
        return adminXmlStreamForm;
    }

    public com.jurismarches.vradi.services.dto.VradiXmlStreamDTO getBean() {
        return bean;
    }

    public javax.swing.JButton getCreateForms() {
        return createForms;
    }

    public javax.swing.JButton getCreateXmlStream() {
        return createXmlStream;
    }

    public com.jurismarches.vradi.ui.admin.content.XmlStreamFieldTableModel getFieldsModel() {
        return fieldsModel;
    }

    public org.jdesktop.swingx.JXTable getFieldsTable() {
        return fieldsTable;
    }

    public javax.swing.JComboBox getFormTypeCombo() {
        return formTypeCombo;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    public javax.swing.JButton getValidateUrl() {
        return validateUrl;
    }

    public javax.swing.JTextField getXmlStreamName() {
        return xmlStreamName;
    }

    public javax.swing.JLabel getXmlStreamPreview() {
        return xmlStreamPreview;
    }

    public javax.swing.JTextField getXmlStreamUrl() {
        return xmlStreamUrl;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminXmlStreamForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminXmlStreamForm.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(SwingUtil.boxComponentWithJxLayer(xmlStreamName), new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(SwingUtil.boxComponentWithJxLayer(xmlStreamUrl), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(xmlStreamPreview, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(SwingUtil.boxComponentWithJxLayer(formTypeCombo), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(validateUrl, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminXmlStreamForm, BorderLayout.NORTH);
        body.add($JPanel1, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(bean);
        validator.setFieldRepresentation("formType", formTypeCombo);
        validator.setFieldRepresentation("name", xmlStreamName);
        validator.setFieldRepresentation("url", xmlStreamUrl);
    }

    protected void createAdminXmlStreamForm() {
        $objectMap.put("adminXmlStreamForm", adminXmlStreamForm = new jaxx.runtime.swing.Table());
        adminXmlStreamForm.setName("adminXmlStreamForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.services.dto.VradiXmlStreamDTO());
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCreateForms() {
        $objectMap.put("createForms", createForms = new javax.swing.JButton());
        createForms.setName("createForms");
        createForms.setText(_("vradi.adminXmlStream.createForms"));
        createForms.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createForms"));
    }

    protected void createCreateXmlStream() {
        $objectMap.put("createXmlStream", createXmlStream = new javax.swing.JButton());
        createXmlStream.setName("createXmlStream");
        createXmlStream.setText(_("vradi.adminXmlStream.createXmlStream"));
        createXmlStream.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createXmlStream"));
    }

    protected void createFieldsModel() {
        $objectMap.put("fieldsModel", fieldsModel = new com.jurismarches.vradi.ui.admin.content.XmlStreamFieldTableModel());
        fieldsModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__fieldsModel"));
    }

    protected void createFieldsTable() {
        $objectMap.put("fieldsTable", fieldsTable = new org.jdesktop.swingx.JXTable());
        fieldsTable.setName("fieldsTable");
        if (fieldsTable.getFont() != null) {
            fieldsTable.setFont(fieldsTable.getFont().deriveFont((float) 11));
        }
        fieldsTable.setRowSelectionAllowed(false);
    }

    protected void createFormTypeCombo() {
        $objectMap.put("formTypeCombo", formTypeCombo = new javax.swing.JComboBox());
        formTypeCombo.setName("formTypeCombo");
        formTypeCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__formTypeCombo"));
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        title.setName("title");
    }

    @Override
    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new jaxx.runtime.swing.Table());
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createValidateUrl() {
        $objectMap.put("validateUrl", validateUrl = new javax.swing.JButton());
        validateUrl.setName("validateUrl");
        validateUrl.setText(_("vradi.adminXmlStream.validateUrl"));
        validateUrl.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateUrl"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiXmlStreamDTO >(com.jurismarches.vradi.services.dto.VradiXmlStreamDTO.class, null));
    }

    protected void createXmlStreamName() {
        $objectMap.put("xmlStreamName", xmlStreamName = new javax.swing.JTextField());
        xmlStreamName.setName("xmlStreamName");
        xmlStreamName.setColumns(15);
        xmlStreamName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__xmlStreamName"));
    }

    protected void createXmlStreamPreview() {
        $objectMap.put("xmlStreamPreview", xmlStreamPreview = new javax.swing.JLabel());
        xmlStreamPreview.setName("xmlStreamPreview");
    }

    protected void createXmlStreamUrl() {
        $objectMap.put("xmlStreamUrl", xmlStreamUrl = new javax.swing.JTextField());
        xmlStreamUrl.setName("xmlStreamUrl");
        xmlStreamUrl.setColumns(15);
        xmlStreamUrl.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__xmlStreamUrl"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createXmlStream);
        $JPanel0.add(createForms);
        $JPanel0.add($JButton0);
        $JPanel0.add($HidorButton0);
        addChildrenToBody();
        addChildrenToAdminXmlStreamForm();
        // inline complete setup of $JPanel1
        $JPanel1.add($JLabel3, BorderLayout.NORTH);
        $JPanel1.add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fieldsTable);
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 17 property setters
        createXmlStream.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.add"));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.delete"));
        $HidorButton0.setHideTip(_("vradi.adminXmlStream.hideForm"));
        $HidorButton0.setShowTip(_("vradi.adminXmlStream.showForm"));
        $HidorButton0.setTarget(adminXmlStreamForm);
        $HidorButton0.setTargetVisible(true);
        adminXmlStreamForm.setMinimumSize(SwingUtil.newMinDimension());
        xmlStreamPreview.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.magnify"));
        formTypeCombo.setModel(new DefaultComboBoxModel());
        formTypeCombo.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        fieldsTable.setModel(fieldsModel);
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setFont(new Font("Serif", Font.BOLD, 26));
        title.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 8 data bindings
        $registerDefaultBindings();
        $objectMap.put("adminXmlStream", this);
        createBean();
        createFieldsModel();
        createValidator();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        createCreateXmlStream();
        createCreateForms();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminXmlStream.deleteXmlStream"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        $HidorButton0.setName("$HidorButton0");
        createAdminXmlStreamForm();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminXmlStream.name"));
        createXmlStreamName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminXmlStream.url"));
        createXmlStreamUrl();
        createXmlStreamPreview();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminXmlStream.formType"));
        createFormTypeCombo();
        createValidateUrl();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        $JLabel3.setName("$JLabel3");
        $JLabel3.setHorizontalAlignment(2);
        $JLabel3.setText(_("vradi.adminField.title"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createFieldsTable();
        createLastModified();
        // inline creation of adminXmlStream
        setName("adminXmlStream");
        ((javax.swing.JPanel) adminXmlStream.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADMIN_XML_STREAM_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("wikittyId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    setEnabled(bean.getWikittyId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("wikittyId", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TITLE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    title.setText(_(updateTitle(bean.getName())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_XML_STREAM_NAME_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(xmlStreamName, bean.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_XML_STREAM_URL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("url", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(xmlStreamUrl, bean.getUrl());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("url", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_XML_STREAM_PREVIEW_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("url", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    xmlStreamPreview.setToolTipText(_(getHandler().getFirstElementPreview(AdminXmlStreamUI.this, bean.getUrl())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("url", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FORM_TYPE_COMBO_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("formType", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    formTypeCombo.setSelectedItem(bean.getFormType());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("formType", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATE_URL_ENABLED, true ,"valide") {
        
            @Override
            public void processDataBinding() {
                validateUrl.setEnabled(isValide());
            }
        });
    }

}