package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.InfogeneImpl;
import com.jurismarches.vradi.models.FieldSelectModel;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.admin.content.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.swing.SwingValidatorMessageListRenderer;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminFormTypeUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<WikittyExtension> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected org.sharengo.wikitty.WikittyExtension bean;
    protected jaxx.runtime.swing.CardLayout2 cardLayout;
    protected javax.swing.JPanel cardPanel;
    protected jaxx.runtime.swing.VBox content;
    protected javax.swing.JButton create;
    protected javax.swing.JButton createForm;
    protected jaxx.runtime.swing.Table fieldListUI;
    protected jaxx.runtime.swing.HidorButton hidorInfogene;
    protected javax.swing.JPanel infogene;
    protected jaxx.runtime.swing.HBox lastModified;
    protected javax.swing.JLabel title;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminFormTypeUI $AdminContentUI0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    @Override
    public void openUI(NavigationTreeNode node) throws Exception {
        super.openUI(node);
        
        content.removeAll();
        infogene.removeAll();
        lastModified.removeAll();
        
        if (getBean() != null) {
            for (int i = 0 ; i < getBean().getFieldNames().size() ; i++){
                String fieldName = getBean().getFieldNames().get(i);
                FieldType fieldType = getBean().getFieldType(fieldName);
                String fieldDesc = VradiHelper.getFieldTypeDescription(fieldType);
                FieldSelectModel fieldSelectModel = new FieldSelectModel(fieldName, fieldDesc,
                        VradiHelper.getFieldTypeEnum(fieldType), i);
                create(fieldSelectModel);
            }
            String date = getBean().getTagValue(VradiHelper.TYPE_LAST_MODIFIED_DATE);
            String time = getBean().getTagValue(VradiHelper.TYPE_LAST_MODIFIED_TIME);
            String user = getBean().getTagValue(VradiHelper.TYPE_LAST_MODIFIED_BY);
    
            log.debug(date + " " + time + " " + user);
            if(date != null && time != null && user != null) {
                String labelText = String.format(_("vradi.entity.lastModified.strings"), date, time, user);
                lastModified.add(new JLabel(labelText));
            }
            fillInfogenePanel();
        }
        title.setText(_("vradi.adminForm.title", getStringValue(bean == null ? "" : bean.getName())));
        setModified(false);
    }
    
    @Override
    public void save(){
        java.util.List<FieldSelectModel> fields = new ArrayList<FieldSelectModel>();
        for(Component component : content.getComponents()) {
            fields.add(((FieldSelectUI)component).getBean());
        }
        getHandler().saveFormType(this, getHelper(), fields, getBean());
        setModified(false);
    }
    
    protected void create() {
        create(new FieldSelectModel(content.getComponentCount()));
    }
    
    protected void create(FieldSelectModel fieldSelectModel){
       FieldSelectUI result = new FieldSelectUI(this);
    
       result.updateBean(fieldSelectModel);
       result.addPropertyChangeListener(FieldSelectUI.PROPERTY_MODIFIED, new PropertyChangeListener() {
                public void propertyChange(PropertyChangeEvent evt) {
                    FieldSelectUI field = (FieldSelectUI) evt.getSource();
                    log.debug("field " + field + " modified value =  " + evt.getNewValue());
                    setModified(true);
                    if(evt.getNewValue() == null) {
    
                        if(field != null) {
                            field.setVisible(false);
                            content.remove(field);
                        }
                        if(field.getBean().isUpOrDown() != null) {
                            if(field.getBean().isUpOrDown() && field.getBean().getPosition() == 0) {
                                content.add(field, 0);
                            } else if(!field.getBean().isUpOrDown() && field.getBean().getPosition() == content.getComponentCount()) {
                                content.add(field);        
                            } else {
                                int fieldToMovePosition = field.getBean().isUpOrDown() ?
                                        field.getBean().getPosition() - 1 : field.getBean().getPosition();
                                int fieldToAddPosition = field.getBean().isUpOrDown() ?
                                        field.getBean().getPosition() - 1 : field.getBean().getPosition() + 1;
                                FieldSelectUI fieldToMove = (FieldSelectUI) content.getComponent(fieldToMovePosition);
                                log.debug(fieldToMove.getBean().getNameValue() + " : " + fieldToMove.getBean().getPosition());
    
                                content.add(field, fieldToAddPosition);
                                for(int i = 0 ; i < content.getComponentCount() ; i++) {
                                    FieldSelectUI fieldSelectUI = (FieldSelectUI) content.getComponent(i);
                                    fieldSelectUI.getBean().setPosition(i);
                                    log.debug(fieldSelectUI.getBean().getNameValue() + " : " + fieldSelectUI.getBean().getPosition());
                                }
                            }
                            field.getBean().setUpOrDown(null);
                            field.setVisible(true);
                        }
                        content.validate();
                    }
                }
        });
        result.setModified(false);
    
       content.add(result);
       validate();
    }
    
    private void fillInfogenePanel() {
        WikittyExtension extension = InfogeneImpl.extensionInfogene;
        java.util.List<String> fieldNames = extension.getFieldNames();
        for (int i = 0 ; i < fieldNames.size() ; i++) {
            String fieldName = fieldNames.get(i);
            FieldType fieldType = extension.getFieldType(fieldName);
            String fieldDesc = VradiHelper.getFieldTypeDescription(fieldType);
            
            FieldSelectModel fieldSelectModel = new FieldSelectModel(fieldName, fieldDesc,
                    FieldTypeEnum.valueOf(fieldType), i);
    
            FieldDisplayUI fieldDisplayUI = new FieldDisplayUI(this);
            fieldDisplayUI.updateBean(fieldSelectModel);
            
            infogene.add(fieldDisplayUI);
        }
    }
    
    private void onHidorInfogene() {
        if (hidorInfogene.isSelected()) {
            cardLayout.show(cardPanel, "infogene");
        } else {
            cardLayout.show(cardPanel, "content");
        }
    }
    
    @Override
    protected void updateBeanFromEntity(WikittyExtension bean) {
        setBean(bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminFormTypeUI() {
        super();
        $initialize();
    }

    public AdminFormTypeUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__create(java.awt.event.ActionEvent event) {
        create();
    }

    public void doActionPerformed__on__createForm(java.awt.event.ActionEvent event) {
        getHandler().createFormType(this, getHelper()); setModified(true);
    }

    public void doActionPerformed__on__hidorInfogene(java.awt.event.ActionEvent event) {
        onHidorInfogene();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public org.sharengo.wikitty.WikittyExtension getBean() {
        return bean;
    }

    public jaxx.runtime.swing.CardLayout2 getCardLayout() {
        return cardLayout;
    }

    public javax.swing.JPanel getCardPanel() {
        return cardPanel;
    }

    public jaxx.runtime.swing.VBox getContent() {
        return content;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JButton getCreateForm() {
        return createForm;
    }

    public jaxx.runtime.swing.Table getFieldListUI() {
        return fieldListUI;
    }

    public jaxx.runtime.swing.HidorButton getHidorInfogene() {
        return hidorInfogene;
    }

    public javax.swing.JPanel getInfogene() {
        return infogene;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(org.sharengo.wikitty.WikittyExtension newValue) {
        org.sharengo.wikitty.WikittyExtension oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(fieldListUI, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToCardPanel() {
        if (!allComponentsCreated) {
            return;
        }
        cardPanel.add(content, "content");
        cardPanel.add(infogene, "infogene");
    }

    protected void addChildrenToFieldListUI() {
        if (!allComponentsCreated) {
            return;
        }
        fieldListUI.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        toolbar.add(createForm, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCardLayout() {
        $objectMap.put("cardLayout", cardLayout = new jaxx.runtime.swing.CardLayout2());
    }

    protected void createCardPanel() {
        $objectMap.put("cardPanel", cardPanel = new javax.swing.JPanel());
        cardPanel.setName("cardPanel");
        cardPanel.setLayout(cardLayout);
    }

    protected void createContent() {
        $objectMap.put("content", content = new jaxx.runtime.swing.VBox());
        content.setName("content");
    }

    protected void createCreate() {
        $objectMap.put("create", create = new javax.swing.JButton());
        create.setName("create");
        create.setText(_("vradi.adminField.new"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createCreateForm() {
        $objectMap.put("createForm", createForm = new javax.swing.JButton());
        createForm.setName("createForm");
        createForm.setText(_("vradi.adminForm.createForm"));
        createForm.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createForm"));
    }

    protected void createFieldListUI() {
        $objectMap.put("fieldListUI", fieldListUI = new jaxx.runtime.swing.Table());
        fieldListUI.setName("fieldListUI");
    }

    protected void createHidorInfogene() {
        $objectMap.put("hidorInfogene", hidorInfogene = new jaxx.runtime.swing.HidorButton());
        hidorInfogene.setName("hidorInfogene");
        hidorInfogene.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__hidorInfogene"));
    }

    protected void createInfogene() {
        $objectMap.put("infogene", infogene = new javax.swing.JPanel());
        infogene.setName("infogene");
        infogene.setLayout(new GridLayout(0,1));
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        title.setName("title");
    }

    @Override
    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new jaxx.runtime.swing.Table());
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToToolbar();
        addChildrenToBody();
        addChildrenToFieldListUI();
        // inline complete setup of $JPanel0
        $JPanel0.add(create);
        $JPanel0.add(hidorInfogene);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(cardPanel);
        addChildrenToCardPanel();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        cardLayout.setUseOnlyVisibleComponentDimension(true);
        hidorInfogene.setHideTip(_("vradi.adminFormType.hideInfogene"));
        hidorInfogene.setShowTip(_("vradi.adminFormType.showInfogene"));
        hidorInfogene.setTarget(new jaxx.runtime.swing.Spacer());
        hidorInfogene.setTargetVisible(false);
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setFont(new Font("Serif", Font.BOLD, 26));
        title.setHorizontalTextPosition(JLabel.LEFT);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 1 data bindings
        $registerDefaultBindings();
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        createCardLayout();
        createTitle();
        createCreateForm();
        createFieldListUI();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminField.title"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        createCreate();
        createHidorInfogene();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createCardPanel();
        createContent();
        createInfogene();
        createLastModified();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((javax.swing.JPanel) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
    }

}