package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.admin.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreePath;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusPathChooserUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SAVED = "saved";
    public static final String PROPERTY_SELECTED = "selected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SELECT_ENABLED = "select.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.ThesaurusPathChooserUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton cancel;
    protected java.lang.Boolean saved;
    protected javax.swing.JButton select;
    protected java.lang.Boolean selected;
    protected javax.swing.JTree thesaurus;
    protected ThesaurusPathChooserUI thesaurusPathChooserUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected ThesaurusTreeHelper helper;
    
    
    public  ThesaurusPathChooserUI(jaxx.runtime.JAXXContext parentContext, ThesaurusTreeHelper helper) {
        jaxx.runtime.SwingUtil.initContext(this, parentContext);
        this.helper = helper;
        setContextValue(helper);
    $initialize();
    }
    
    public void setHelper(ThesaurusTreeHelper helper){
        this.helper = helper;
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected ThesaurusTreeHelper getHelper() {
        return helper;
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
                JTree tree = (JTree) mouseEvent.getSource();
                TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
                // Clear if no selection
                if (path == null){
                    tree.clearSelection();
                    getHelper().setSelectedNode(ThesaurusPathChooserUI.this, null);
                    setSelected(false);
                } else {
                    setSelected(true);
                }
            }
        });
    
        SwingUtil.addExpandOnClickListener(thesaurus);
    }
        
    protected void close(){
        setVisible(false);
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusPathChooserUI() {
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__select(java.awt.event.ActionEvent event) {
        setSaved(true);close();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public java.lang.Boolean getSaved() {
        return saved;
    }

    public javax.swing.JButton getSelect() {
        return select;
    }

    public java.lang.Boolean getSelected() {
        return selected;
    }

    public javax.swing.JTree getThesaurus() {
        return thesaurus;
    }

    public java.lang.Boolean isSaved() {
        return saved !=null && saved;
    }

    public java.lang.Boolean isSelected() {
        return selected !=null && selected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setSaved(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.saved;
        this.saved = newValue;
        firePropertyChange(PROPERTY_SAVED, oldValue, newValue);
    }

    public void setSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selected;
        this.selected = newValue;
        firePropertyChange(PROPERTY_SELECTED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusPathChooserUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createSaved() {
        $objectMap.put("saved", saved = false);
    }

    protected void createSelect() {
        $objectMap.put("select", select = new javax.swing.JButton());
        select.setName("select");
        select.setText(_("vradi.common.select"));
        select.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__select"));
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = false);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new javax.swing.JTree());
        thesaurus.setName("thesaurus");
        thesaurus.setExpandsSelectedPaths(true);
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusPathChooserUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(select, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurus);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        thesaurus.setModel(helper.createTreeModel(this));
        thesaurus.setSelectionModel(helper.createTreeHandler(this));
        cancel.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        select.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("select"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 1 data bindings
        $registerDefaultBindings();
        $objectMap.put("thesaurusPathChooserUI", this);
        createSelected();
        createSaved();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminThesaurus.selectAsk"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurus();
        createCancel();
        createSelect();
        // inline creation of thesaurusPathChooserUI
        setName("thesaurusPathChooserUI");
        SwingUtil.setComponentHeight(thesaurusPathChooserUI,600);
        thesaurusPathChooserUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.adminThesaurus.select"));
        SwingUtil.setComponentWidth(thesaurusPathChooserUI,800);
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECT_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                select.setEnabled(isSelected());
            }
        });
    }

}