package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.admin.*;
import com.jurismarches.vradi.ui.admin.content.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreePath;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminPopupUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADMIN_TABS_MODEL = "adminTabs.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.AdminPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminPopupUI adminPopupUI = this;
    protected com.jurismarches.vradi.ui.admin.content.AdminStatusUI adminStatus;
    protected javax.swing.JTabbedPane adminTabs;
    protected com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI adminThesaurus;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private com.jurismarches.vradi.ui.admin.AdminNavUI $AdminNavUI0;
    private com.jurismarches.vradi.ui.admin.AdminNavUI $AdminNavUI1;
    private com.jurismarches.vradi.ui.admin.AdminNavUI $AdminNavUI2;
    private com.jurismarches.vradi.ui.admin.AdminNavUI $AdminNavUI3;
    private javax.swing.JButton $JButton0;
    private jaxx.runtime.swing.TabInfo $TabInfo0;
    private jaxx.runtime.swing.TabInfo $TabInfo1;
    private jaxx.runtime.swing.TabInfo $TabInfo2;
    private jaxx.runtime.swing.TabInfo $TabInfo3;
    private jaxx.runtime.swing.TabInfo $TabInfo4;
    private jaxx.runtime.swing.TabInfo $TabInfo5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean contextInitialized;
    private SingleSelectionModel selectionModel;
    
    
    public  AdminPopupUI(JAXXContext parentContext, Window parent) {
        super(parent);$initialize();
    
        SwingUtil.initContext(this, parentContext);
        getHandler().createModel(this);
        jaxx.runtime.JAXXUtil.assignment(selectionModel = new DefaultSingleSelectionModel() {
            private static final long serialVersionUID = 1L;
    
            @Override
            public void setSelectedIndex(int index) {
                int oldIndex = getSelectedIndex();
                if (oldIndex != -1) {
                    // on verifie que l'onglet en cours n'est pas modifie
                    AdminNavUI tab = getCurrentTab();
    
                    // null if is thesaurus selected
                    if (tab == null){
                        boolean canContinue = getThesaurusHandler().answerToSaveBeforeQuit(getTesaurusTab());
                        if (!canContinue) {
                            // l'utilisateur ne veut pas partir au final
                            return;
                        }
                    } else {
                        log.debug("current tab to close " + tab.getName());
                        AdminContentUI<?> content = tab.getCurrentContent();
                        boolean canContinue = getHandler().answerToSave(content);
                        if (!canContinue) {
                            // l'utilisateur ne veut pas partir au final
                            return;
                        }
                    }
                }
                super.setSelectedIndex(index);
            }
        }, "selectionModel", com.jurismarches.vradi.ui.admin.AdminPopupUI.this);
        jaxx.runtime.JAXXUtil.assignment(contextInitialized = true, "contextInitialized", com.jurismarches.vradi.ui.admin.AdminPopupUI.this);
    $initialize();
    }
    
    protected ThesaurusHandler getThesaurusHandler() {
        return UIHelper.getHandler(this, ThesaurusHandler.class);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    public void close(){
        AdminNavUI navSelected = getCurrentTab();
        AdminHandler handler = getHandler();
        // if is thesaurus selected
        if (navSelected == null){
            boolean canContinue = getThesaurusHandler().answerToSaveBeforeQuit(getTesaurusTab());
            if (canContinue) {
                handler.close(this);
            }
            return;
        }
        AdminContentUI currentContent = navSelected.getCurrentContent();
        boolean canContinue = handler.answerToSave(currentContent);
        if (canContinue) {
            handler.close(this);
        }
    }
    
    public void showTab(int i){
        adminTabs.setSelectedIndex(i);
    }
    
    public AdminNavUI getCurrentTab() {
        Component selected = adminTabs.getSelectedComponent();
        if (selected instanceof AdminThesaurusUI ||
            selected instanceof AdminStatusUI) {
            return null;
        }
        return (AdminNavUI) selected;
    }
    
    public AdminStatusUI getStatusTab(){
        return (AdminStatusUI)adminTabs.getComponentAt(4);
    }
    
    public AdminThesaurusUI getTesaurusTab(){
        return (AdminThesaurusUI)adminTabs.getComponentAt(5);
    }
    
    public void updateTab(AdminNavUI ui) {
        // If id AdminThesaurus selected
        if (ui != null){
            TreePath path = ui.getNav().getSelectionPath();
            Object old = path == null ? null : path.getLastPathComponent();
    
            getHandler().createModel(this);
            ui.getHelper().createTreeModel();
    
            //NavigationTreeModel treeModel = ui.getHelper().createTreeModel(ui);
            //ui.getNav().setModel(treeModel);
    
            if (old != null && old instanceof NavigationTreeNode) {
                // reselect node (if found)
                NavigationTreeNode node = (NavigationTreeNode) old;
                ui.getHelper().reSelectNode(ui, node.getFullPath());
            }
            ui.open();
        }
    }
    
    void $afterCompleteSetup() {
        SwingUtil.center(getOwner(), this);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminPopupUI() {
        $initialize();
    }

    public AdminPopupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doStateChanged__on__adminTabs(javax.swing.event.ChangeEvent event) {
        updateTab(getCurrentTab());
    }

    public void doWindowClosing__on__adminPopupUI(java.awt.event.WindowEvent event) {
        close();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.ui.admin.content.AdminStatusUI getAdminStatus() {
        return adminStatus;
    }

    public javax.swing.JTabbedPane getAdminTabs() {
        return adminTabs;
    }

    public com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI getAdminThesaurus() {
        return adminThesaurus;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.ui.admin.AdminNavUI get$AdminNavUI0() {
        return $AdminNavUI0;
    }

    protected com.jurismarches.vradi.ui.admin.AdminNavUI get$AdminNavUI1() {
        return $AdminNavUI1;
    }

    protected com.jurismarches.vradi.ui.admin.AdminNavUI get$AdminNavUI2() {
        return $AdminNavUI2;
    }

    protected com.jurismarches.vradi.ui.admin.AdminNavUI get$AdminNavUI3() {
        return $AdminNavUI3;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminPopupUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(adminTabs, BorderLayout.CENTER);
        add($JButton0, BorderLayout.SOUTH);
    }

    protected void addChildrenToAdminTabs() {
        if (!allComponentsCreated) {
            return;
        }
        adminTabs.add($AdminNavUI0);
        adminTabs.add($AdminNavUI1);
        adminTabs.add($AdminNavUI2);
        adminTabs.add($AdminNavUI3);
        adminTabs.add(adminStatus);
        adminTabs.add(adminThesaurus);
        $TabInfo0.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 0));
        adminTabs.setTitleAt(0, _("vradi.admin.client"));
        $TabInfo1.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 1));
        adminTabs.setTitleAt(1, _("vradi.admin.group"));
        $TabInfo2.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 2));
        adminTabs.setTitleAt(2, _("vradi.admin.form"));
        $TabInfo3.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 3));
        adminTabs.setTitleAt(3, _("vradi.admin.xmlStream"));
        $TabInfo4.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 4));
        adminTabs.setTitleAt(4, _("vradi.admin.status"));
        $TabInfo5.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 5));
        adminTabs.setTitleAt(5, _("vradi.admin.thesaurus"));
    }

    protected void createAdminStatus() {
        $objectMap.put("adminStatus", adminStatus = new com.jurismarches.vradi.ui.admin.content.AdminStatusUI(this));
        adminStatus.setName("adminStatus");
    }

    protected void createAdminTabs() {
        $objectMap.put("adminTabs", adminTabs = new javax.swing.JTabbedPane());
        adminTabs.setName("adminTabs");
        adminTabs.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__adminTabs"));
    }

    protected void createAdminThesaurus() {
        $objectMap.put("adminThesaurus", adminThesaurus = new com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI(this, new ThesaurusTreeHelper(AdminPopupUI.this, "edit")));
        adminThesaurus.setName("adminThesaurus");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminPopupUI();
        addChildrenToAdminTabs();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("close"));
        ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setFont(new Font("Serif", Font.BOLD, 26));
        ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setHorizontalTextPosition(JLabel.LEFT);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 1 data bindings
        $registerDefaultBindings();
        $objectMap.put("adminPopupUI", this);
        createAdminTabs();
        // inline creation of $AdminNavUI0
        $objectMap.put("$AdminNavUI0", $AdminNavUI0 = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new ClientNavigationTreeHelper(this)));
        $AdminNavUI0.setName("$AdminNavUI0");
        // inline creation of $AdminNavUI1
        $objectMap.put("$AdminNavUI1", $AdminNavUI1 = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new GroupNavigationTreeHelper(this)));
        $AdminNavUI1.setName("$AdminNavUI1");
        // inline creation of $AdminNavUI2
        $objectMap.put("$AdminNavUI2", $AdminNavUI2 = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new FormNavigationTreeHelper(this)));
        $AdminNavUI2.setName("$AdminNavUI2");
        // inline creation of $AdminNavUI3
        $objectMap.put("$AdminNavUI3", $AdminNavUI3 = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new XmlStreamNavigationTreeHelper(this)));
        $AdminNavUI3.setName("$AdminNavUI3");
        createAdminStatus();
        createAdminThesaurus();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.action.close"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new jaxx.runtime.swing.TabInfo());
        $TabInfo0.setTitle(_("vradi.admin.client"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new jaxx.runtime.swing.TabInfo());
        $TabInfo1.setTitle(_("vradi.admin.group"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new jaxx.runtime.swing.TabInfo());
        $TabInfo2.setTitle(_("vradi.admin.form"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new jaxx.runtime.swing.TabInfo());
        $TabInfo3.setTitle(_("vradi.admin.xmlStream"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new jaxx.runtime.swing.TabInfo());
        $TabInfo4.setTitle(_("vradi.admin.status"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new jaxx.runtime.swing.TabInfo());
        $TabInfo5.setTitle(_("vradi.admin.thesaurus"));
        // inline creation of adminPopupUI
        setName("adminPopupUI");
        SwingUtil.setComponentHeight(adminPopupUI,600);
        adminPopupUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.admin.title"));
        SwingUtil.setComponentWidth(adminPopupUI,1024);
        adminPopupUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__adminPopupUI"));
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADMIN_TABS_MODEL, true ,"selectionModel") {
        
            @Override
            public void processDataBinding() {
                adminTabs.setModel(selectionModel);
            }
        });
    }

}