/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.table.TableColumnExt;
import org.sharengo.exceptions.TechnicalException;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;

/**
 * @author letellier
 */
public class OfferListHandler {

    static private final Log log = LogFactory.getLog(OfferListHandler.class);

    static final public int TABPANEL_LABEL_MAX_CHAR_NB = 30;

    /**
     * Methode pour initialiser l'ui principale sans l'afficher.
     *
     * @param rootContext le context applicatif
     * @param rootHandler
     * @return l'ui instancie et initialisee mais non visible encore
     */
    public OfferListUI initUI(JAXXContext rootContext, VradiMainUIHandler rootHandler) {

        final JAXXInitialContext context = new JAXXInitialContext().add(rootContext).add(this);

        final SearchHandler searchHandler = UIHelper.getHandler(context, SearchHandler.class);

        // show main ui
        final OfferListTableModel offerListTableModel = new OfferListTableModel();
        final OfferListColumnFactory offerListColumnFactory = new OfferListColumnFactory();
        
        context.add(offerListTableModel);
        context.add(offerListColumnFactory);

        final OfferListUI ui = new OfferListUI(context);
        
        // add listeners
        final JXTable listTable = ui.getListTable();
        listTable.getColumnModel().addColumnModelListener(
                getOfferListTableColumnModelListener());
        
        final MouseListener offerListTableMouseListener = getOfferListTableMouseListener(ui);
        listTable.addMouseListener(offerListTableMouseListener);
        
        final TableModelListener offerListTableModelListener = getOfferListTableModelListener(listTable);
        offerListTableModel.addTableModelListener(offerListTableModelListener);
        
        // listTable cellRenderer
        final OfferListTableModel.OfferListTableCellRenderer renderer =
                new OfferListTableModel.OfferListTableCellRenderer();
        listTable.setDefaultRenderer(Boolean.class, renderer);
        listTable.setDefaultRenderer(Date.class, renderer);
        listTable.setDefaultRenderer(Double.class, renderer);
        listTable.setDefaultRenderer(String.class, renderer);
        
        // listTable highlighter
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
                HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        listTable.addHighlighter(highlighter);
    
        // Show search ui
        final SearchUI searchUI = searchHandler.initUI(rootContext, offerListTableModel);
        searchUI.setOfferListUI(true);

        ui.getSearchPanel().add(searchUI, BorderLayout.CENTER);

        // Saved in context
        VradiContext.OFFERT_LIST_UI_ENTRY_DEF.setContextValue(rootContext, ui);

        return ui;
    }

    private TableModelListener getOfferListTableModelListener(final JXTable listTable) {
        return new TableModelListener() {
            @Override
            public void tableChanged(TableModelEvent e) {
                listTable.packAll();
            }
        };
    }

    private TableColumnModelExtListener getOfferListTableColumnModelListener() {
        return new TableColumnModelExtListener() {
            @Override
            public void columnPropertyChange(
                    PropertyChangeEvent paramPropertyChangeEvent) {
                String propertyName = paramPropertyChangeEvent.getPropertyName();
                
                if ("visible".equals(propertyName)) {
                    TableColumnExt column = (TableColumnExt) paramPropertyChangeEvent.getSource();
					String fqFieldName = (String) column.getClientProperty("fqFieldName");

                    if (log.isTraceEnabled()) {
                        log.trace("clientprop: " + fqFieldName);
                        log.trace("identifier: " + column.getIdentifier());
                    }
                    
                    Boolean visible = (Boolean) paramPropertyChangeEvent.getNewValue();
                    if (visible) {
                        VradiHelper.addVradiListColumns(fqFieldName);
                    } else {
                        VradiHelper.removeVradiListColumns(fqFieldName);
                    }
                }
            }
            
            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }
            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }
            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }
            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }
            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        };
    }

    private MouseListener getOfferListTableMouseListener(final OfferListUI offerListUI) {
        // double click on listTable shows selected offer
        return new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        offerListUI.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
                        selectOffer(offerListUI);
                        
                    } catch (Exception ee) {
                        log.error(ee.getMessage(), ee);
                        ErrorDialogUI.showError(ee);
                        
                    } finally {
                        offerListUI.setCursor(null);
                    }
                }
            }
        };
    }
    
    public void addEditPane(JAXXContext context, final Form data) {
        final OfferListUI ui = getUI(context);
        
        // Fill free space
        ui.setDividerLocation(0);
        ui.setResizeWeight(0);
		ui.setDividerSize(12);
		
        // Get tab
        JTabbedPane contentTabbedPane = ui.getEditTabs();

        // Tab id
        String id = data.getWikittyId();

        // Exist ?
        if (contentTabbedPane.indexOfTab(id) < 0) {

            // Open new
            final OfferEditHandler handler = UIHelper.getHandler(context, OfferEditHandler.class);
            final OfferEditUI editUi = handler.initUI(context, data);
            contentTabbedPane.add(id, editUi);

            final VradiTabHeader panel = new VradiTabHeader();
            if (data.getObjet() != null) {
                String panelLabel = data.getObjet().length() < TABPANEL_LABEL_MAX_CHAR_NB ?
                        data.getObjet() : data.getObjet().substring(0, TABPANEL_LABEL_MAX_CHAR_NB) + "...";
                panel.getLabel().setText(panelLabel);
            }
            panel.setId(id);

            // Table closeable
            contentTabbedPane.setTabComponentAt(contentTabbedPane.indexOfTab(id), panel);
            panel.getCloseTab().addMouseListener(new javax.swing.event.MouseInputAdapter() {

                @Override
                public void mouseClicked(MouseEvent e) {
                    closePane(editUi, panel.getId());
                }
            });

            // Detachable
            panel.getDetachTab().addMouseListener(new javax.swing.event.MouseInputAdapter() {

                @Override
                public void mouseClicked(MouseEvent e) {
                    detachPane(e);
                }
            });


            List<Status> statuses = getAllStatuses();
            JPanel buttonPanel = editUi.getStatusButtonPanel();

            for (final Status status : statuses) {
                JButton statusButton = new JButton(status.getName());
                statusButton.setToolTipText(status.getDescription());
                if(status.getWikittyId().equals(data.getStatus())) {
                    Color newColor = new Color(110,150,200,
                            statusButton.getBackground().getAlpha());
                    statusButton.setBackground(newColor);
                }
                statusButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        handler.changeStatusAndSave(editUi, data, status);
                        closePane(editUi, panel.getId());

                        SearchHandler handler = UIHelper.getHandler(editUi, SearchHandler.class);
                        handler.executeQuery(ui);
                    }
                });
                buttonPanel.add(statusButton);
            }
            // Cancel
            editUi.getAnnuler().addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent e) {
                    closePane(editUi, panel.getId());
                }
            });

            // Update
            /*editUi.getValidate().addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    handler.save(editUi, data);
                    closePane(editUi, panel.getId());

                    SearchHandler handler = UIHelper.getHandler(editUi, SearchHandler.class);
                    handler.executeQuery(ui);
                }
            });*/
        }
        
        // Select
        contentTabbedPane.setSelectedIndex(contentTabbedPane.indexOfTab(id));
    }

    public List<Status> getAllStatuses() {
        List<Status> statuses = new ArrayList<Status>();
        try {
            statuses = ServiceHelper.getVradiStorageService().getAllStatuses();
        } catch (TechnicalException eee) {
            log.error(eee);
            ErrorDialogUI.showError(eee);
        }
        return statuses;
    }

    protected VradiTabHeader getTabHeader(MouseEvent e) {
        JButton button = (JButton) e.getSource();
        return (VradiTabHeader) button.getParent();
    }

    protected void closePane(JAXXContext context, String id) {
        OfferListUI ui = VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        JTabbedPane contentTabbedPane = getContentPane(ui);
        int index = contentTabbedPane.indexOfTab(id);
        if (index > -1) {
            contentTabbedPane.remove(index);
        }
        allEditPanelRemoved(contentTabbedPane, ui);
    }

    private void removeEditPaneFromRef(OfferEditUI ui) {
        VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(VradiContext.get()).remove(ui);
    }

    // Detach editUI
    protected void detachPane(MouseEvent e) {
        // Get panel
        VradiTabHeader mytab = getTabHeader(e);
        String id = mytab.getId();
        String name = mytab.getLabel().getText();

        OfferListUI ui = mytab.getParentContainer(OfferListUI.class);
        JTabbedPane contentTabbedPane = getContentPane(ui);
        final OfferEditUI content = getOfferEdit(contentTabbedPane, id);

        // Create popup
        final JFrame frame = new JFrame(name);

        // Close
        /*content.getValidate().addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                closeDetachedPane(frame, content);
            }
        });*/

        // Cancel
        content.getAnnuler().addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                closeDetachedPane(frame, content);
            }
        });

        // Remove default listener
        frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);

        // Add listener
        frame.addWindowListener(new WindowAdapter() {

            @Override
            public void windowClosed(WindowEvent e) {
                closeDetachedPane(frame, content);
            }
        });

        frame.setLayout(new BorderLayout());
        frame.add(content, BorderLayout.CENTER);
        frame.setVisible(true);
        frame.setSize(new Dimension(800, 800));

        // Remove
        allEditPanelRemoved(contentTabbedPane, ui);
    }

    protected OfferEditUI getOfferEdit(JTabbedPane contentTabbedPane, String id) {
        return (OfferEditUI) contentTabbedPane.getComponentAt(contentTabbedPane.indexOfTab(id));
    }

    protected void closeDetachedPane(JFrame f, OfferEditUI ui) {
        f.dispose();
        removeEditPaneFromRef(ui);
    }

    public void addEditPane(JAXXContext context, List<Form> datas) {
        for (Form data : datas) {
            addEditPane(context, data);
        }
    }

    protected void allEditPanelRemoved(JTabbedPane contentTabbedPane, OfferListUI ui) {
        if (contentTabbedPane.getTabCount() == 0) {
            ui.setDividerLocation(Integer.MAX_VALUE);
            ui.setResizeWeight(1);
            ui.setDividerSize(0);
        }
    }

    OfferListUI getUI(JAXXContext context) {
        if (context instanceof OfferListUI) {
            return (OfferListUI) context;
        }
        OfferListUI ui = VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    JTabbedPane getContentPane(JAXXContext context) {
        OfferListUI ui = getUI(context);
        return ui.getEditTabs();
    }

    JTabbedPane getContentPane(OfferListUI ui) {
        return ui.getEditTabs();
    }

    protected void selectOffer(JAXXContext context) {
        JTable listTable = getUI(context).listTable;
        OfferListTableModel tableModel = getUI(context).getOfferListTableModel();
        int selectedRow = listTable.getSelectedRow();
        
        if (selectedRow >= 0 && selectedRow < tableModel.getRowCount()) {
            selectedRow = listTable.convertRowIndexToModel(selectedRow);
         
            VradiFormPageDTO formPageDTO = tableModel.getFormPageDTO();
            List<Form> formsToShow = formPageDTO.getFormsToShow();
            
            Form data = formsToShow.get(selectedRow);
            if (data != null) {
                log.info("Show Form: " + data.getObjet());
                addEditPane(context, data);
            }
        }
    }

}
