/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package com.jurismarches.vradi.models;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author letellier
 */

public abstract class ModifModel<E extends ModifModel.Modif> extends AbstractListModel {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(ModifThesaurusModel.class);

    public interface Modif{

        public String getMsg();

        public boolean revert();

    }
    
    protected List<E> values = new ArrayList<E>();

    protected void fireAdd(){
        int index = values.size();
	    fireIntervalAdded(this, index, index);
    }

    protected void fireRemove(){
        int index = values.size();
	    fireIntervalRemoved(this, index, index);
    }

    protected boolean revert(int index){
        Modif value = values.get(index);
        boolean result = value.revert();
        if (result){
            values.remove(value);
	        fireIntervalRemoved(this, index, index);
        }
        return result;
    }

    public boolean revert(int[] index){
        boolean result = true;
        for (int i : index){
            result = result && revert(i);
        }
        return result;
    }

    public void clear(){
        this.values.clear();
        fireRemove();
    }

    public boolean remove(E value){
        boolean result = this.values.remove(value);              
        fireRemove();
        return result;
    }

    public boolean removeAll(Collection<? extends E> value){
        boolean result = this.values.removeAll(value);
        fireRemove();
        return result;
    }

    public boolean add(E value){
        boolean result = this.values.add(value);
        fireAdd();
        return result;
    }

    public boolean addAll(Collection<? extends E> value){
        boolean result = this.values.addAll(value);
        fireAdd();
        return result;
    }

    public E get(int index){
        return values.get(index);
    }

    public List<E> getValues(){
        return values;
    }

    public void setValues(List<E> values){
        this.values = values;
        fireAdd();
    }

    @Override
    public int getSize() {
        return values.size();
    }

    @Override
    public Object getElementAt(int index) {
        return values.get(index);
    }
}
