/*
 * *##% 
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.models;

import org.sharengo.wikitty.WikittyExtension;

import javax.swing.*;
import java.util.List;

/**
 * @author letellier
 */
public class FormTypeModel extends DefaultComboBoxModel {

    private static final long serialVersionUID = 1L;

    protected WikittyExtension selected = null;
    protected WikittyExtension[] values;

    public FormTypeModel(List<WikittyExtension> formTypes) {
        super();
        values = formTypes.toArray(new WikittyExtension[formTypes.size()]);

    }

    @Override
    public int getSize() {
        return values.length;
    }

    @Override
    public Object getElementAt(int index) {
        return values[index].getName();
    }

    @Override
    public void setSelectedItem(Object anItem) {
        for (WikittyExtension ext : values) {
            if (ext.getName().equals(anItem)) {
                selected = ext;
                break;
            }
        }
    }

    @Override
    public Object getSelectedItem() {
        return selected;
    }
}
