package com.jurismarches.vradi.ui.search;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.OfferListTableModel;
import com.jurismarches.vradi.ui.search.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.AbstractTableModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class SearchUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_OFFER_LIST_UI = "offerListUI";
    public static final String PROPERTY_REQUEST = "request";
    public static final String PROPERTY_REQUEST_MODEL = "requestModel";
    public static final String PROPERTY_RESULT_TABLE_MODEL = "resultTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_REQUESTS_VISIBLE = "requests.visible";
    public static final String BINDING_REQUEST_AREA_TEXT = "requestArea.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_VISIBLE = "$JLabel0.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVtpSfghCQIhIqtYYJWzVmwHlRw1SUsRYMMRenHYHOmS7s8zM0vVi/BP8E/TuxcSbJ+PBswcvxn/BGA9ejW92t91uXaCmPex2533ve9978957+wMlBEeXDrDjaNw2Ja0TbWNld3erckCq8j4RVU4tyTjyfrE4ipfRoN46FxJdKReVe853z+VZ3WImMdu8F4poQMjnBhE1QqREF8MeVSFypZZ5wbFs3mRtiYpiff3rZ/yV/vJNHCHHAnUjkErmNK8gk74iilNdojGIdIRzBjb3QQan5j7oHVZneQML8RDXySF6gVJFlLQwBzKJLnefssvh+juWRKnsNq4Y5KZE16usrh3YnIo65tUaEdoRxzrVbKoJok60kvvaKViW658Eb04ObSJAwKiSpynJmic5AA2yvT3Ci1TInYJE5wLgKmMGwWaAHOVE2IZ0FW0ynRgSzR+vaqtJG+ADqiFfmU8zraI6mmiAMnUJFbbKnA6X/uxGEVeIAbUYa4d7pwqUDrA+PbTbRAjb5A7D/Srfkmgq1A6ek2sLOwxnN0pVzgzjETbV5ZwPBQlMCj4bVNpXtcIJ7hS2TRz3XEEvdQq7rT4zYbKkd+sSjYd4Vm0pmakw11rQRBXukauPubBhOLtOdcY9H0hjNiL7NkTYOQ2dKwmnGIo8d2pz5n3wTsGvJEcXQtFgqLVgqIOpi5VRgttwDJdT/ncPPAaTtwGmOjaAInStfybHv374/n6tOfZDEHsiEtq2tWAcLc4swiVVoUe8mbclNXKb2Fooo7QgBqw8d6XNRAgr+WYQB/G8sVLu2joWNaBIpL59/DT57MsZFF9DAwbD+hpW+AJKyxoMWo0ZumMtLbuKhhr98BxV2iTqk9ArMASL1DSoSTJYwkRXbEnuOVCGmYgytLRU0p9/j5feLTdLEQNp08fCg3IknqKkF83dgf56i9x5g5Ygts6CNRa12GLqPW35w33Hfd6NyjV1RAWFCZDo7KKOJc5UqKlDW0KqymfFzUH9y3dNmairvaLM69EkM6eSqOMHPTHALXLWcK3L0RxXu1KxdIKK/2A4RsONnhnmu7njGtXJNrVOSCXXDQ2MTKN3mqTEfJ/IHlmGPZYnXveeQvYX3N2GL1YJAAA=";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.search.SearchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton clear;
    protected com.jurismarches.vradi.ui.search.CriteriaUI criterias;
    protected java.lang.Boolean offerListUI;
    protected java.lang.String request;
    protected javax.swing.JTextArea requestArea;
    protected javax.swing.ComboBoxModel requestModel;
    protected javax.swing.JComboBox requests;
    protected com.jurismarches.vradi.ui.OfferListTableModel resultTableModel;
    protected javax.swing.JButton search;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SearchUI $Table0 = this;
    private javax.swing.JLabel $JLabel0;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JScrollPane $JScrollPane0;
    private jaxx.runtime.swing.Table $Table2;
    private jaxx.runtime.swing.HidorButton $HidorButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public SearchHandler getHandler() {
        return getContextValue(SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        java.util.List<String> queries = getHandler().loadRequests();
        requests.removeAllItems();
        for(String query : queries) {
            requests.addItem(query);
        }
    
        getHandler().executeQuery(this);
    }
    
    protected void keyReleased(KeyEvent keyEvent){
        if(keyEvent.getKeyCode() == KeyEvent.VK_ENTER) {
            executeQuery();
        }
        setRequest(requestArea.getText());
    }
    
    protected void executeQuery(){
        resultTableModel.setPageToShow(1);
        getHandler().executeQuery(this);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SearchUI() {
        $initialize();
    }

    public SearchUI(JAXXContext parentContext) {
        Util.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__clear(java.awt.event.ActionEvent event) {
        setRequest("");
    }

    public void doActionPerformed__on__requests(java.awt.event.ActionEvent event) {
        setRequest(getStringValue(requests.getSelectedItem()));
    }

    public void doActionPerformed__on__search(java.awt.event.ActionEvent event) {
        executeQuery();
    }

    public void doKeyReleased__on__requestArea(java.awt.event.KeyEvent event) {
        keyReleased(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getClear() {
        return clear;
    }

    public com.jurismarches.vradi.ui.search.CriteriaUI getCriterias() {
        return criterias;
    }

    public java.lang.Boolean getOfferListUI() {
        return offerListUI;
    }

    public java.lang.String getRequest() {
        return request;
    }

    public javax.swing.JTextArea getRequestArea() {
        return requestArea;
    }

    public javax.swing.ComboBoxModel getRequestModel() {
        return requestModel;
    }

    public javax.swing.JComboBox getRequests() {
        return requests;
    }

    public com.jurismarches.vradi.ui.OfferListTableModel getResultTableModel() {
        return resultTableModel;
    }

    public javax.swing.JButton getSearch() {
        return search;
    }

    public java.lang.Boolean isOfferListUI() {
        return offerListUI !=null && offerListUI;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setOfferListUI(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.offerListUI;
        this.offerListUI = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_UI, oldValue, newValue);
    }

    public void setRequest(java.lang.String newValue) {
        java.lang.String oldValue = this.request;
        this.request = newValue;
        firePropertyChange(PROPERTY_REQUEST, oldValue, newValue);
    }

    public void setRequestModel(javax.swing.ComboBoxModel newValue) {
        javax.swing.ComboBoxModel oldValue = this.requestModel;
        this.requestModel = newValue;
        firePropertyChange(PROPERTY_REQUEST_MODEL, oldValue, newValue);
    }

    public void setResultTableModel(com.jurismarches.vradi.ui.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.OfferListTableModel oldValue = this.resultTableModel;
        this.resultTableModel = newValue;
        firePropertyChange(PROPERTY_RESULT_TABLE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createClear() {
        $objectMap.put("clear", clear = new javax.swing.JButton());
        clear.setName("clear");
        clear.setText(_("vradi.criteria.clear"));
        clear.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clear"));
    }

    protected void createCriterias() {
        $objectMap.put("criterias", criterias = new com.jurismarches.vradi.ui.search.CriteriaUI(this));
        criterias.setName("criterias");
    }

    protected void createOfferListUI() {
        $objectMap.put("offerListUI", offerListUI = false);
    }

    protected void createRequest() {
        $objectMap.put("request", request = "");
    }

    protected void createRequestArea() {
        $objectMap.put("requestArea", requestArea = new javax.swing.JTextArea());
        requestArea.setName("requestArea");
        requestArea.setColumns(15);
        requestArea.setLineWrap(true);
        requestArea.setWrapStyleWord(true);
        requestArea.setRows(3);
        requestArea.addKeyListener(Util.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__requestArea"));
    }

    protected void createRequestModel() {
        $objectMap.put("requestModel", requestModel = getHandler().getRequestModel());
    }

    protected void createRequests() {
        $objectMap.put("requests", requests = new javax.swing.JComboBox());
        requests.setName("requests");
        requests.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__requests"));
    }

    protected void createResultTableModel() {
        $objectMap.put("resultTableModel", resultTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createSearch() {
        $objectMap.put("search", search = new javax.swing.JButton());
        search.setName("search");
        search.setText(_("vradi.criteria.search"));
        search.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__search"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        add(requests, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($Table1, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(criterias, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JScrollPane0, new GridBagConstraints(0, 0, 1, 1, 0.9, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($Table2, new GridBagConstraints(1, 0, 1, 1, 0.1, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(requestArea);
        // inline complete setup of $Table2
        $Table2.add(search, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add(clear, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add($HidorButton0, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 3 data bindings
        Util.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        requests.setModel(requestModel);
        $HidorButton0.setHideTip(_("vradi.criteria.collapse"));
        $HidorButton0.setShowTip(_("vradi.criteria.notCollapse"));
        $HidorButton0.setTarget(criterias);
        $HidorButton0.setTargetVisible(true);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 3 data bindings
        $registerDefaultBindings();
        $objectMap.put("$Table0", this);
        createRequest();
        createOfferListUI();
        createResultTableModel();
        createRequestModel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.list.requests"));
        createRequests();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        $Table1.setName("$Table1");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createRequestArea();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new jaxx.runtime.swing.Table());
        $Table2.setName("$Table2");
        createSearch();
        createClear();
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        $HidorButton0.setName("$HidorButton0");
        createCriterias();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_VISIBLE, true ,"offerListUI") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setVisible(isOfferListUI());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUESTS_VISIBLE, true ,"offerListUI") {
        
            @Override
            public void processDataBinding() {
                requests.setVisible(isOfferListUI());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUEST_AREA_TEXT, true ,"request") {
        
            @Override
            public void processDataBinding() {
                jaxx.runtime.SwingUtil.setText(requestArea, getRequest());
            }
        });
    }

}