/*
 * *##% 
 * vradi-swing
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.VradiStorageServiceImpl;
import com.jurismarches.vradi.services.dto.VradiClientDTO;
import com.jurismarches.vradi.services.dto.VradiFormDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.VradiMainUI;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.OneClicListSelectionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.WikittyExtension;

import javax.swing.*;
import javax.swing.event.CellEditorListener;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.HashMap;
import java.util.*;
import java.util.List;
import java.util.Map;

/**
 * @author morin
 */
public class EmailHandler {

    static private final Log log = LogFactory.getLog(EmailHandler.class);

    public EmailPopupUI init(JAXXContext rootContext, Object... datas) {
        EmailPopupUI ui = VradiContext.EMAIL_UI_ENTRY_DEF
                .getContextValue(rootContext);

        if (ui == null) {
            JAXXInitialContext context = new JAXXInitialContext()
                    .add(rootContext).add(this);

            VradiMainUI mainUI = VradiContext.MAIN_UI_ENTRY_DEF
                    .getContextValue(context);

            ui = new EmailPopupUI(context, mainUI);

            VradiContext.EMAIL_UI_ENTRY_DEF.setContextValue(rootContext, ui);
        }
        return ui;
    }


    EmailPopupUI getUI(JAXXContext context) {
        if (context instanceof EmailPopupUI) {
            return (EmailPopupUI) context;
        }
        EmailPopupUI ui = VradiContext.EMAIL_UI_ENTRY_DEF
                .getContextValue(context);
        return ui;
    }

    void close(JAXXContext context) {
        EmailPopupUI ui = getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    protected VradiStorageService getVradiStorageService() {
        return ServiceHelper.getVradiStorageService();
    }

    List<VradiSendingDTO> getFormsByClients(EmailListByClientUI ui) {
        List<VradiSendingDTO> result = new ArrayList<VradiSendingDTO>();
        try {
            result = getVradiStorageService().getFormsByClients(
                    (String) ui.getCriteria().getDateTypeSelection()
                            .getSelectedItem(),
                    ui.getCriteria().getFromDate().getDate(),
                    ui.getCriteria().getToDate().getDate(),
                    (WikittyExtension) ui.getCriteria().getFormTypeSelection()
                            .getSelectedItem(),
                    ui.getReceptionProofCheckBox().isSelected() ?
                            (Boolean) ui.getReceptionProofGroup()
                                    .getSelectedValue()
                            : null,
                    ui.getParagraphCheckBox().isSelected() ?
                            (Boolean) ui.getParagraphGroup().getSelectedValue()
                            : null,
                    ui.getStatusCheckBox().isSelected() ?
                            ((SendingStatus) ui.getStatusComboBox()
                                    .getSelectedItem()).getStatus()
                            : -1
            );
        } catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error(e);
            }
        }
        return result;
    }

    Map<Form, List<Client>> getClientsByForms(EmailListByFormUI ui) {
        Map<Form, List<Client>> result = new HashMap<Form, List<Client>>();
        try {
            result = getVradiStorageService().getClientsByForms(
                    (String) ui.getCriteria().getDateTypeSelection()
                            .getSelectedItem(),
                    ui.getCriteria().getFromDate().getDate(),
                    ui.getCriteria()
                            .getToDate().getDate(),
                    (WikittyExtension) ui.getCriteria().getFormTypeSelection()
                            .getSelectedItem()
            );
        } catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error(e);
            }
        }
        for (Map.Entry entry : result.entrySet()) {
            log.debug(entry.getKey() + " : " + entry.getValue());
        }
        return result;
    }

    public void bindEmailsWithForms() {
        try {
            getVradiStorageService().bindFormsToClients();
        } catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error(e);
            }
        }
    }

    public class FormListCellRenderer implements TableCellRenderer {
        /**
         * le composant pour le rendu
         */
        protected JList[] lists;
        /**
         * le composant de délégation pour obtenir le rendu visuel
         * (commun à tout le tableau)
         */
        protected TableCellRenderer delegateRenderer;

        public FormListCellRenderer(ClientEmailContentTableModel model) {
            this(new DefaultTableCellRenderer(), model);
        }

        public FormListCellRenderer(TableCellRenderer delegateRenderer,
                                    ClientEmailContentTableModel model) {
            this.delegateRenderer = delegateRenderer;
            //this.lists = new JList(new DefaultListModel());
            lists = new JList[model.getRowCount()];
            for (int i = 0; i < model.getRowCount(); i++) {
                lists[i] = new JList(new DefaultListModel());
                UIHelper.fillList(lists[i],
                        model.getData().get(i).getFormDTOs(), null);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table,
                                                       Object value,
                                                       boolean isSelected,
                                                       boolean hasFocus,
                                                       int row, int column) {
            if (log.isDebugEnabled()) {
                log.debug("renderer value" + value);
            }
            UIHelper.updateListSelection(lists[row], value);

            renderFromDelegate(table, value, isSelected, hasFocus, row, column);

            return lists[row];
        }

        /**
         * Effectuer le rendu visual à partir du renderer delegate.
         *
         * @param table      la table a afficher
         * @param value      la valeur à afficher
         * @param isSelected {@code true} si la cellule est sélectionnée
         * @param hasFocus   {@code true} si la cellule a le focus
         * @param row        la ligne sélectionnée
         * @param column     la colonne sélectionnée
         */
        protected void renderFromDelegate(JTable table, Object value,
                                          boolean isSelected,
                                          boolean hasFocus,
                                          int row, int column) {
            // obtain visual render from delegate
            JComponent rendererComponent = (JComponent) delegateRenderer.
                    getTableCellRendererComponent(table, value, isSelected,
                            hasFocus, row, column);
            lists[row].setBackground(rendererComponent.getBackground());
            lists[row].setFont(rendererComponent.getFont());
            lists[row].setBorder(rendererComponent.getBorder());
        }
    }

    public class FormListCellEditor extends AbstractCellEditor
            implements TableCellEditor {

        /**
         * le composant pour éditer
         */
        protected JList[] lists;
        /**
         * l'editeur de délégation, pour obtenir certaines informations
         * sur le rendu visuel
         */
        protected TableCellEditor delegate;

        protected int selectedIndex;


        public FormListCellEditor(TableCellEditor delegate,
                                  ClientEmailContentTableModel model) {
            this.delegate = delegate;
            //this.lists = new JList(new DefaultListModel());
            lists = new JList[model.getRowCount()];
            for (int i = 0; i < model.getRowCount(); i++) {
                lists[i] = new JList(new DefaultListModel());
                UIHelper.fillList(lists[i],
                        model.getData().get(i).getFormDTOs(), null);
                OneClicListSelectionModel selectModel =
                        new OneClicListSelectionModel(
                                lists[i].getSelectionModel(),
                                lists[i].getModel());
                lists[i].setSelectionModel(selectModel);
                this.lists[i].setBorder(
                        BorderFactory.createLoweredBevelBorder());
            }
        }

        public FormListCellEditor(ClientEmailContentTableModel model) {
            this(new DefaultCellEditor(new JTextField()), model);
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            boolean b = super.isCellEditable(e);
            b &= ((Component) e.getSource()).hasFocus();
            //        if (e instanceof MouseEvent) {
            //            return b && ((MouseEvent) e).getClickCount() > 1;
            //        }
            return b;
        }

        @Override
        public Object getCellEditorValue() {
            Object[] values = lists[selectedIndex].getSelectedValues();
            if (log.isDebugEnabled()) {
                log.debug("selected values = " + Arrays.toString(values));
            }
            return values;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value,
                                                     boolean isSelected,
                                                     int row, int column) {
            if (log.isDebugEnabled()) {
                log.debug("editor value" + value);
            }
            selectedIndex = row;
            UIHelper.updateListSelection(lists[row], value);

            // obtain visual render from delegate
            lists[row].setFont(table.getFont());

            return lists[row];
        }

    }

    public class ClientListCellRenderer extends JList
            implements TableCellRenderer {
        // This method is called each time a cell in a column
        // using this renderer needs to be rendered.
        public Component getTableCellRendererComponent(JTable table,
                                                       Object value,
                                                       boolean isSelected,
                                                       boolean hasFocus,
                                                       int row, int column) {
            // 'value' is value contained in the cell located at
            // (row, column)
            if (isSelected) {
                // cell (and perhaps other cells) are selected
                setBackground(table.getSelectionBackground());
                setForeground(table.getSelectionForeground());
            } else {
                setBackground(table.getBackground());
                setForeground(table.getForeground());
            }

            // Configure the button with the specified value
            List<Client> values = new ArrayList((Set<Client>) value);
            String[] clientNames = new String[values.size()];
            for (int i = 0; i < values.size(); i++) {
                clientNames[i] = values.get(i).getName();
            }
            setListData(clientNames);

            // Since the renderer is a button, return itself
            return this;
        }
    }

    public class ParagraphCellRenderer extends DefaultTableCellRenderer {
        // This method is called each time a cell in a column
        // using this renderer needs to be rendered.
        public Component getTableCellRendererComponent(JTable table,
                                                       Object value,
                                                       boolean isSelected,
                                                       boolean hasFocus,
                                                       int row, int column) {
            String stringValue = "null".equals(value) ? "" : (String) value;

            // Since the renderer is a button, return itself
            return super.getTableCellRendererComponent(table, stringValue,
                    isSelected, hasFocus, row, column);
        }
    }

    public class ParagraphCellEditor extends AbstractCellEditor
            implements TableCellEditor {
        // This is the button that will handle the editing of the cell value

        protected JPanel panel = new JPanel(new BorderLayout());
        protected JLabel valueLabel = new JLabel();

        // This method is called when a cell value is edited by the user.
        public Component getTableCellEditorComponent(JTable table, Object value,
                                                     boolean isSelected,
                                                     int row, int column) {
            // 'value' is value contained in the cell located at (row, column)
            panel.removeAll();

            final String paragraph = value.equals(
                    VradiStorageServiceImpl.DEFAULT_SENDING_PARAGRAPH) ?
                    "" : (String) value;
            valueLabel = new JLabel("<html>" + paragraph.replace("\n", "<br/>")
                    + "</html>");
            panel.add(valueLabel, BorderLayout.CENTER);
            JButton button = new JButton();
            button.setIcon(jaxx.runtime.SwingUtil
                    .getUIManagerActionIcon("rename"));
            button.addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent actionEvent) {

                    ParagraphEditorDialog editor = new ParagraphEditorDialog();

                    editor.setParagraph(paragraph);

                    editor.setVisible(true);

                    valueLabel.setText("<html>" + editor.getParagraph()
                            .replace("\n", "<br/>") + "</html>");
                }
            });
            panel.add(button, BorderLayout.PAGE_END);

            return panel;
        }

        // This method is called when editing is completed.
        // It must return the new value to be stored in the cell.
        public Object getCellEditorValue() {
            return valueLabel.getText();
        }
    }

    public class ReceptionProofRenderer extends JCheckBox
            implements TableCellRenderer {
        // This method is called each time a cell in a column
        // using this renderer needs to be rendered.
        public Component getTableCellRendererComponent(JTable table,
                                                       Object value,
                                                       boolean isSelected,
                                                       boolean hasFocus,
                                                       int row, int column) {
            // 'value' is value contained in the cell located at
            // (row, column)

            if (isSelected) {
                // cell (and perhaps other cells) are selected
                setBackground(table.getSelectionBackground());
                setForeground(table.getSelectionForeground());
            } else {
                setBackground(table.getBackground());
                setForeground(table.getForeground());
            }

            // Configure the button with the specified value
            this.setSelected((Boolean) value);

            // Since the renderer is a button, return itself
            return this;
        }
    }


    public class ActionButtonRenderer extends JButton
            implements TableCellRenderer {
        // This method is called each time a cell in a column
        // using this renderer needs to be rendered.
        public Component getTableCellRendererComponent(JTable table,
                                                       Object value,
                                                       boolean isSelected,
                                                       boolean hasFocus,
                                                       int row, int column) {
            // 'value' is value contained in the cell located at
            // (row, column)

            if (isSelected) {
                // cell (and perhaps other cells) are selected
                setBackground(table.getSelectionBackground());
                setForeground(table.getSelectionForeground());
            } else {
                setBackground(table.getBackground());
                setForeground(table.getForeground());
            }

            // Configure the button with the specified value
            if ((Boolean) value) {
                // TODO : Pourquoi est-ce dans le handler ???
                this.setIcon(SwingUtil.getUIManagerActionIcon("send"));
                this.setToolTipText("vradi.email.send");
            } else {
                this.setEnabled(false);
                this.setVisible(false);
            }

            // Since the renderer is a button, return itself
            return this;
        }
    }

    public class ActionButtonCellEditor extends AbstractCellEditor
            implements TableCellEditor {
        // This is the button that will handle the editing of the cell value
        protected JButton button = new JButton();

        public ActionButtonCellEditor() {
            button.setIcon(SwingUtil.getUIManagerActionIcon("send"));
            button.setToolTipText("vradi.email.send");
            button.setFocusable(false);
            button.addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    log.debug("send email");
                    fireEditingCanceled();
                }
            });
        }

        // This method is called when a cell value is edited by the user.
        public Component getTableCellEditorComponent(JTable table,
                                                     Object value,
                                                     boolean isSelected,
                                                     int row, int column) {
            // Return the configured button
            return button;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }
    }

    public void updateClientEmailContentTableModel(EmailListByClientUI ui) {

        ClientEmailContentTableModel contentModel = ui.getContentModel();

        contentModel.setValueIsAdjusting(true);
        try {

            contentModel.clear();

            // ajout des donnees
            int maxForms = 0;

            for (VradiSendingDTO sendingDTO : getFormsByClients(ui)) {
                maxForms = Math.max(maxForms, sendingDTO.getFormDTOs().size());

                contentModel.addEntry(sendingDTO);
            }

            ui.getContent().setRowHeight(maxForms > 1 ? 19 * maxForms : 19);

        } finally {
            contentModel.fireTableDataChanged();
            contentModel.setValueIsAdjusting(false);
        }
        SwingUtil.setTableColumnRenderer(ui.getContent(), 0,
                new DefaultTableCellRenderer() {

                    @Override
                    public Component getTableCellRendererComponent(JTable table,
                                                                   Object value,
                                                                   boolean isSelected,
                                                                   boolean hasFocus,
                                                                   int row,
                                                                   int column) {
                        if (value == null) {
                            return super.getTableCellRendererComponent(table,
                                    _("vradi.email.session.value.null"),
                                    isSelected,
                                    hasFocus, row, column);
                        } else {
                            return super.getTableCellRendererComponent(table,
                                    _("vradi.email.session.value",
                                            (Date) value),
                                    isSelected, hasFocus, row, column);
                        }
                    }
                });
        SwingUtil.setTableColumnRenderer(ui.getContent(), 1,
                ui.getContent().getDefaultRenderer(String.class));
        SwingUtil.setTableColumnRenderer(ui.getContent(), 2,
                new FormListCellRenderer(contentModel));
        SwingUtil.setTableColumnEditor(ui.getContent(), 2,
                new FormListCellEditor(contentModel));
        SwingUtil.setTableColumnRenderer(ui.getContent(), 3,
                new ParagraphCellRenderer());
        SwingUtil.setTableColumnEditor(ui.getContent(), 3,
                new ParagraphCellEditor());
        SwingUtil.setTableColumnRenderer(ui.getContent(), 4,
                ui.getContent().getDefaultRenderer(String.class));
        SwingUtil.setTableColumnRenderer(ui.getContent(), 5,
                new ReceptionProofRenderer());
        SwingUtil.setTableColumnEditor(ui.getContent(), 5,
                new DefaultCellEditor(new JCheckBox()));

    }

    public void updateFormEmailContentTableModel(EmailListByFormUI ui) {

        FormEmailContentTableModel contentModel = ui.getContentModel();
        contentModel.setValueIsAdjusting(true);

        try {

            contentModel.clear();

            // ajout des donnees
            int maxClients = 0;

            for (Map.Entry entry : getClientsByForms(ui).entrySet()) {
                List<Client> clients = (List<Client>) entry.getValue();
                maxClients = Math.max(maxClients, clients.size());
                Form form = (Form) entry.getKey();
                contentModel.addEntry(form.getName(), clients);
            }
            ui.getContent().setRowHeight(maxClients > 1 ? 19 * maxClients : 19);

        } finally {
            contentModel.fireTableDataChanged();
            contentModel.setValueIsAdjusting(false);
        }
    }

    public void sendEmails(EmailListByClientUI ui) {
        if (log.isDebugEnabled()) {
            log.debug("Send email");
        }
        ClientEmailContentTableModel contentModel = ui.getContentModel();
        List<Sending> sendingsToSave = new ArrayList<Sending>();
        for (VradiSendingDTO sendingDTO : contentModel.getData()) {
            if (log.isDebugEnabled()) {
                log.debug("Client : "
                        + sendingDTO.getClientDTO().getName());
            }
            if (sendingDTO.getStatus() == SendingStatus.TO_SEND.getStatus()) {
                sendingDTO.setStatus(sendingDTO.getReceptionProof() ?
                        SendingStatus.WAITING_RECPETION_PROOF.getStatus() :
                        SendingStatus.SENT.getStatus());
                sendingDTO.setSentDate(new Date());
                if (contentModel.getFormsToExclude(sendingDTO) == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("No form is excluded, send all to client : "
                                + sendingDTO.getClientDTO().getName());
                    }
                    sendingsToSave.add(sendingDTO.getSending());
                } else if (contentModel.getFormsToExclude(sendingDTO).size()
                        == sendingDTO.getFormDTOs().size()) {
                    if (log.isDebugEnabled()) {
                        log.debug("All the forms are excluded, " +
                                "do nothing for client : "
                                + sendingDTO.getClientDTO().getName());
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Some forms are excluded for client : "
                                + sendingDTO.getClientDTO().getName());
                    }
                    Sending newSending = new SendingImpl();
                    newSending.setStatus(SendingStatus.TO_SEND.getStatus());
                    VradiClientDTO client = sendingDTO.getClientDTO();
                    newSending.setClient(client.getWikittyId());
                    List<VradiFormDTO> forms =
                            contentModel.getFormsToExclude(sendingDTO);
                    for (VradiFormDTO form : forms) {
                        newSending.addForm(form.getWikittyId());
                        sendingDTO.removeFormDTO(form);
                    }
                    sendingsToSave.add(newSending);
                    sendingsToSave.add(sendingDTO.getSending());
                }
            }
        }
        try {
            getVradiStorageService().updateSendings(sendingsToSave);
        } catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error(e);
            }
        }

    }

}
