package com.jurismarches.vradi.ui.editors;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

/**
 * User: chemit
 * Date: 26 nov. 2009
 * Time: 21:48:47
 */
public class VradiEditorModel<O> implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_FIELD_NAME = "fieldName";
    public static final String PROPERTY_FIELD_DESCRIPTION = "fieldDescription";
    public static final String PROPERTY_EXTENSION_NAME = "extensionName";
    public static final String PROPERTY_VALIDATOR_CONTEXT = "validatorContext";

    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    protected O value;
    protected String fieldName;
    protected String fieldDescription;
    protected String extensionName;
    protected String validatorContext;

    public O getValue() {
        return value;
    }

    public String getExtensionName() {
        return extensionName;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getFieldDescription() {
        return fieldDescription;
    }

    public String getValidatorContext() {
        return validatorContext;
    }

    public void setValue(O value) {
        O oldValue = this.value;
        this.value = value;
        pcs.firePropertyChange(PROPERTY_VALUE, oldValue, value);
    }

    public void setExtensionName(String extensionName) {
        String oldValue = this.extensionName;
        this.extensionName = extensionName;
        pcs.firePropertyChange(PROPERTY_EXTENSION_NAME, oldValue, extensionName);
    }

    public void setFieldName(String fieldName) {
        String oldValue = this.fieldName;
        this.fieldName = fieldName;
        pcs.firePropertyChange(PROPERTY_FIELD_NAME, oldValue, fieldName);
    }

    public void setFieldDescription(String fieldDescription) {
        String oldValue = this.fieldDescription;
        this.fieldDescription = fieldDescription;
        pcs.firePropertyChange(PROPERTY_FIELD_DESCRIPTION, oldValue, fieldDescription);
    }

    public void setValidatorContext(String validatorContext) {
        String oldValue = this.validatorContext;
        this.validatorContext = validatorContext;
        pcs.firePropertyChange(PROPERTY_FIELD_NAME, oldValue, validatorContext);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }
}

