/*
 * *##% 
 * vradi-swing
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.ui.admin.VradiNavigationTreeHelper;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;
import org.sharengo.wikitty.WikittyExtension;

import java.util.List;

/**
 * @author letellier
 */
public class FormNavigationTreeHelper extends VradiNavigationTreeHelper {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(FormNavigationTreeHelper.class);

    public FormNavigationTreeHelper(JAXXContext context) {
        super(FORMS.getName(), context);
    }

    @Override
    public NavigationTreeModel createTreeModel() {

        JAXXContext context = getContext();

        List<WikittyExtension> forms = FORMS.getContextValue(context);

        // construction du noeud root
        // il ne contient pas de context et ne sera pas visible
        NavigationTreeNode rootNode = builder.buildEmptyRoot(null, "$root");

        NavigationTreeNode formNode = builder.build(
                rootNode,
                _(FORMS.getName()),
                FORMS,
                "forms",
                AdminFormTypeUI.class,
                null);

        for (WikittyExtension f : forms) {
            builder.addForm(context, formNode, f);
        }

        NavigationTreeModel model = builder.getModel();

        if (log.isDebugEnabled()) {
            builder.printModel(model.getRoot());
        }

        // save tree model in context
        setTreeModel(context, model);

        setSelectedNode(context, formNode);

        return model;
    }
}
