package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.admin.content.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.swing.SwingValidator;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminClientUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<Client> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_IN_GROUP = "inGroup";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLIENT_ADDRESS_TEXT = "clientAddress.text";
    public static final String BINDING_CLIENT_CONTACT_TEXT = "clientContact.text";
    public static final String BINDING_CLIENT_GROUPS_VISIBLE = "clientGroups.visible";
    public static final String BINDING_CLIENT_NAME_TEXT = "clientName.text";
    public static final String BINDING_CLIENT_PHONE_TEXT = "clientPhone.text";
    public static final String BINDING_REQUEST_LIST_UI_BEAN = "requestListUI.bean";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JBUTTON1_VISIBLE = "$JButton1.visible";
    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";
    private static final String BINDING_$JBUTTON2_VISIBLE = "$JButton2.visible";
    private static final String BINDING_$JBUTTON3_ENABLED = "$JButton3.enabled";
    private static final String BINDING_$JBUTTON3_VISIBLE = "$JButton3.visible";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String BINDING_$JLABEL5_VISIBLE = "$JLabel5.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminClientForm;
    protected com.jurismarches.vradi.services.dto.VradiClientDTO bean;
    protected javax.swing.JTextField clientAddress;
    protected javax.swing.JTextField clientContact;
    protected jaxx.runtime.swing.ListSelectorUI< Group > clientGroups;
    protected javax.swing.JTextField clientName;
    protected javax.swing.JTextField clientPhone;
    protected java.lang.Boolean inGroup;
    protected jaxx.runtime.swing.HBox lastModified;
    protected com.jurismarches.vradi.ui.admin.content.RequestListUI requestListUI;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiClientDTO > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminClientUI $AdminContentUI0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JButton $JButton2;
    private javax.swing.JButton $JButton3;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JButton $JButton4;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    void $afterCompleteSetup() {
        addPCSLogger();
        addBeanPCSLogger(bean);
        addBeanModifiedPCS(bean);
        clientGroups.addPropertyChangeListener(ListSelectorUI.PROPERTY_MODIFIED, new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from groups");
                    setModified(true);
                }
            }
        });
        errorTable.registerValidator(validator);
    }
    
    @Override
    public void openUI(NavigationTreeNode node) throws Exception {
        super.openUI(node);
        requestListUI.init();
    
        java.util.List<Group> toCombo = getHandler().getAllGroups(this);
        java.util.List<Group> toList  = new java.util.ArrayList<Group>(toCombo);
    
        for (java.util.Iterator<Group> it = toList.iterator(); it.hasNext();) {
            Group group = it.next();
            if (group.getClient() == null || !group.getClient().contains(bean.getWikittyId())) {
                it.remove();
                log.debug("client does NOT use group " + group.getName());
            } else {
                toCombo.remove(group);
                log.debug("client use group " + group.getName());
            }
        }
        clientGroups.init(toCombo, toList);
        NavigationTreeNode parentNode = getHelper().getParentGroupNode(getHelper().getSelectedNode(this));
        setInGroup(parentNode != null);
    
        lastModified.removeAll();
        if(bean != null && bean.getLastModified() != null && bean.getLastModifier() != null) {
            String labelText = String.format(_("vradi.entity.lastModified.date.user"), bean.getLastModified(), bean.getLastModifier());
            lastModified.add(new JLabel(labelText));
        }
    }
    
    @Override
    protected void updateBeanFromEntity(Client bean) {
        this.bean.fromWikitty(bean);
        log.debug(this.bean.getLastModified() + " " + this.bean.getLastModifier());
    }
    
    @Override
    public void save() {
    
        // objects to save
        java.util.Collection<Object> toSave = new java.util.ArrayList<Object>();
    
        this.bean.setLastModified(new java.util.Date());
        this.bean.setLastModifier(getContextValue(VradiUser.class).getName());
        Client bean = (Client) getHelper().getSelectedBean(this);
        if(!bean.getExtensions().contains(ModificationTag.MODIFICATION_TAG)) {
            bean.addExtension(ModificationTag.MODIFICATION_TAG);
        }
        this.bean.toWikitty(bean);
        log.info("===================================================================================");
        log.info("client to save " + bean.getName());
        toSave.add(bean);
    
        String wikittyId = bean.getWikittyId();
        for (Group g : clientGroups.getComboDatas()) {
            log.debug("test group without this client " + g.getName() + " - " + g.getClient());
            if (g.getClient() != null && g.getClient().contains(wikittyId)) {
                // group was containing client, but no more
                g.removeClient(wikittyId);
                // mark it for save
                toSave.add(g);
                log.info("group to save (client was removed) " + g);
            }
        }
        for (Group g : clientGroups.getListDatas()) {
            log.debug("test group with this client " + g.getName() + " - " + g.getClient());
            if (g.getClient() == null || !g.getClient().contains(wikittyId)) {
                // group was not containing client, but do now
                g.addClient(wikittyId);
                // mark it for save
                toSave.add(g);
                log.info("group to save (client was added) " + g);
            }
        }
        getHandler().save(this, getHelper(), toSave.toArray(new Object[toSave.size()]));
        clientGroups.setModified(false);
        log.info("===================================================================================");
    }
    
    protected void deleteFromGroup() {
        log.info("===================================================================================");
        NavigationTreeNode parentNode = getHelper().getParentGroupNode(getHelper().getSelectedNode(this));
        Group group = (Group) parentNode.getBean(this);
        log.info("group to save " + group.getName());
        group.removeClient(bean.getWikittyId());
        getHandler().save(group);
        getHelper().reloadGroup(this, parentNode, group);
        getHelper().selectNode(this, parentNode.getFullPath());
        log.info("===================================================================================");
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminClient.title", getStringValue(name));
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminClientUI() {
        super();
        $initialize();
    }

    public AdminClientUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiClientDTO > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton4(java.awt.event.ActionEvent event) {
        UIHelper.openAddressInBrowser(bean.getAddress());
    }

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().createClient(this, getHelper());setModified(true);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().createUser(this, getHelper());
    }

    public void doActionPerformed__on__$JButton2(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), bean);
    }

    public void doActionPerformed__on__$JButton3(java.awt.event.ActionEvent event) {
        deleteFromGroup();
    }

    public void doKeyReleased__on__clientAddress(java.awt.event.KeyEvent event) {
        bean.setAddress(clientAddress.getText());
    }

    public void doKeyReleased__on__clientContact(java.awt.event.KeyEvent event) {
        bean.setContact(clientContact.getText());
    }

    public void doKeyReleased__on__clientName(java.awt.event.KeyEvent event) {
        bean.setName(clientName.getText());
    }

    public void doKeyReleased__on__clientPhone(java.awt.event.KeyEvent event) {
        bean.setPhone(clientPhone.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminClientForm() {
        return adminClientForm;
    }

    public com.jurismarches.vradi.services.dto.VradiClientDTO getBean() {
        return bean;
    }

    public javax.swing.JTextField getClientAddress() {
        return clientAddress;
    }

    public javax.swing.JTextField getClientContact() {
        return clientContact;
    }

    public jaxx.runtime.swing.ListSelectorUI< Group > getClientGroups() {
        return clientGroups;
    }

    public javax.swing.JTextField getClientName() {
        return clientName;
    }

    public javax.swing.JTextField getClientPhone() {
        return clientPhone;
    }

    public java.lang.Boolean getInGroup() {
        return inGroup;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public com.jurismarches.vradi.ui.admin.content.RequestListUI getRequestListUI() {
        return requestListUI;
    }

    public java.lang.Boolean isInGroup() {
        return inGroup !=null && inGroup;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setInGroup(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.inGroup;
        this.inGroup = newValue;
        firePropertyChange(PROPERTY_IN_GROUP, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    protected javax.swing.JButton get$JButton3() {
        return $JButton3;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JButton get$JButton4() {
        return $JButton4;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminClientForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminClientForm.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(SwingUtil.boxComponentWithJxLayer(clientName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientAddress, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JButton4, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientPhone, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientContact, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientGroups, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminClientForm, BorderLayout.NORTH);
        body.add(requestListUI, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setFieldRepresentation("name", clientName);
    }

    protected void createAdminClientForm() {
        $objectMap.put("adminClientForm", adminClientForm = new jaxx.runtime.swing.Table());
        adminClientForm.setName("adminClientForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.services.dto.VradiClientDTO());
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createClientAddress() {
        $objectMap.put("clientAddress", clientAddress = new javax.swing.JTextField());
        clientAddress.setName("clientAddress");
        clientAddress.setColumns(15);
        clientAddress.addKeyListener(Util.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientAddress"));
    }

    protected void createClientContact() {
        $objectMap.put("clientContact", clientContact = new javax.swing.JTextField());
        clientContact.setName("clientContact");
        clientContact.setColumns(15);
        clientContact.addKeyListener(Util.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientContact"));
    }

    protected void createClientGroups() {
        $objectMap.put("clientGroups", clientGroups = new jaxx.runtime.swing.ListSelectorUI< Group >());
        clientGroups.setName("clientGroups");
        clientGroups.setShowHidor(true);
        ((javax.swing.JToolBar) clientGroups.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) clientGroups.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createClientName() {
        $objectMap.put("clientName", clientName = new javax.swing.JTextField());
        clientName.setName("clientName");
        clientName.setColumns(15);
        clientName.addKeyListener(Util.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientName"));
    }

    protected void createClientPhone() {
        $objectMap.put("clientPhone", clientPhone = new javax.swing.JTextField());
        clientPhone.setName("clientPhone");
        clientPhone.setColumns(15);
        clientPhone.addKeyListener(Util.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientPhone"));
    }

    protected void createInGroup() {
        $objectMap.put("inGroup", inGroup = null);
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createRequestListUI() {
        $objectMap.put("requestListUI", requestListUI = new com.jurismarches.vradi.ui.admin.content.RequestListUI(this));
        requestListUI.setName("requestListUI");
    }

    @Override
    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new jaxx.runtime.swing.Table());
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiClientDTO >(com.jurismarches.vradi.services.dto.VradiClientDTO.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add($JButton0);
        $JPanel0.add($JButton1);
        $JPanel0.add($JButton2);
        $JPanel0.add($JButton3);
        $JPanel0.add($HidorButton0);
        addChildrenToBody();
        addChildrenToAdminClientForm();
        
        // apply 17 data bindings
        Util.applyDataBinding(this, $bindings.keySet());
        
        // apply 18 property setters
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("client.add"));
        $JButton2.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("client.delete"));
        $JButton3.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        $HidorButton0.setHideTip(_("vradi.adminClient.hideForm"));
        $HidorButton0.setShowTip(_("vradi.adminClient.showForm"));
        $HidorButton0.setTarget(adminClientForm);
        $HidorButton0.setTargetVisible(true);
        adminClientForm.setMinimumSize(SwingUtil.newMinDimension());
        $JButton4.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("site"));
        clientGroups.setAddToComboTip(_("vradi.adminClient.removeGroups"));
        clientGroups.setAddToListTip(_("vradi.adminClient.addGroup"));
        clientGroups.setMinimumSize(new Dimension(100,250));
        clientGroups.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        $JLabel0.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        $JLabel0.setFont(new Font("Serif", Font.BOLD, 26));
        $JLabel0.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 17 data bindings
        $registerDefaultBindings();
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        createInGroup();
        createValidator();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminClient.createClient"));
        $JButton0.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.adminClient.createUser"));
        $JButton1.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new javax.swing.JButton());
        $JButton2.setName("$JButton2");
        $JButton2.setToolTipText(_("vradi.adminClient.deleteClient"));
        $JButton2.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new javax.swing.JButton());
        $JButton3.setName("$JButton3");
        $JButton3.setToolTipText(_("vradi.adminClient.deleteClientFromGroup"));
        $JButton3.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        $HidorButton0.setName("$HidorButton0");
        createAdminClientForm();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminClient.name"));
        createClientName();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminClient.adresse"));
        createClientAddress();
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new javax.swing.JButton());
        $JButton4.setName("$JButton4");
        $JButton4.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminClient.tel"));
        createClientPhone();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("vradi.adminClient.contact"));
        createClientContact();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new javax.swing.JLabel());
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("vradi.adminClient.listGroup"));
        createClientGroups();
        createRequestListUI();
        createLastModified();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((javax.swing.JPanel) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 17 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("wikittyId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    setEnabled(bean.getWikittyId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("wikittyId", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    $JLabel0.setText(_(updateTitle(bean.getName())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON2_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton2.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON2_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton2.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON3_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton3.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON3_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton3.setVisible(isInGroup());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLIENT_NAME_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(clientName, bean.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLIENT_ADDRESS_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("address", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(clientAddress, bean.getAddress());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("address", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLIENT_PHONE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("phone", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(clientPhone, bean.getPhone());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("phone", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLIENT_CONTACT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("contact", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(clientContact, bean.getContact());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("contact", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL5_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JLabel5.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENT_GROUPS_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                clientGroups.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUEST_LIST_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                requestListUI.setBean(getBean());
            }
        });
    }

}