package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.admin.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminThesaurusUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_SELECTED = "selected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_EDIT_ENABLED = "edit.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.AdminThesaurusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminThesaurusUI adminThesaurusUI = this;
    protected javax.swing.JButton cancel;
    protected javax.swing.JButton create;
    protected javax.swing.JButton delete;
    protected javax.swing.JButton edit;
    protected java.lang.Boolean modified;
    protected javax.swing.JButton save;
    protected java.lang.Boolean selected;
    protected javax.swing.JTree thesaurus;
    protected jaxx.runtime.swing.HBox toolBar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    ThesaurusTreeHelper helper;
    
    
    public  AdminThesaurusUI(jaxx.runtime.JAXXContext parentContext, ThesaurusTreeHelper helper) {
        jaxx.runtime.Util.initContext(this, parentContext);
        this.helper = helper;
        setContextValue(helper);
    $initialize();
    }
    
    public void reinit(ThesaurusTreeHelper helper){
        this.helper = helper;
        setContextValue(helper);
    
        thesaurus.setModel(helper.createTreeModel(this));
        thesaurus.setSelectionModel(helper.createTreeHandler(this));
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected ThesaurusTreeHelper getHelper() {
        return helper;
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        thesaurus.putClientProperty("JTree.lineStyle", "Angled");
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
                JTree tree = (JTree) mouseEvent.getSource();
                TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
                // If node is selected
                setSelected(path != null);
    
                // Clear if no selection
                if (!isSelected()){
                    tree.clearSelection();
                    getHelper().setSelectedNode(AdminThesaurusUI.this, null);
                }
                
                if (mouseEvent.getButton() == MouseEvent.BUTTON3){
                    JPopupMenu popup = new JPopupMenu();
    
                    JMenuItem menuAddChild = new JMenuItem();
                    menuAddChild.setText(_("vradi.menu.addChildThesaurus"));
                    menuAddChild.addActionListener(new ActionListener() {
    
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
    
                            addChildToSelected();
                        }
                    });
                    popup.add(menuAddChild);
                    
                    JMenuItem menuRenameSelected = new JMenuItem();
                    menuRenameSelected.setText(_("vradi.menu.editThesaurusSelected"));
                    menuRenameSelected.addActionListener(new ActionListener() {
    
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            editSelected();
                        }
                    });
                    popup.add(menuRenameSelected);
    
                    JMenuItem menuDeleteSeleted = new JMenuItem();
                    menuDeleteSeleted.setText(_("vradi.menu.deleteThesaurusSelected"));
                    menuDeleteSeleted.addActionListener(new ActionListener() {
    
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            deleteSelected();
                        }
                    });
                    popup.add(menuDeleteSeleted);
    
                    popup.show(thesaurus, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    
    }
    
    protected void addChildToSelected(){
        log.debug("addChildToSelected ");
        // Ajout dun nouveau thesaurus
        setModified(getHandler().addChildThesaurusToSelected(this, helper));
    }
    protected void editSelected(){
        log.debug("editSelected ");
        // Edition dun thesaurus
        setModified(getHandler().editThesaurusSelected(this, helper));
    }
    protected void deleteSelected(){
        log.debug("deleteSelected ");
        // Suppression dun thesaurus
        setModified(getHandler().deleteThesaurusSelected(this, helper));
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminThesaurusUI() {
        $initialize();
    }

    public AdminThesaurusUI(JAXXContext parentContext) {
        Util.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        setModified(false);getHandler().cancelThesaurus(this, helper);
    }

    public void doActionPerformed__on__create(java.awt.event.ActionEvent event) {
        addChildToSelected();
    }

    public void doActionPerformed__on__delete(java.awt.event.ActionEvent event) {
        deleteSelected();
    }

    public void doActionPerformed__on__edit(java.awt.event.ActionEvent event) {
        editSelected();
    }

    public void doActionPerformed__on__save(java.awt.event.ActionEvent event) {
        setModified(false);getHandler().saveThesaurus(this, helper);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JButton getDelete() {
        return delete;
    }

    public javax.swing.JButton getEdit() {
        return edit;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public java.lang.Boolean getSelected() {
        return selected;
    }

    public javax.swing.JTree getThesaurus() {
        return thesaurus;
    }

    public jaxx.runtime.swing.HBox getToolBar() {
        return toolBar;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    public java.lang.Boolean isSelected() {
        return selected !=null && selected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    public void setSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selected;
        this.selected = newValue;
        firePropertyChange(PROPERTY_SELECTED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminThesaurusUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(toolBar, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(cancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(save, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        toolBar.add(create);
        toolBar.add(edit);
        toolBar.add(delete);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCreate() {
        $objectMap.put("create", create = new javax.swing.JButton());
        create.setName("create");
        create.setText(_("vradi.common.create"));
        create.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new javax.swing.JButton());
        delete.setName("delete");
        delete.setText(_("vradi.common.delete"));
        delete.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createEdit() {
        $objectMap.put("edit", edit = new javax.swing.JButton());
        edit.setName("edit");
        edit.setText(_("vradi.common.edit"));
        edit.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__edit"));
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createSave() {
        $objectMap.put("save", save = new javax.swing.JButton());
        save.setName("save");
        save.setText(_("vradi.common.save"));
        save.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = false);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new javax.swing.JTree());
        thesaurus.setName("thesaurus");
        thesaurus.setExpandsSelectedPaths(true);
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(false);
    }

    protected void createToolBar() {
        $objectMap.put("toolBar", toolBar = new jaxx.runtime.swing.HBox());
        toolBar.setName("toolBar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminThesaurusUI();
        addChildrenToToolBar();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurus);
        
        // apply 3 data bindings
        Util.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        create.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        edit.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("edit"));
        delete.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        thesaurus.setModel(helper.createTreeModel(this));
        thesaurus.setSelectionModel(helper.createTreeHandler(this));
        cancel.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        save.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("save"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 3 data bindings
        $registerDefaultBindings();
        $objectMap.put("adminThesaurusUI", this);
        createModified();
        createSelected();
        createToolBar();
        createCreate();
        createEdit();
        createDelete();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurus();
        createCancel();
        createSave();
        // inline creation of adminThesaurusUI
        setName("adminThesaurusUI");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDIT_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                edit.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DELETE_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                delete.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SAVE_ENABLED, true ,"modified") {
        
            @Override
            public void processDataBinding() {
                save.setEnabled(isModified());
            }
        });
    }

}