package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

import javax.swing.*;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.MaskFormatter;
import java.awt.*;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;

/**
 * Classe de méthodes utiles pour les ui.
 * <p/>
 * User: chemit
 * Date: 23 nov. 2009
 * Time: 11:51:14
 */
public class UIHelper extends SwingUtil {

    /**
     * Logger
     */
    private static final Log log = LogFactory.getLog(UIHelper.class);


    private UIHelper() {
        // pas d'instance
    }

    /**
     * Met à jour le modèle de sélection {@code list} donnée avec l'objet {@code value} entrant.
     * <p/>
     * {@code value} represente normalement une collection de données.
     *
     * @param list  la liste à updater
     * @param value la liste des valeurs de la selection de la liste.
     */
    public static void updateListSelection(JList list, Object value) {

        list.setValueIsAdjusting(true);
        list.clearSelection();

        try {
            if (value != null) {

                // la valeur doit être une collection, on met a jour le model de selection
                int size = list.getModel().getSize();
                Collection<?> valuesToSelect = (Collection<?>) value;
                int[] indexToSelect = new int[valuesToSelect.size()];
                int index = 0;
                for (Object v : valuesToSelect) {
                    for (int i = 0; i < size; i++) {
                        Object o = list.getModel().getElementAt(i);
                        if (o.equals(v)) {
                            indexToSelect[index++] = i;
                            break;
                        }
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("index to select = " + Arrays.toString(indexToSelect));
                }
                list.setSelectedIndices(indexToSelect);
            }

        } finally {

            list.setValueIsAdjusting(false);
        }
    }

    // I18n
    public static void setI18nTableHeaderRenderer(JTable table, String... libelles) {
        table.getTableHeader().setDefaultRenderer(new VradiI18nTableCellRenderer(table.getTableHeader().getDefaultRenderer(), libelles));
    }

    public static void openAddressInBrowser(String address) {
        browseURI("http://maps.google.fr/maps?f=q&source=s_q&hl=fr&geocode=&q=" + getStringValue(address) + ",France");
    }

    public static void browseURI(String uri) {
        //TODO KMORIN 241109 change error handling
        try {
            java.awt.Desktop.getDesktop().browse(new java.net.URI(uri.replace(" ", "+")));
        } catch (IOException e) {
            log.error(e);
            ErrorDialogUI.showError(e);
        } catch (URISyntaxException e) {
            log.error(e);
            ErrorDialogUI.showError(e);
        }
    }

    public static void createEmail(String emailAdress) {
        //TODO KMORIN 211209 change error handling
        try {
            URI mailtoURI = new URI("mailto:" + emailAdress);
            Desktop.getDesktop().mail(mailtoURI);
        } catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error(e);
            }
            ErrorDialogUI.showError(e);
        } catch (URISyntaxException e) {
            if (log.isErrorEnabled()) {
                log.error("Error while opening link", e);
            }
        } catch (UnsupportedOperationException e) {
            if (log.isWarnEnabled()) {
                log.warn("Cannot open link (maybe defaut browser in not configured ?)");
            }
            if (log.isDebugEnabled()) {
                log.debug("Error while opening link", e);
            }
        }
    }

    public static void exportToCSV(File file, OfferListTableModel model) {
        try {
            FileWriter writer = new FileWriter(file);

            for (int i = 0; i < model.getColumnCount(); i++) {
                writer.append('"').append(_(model.getColumnName(i))).append('"')
                        .append(i < model.getColumnCount() - 1 ? ',' : '\n');
            }
            for (int i = 0; i < model.getRowCount(); i++) {
                for (int j = 0; j < model.getColumnCount(); j++) {
                    String value = String.valueOf(model.getValueAt(i, j));
                    writer.append('"').append(value == null ? "" : value).append('"')
                            .append(j < model.getColumnCount() - 1 ? ',' : '\n');
                }
            }
            writer.flush();
            writer.close();

        } catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error(e);
                ErrorDialogUI.showError(e);
            }
        }
    }

    public static File openFileChooser(final String fileExtension, final String description, final Component component,
                                       String validationLabel) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter() {

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }

                String ext = null;
                String fileName = file.getName();
                int dot = fileName.lastIndexOf('.');

                if (dot > 0 && dot < fileName.length() - 1) {
                    ext = fileName.substring(dot).toLowerCase();
                }
                return ext != null && ext.equals(fileExtension);
            }

            @Override
            public String getDescription() {
                return _(description);
            }
        });

        int returnVal = fileChooser.showDialog(component, _(validationLabel));
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            File file = fileChooser.getSelectedFile();
            if (!file.getName().endsWith(fileExtension)) {
                file = new File(file.getAbsolutePath() + fileExtension);
            }
            log.debug("saving : " + file.getName() + ".");
            return file;
        } else {
            log.debug("No file chosen by user.");
            return null;
        }
    }

    public static ListCellRenderer getTranslationListCellRenderer() {
        return new DefaultListCellRenderer() {

            public Component getListCellRendererComponent(
                    JList list,
                    Object value,
                    int index,
                    boolean isSelected,
                    boolean cellHasFocus) {
                if (value != null) {
                    return super.getListCellRendererComponent(list, _(value.toString()), index,
                            isSelected, cellHasFocus);
                } else {
                    return super.getListCellRendererComponent(list, value, index,
                            isSelected, cellHasFocus);
                }
            }

        };
    }

    public static <T> T getHandler(JAXXContext context, Class<T> handlerClass) {
        T handler = context.getContextValue(handlerClass);
        if (handler == null) {
            try {
                handler = handlerClass.newInstance();
            } catch (InstantiationException e) {
                log.error("Cant create handler instance of type " + handlerClass.getName() + " : ", e);
                ErrorDialogUI.showError(e);
            } catch (IllegalAccessException e) {
                log.error("Cant create handler instance of type " + handlerClass.getName() + " : ", e);
                ErrorDialogUI.showError(e);
            }

            if (context instanceof JAXXInitialContext) {
                ((JAXXInitialContext) context).add(handler);
            } else {
                context.setContextValue(handler);
            }
        }
        return handler;
    }

    public static ComboBoxModel getNumberComboBoxModel(int nbData) {
        Object[] data = new Integer[nbData];
        for (int i = 0; i < data.length; i++) {
            data[i] = i;
        }
        return new DefaultComboBoxModel(data);
    }

    public static ComboBoxModel getHourModel() {
        return getNumberComboBoxModel(24);
    }

    public static ComboBoxModel getMinuteModel() {
        return getNumberComboBoxModel(60);
    }

    public static ListCellRenderer get2DigitsRenderer() {
        return new DefaultListCellRenderer() {

            @Override
            public Component getListCellRendererComponent(JList jList, Object o,
                                                          int i, boolean b, boolean b1) {

                String value = (Integer) o < 10 ? "0" + o.toString() : o.toString();
                return super.getListCellRendererComponent(jList, value, i, b, b1);
            }
        };
    }

    public static class NumberFormatterFactory extends JFormattedTextField.AbstractFormatterFactory {

        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
            try {
                return new MaskFormatter("######");
            } catch (ParseException eee) {
                log.error(eee);
                return null;
            }
        }
    }

}
