/*
 * *##% 
 * vradi-swing
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.search.SearchHandler;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;

import javax.swing.*;
import javax.swing.tree.TreePath;
import java.util.List;

/**
 * @author letellier
 */
public class ThesaurusHandler {

    /**
     * to use log facility, just put in your code: log.info(\"...\");
     */
    static private Log log = LogFactory.getLog(ThesaurusHandler.class);
//    protected List<ThesaurusUI> thesaurusUI;

    /**
     * Methode pour initialiser l'ui principale sans l'afficher.
     *
     * @param rootContext   le context applicatif
     * @param rootThesaurus
     * @param bean
     * @return l'ui instancie et initialisee mais non visible encore
     */
    public ThesaurusUI initUI(JAXXContext rootContext, VradiThesaurusDTO rootThesaurus, Form bean) {

        return initUI(rootContext, rootThesaurus, bean, false);
    }

    public ThesaurusUI initUI(JAXXContext rootContext, VradiThesaurusDTO rootThesaurus, Form bean, boolean deletable) {

        JAXXInitialContext context = new JAXXInitialContext().add(rootContext);

        // show main ui
        context.add(this);

        // Init ui
        ThesaurusUI ui = new ThesaurusUI(context, rootThesaurus);
        ui.setDeletable(deletable);
        ui.setBean(bean);

        return ui;
    }

    ThesaurusUI getUI(JAXXContext context) {
        if (context instanceof ThesaurusUI) {
            return (ThesaurusUI) context;
        }
        return null;
    }

    protected OfferEditUI getEditUI(JAXXContext context) {
        return UIHelper.getHandler(context, OfferEditHandler.class).getUI(context);
    }

    protected OfferListUI getListUI(JAXXContext context) {
        return UIHelper.getHandler(context, OfferListHandler.class).getUI(context);
    }

    public static VradiThesaurusDTO getRootThesaurus() {
        try {
            TreeNode rootTreeNode = ServiceHelper.getVradiStorageService().getRootThesaurus();
            VradiThesaurusDTO dto = new VradiThesaurusDTO();
            dto.fromWikitty(rootTreeNode);
            return dto;
        } catch (TechnicalException ex) {
            log.error("Cant get thesaurus caused by : " + ex);
            ErrorDialogUI.showError(ex);
        }
        return null;
    }

    protected NavigationTreeNode getParentNode(ThesaurusTreeHelper helper, TreePath path) {
        if (path == null) {
            return helper.getRootNode();
        } else {
            return (NavigationTreeNode) path.getLastPathComponent();
        }
    }

    public void addCriteria(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        OfferListUI ui = getListUI(context);

        // Get selected thesaurus
        NavigationTreeNode parentNode = getParentNode(helper, path);
        VradiThesaurusDTO thesaurus = (VradiThesaurusDTO) parentNode.getBean(context);

        // Adding to offerListUI
        UIHelper.getHandler(context, SearchHandler.class).addAndPersistCriteria(context, thesaurus.getBean());

        ui.validate();
    }

    public void addThesaurus(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        if (path != null) {
            // Get selected thesaurus
            NavigationTreeNode parentNode = (NavigationTreeNode) path.getLastPathComponent();

            // Remove selected from parent
            helper.getBuilder().removeNodeFromParent(context, parentNode);

            // Creating new root
            VradiThesaurusDTO thesaurusParent = (VradiThesaurusDTO) parentNode.getBean(context);

            OfferEditUI ui = getEditUI(context);
            addThesaurus(context, thesaurusParent, true, true);
        }
    }

    public void refreshAllThesaurus(JAXXContext context) {
        List<OfferEditUI> editUIs = VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(VradiContext.get());
        if (log.isDebugEnabled()) {
            log.debug("Refresh ui : " + (editUIs == null ? "is null" : editUIs.size()));
        }
        if (editUIs != null) {
            for (OfferEditUI editUI : editUIs) {
                if (log.isDebugEnabled()) {
                    log.debug("Refresh ui : " + editUI.getData().getName());
                }
                OfferEditHandler offerEditHandler = UIHelper.getHandler(context, OfferEditHandler.class);
                offerEditHandler.initThesaurus(context, editUI);

                editUI.validate();
            }
        }
    }

    // Creating child thesorus instance
    public void addThesaurus(JAXXContext context, VradiThesaurusDTO root, boolean deletable, boolean save) {
        if (root != null) {
            ThesaurusUI thesaurusChildUI = new ThesaurusUI(context, root);

            thesaurusChildUI.setDeletable(deletable);

            getThesaurusContainer(context).add(thesaurusChildUI);

            // Save in properties
            if (save) {
                VradiHelper.addVradiListThesaurus(root.getBean());
            }

            getUI(context).validate();
        }
    }

    public void addColumn(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        // Get selected thesaurus
        NavigationTreeNode node = getParentNode(helper, path);

        // Creating new root
        VradiThesaurusDTO thesaurus = (VradiThesaurusDTO) node.getBean(context);

        // Save in properties
        VradiHelper.addVradiListColumns(thesaurus.getBean());

        // Refresh model
        getListUI(context).updateTableModel();
    }

    // Remove child thesorus instance
    public void closeThesaurus(ThesaurusUI thesaurus) {
        getThesaurusContainer(thesaurus).remove(thesaurus);

        // Save in properties
        VradiThesaurusDTO selected = (VradiThesaurusDTO) thesaurus.helper.getRootNode().getBean();
        VradiHelper.removeVradiListThesaurus(selected.getBean());

        refreshAllThesaurus(thesaurus);
    }

    protected JPanel getThesaurusContainer(JAXXContext context) {
        return getUI(context).getParentContainer(OfferEditUI.class).getThesaurus();
    }

    public String selectPath(JAXXContext context, VradiThesaurusDTO bean) {
        return null;
    }
}
