package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.VradiHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;

import java.io.InputStream;

/**
 * Created by IntelliJ IDEA.
 * User: morin
 * Date: 26 nov. 2009
 * Time: 14:00:48
 * To change this template use File | Settings | File Templates.
 */
public class ChangeLogHandler {

    private static Log log = LogFactory.getLog(ChangeLogHandler.class);

    public static final String CHANGELOG_FILE
            = "com/jurismarches/vradi/changelog.txt";
    public static final String CHANGELOG_VERSION_SEPARATOR = "\n---- ";

    public String getLatestChangeLog() {
        String content = loadSource();
        String[] versionChangeLogs = content.split(CHANGELOG_VERSION_SEPARATOR);
        log.debug(versionChangeLogs[0]);
        String lastVersion = versionChangeLogs[0]
                .replace(CHANGELOG_VERSION_SEPARATOR.substring(1), "")
                .split("\\s")[0].trim();
        log.debug(lastVersion);
        return versionChangeLogs[0];
    }

    public String getChangeLog() {
        StringBuffer result = new StringBuffer();
        String content = loadSource();
        String[] versionChangeLogs = content.split(CHANGELOG_VERSION_SEPARATOR);
        log.debug(versionChangeLogs[0]);
        String lastVersion = versionChangeLogs[0]
                .replace(CHANGELOG_VERSION_SEPARATOR.substring(1), "")
                .split("\\s")[0].trim();
        log.debug(lastVersion);
        if (VradiHelper.isVersionNewer(lastVersion)) {
            result.append(versionChangeLogs[0]);
            for (int i = 1; i < versionChangeLogs.length; i++) {
                log.debug(versionChangeLogs[i]);
                String version = versionChangeLogs[i].split("\\s")[0].trim();
                if (VradiHelper.isVersionNewer(version)) {
                    result.append(CHANGELOG_VERSION_SEPARATOR)
                            .append(versionChangeLogs[i]);
                } else {
                    break;
                }
            }
        }
        VradiHelper.setLastVersion(lastVersion);
        return result.toString();
    }

    public String loadSource() {
        try {
            InputStream changelogFile = getClass().getClassLoader()
                    .getResourceAsStream(CHANGELOG_FILE);
            String result = IOUtils.toString(changelogFile);
            log.debug(result);
            return result;
        } catch (Exception e) {
            log.error("could not load file " + CHANGELOG_FILE, e);
            return "could not load file " + CHANGELOG_FILE;
        }
    }
}
