/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.ui.DateFormTypeFilterHandler;
import com.jurismarches.vradi.ui.DateFormTypeFilterUI;
import com.jurismarches.vradi.ui.OfferEditHandler;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.OfferListTableModel;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import com.jurismarches.vradi.ui.VradiTabHeader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;

public class OfferListHandler {
    private static final Log log = LogFactory.getLog(OfferListHandler.class);

    public OfferListUI initUI(JAXXContext rootContext, VradiMainUIHandler rootHandler) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        DateFormTypeFilterHandler criteriaHandler = new DateFormTypeFilterHandler();
        DateFormTypeFilterUI criteriaUI = criteriaHandler.initUI(rootContext);
        context.add((Object)this);
        context.add((Object)criteriaHandler);
        context.add((Object)criteriaUI);
        OfferListUI ui = new OfferListUI((JAXXContext)context);
        ui.getCriteriaPanel().add((Component)criteriaUI, "Center");
        VradiContext.OFFERT_LIST_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        return ui;
    }

    public DateFormTypeFilterHandler getCriteriaHandler(JAXXContext context) {
        return (DateFormTypeFilterHandler)context.getContextValue(DateFormTypeFilterHandler.class);
    }

    public OfferListTableModel getOfferListTableModel() {
        ArrayList<Form> forms = new ArrayList();
        GregorianCalendar now = new GregorianCalendar();
        now.set(10, 0);
        now.set(12, 0);
        now.set(14, 0);
        try {
            forms = ServiceHelper.getVradiStorageService().findForms(null, null, null, now.getTime(), now.getTime(), null);
        }
        catch (TechnicalException eee) {
            log.error((Object)"Cant find forms for this day ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        OfferListTableModel model = new OfferListTableModel(forms);
        return model;
    }

    public void addEditPane(JAXXContext context, final Form data) {
        final OfferListUI ui = this.getUI(context);
        ui.setDividerLocation(0);
        ui.setResizeWeight(0.0);
        ui.setDividerSize(10);
        JTabbedPane contentTabbedPane = ui.getEditTabs();
        String id = data.getWikittyId();
        if (contentTabbedPane.indexOfTab(id) < 0) {
            final OfferEditHandler handler = new OfferEditHandler();
            final OfferEditUI editUi = handler.initUI(context, data);
            contentTabbedPane.add(id, editUi);
            final VradiTabHeader panel = new VradiTabHeader();
            panel.getLabel().setText(data.getName());
            panel.setId(id);
            contentTabbedPane.setTabComponentAt(contentTabbedPane.indexOfTab(id), (Component)((Object)panel));
            panel.getCloseTab().addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    OfferListHandler.this.closePane(panel);
                }
            });
            panel.getDetachTab().addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    OfferListHandler.this.detachPane(e);
                }
            });
            editUi.getAnnuler().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OfferListHandler.this.closePane(panel);
                }
            });
            editUi.getValidate().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    handler.save((JAXXContext)editUi, data);
                    OfferListHandler.this.closePane(panel);
                    ui.getHandler().executeQuery(ui);
                }
            });
        }
        contentTabbedPane.setSelectedIndex(contentTabbedPane.indexOfTab(id));
    }

    protected VradiTabHeader getTabHeader(MouseEvent e) {
        JButton button = (JButton)e.getSource();
        return (VradiTabHeader)((Object)button.getParent());
    }

    protected void closePane(VradiTabHeader mytab) {
        OfferListUI ui = mytab.getParentContainer(OfferListUI.class);
        String id = mytab.getId();
        JTabbedPane contentTabbedPane = this.getContentPane(ui);
        contentTabbedPane.remove(contentTabbedPane.indexOfTab(id));
        this.allEditPanelRemoved(contentTabbedPane, ui);
    }

    private void removeEditPaneFromRef(OfferEditUI ui) {
        ((List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get())).remove(ui);
    }

    protected void detachPane(MouseEvent e) {
        VradiTabHeader mytab = this.getTabHeader(e);
        String id = mytab.getId();
        String name = mytab.getLabel().getText();
        OfferListUI ui = mytab.getParentContainer(OfferListUI.class);
        JTabbedPane contentTabbedPane = this.getContentPane(ui);
        final OfferEditUI content = this.getOfferEdit(contentTabbedPane, id);
        final JFrame frame = new JFrame(name);
        content.getValidate().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfferListHandler.this.closeDetachedPane(frame, content);
            }
        });
        content.getAnnuler().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfferListHandler.this.closeDetachedPane(frame, content);
            }
        });
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                OfferListHandler.this.closeDetachedPane(frame, content);
            }
        });
        frame.setLayout(new BorderLayout());
        frame.add((Component)content, "Center");
        frame.setVisible(true);
        frame.setSize(new Dimension(800, 800));
        this.allEditPanelRemoved(contentTabbedPane, ui);
    }

    protected OfferEditUI getOfferEdit(JTabbedPane contentTabbedPane, String id) {
        return (OfferEditUI)contentTabbedPane.getComponentAt(contentTabbedPane.indexOfTab(id));
    }

    protected void closeDetachedPane(JFrame f, OfferEditUI ui) {
        f.dispose();
        this.removeEditPaneFromRef(ui);
    }

    public void addEditPane(JAXXContext context, List<Form> datas) {
        for (Form data : datas) {
            this.addEditPane(context, data);
        }
    }

    protected void allEditPanelRemoved(JTabbedPane contentTabbedPane, OfferListUI ui) {
        if (contentTabbedPane.getTabCount() == 0) {
            ui.setDividerLocation(Integer.MAX_VALUE);
            ui.setResizeWeight(1.0);
            ui.setDividerSize(0);
        }
    }

    OfferListUI getUI(JAXXContext context) {
        if (context instanceof OfferListUI) {
            return (OfferListUI)context;
        }
        OfferListUI ui = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    JTabbedPane getContentPane(JAXXContext context) {
        OfferListUI ui = this.getUI(context);
        return ui.getEditTabs();
    }

    JTabbedPane getContentPane(OfferListUI ui) {
        return ui.getEditTabs();
    }

    protected void selectOffer(JAXXContext context) {
        JTable listTable = this.getUI((JAXXContext)context).listTable;
        int selectedRow = listTable.getSelectedRow();
        selectedRow = listTable.convertRowIndexToModel(selectedRow);
        this.edit(context, selectedRow, this.getUI((JAXXContext)context).offerListTableModel);
    }

    protected void edit(JAXXContext context, int i, OfferListTableModel model) {
        Form data = null;
        data = model.getDatas().get(i);
        log.debug((Object)("Form selected : " + data));
        if (data != null) {
            this.addEditPane(context, data);
        }
    }

    public void executeQuery(OfferListUI ui) {
        String query = ui.getRequest().getText().trim();
        DateFormTypeFilterUI criterias = null;
        DateFormTypeFilterHandler criteriasHandler = (DateFormTypeFilterHandler)VradiContext.CRITERIA_HANDLER_ENTRY_DEF.getContextValue((JAXXContext)ui);
        OfferListTableModel listTableModel = ui.getOfferListTableModel();
        JComboBox combo = ui.getRequests();
        if (!ui.isAdvencedSearchCollapsed().booleanValue()) {
            criterias = (DateFormTypeFilterUI)VradiContext.CRITERIA_UI_ENTRY_DEF.getContextValue((JAXXContext)ui);
        }
        criteriasHandler.executeQuery((JAXXContext)ui, criterias, listTableModel, combo, query);
    }

    public ComboBoxModel getRequestModel() {
        return new DefaultComboBoxModel();
    }

    public List<String> loadRequests() {
        return VradiHelper.loadRequests();
    }

    public void removeColumn(JAXXContext context, TreeNode thesaurus) {
        VradiHelper.removeVradiListColumns(thesaurus);
        this.getUI(context).updateTableModel();
    }
}

