/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.ui.DateFormTypeFilterUI;
import com.jurismarches.vradi.ui.OfferListTableModel;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.Thesaurus;
import com.jurismarches.vradi.ui.VradiCriteriaField;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

public class DateFormTypeFilterHandler {
    private static final Log log = LogFactory.getLog(DateFormTypeFilterHandler.class);

    public DateFormTypeFilterUI initUI(JAXXContext rootContext) {
        DateFormTypeFilterUI ui = this.getUI(rootContext);
        if (ui == null) {
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
            context.add((Object)this);
            ui = new DateFormTypeFilterUI((JAXXContext)context);
            this.initCriteria((JAXXContext)ui);
            VradiContext.CRITERIA_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
            VradiContext.CRITERIA_HANDLER_ENTRY_DEF.setContextValue(rootContext, (Object)this);
        }
        return ui;
    }

    public DateFormTypeFilterUI initCloneUI(JAXXContext rootContext) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        context.add((Object)this);
        DateFormTypeFilterUI ui = new DateFormTypeFilterUI((JAXXContext)context);
        this.initCriteria((JAXXContext)ui);
        return ui;
    }

    public DateFormTypeFilterUI getUI(JAXXContext context) {
        if (context instanceof DateFormTypeFilterUI) {
            return (DateFormTypeFilterUI)context;
        }
        return (DateFormTypeFilterUI)VradiContext.CRITERIA_UI_ENTRY_DEF.getContextValue(context);
    }

    protected JPanel getCriteriaPanel(JAXXContext context) {
        return this.getUI(context).getCriterias();
    }

    public void initCriteria(JAXXContext context) {
        this.getCriteriaPanel(context).removeAll();
        TreeNode root = null;
        try {
            root = ServiceHelper.getVradiStorageService().getRootThesaurus();
        }
        catch (TechnicalException e) {
            log.error((Object)"Cant get rootThesaurus : ", (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        this.addCriteria(context, root, false);
        for (String value : VradiHelper.getVradiListCriteria()) {
            this.addCriteria(context, value, true);
        }
    }

    public void removeCriteria(JAXXContext context, VradiCriteriaField criteriaField) {
        this.getCriteriaPanel(context).remove((Component)((Object)criteriaField));
        this.getUI(context).validate();
    }

    public void removeCriteriaAndPersist(JAXXContext context, TreeNode bean) {
        VradiCriteriaField criteriaField = (VradiCriteriaField)context;
        VradiHelper.removeVradiListCriteria(bean);
        this.removeCriteria(context, criteriaField);
        this.getUI(context).validate();
    }

    public void addAndPersistCriteria(JAXXContext context, TreeNode node) {
        VradiHelper.addVradiListCriteria(node);
        this.addCriteria(context, node, true);
    }

    protected void addCriteria(JAXXContext context, String wikittyId, boolean deletable) {
        TreeNode criteria = null;
        try {
            criteria = ServiceHelper.getVradiStorageService().getThesaurus(wikittyId);
        }
        catch (TechnicalException e) {
            log.error((Object)("Cant get thesaurus : " + wikittyId), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        if (criteria != null) {
            this.addCriteria(context, criteria, deletable);
        }
    }

    protected void addCriteria(JAXXContext context, TreeNode criteria, boolean deletable) {
        Thesaurus thesCriteria = new Thesaurus(criteria);
        VradiCriteriaField criteriaField = new VradiCriteriaField(context);
        criteriaField.setLabelName(criteria.getName());
        criteriaField.setBean(criteria);
        criteriaField.setDeletable(deletable);
        JComboBox combo = criteriaField.getCombo();
        Thesaurus[] thesArray = new Thesaurus[thesCriteria.getChildren().size() + 1];
        for (int i = 1; i < thesArray.length; ++i) {
            thesArray[i] = (Thesaurus)thesCriteria.getChildren().toArray()[i - 1];
        }
        combo.setModel(new DefaultComboBoxModel<Thesaurus>(thesArray));
        combo.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        criteriaField.init();
        this.getCriteriaPanel(context).add((Component)((Object)criteriaField));
        this.getUI(context).validate();
    }

    protected List<String> getDateFormType(WikittyExtension formType) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Form.datePub");
        result.add("Form.datePeremption");
        if (formType != null) {
            for (String name : formType.getFieldNames()) {
                FieldType type = formType.getFieldType(name);
                if (type.getType() != FieldType.TYPE.DATE) continue;
                result.add(formType.getName() + "." + name);
            }
        }
        return result;
    }

    public void updateDateSelectionModel(DateFormTypeFilterUI ui) {
        WikittyExtension value = (WikittyExtension)ui.getFormTypeSelection().getSelectedItem();
        List<String> datas = this.getDateFormType(value);
        ui.getDateTypeSelection().setModel(new DefaultComboBoxModel<Object>(datas.toArray()));
        ui.validate();
    }

    public void executeQuery(JAXXContext context, DateFormTypeFilterUI criterias, OfferListTableModel tableModel, JComboBox combo, String request) {
        List<Form> forms;
        String query = request.trim();
        if (criterias == null) {
            log.debug((Object)"filter collapsed");
            forms = VradiHelper.executeQuery(query, null, null, null, null, null);
        } else {
            Component[] thesaurusCriteria = criterias.getCriterias().getComponents();
            ArrayList[] thesaurus = new ArrayList[thesaurusCriteria.length];
            for (int i = 0; i < thesaurus.length; ++i) {
                Thesaurus th = (Thesaurus)((VradiCriteriaField)((Object)thesaurusCriteria[i])).getCombo().getSelectedItem();
                if (th == null) continue;
                thesaurus[i] = new ArrayList();
                thesaurus[i].add(th.getWikittyId());
                VradiHelper.getThesaurusChildren(th, thesaurus[i]);
            }
            forms = VradiHelper.executeQuery(query, (WikittyExtension)criterias.getFormTypeSelection().getSelectedItem(), (String)criterias.getDateTypeSelection().getSelectedItem(), criterias.getFromDate().getDate(), criterias.getToDate().getDate(), thesaurus);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Form found : " + forms.size()));
        }
        if (context instanceof OfferListUI) {
            VradiHelper.addRequestToProperties(query);
        }
        if (combo != null) {
            ((DefaultComboBoxModel)combo.getModel()).removeElement(request);
            combo.insertItemAt(request, 0);
            combo.setSelectedIndex(0);
        }
        tableModel.setDatas(forms);
    }
}

