/*
 * *##% 
 * vradi-swing
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.dto.VradiClientDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

import javax.swing.table.AbstractTableModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Le modèle du tableau pour afficher et éditer les bindings d'un flux XML.
 * <p/>
 * User: chemit
 * Date: 15 nov. 2009
 * Time: 16:56:08
 */
public class ClientEmailContentTableModel extends AbstractTableModel {

    private static final long serialVersionUID = 1L;

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(ClientEmailContentTableModel.class);

    /**
     * Liste des clients et formulaires à afficher
     */
    protected List<VradiSendingDTO> data;
    /**
     * Un drapeau pour bloquer le déclanchement des fireXXX)
     */
    protected boolean valueIsAdjusting;

    public ClientEmailContentTableModel() {
        data = new ArrayList<VradiSendingDTO>();
    }

    @Override
    public int getRowCount() {
        return data.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    /**
     * Pour vider le modèle.
     */
    public void clear() {
        data.clear();
        if (!valueIsAdjusting) {
            fireTableDataChanged();
        }
    }

    public boolean isValueIsAdjusting() {
        return valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }

    /**
     * @return une copie de la liste des bindings
     */
    public List<VradiSendingDTO> getData() {
        // always send a copy
        return new ArrayList<VradiSendingDTO>(data);
    }

    /**
     * Ajouter une entrée dans le modèle
     */
    public void addEntry(VradiSendingDTO formsByClientDTO) {
        if (log.isDebugEnabled()) {
            log.debug("adding client " + formsByClientDTO.getClientDTO().getName());
        }
//        String[] status = new String[forms.size()];
//        Arrays.fill(status, _("vradi.email.status.toSend"));
//        clientContent.status = Arrays.asList(status);
        data.add(formsByClientDTO);
        if (isValueIsAdjusting()) {
            int newIndex = data.size() - 1;
            fireTableRowsInserted(newIndex, newIndex);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ensureColumnIndex(columnIndex);
        ensureRowIndex(rowIndex);
        VradiSendingDTO value = data.get(rowIndex);
        Object result = null;
        switch (columnIndex) {
            case 0:
                result = value.getClientDTO();
                break;
            case 1:
                result = value.getFormDTOs();
                break;
            case 2:
                result = value.getParagraph();
                break;
            case 3:
                result = value.getStatus();
                break;
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ensureColumnIndex(columnIndex);
        ensureRowIndex(rowIndex);
        VradiSendingDTO value = data.get(rowIndex);
        switch (columnIndex) {
            case 0:
                value.setClientDTO((VradiClientDTO) aValue);
                break;
            case 1:
                value.setFormDTOs((List<Form>) aValue);
                break;
            case 2:
                value.setParagraph((String) aValue);
                break;
            case 3:
                value.setStatus((String) aValue);
                break;
        }
        fireTableCellUpdated(rowIndex, columnIndex);
    }


    protected void ensureRowIndex(int rowIndex) {
        if (rowIndex >= getRowCount()) {
            throw new ArrayIndexOutOfBoundsException("rowIndex (" + rowIndex + ") can not be greater than " + getRowCount());
        }
    }

    protected void ensureColumnIndex(int columnIndex) {
        if (columnIndex >= getColumnCount()) {
            throw new ArrayIndexOutOfBoundsException("columnIndex (" + columnIndex + ") can not be greater than " + getColumnCount());
        }
    }

}
