package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.ui.admin.content.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.Util;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.VradiContext;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.EntityComboBox;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.n_;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.DataBindingListener;

public class AdminGroupUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<Group> {
    private static String $jaxxObjectDescriptor = "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";
    private static final long serialVersionUID = 1L;
    protected jaxx.runtime.swing.Table adminGroupForm;
    protected com.jurismarches.vradi.services.dto.VradiGroupDTO bean;
    protected jaxx.runtime.swing.ListSelectorUI< Client > groupClients;
    protected javax.swing.JTextField groupName;
    protected jaxx.runtime.swing.ListSelectorUI< User > groupUsers;
    protected com.jurismarches.vradi.ui.admin.content.RequestListUI requestListUI;
    private AdminGroupUI $AdminContentUI0 = this;
    private jaxx.runtime.swing.HidorButton $HidorButton5;
    private javax.swing.JButton $JButton3;
    private javax.swing.JButton $JButton4;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JLabel $JLabel7;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JPanel $JPanel2;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    private PropertyChangeListener $DataSource10 = new DataBindingListener(this, "$JLabel1.text");
    private PropertyChangeListener $DataSource12 = new DataBindingListener(this, "$JButton4.enabled");
    private PropertyChangeListener $DataSource17 = new DataBindingListener(this, "groupName.text");
    private PropertyChangeListener $DataSource9 = new DataBindingListener(this, "$AdminContentUI0.enabled");

    /* begin raw body code */    
    
    void $afterCompleteSetup() {
        addPCSLogger();
        addBeanPCSLogger(bean);
        addBeanModifiedPCS(bean);
        groupClients.addPropertyChangeListener("modified", new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from clients");
                    setModified(true);
                }
            }
        });
        groupUsers.addPropertyChangeListener("modified", new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from users");
                    setModified(true);
                }
            }
        });
    }
    
    @Override
    public void openUI(NavigationTreeNode node) throws Exception {
        super.openUI(node);
        requestListUI.init();
    
        java.util.List<Client> toClientCombo = getHandler().getAllClients(this);
        java.util.List<Client> toClientList = new java.util.ArrayList<Client>(toClientCombo);
    
        for (java.util.Iterator<Client> it = toClientList.iterator(); it.hasNext();) {
            Client client = it.next();
            if (bean.getClient() == null || !bean.getClient().contains(client.getWikittyId())) {
                it.remove();
                if (log.isDebugEnabled()) {
                    log.debug("group does NOT use client " + client.getName());
                }
            } else {
                toClientCombo.remove(client);
                if (log.isDebugEnabled()) {
                    log.debug("group use client " + client.getName());
                }
            }
        }
        groupClients.init(toClientCombo, toClientList);
    
        java.util.List<User> toUserCombo = getHandler().getAllUsers(this);
        java.util.List<User> toUserList = new java.util.ArrayList<User>(toUserCombo);
    
        for (java.util.Iterator<User> it = toUserList.iterator(); it.hasNext();) {
            User user = it.next();
            if (bean.getUser() == null || !bean.getUser().contains(user.getWikittyId())) {
                it.remove();
                if (log.isDebugEnabled()) {
                    log.debug("group does NOT use user " + user.getName());
                }
            } else {
                toUserCombo.remove(user);
                if (log.isDebugEnabled()) {
                    log.debug("group use user " + user.getName());
                }
            }
        }
        groupUsers.init(toUserCombo, toUserList);
    }
    
    @Override
    public void save() {
        if (log.isDebugEnabled()) {
            log.debug("===================================================================================");
            log.debug("group to save " + bean.getName());
        }
        bean.clearClient();
        for (Client client : groupClients.getListDatas()) {
            if (log.isDebugEnabled()) {
                log.debug("add client " + client.getName() + " to group");
            }
            bean.addClient(client.getWikittyId());
        }
        bean.clearUser();
        for (User user : groupUsers.getListDatas()) {
            if (log.isDebugEnabled()) {
                log.debug("add user " + user.getName() + " to group");
            }
            bean.addUser(user.getWikittyId());
        }
    
        Group bean = (Group) getHelper().getSelectedBean(this);
        this.bean.toWikitty(bean);
        getHandler().save(bean);
        getHelper().reloadGroup(this, getHelper().getSelectedNode(this), bean);
        groupClients.setModified(false);
        groupUsers.setModified(false);
        if (log.isDebugEnabled()) {
            log.debug("===================================================================================");
        }
    }
    
    @Override
    protected void updateBeanFromEntity(Group bean) {
        this.bean.fromWikitty(bean);
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminGroup.title", getStringValue(name));
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public AdminGroupUI() {
        super();
        $initialize();
    }

    public AdminGroupUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ("$AdminContentUI0.enabled".equals($binding)) {    
            if (bean != null) {
                bean.addPropertyChangeListener("wikittyId", $DataSource9);
            }
        } else if ("$JLabel1.text".equals($binding)) {    
            if (bean != null) {
                bean.addPropertyChangeListener("name", $DataSource10);
            }
        } else if ("$JButton4.enabled".equals($binding)) {    
            addPropertyChangeListener("enabled", $DataSource12);
        } else if ("groupName.text".equals($binding)) {    
            if (bean != null) {
                bean.addPropertyChangeListener("name", $DataSource17);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    @Override
    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$AdminContentUI0.enabled".equals($dest)) {
                if (bean != null) {
                    setEnabled(bean.getWikittyId() != null);
                }
            } else if ("$JLabel1.text".equals($dest)) {
                if (bean != null) {
                    $JLabel1.setText(_(updateTitle(bean.getName())));
                }
            } else if ("$JButton4.enabled".equals($dest)) {
                $JButton4.setEnabled(isEnabled());
            } else if ("groupName.text".equals($dest)) {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(groupName, getStringValue(bean.getName()));
                }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ("$AdminContentUI0.enabled".equals($binding)) {    
            if (bean != null) {
                bean.removePropertyChangeListener("wikittyId", $DataSource9);
            }
        } else if ("$JLabel1.text".equals($binding)) {    
            if (bean != null) {
                bean.removePropertyChangeListener("name", $DataSource10);
            }
        } else if ("$JButton4.enabled".equals($binding)) {    
            removePropertyChangeListener("enabled", $DataSource12);
        } else if ("groupName.text".equals($binding)) {    
            if (bean != null) {
                bean.removePropertyChangeListener("name", $DataSource17);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton3(java.awt.event.ActionEvent event) {
        getHandler().createGroup(this, getHelper());setModified(true);
    }

    public void doActionPerformed__on__$JButton4(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), bean);
    }

    public void doKeyReleased__on__groupName(java.awt.event.KeyEvent event) {
        bean.setName(groupName.getText());
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminGroupForm() {
        return adminGroupForm;
    }

    public com.jurismarches.vradi.services.dto.VradiGroupDTO getBean() {
        return bean;
    }

    public jaxx.runtime.swing.ListSelectorUI< Client > getGroupClients() {
        return groupClients;
    }

    public javax.swing.JTextField getGroupName() {
        return groupName;
    }

    public jaxx.runtime.swing.ListSelectorUI< User > getGroupUsers() {
        return groupUsers;
    }

    public com.jurismarches.vradi.ui.admin.content.RequestListUI getRequestListUI() {
        return requestListUI;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected jaxx.runtime.swing.HidorButton get$HidorButton5() {
        return $HidorButton5;
    }

    protected javax.swing.JButton get$JButton3() {
        return $JButton3;
    }

    protected javax.swing.JButton get$JButton4() {
        return $JButton4;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JPanel get$JPanel2() {
        return $JPanel2;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToToolbar();
        // inline complete setup of $JPanel2
        $JPanel2.add($JButton3);
        $JPanel2.add($JButton4);
        $JPanel2.add($HidorButton5);
        addChildrenToBody();
        addChildrenToAdminGroupForm();
        // init data bindings
        applyDataBinding("$AdminContentUI0.enabled");
        applyDataBinding("$JLabel1.text");
        $JButton4.setIcon(jaxx.runtime.Util.getUIManagerActionIcon("delete"));
        applyDataBinding("$JButton4.enabled");
        $HidorButton5.setCollapseTip(_("vradi.adminGroup.hideForm"));
        $HidorButton5.setExpandTip(_("vradi.adminGroup.showForm"));
        $HidorButton5.setTarget(adminGroupForm);
        $HidorButton5.setTargetVisible(true);
        applyDataBinding("groupName.text");
        groupClients.setAddToComboTip(_("vradi.adminGroup.removeClient"));
        groupClients.setAddToListTip(_("vradi.adminGroup.addClient"));
        groupClients.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        groupUsers.setAddToComboTip(_("vradi.adminGroup.removeGroup"));
        groupUsers.setAddToListTip(_("vradi.adminGroup.addUser"));
        groupUsers.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        requestListUI.setBean(bean);
        $JLabel1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        $JLabel1.setFont(new Font("Serif", Font.BOLD, 26));
        $JLabel1.setHorizontalTextPosition(JLabel.LEFT);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new javax.swing.JPanel());
        $JPanel2.setName("$JPanel2");
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new javax.swing.JButton());
        $JButton3.setName("$JButton3");
        $JButton3.setText(_("vradi.adminGroup.createGroup"));
        $JButton3.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new javax.swing.JButton());
        $JButton4.setName("$JButton4");
        $JButton4.setToolTipText(_("vradi.adminClient.deleteGroup"));
        $JButton4.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $HidorButton5
        $objectMap.put("$HidorButton5", $HidorButton5 = new jaxx.runtime.swing.HidorButton());
        $HidorButton5.removeDataBinding("hidor.name");
        $HidorButton5.setName("$HidorButton5");
        $HidorButton5.removeDataBinding("hidor.collapseTip");
        $HidorButton5.removeDataBinding("hidor.expandTip");
        $HidorButton5.removeDataBinding("hidor.target");
        $HidorButton5.removeDataBinding("hidor.targetVisible");
        createAdminGroupForm();
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new javax.swing.JLabel());
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("vradi.adminGroup.name"));
        createGroupName();
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new javax.swing.JLabel());
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("vradi.adminGroup.listClients"));
        createGroupClients();
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new javax.swing.JLabel());
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("vradi.adminGroup.listUsers"));
        createGroupUsers();
        createRequestListUI();
        // inline creation of $AdminContentUI0
        removeDataBinding("$JPanel0.name");
        setName("$AdminContentUI0");
        removeDataBinding("$JPanel0.enabled");
        ((javax.swing.JPanel) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        $completeSetup();
    }

    protected void addChildrenToAdminGroupForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminGroupForm.add($JLabel6, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(groupName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add($JLabel7, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(groupClients, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add($JLabel8, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(groupUsers, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminGroupForm, BorderLayout.NORTH);
        body.add(requestListUI, BorderLayout.CENTER);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createAdminGroupForm() {
        $objectMap.put("adminGroupForm", adminGroupForm = new jaxx.runtime.swing.Table());
        adminGroupForm.setName("adminGroupForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.services.dto.VradiGroupDTO());
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createGroupClients() {
        $objectMap.put("groupClients", groupClients = new jaxx.runtime.swing.ListSelectorUI< Client >());
        groupClients.removeDataBinding("$JPanel0.name");
        groupClients.setName("groupClients");
        groupClients.removeDataBinding("$JPanel0.addToComboTip");
        groupClients.removeDataBinding("$JPanel0.addToListTip");
        groupClients.removeDataBinding("$JPanel0.renderer");
        groupClients.removeDataBinding("$JPanel0.showHidor");
        groupClients.setShowHidor(true);
        ((javax.swing.JToolBar) groupClients.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) groupClients.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createGroupName() {
        $objectMap.put("groupName", groupName = new javax.swing.JTextField());
        groupName.setName("groupName");
        groupName.setColumns(15);
        groupName.addKeyListener(Util.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__groupName"));
    }

    protected void createGroupUsers() {
        $objectMap.put("groupUsers", groupUsers = new jaxx.runtime.swing.ListSelectorUI< User >());
        groupUsers.removeDataBinding("$JPanel0.name");
        groupUsers.setName("groupUsers");
        groupUsers.removeDataBinding("$JPanel0.addToComboTip");
        groupUsers.removeDataBinding("$JPanel0.addToListTip");
        groupUsers.removeDataBinding("$JPanel0.renderer");
        groupUsers.removeDataBinding("$JPanel0.showHidor");
        groupUsers.setShowHidor(true);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createRequestListUI() {
        $objectMap.put("requestListUI", requestListUI = new com.jurismarches.vradi.ui.admin.content.RequestListUI(this));
        requestListUI.removeDataBinding("$JPanel0.name");
        requestListUI.setName("requestListUI");
        requestListUI.removeDataBinding("$JPanel0.bean");
    }

    @Override
    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new jaxx.runtime.swing.Table());
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

}