package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.XmlStreamService;
import com.jurismarches.vradi.services.dto.VradiXmlStreamDTO;
import com.jurismarches.vradi.ui.*;
import com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI;
import com.jurismarches.vradi.ui.admin.content.FieldSelectUI;
import com.jurismarches.vradi.ui.admin.content.RequestSelectUI;
import com.jurismarches.vradi.ui.admin.content.XmlStreamFieldTableModel;
import com.jurismarches.vradi.ui.editors.JListCellEditor;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.*;

import javax.swing.*;
import java.awt.*;
import java.util.*;
import java.util.List;

/**
 * @author letellier
 */
public class AdminHandler {

    /**
     * to use log facility, just put in your code: log.info(\"...\");
     */
    static private final Log log = LogFactory.getLog(AdminHandler.class);

    protected Map<String, List<String>> xmlStreamFields = new HashMap<String, List<String>>();

    AdminPopupUI getUI(JAXXContext context) {
        if (context instanceof AdminPopupUI) {
            return (AdminPopupUI) context;
        }
        AdminPopupUI ui = VradiContext.ADMIN_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

//    OfferListUI getOfferListUI(JAXXContext context) {
//        return VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
//    }

    void close(JAXXContext context) {
        AdminPopupUI ui = getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    protected VradiStorageService getVradiStorageService() {
        return ServiceHelper.getVradiStorageService();
    }

    protected XmlStreamService getXmlStreamService() {
        return ServiceHelper.getXmlStreamService();
    }

    // COMMON
    protected boolean answerToDelete(JAXXContext context, String name) {
        AdminPopupUI ui = getUI(context);

        int n = JOptionPane.showConfirmDialog(ui, _("vradi.admin.deleteAnswer") + name + " ?", _("vradi.admin.deleteTitle"), JOptionPane.YES_NO_OPTION);

        return n == JOptionPane.OK_OPTION;
    }

    protected void repaintSelectedNode(JAXXContext context, VradiNavigationTreeHelper helper) {
        helper.repaintNode(context, getSelectedNode(context, helper));
    }

    protected NavigationTreeNode getSelectedNode(JAXXContext context, VradiNavigationTreeHelper helper) {
        return helper.getSelectedNode(context);
    }

    public void save(Object bean) {
        BusinessEntity entity = (BusinessEntity) bean;
        try {
            // up
            getVradiStorageService().updateEntity(entity);
        } catch (TechnicalException ex) {
            log.error("Cant saving bean : " + entity + " id : " + entity.getWikittyId() + " caused by : " + ex);
            ErrorDialogUI.showError(ex);
        }
    }

    public void save(JAXXContext context, VradiNavigationTreeHelper helper, Object... beans) {
        try {
            for (Object bean : beans) {
                log.info("will save bean " + bean);
                save(bean);
            }

        } finally {

            // Refresh nav
            repaintSelectedNode(context, helper);
        }
    }

    public boolean answerToSave(AdminThesaurusUI content) {
        if (content != null) {

            log.info("current content  to close " + content.getClass().getSimpleName() + " : " + content.isModified());
            if (content.isModified()) {
                int n = JOptionPane.showConfirmDialog(content, _("vradi.admin.saveThesaurusAnswer") + " ?", _("vradi.admin.saveTitle"), JOptionPane.YES_NO_CANCEL_OPTION);
                switch (n) {
                    case JOptionPane.NO_OPTION:
                        // annule les modifications
                        cancelThesaurus(content, content.getHelper());
                        break;
                    case JOptionPane.OK_OPTION:
                        // sauvegarde les modifications
                        saveThesaurus(content, content.getHelper());
                        break;
                    case JOptionPane.CANCEL_OPTION:
                        // annule le changement d'onglet
                        return false;

                }
            }
        }
        return true;
    }

    public boolean answerToSave(AdminContentUI<?> content) {
        if (content != null) {

            log.info("current content  to close " + content.getClass().getSimpleName() + " : " + content.isModified());
            if (content.isModified()) {
                int n = JOptionPane.showConfirmDialog(content, _("vradi.admin.saveAnswer") + VradiHelper.getEntityName(content.getBean()) + " ?", _("vradi.admin.saveTitle"), JOptionPane.YES_NO_CANCEL_OPTION);
                switch (n) {
                    case JOptionPane.NO_OPTION:
                        // annule les modifications
                        cancel(content, content.getHelper());
                        break;
                    case JOptionPane.OK_OPTION:
                        // sauvegarde les modifications
                        content.postSave();
                        break;
                    case JOptionPane.CANCEL_OPTION:
                        // annule le changement d'onglet
                        return false;

                }
            }
        }
        return true;
    }

    public void delete(JAXXContext context, VradiNavigationTreeHelper helper, Object bean) {
        BusinessEntity entity = (BusinessEntity) bean;
        try {
            // up
            getVradiStorageService().deleteEntity(entity);

        } catch (TechnicalException ex) {
            log.error("Cant delete bean : " + entity + " id : " + entity.getWikittyId() + " caused by : " + ex);
            ErrorDialogUI.showError(ex);
        } finally {

            // remove node
            NavigationTreeNode parent = helper.removeChildNode(helper.getSelectedNode(context));

            // select parent node
            helper.selectNode(context, parent);
        }
    }

    protected <B> void cancel(AdminContentUI<B> content, VradiNavigationTreeHelper helper) {
        B selectedBean = content.getSelectedEntity();
        try {
            content.openUI(helper.getSelectedNode(content));
        } catch (Exception e) {
            log.error("Cant cancel bean : " + selectedBean + " caused by : " + e, e);
            ErrorDialogUI.showError(e);
        }
    }

    // MODELS
    public OfferListTableModel getResultTableModel(List<Form> forms) {
        OfferListTableModel model = new OfferListTableModel(forms);
        return model;
    }

    public ComboBoxModel getTypesModel() {
        ComboBoxModel model = new FieldTypeModel();
        return model;
    }

//    public ComboBoxModel getEntitiesComboBoxModel(List entities) {
//        return new DefaultComboBoxModel(entities.toArray());
//    }

    // THESAURUS
    public void refreshAllThesaurus(JAXXContext context) {
        List<OfferEditUI> editUIs = VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(VradiContext.get());
        if (log.isDebugEnabled()) {
            log.debug("Refresh ui : " + (editUIs == null ? "is null" : editUIs.size()));
        }
        if (editUIs != null) {
            for (OfferEditUI editUI : editUIs) {
                if (log.isDebugEnabled()) {
                    log.debug("Refresh ui : " + editUI.getData().getName());
                }
                OfferEditHandler offerEditHandler = new OfferEditHandler();
                offerEditHandler.initThesaurus(context, editUI);
            }
        }
    }

    public Thesaurus getRootThesaurus() {
        try {
            return new Thesaurus(ServiceHelper.getVradiStorageService().getRootThesaurus());
        } catch (TechnicalException e) {
            log.error("Cant get root thesaurus : ", e);
            ErrorDialogUI.showError(e);
        }
        return null;
    }

    protected NavigationTreeNode getSelectedNode(JAXXContext context, ThesaurusTreeHelper helper) {
        // Get selected thesaurus
        NavigationTreeNode selectedNode = helper.getSelectedNode(context);
        if (selectedNode == null) {
            selectedNode = helper.getRootNode();
        }
        return selectedNode;
    }

    public boolean addChildThesaurusToSelected(JAXXContext context, ThesaurusTreeHelper helper, boolean isRoot) {
        NavigationTreeNode parentNode = getSelectedNode(context, helper);
        if (isRoot) {
            parentNode = helper.getRootNode();
        }
        return addChildThesaurus(context, helper, parentNode);
    }

    public boolean renameThesaurusSelected(JAXXContext context, ThesaurusTreeHelper helper) {
        NavigationTreeNode selectedNode = getSelectedNode(context, helper);
        NavigationTreeNode parentNode = selectedNode.getParent();

        Thesaurus selected = (Thesaurus) selectedNode.getBean(context);

        // Ask name
        // TODO : Voir les impacts et difuser la modif
        String name = JOptionPane.showInputDialog(getUI(context), _("vradi.thesaurus.askRenameName"));

        // If name is not empty
        if (name != null && !name.isEmpty()) {

            // Tag to delete
            selected.setName(name);
            selected.setToSave(true);

            selectedNode.setBean(selected);
            helper.repaintNode(context, selectedNode);

            helper.expendNode(context, selectedNode);
            return true;
        }
        return false;
    }

    public boolean deleteThesaurusSelected(JAXXContext context, ThesaurusTreeHelper helper) {
        NavigationTreeNode selectedNode = getSelectedNode(context, helper);

        Thesaurus selected = (Thesaurus) selectedNode.getBean(context);

        // TODO : Voir les impacts et difuser la modif
        int result = JOptionPane.showConfirmDialog(getUI(context), _("vradi.thesaurus.askdeleteThesaurus") + selected.getRecursifName());

        if (result == JOptionPane.OK_OPTION) {

            selected.setToDelete(true);

            helper.getBuilder().removeNodeFromParent(context, selectedNode);

            return true;
        }
        return false;
    }

    protected void deleteThesaurus(Thesaurus toDelete) {
        try {
            ServiceHelper.getVradiStorageService().deleteEntity(toDelete.getBean());
        } catch (TechnicalException e) {
            log.error("Cant delete thesaurus : " + toDelete.getName() + " id : " + toDelete.getWikittyId(), e);
            ErrorDialogUI.showError(e);
        }
    }

    protected boolean addChildThesaurus(JAXXContext context, ThesaurusTreeHelper helper, NavigationTreeNode parentNode) {
        // Ask name
        String name = JOptionPane.showInputDialog(getUI(context), _("vradi.thesaurus.askName"));

        // If name is not empty
        if (name != null && !name.isEmpty()) {

            return addChildThesaurus(context, helper, parentNode, name) != null;
        }
        return false;
    }

    protected NavigationTreeNode addChildThesaurus(JAXXContext context, ThesaurusTreeHelper helper, NavigationTreeNode parentNode, String name) {
        // If name is not empty
        if (name != null && !name.isEmpty()) {

            // Add new to parent
            Thesaurus thesaurusParent = (Thesaurus) parentNode.getBean(context);
            TreeNode treeNodeParent = thesaurusParent.getBean();

            // Creating child
            TreeNode newTreeNode = new TreeNodeImpl();
            newTreeNode.setName(name);

            // Add child to parent treeNode
            treeNodeParent.addChildren(newTreeNode.getWikittyId());
            newTreeNode.setParent(treeNodeParent.getWikittyId());

            // Add child to parent thesaurus
            Thesaurus newThesaurus = new Thesaurus(newTreeNode);
            newThesaurus.setParent(treeNodeParent);
            thesaurusParent.addChild(newThesaurus);

            newThesaurus.setToSave(true);

            NavigationTreeNode newNode = helper.getBuilder().addThesaurus(context, parentNode, newThesaurus);
            helper.expendNode(context, parentNode);
            return newNode;
        }
        return null;
    }

    public void cancelThesaurus(JAXXContext context, ThesaurusTreeHelper helper) {
        NavigationTreeNode node = helper.getRootNode();
        cancelThesaurus(context, helper, node);
    }

    public void cancelThesaurus(JAXXContext context, ThesaurusTreeHelper helper, NavigationTreeNode node) {
        Thesaurus bean = (Thesaurus) node.getBean();
        if (bean.isToSave()) {
            // Remove node
            helper.getBuilder().removeNodeFromParent(context, node);
        } else {
            // Find in child
            Enumeration<NavigationTreeNode> children = node.children();
            while (children.hasMoreElements()) {
                NavigationTreeNode child = children.nextElement();
                cancelThesaurus(context, helper, child);
            }
        }
    }

    public void saveThesaurus(JAXXContext context, ThesaurusTreeHelper helper) {
        Thesaurus root = (Thesaurus) helper.getRootNode().getBean(context);
        saveThesaurus(root);

        // Refresh criteria
        VradiContext.CRITERIA_HANDLER_ENTRY_DEF.getContextValue(context).initCriteria(context);

        refreshAllThesaurus(context);
    }

    protected void saveThesaurus(Thesaurus toSave) {
        // Get bean
        TreeNode bean = toSave.getBean();
        TreeNode parent = toSave.getParent();

        // Get storage service
        VradiStorageService service = ServiceHelper.getVradiStorageService();

        // To save
        if (toSave.isToSave()) {
            log.debug(parent + " " + bean);
            // Adding to parent
            parent.addChildren(bean.getWikittyId());

            // Save
            try {
                bean = (TreeNode) service.updateEntity(bean);
                parent = (TreeNode) service.updateEntity(parent);
                log.debug("Saving thesaurus : " + bean.getName());
            } catch (TechnicalException ex) {
                log.error("Cant save thesaurus : " + bean.getName() + " id : "
                        + bean.getWikittyId() + " caused by : ", ex);
                ErrorDialogUI.showError(ex);
            }
            // Its save
            toSave.setToSave(false);

            // To delete
        } else if (toSave.isToDelete()) {
            // Remove to parent
            parent.removeChildren(bean.getWikittyId());

            // Save
            deleteThesaurus(toSave);
            log.debug("Saving thesaurus : " + bean.getName());

        }
        Collection<Thesaurus> children = toSave.getChildren();
        if (children != null) {
            for (Thesaurus child : children) {
                saveThesaurus(child);
            }
        }
    }

    // REQUEST
    public void openRequest(JAXXContext rootContext, String request) {

        DateFormTypeFilterHandler criteriaHandler = VradiContext.CRITERIA_HANDLER_ENTRY_DEF.getContextValue(rootContext);

        DateFormTypeFilterUI criterias = criteriaHandler.initCloneUI(rootContext);

        AdminRequestUI requestUI = new AdminRequestUI(rootContext);
        requestUI.setCriterias(criterias);

        requestUI.getCriteriaPanel().add(criterias, BorderLayout.CENTER);
        requestUI.show(request);

        RequestSelectUI ui = (RequestSelectUI) rootContext;
        ui.setBean(requestUI.getBean());
    }

    // CLIENT

    public List<Client> getAllClients(JAXXContext context) {
        List<Client> values = VradiNavigationTreeHelper.CLIENTS.getContextValue(context);
        // always return a safe copy
        return new ArrayList<Client>(values);
    }

    public List<User> getAllUsers(JAXXContext context) {
        List<User> values = VradiNavigationTreeHelper.USERS.getContextValue(context);
        // always return a safe copy
        return new ArrayList<User>(values);
    }

    public void createClient(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addClient = helper.addClient(context, getSelectedNode(context, helper), null);
        helper.selectNode(context, addClient);
    }

    // USER

    public void createUser(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addUser = helper.addUser(context, getSelectedNode(context, helper), null);
        helper.selectNode(context, addUser);
    }

    // GROUP

    public List<Group> getAllGroups(JAXXContext context) {
        List<Group> values = VradiNavigationTreeHelper.GROUPS.getContextValue(context);
        // always return a safe copy
        return new ArrayList<Group>(values);
    }

    public void createGroup(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addGroup = helper.addGroup(context, getSelectedNode(context, helper), null);
        helper.selectNode(context, addGroup);
    }

    // FORM

    public List<WikittyExtension> getAllForms(JAXXContext context) {
        List<WikittyExtension> values = VradiNavigationTreeHelper.FORMS.getContextValue(context);
        // always return a safe copy
        return new ArrayList<WikittyExtension>(values);
    }

    public void createFormType(JAXXContext context, VradiNavigationTreeHelper helper) {
        String name = JOptionPane.showInputDialog(getUI(context), _("vradi.adminForm.askName"));

        if (name != null && !name.isEmpty()) {
            WikittyExtension formType = new WikittyExtension(name, WikittyUtil.DEFAULT_VERSION,
                    Form.EXT_FORM, new LinkedHashMap<String, FieldType>());
            NavigationTreeNode addFormType = helper.addFormType(context, getSelectedNode(context, helper), formType);
            helper.selectNode(context, addFormType);
        }
    }

    public void createForms(XmlStream xmlStream) {
        if (xmlStream != null) {
            try {
                String lastItem = getVradiStorageService().getFormsFromXmlStream(xmlStream,
                        VradiHelper.getLastItemOfXmlStream(xmlStream.getName()));
                log.info(lastItem);
                VradiHelper.setLastItemOfXmlStream(xmlStream.getName(), lastItem);
            } catch (TechnicalException ex) {
                log.error("Cant create form : " + ex);
                ErrorDialogUI.showError(ex);
            }
        }
    }

    public void saveFormType(JAXXContext context, VradiNavigationTreeHelper helper, java.util.List<FieldSelectUI> fields, WikittyExtension formType) {
        WikittyExtension newFormType = new WikittyExtension(formType.getName(), formType.getVersion(), formType.getRequires(), null);
        for (FieldSelectUI field : fields) {
            String name = field.getNameValue();
            log.debug(name);
            if (name != null && field.getType() != null) {
                FieldType fieldType = field.getType().getFieldType();
                newFormType.addField(name, fieldType);
            }
        }
        try {
            // up
            getVradiStorageService().updateFormType(newFormType);

            // Refresh nav
            repaintSelectedNode(context, helper);

            // Refresh criteria
            VradiContext.CRITERIA_UI_ENTRY_DEF.getContextValue(context).getFormTypeSelection().setModel(new DefaultComboBoxModel(VradiHelper.getFormTypes()));

        } catch (TechnicalException ex) {
            log.error("Cant adding formType : " + formType.getName() + " id : " + formType.getId() + " caused by : " + ex);
            ErrorDialogUI.showError(ex);
        }
    }

    public List<Form> query(String query) {
        try {
            List<Form> result = getVradiStorageService().findForms(query);
            return result;
        } catch (TechnicalException eee) {
            log.error("Cant execute query : " + eee);
            ErrorDialogUI.showError(eee);
            return null;
        }
    }

    public WikittyExtension getExtension(String extensionName) {
        try {
            return getVradiStorageService().getFormType(extensionName);
        } catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error(e);
                ErrorDialogUI.showError(e);
            }
            return null;
        }
    }
//    public void deleteForm(JAXXContext context, WikittyExtension form){
//        // del
//        if (answerToDelete(context, form.getName())){
//            try {
//                getVradiStorageService(context).deleteFormType(form);
//
//                // Refresh nav
//                AdminNavUI adminFormUI = getUI(context).getAdminFormUI();
//                delItemToNav(adminFormUI, form);
//            } catch (TechnicalException ex) {
//                log.error("Cant deleting user : " + form.getName() + " id : " + form.getId() + " caused by : " + ex);
//            }
//        }
//    }

    // RSS
    public void createXmlStream(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addXmlStream = helper.addXmlStream(context, getSelectedNode(context, helper), null);
        helper.selectNode(context, addXmlStream);
    }

//    public void deleteXmlStream(JAXXContext context, XmlStream xmlStream) {
//        // del
//        if (answerToDelete(context, xmlStream.getUrl())) {
//            try {
//                getVradiStorageService().deleteXmlStream(xmlStream.getWikittyId());
//            } catch (TechnicalException ex) {
//                log.error("Cant deleting xmlStream : " + xmlStream.getUrl() + " id : " + xmlStream.getWikittyId() + " caused by : " + ex);
//            }
//        }
//    }

//    public VradiXmlStreamDTO saveXmlStream(JAXXContext context, VradiNavigationTreeHelper helper,
//                                           XmlStream xmlStream, List<XmlFieldBinding> bindings) {
//        VradiXmlStreamDTO result = new VradiXmlStreamDTO();
//        result.fromWikitty(xmlStream);
//        try {
//            getVradiStorageService().updateXmlFieldBindings(bindings);
//            xmlStream.clearXmlFieldBinding();
//            for (XmlFieldBinding binding : bindings) {
//                xmlStream.addXmlFieldBinding(binding.getWikittyId());
//            }
//            xmlStream = getVradiStorageService().updateXmlStream(xmlStream);
//            result.fromWikitty(xmlStream);
//
//            // Refresh nav
//            repaintSelectedNode(context, helper);
//        } catch (TechnicalException ex) {
//            log.error("Cant adding client : " + xmlStream.getUrl() + " id : " + xmlStream.getWikittyId() + " caused by : " + ex);
//        }
//        return result;
//    }

    public XmlStream saveXmlStream(JAXXContext context, VradiNavigationTreeHelper helper,
                                   XmlStream xmlStream, List<XmlFieldBinding> bindings) {
        XmlStream result = null;
        try {
            bindings = getVradiStorageService().updateXmlFieldBindings(bindings);
            xmlStream.clearXmlFieldBinding();
            for (XmlFieldBinding binding : bindings) {
                log.debug(binding.getFormField() + " : " + (binding.getXmlField() != null ? binding.getXmlField().size() : "null"));
                xmlStream.addXmlFieldBinding(binding.getWikittyId());
            }
            result = (XmlStream) getVradiStorageService().updateEntity(xmlStream);
            for (String s : result.getXmlFieldBinding()) {
                log.debug(getVradiStorageService().getXmlFieldBinding(s).getXmlField());
            }

            // Refresh nav
            repaintSelectedNode(context, helper);
        } catch (TechnicalException ex) {
            log.error("Cant adding client : " + xmlStream.getUrl() + " id : " + xmlStream.getWikittyId() + " caused by : " + ex);
            ErrorDialogUI.showError(ex);
        }
        return result;
    }

//    public List<String> getXmlStreamAttributes(String url) {
//        List<String> xmlFields = new ArrayList<String>();
//        try {
//            xmlFields = getXmlStreamService().getRSSFields(url);
//        } catch (TechnicalException eee) {
//            eee.printStackTrace();
//        }
//
//        return xmlFields;
//    }

    public List<XmlFieldBinding> getXmlStreamFields(XmlStream xmlStream) {
        List<XmlFieldBinding> result;
        try {
            result = getVradiStorageService().getXmlFieldBindings(xmlStream);
            for (XmlFieldBinding xmlFieldBinding : result) {
                log.debug(xmlFieldBinding.getFormField() + " : " + xmlFieldBinding.getXmlField());
            }
        } catch (TechnicalException eee) {
            log.error("Cant get xml stream : ", eee);
            ErrorDialogUI.showError(eee);
            result = new ArrayList<XmlFieldBinding>();
        }
        return result;
    }

    public WikittyExtension getFormType(XmlStream xmlStream) {
        List<XmlFieldBinding> bindings = getXmlStreamFields(xmlStream);
        WikittyExtension result = null;
        for (XmlFieldBinding binding : bindings) {
            String formField = binding.getFormField();
            if (formField != null) {
                WikittyExtension formType = getExtension(formField.substring(0,
                        formField.lastIndexOf('.')));
                if (formType != null && !formType.getName().equals(Form.EXT_FORM)) {
                    result = formType;
                    break;
                }
            }
        }
        return result;
    }

    public void updateFieldsModel(AdminXmlStreamUI ui) {

        XmlStreamFieldTableModel fieldsModel = ui.getFieldsModel();
        fieldsModel.setValueIsAdjusting(true);

        try {

            fieldsModel.clear();

            VradiXmlStreamDTO bean = ui.getBean();

            List<XmlFieldBinding> bindings = getXmlStreamFields(bean);

// Je ne vois pas pourquoi l'on arraiterais le traitement dans ce cas, si l'on a toujours rien enregistrer il faut bien pouvoir le faire ?
//            if (bindings == null || bindings.isEmpty()) {
            // pas de binding
//                log.debug("No binding, stop update");
//                return;
//            }

            WikittyExtension formType = bean.getFormType();
            if (formType == null) {
                // pas de type de formulaire
                log.debug("No form type, stop update");
                return;
            }

            String url = bean.getUrl();
            if (url == null || url.trim().isEmpty()) {
                // pas d'url
                log.debug("No url, stop update");
                return;
            }

            // recuperation des chanmps xml disponibles
            List<String> xmlFieldNames = new ArrayList<String>();
            if (xmlStreamFields.get(url) == null) {
                try {
                    xmlFieldNames = getXmlStreamService().getRSSFields(url);
                    xmlStreamFields.put(url, xmlFieldNames);
                } catch (Exception eee) {
                    log.error("Can't bind xml stream : " + eee);
                    JOptionPane.showMessageDialog(ui, _("vradi.adminXmlStream.badURL.message"),
                            _("vradi.adminXmlStream.badURL.title"), JOptionPane.ERROR_MESSAGE);
                    xmlFieldNames = new ArrayList<String>();
                }
            } else {
                xmlFieldNames = xmlStreamFields.get(url);
            }

            // mise a jour de l'univers des valeurs selectionnables
            ui.getContextValue(JListCellEditor.class).updateUniverse(xmlFieldNames);
            ui.getContextValue(JListCellRenderer.class).updateUniverse(xmlFieldNames);

            if (xmlFieldNames.size() > 0) {
                ui.getFieldsTable().setRowHeight(19 * xmlFieldNames.size());
            }

            // recuperation des noms des champs disponibles

            LinkedHashMap<String, XmlFieldBinding> fieldNames = new LinkedHashMap<String, XmlFieldBinding>();

            fieldNames.put(Form.FQ_FIELD_ID, new XmlFieldBindingImpl());
            fieldNames.put(Form.FQ_FIELD_NAME, new XmlFieldBindingImpl());
            fieldNames.put(Form.FQ_FIELD_DATEPUB, new XmlFieldBindingImpl());
            fieldNames.put(Form.FQ_FIELD_DATEPEREMPTION, new XmlFieldBindingImpl());
            for (String fieldName : formType.getFieldNames()) {
                fieldNames.put(formType.getName() + "." + fieldName, new XmlFieldBindingImpl());
            }

            // ajout des bindings existants

            for (XmlFieldBinding binding : bindings) {
                String formField = binding.getFormField();
                log.debug(formField);
                if (fieldNames.get(formField) != null) {
                    fieldNames.put(formField, binding);
                }
            }

            // ajout des nouveaux bindings

            for (String fieldName : fieldNames.keySet()) {
                XmlFieldBinding binding = fieldNames.get(fieldName);
                if (binding != null) {
                    binding.setFormField(fieldName);
                    fieldsModel.addEntry(binding);
                }
            }

        } finally {

            fieldsModel.fireTableDataChanged();
            fieldsModel.setValueIsAdjusting(false);
        }
    }


//    public void fillXmlStreamFields(final AdminXmlStreamUI ui) {
//        List<XmlFieldBinding> bindings = getXmlStreamFields(ui.getBean());
//        ui.getContent().removeAll();
//        Map<String, XmlFieldBinding> bindingMap = new java.util.HashMap<String, XmlFieldBinding>();
//
//        if (bindings != null) {
//            for (XmlFieldBinding binding : bindings) {
//                String formField = binding.getFormField();
//                bindingMap.put(formField, binding);
////                if (ui.getFormType() == null && formField != null) {
////                    WikittyExtension formType = getExtension(formField.substring(0,
////                            formField.lastIndexOf('.')));
////                    if (!formType.getName().equals(Form.EXT_FORM)) {
////                        ui.setFormType(formType);
////                    }
////                }
//            }
//        }
//        List<String> fieldNames = new ArrayList<String>();
//
//        WikittyExtension formType = ui.getBean().getFormType();
//
//        if (formType != null) {
//            fieldNames.add(Form.FQ_FIELD_ID);
//            fieldNames.add(Form.FQ_FIELD_NAME);
//            fieldNames.add(Form.FQ_FIELD_DATEPUB);
//            fieldNames.add(Form.FQ_FIELD_DATEPEREMPTION);
//            for (String fieldName : formType.getFieldNames()) {
//                fieldNames.add(formType.getName() + "." + fieldName);
//            }
//        }
//        List<String> xmlFieldNames = ui.getBean() == null || ui.getBean().getUrl() == null
//                || ui.getBean().getUrl().isEmpty() ? new ArrayList<String>() :
//                getXmlStreamAttributes(ui.getBean().getUrl());
//
//         log.info("xml fields names : "+ xmlFieldNames);
//
//        for (String fieldName : fieldNames) {
//            XmlStreamFieldSelectUI fieldSelectUI = new XmlStreamFieldSelectUI(ui);
//            XmlFieldBinding binding = bindingMap.get(fieldName);
//            if (binding == null) {
//                binding = new XmlFieldBindingImpl();
//                binding.setFormField(fieldName);
//            }
//            fieldSelectUI.setBean(binding);
//            fieldSelectUI.setXmlFields(ui.getBean().getUrl(), xmlFieldNames);
//            ui.getContent().add(fieldSelectUI);
//            fieldSelectUI.addPropertyChangeListener(new PropertyChangeListener() {
//                public void propertyChange(PropertyChangeEvent evt) {
//                    ui.setModified(true);
//                }
//            });
//        }
//    }

    /**
     * Create the model and store it in the given context.
     * <p/>
     *
     * @param context the context where to hold the model
     */
    public void createModel(JAXXContext context) {
        if (log.isDebugEnabled()) {
            log.debug("createModel");
        }
        try {
            List<WikittyExtension> allForms = getVradiStorageService().getAllFormTypes();
            Collections.sort(allForms, FORM_COMPARATOR);
            VradiNavigationTreeHelper.FORMS.setContextValue(context, allForms);

            List<Group> allGroups = getVradiStorageService().getAllGroups();
            Collections.sort(allGroups, GROUP_COMPARATOR);
            VradiNavigationTreeHelper.GROUPS.setContextValue(context, allGroups);

            List<Client> clients = getVradiStorageService().getAllClients();
            Collections.sort(clients, CLIENT_COMPARATOR);
            VradiNavigationTreeHelper.CLIENTS.setContextValue(context, clients);

            List<XmlStream> xmlStreams = getVradiStorageService().getAllXmlStreams();
            Collections.sort(xmlStreams, XML_STREAM_COMPARATOR);
            VradiNavigationTreeHelper.XMLSTREAMS.setContextValue(context, xmlStreams);

            List<User> users = new ArrayList<User>();
            for (Client c : clients) {
                Set<String> usersId = c.getUser();
                if (usersId != null) {
                    for (String userId : usersId) {
                        User user = getVradiStorageService().getUser(userId);
                        users.add(user);
                    }
                }
            }
            Collections.sort(users, USER_COMPARATOR);
            VradiNavigationTreeHelper.USERS.setContextValue(context, users);
        } catch (TechnicalException ex) {
            log.error(ex);
            ErrorDialogUI.showError(ex);
            //FIXME should we do something ??? (return an empty model for example)
        }
    }

    public void executeQuery(AdminRequestUI ui) {
        String query = ui.getRequest().getText().trim();
        DateFormTypeFilterUI criterias = null;
        DateFormTypeFilterHandler criteriasHandler = VradiContext.CRITERIA_HANDLER_ENTRY_DEF.getContextValue(ui);
        OfferListTableModel listTableModel = ui.getResultTableModel();
        if (!ui.isAdvencedSearchCollapsed()) {
            criterias = ui.getCriterias();
        }
        criteriasHandler.executeQuery(ui, criterias, listTableModel, null, query);
    }

    protected static final Comparator<Client> CLIENT_COMPARATOR = new Comparator<Client>() {

        @Override
        public int compare(Client o1, Client o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<User> USER_COMPARATOR = new Comparator<User>() {

        @Override
        public int compare(User o1, User o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<Group> GROUP_COMPARATOR = new Comparator<Group>() {

        @Override
        public int compare(Group o1, Group o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<WikittyExtension> FORM_COMPARATOR = new Comparator<WikittyExtension>() {

        @Override
        public int compare(WikittyExtension o1, WikittyExtension o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<XmlStream> XML_STREAM_COMPARATOR = new Comparator<XmlStream>() {

        @Override
        public int compare(XmlStream o1, XmlStream o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
}

