package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.ui.admin.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.Util;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.VradiContext;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.EntityComboBox;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.n_;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.swing.navigation.NavigationContentUI;
import jaxx.runtime.DataBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AdminContentUI<B extends Object> extends javax.swing.JPanel implements NavigationContentUI, jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.AdminContentUI.class);
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUu27UQBSdXfaRzQNCAiEoAQVIgQB5oU4ISRat2LA8RIgUsQ1je8hOGM+YmXHibRCfwCdAT4NER4UoqCloEL+AEAUt4o7trLPghFXiYjy6j3PPvb7Hb76jopLo3CYOQ0sGXFOPWCtL6+v37E3i6JtEOZL6WkgUP7k8yrfQkNu1K40utJomvZqkV2vC8wUnfFf2XBMNKt1hRLUJ0Rqd6c1wlKqudt1zoR/IHdQuqSzUVz9/5F+6L17nEQp9YDcArcz8LyvtpNBEeepqNAaVtnCVYb4BNCTlG8B3xNhqDCt1F3vkGXqOyk1U8rEEMI3O999yhBHlh75GA7Mr9zEn7KpGliM8azOQVHlYOm2irC2JXWoF1MKuR7m1ZM6a4BqA1xq+H6GUAMMTLn1CCVA/blhahrm1LAQjmKdhwzYTztMm7hC51gDKPYNR29TkmAi4JEFpblkDmo0lDMdUCJP4mLuJqXRDC7ZwO+Z+otdenn2IbUauaTSZUTny9SaUHMwdwjQa7ym5HGgtuIk5ldZUeCvKnk7sEk31FIGNstKNSj95roWKMgAzsGr9u4QPwBWv3+Rf62cAI+/vifEv77+9q+/s3BDUPpkZuksysAu+FD6RmprSx+KFCzRl1TvYn2uhiiIM9BbpaTqD2GriBnJQL/7qJt26hVUbIIrlrx8+Tjz+fATl62iQCezWsYlvoIpuS5iCYG7o31iMGA1vD8A5arjB1BnuCBgxOjrvYo1nbMpdmPtCCEOYzhhCl4ld+fRrfPXt4s4gckDs9J7h6TCKj1CJckY5ieSXKCtTbkO+IoErUgVlaSpn3oN+sruz0Xkxq9NipAfjvhwG5nUlYm1uVgQy2gfIiJ1IpiaYkIcEKweKNBwQOBqbj0cygzX8gOxAk4WDwhrzpX2ITfRBrECdWHJ7YEz10xzhRuPuIWEKmoTaeK8fFMOY6/uwONsXwu1DI9zfpwuD8AdJPr4+jAcAAA==";
    private static final long serialVersionUID = 1L;
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected java.util.Map<?,?> $previousValues = new java.util.HashMap<Object,Object>();
    protected jaxx.runtime.swing.BlockingLayerUI blockLayerUI;
    protected javax.swing.JPanel body;
    protected javax.swing.JButton cancel;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();
    protected java.lang.Boolean modified;
    protected javax.swing.JButton save;
    protected javax.swing.JPanel toolbar;
    private AdminContentUI $JPanel0 = this;
    private jaxx.runtime.swing.Table $Table1;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    private PropertyChangeListener $DataSource3 = new DataBindingListener(this, "blockLayerUI.block");
    private PropertyChangeListener $DataSource7 = new DataBindingListener(this, "cancel.enabled");
    private PropertyChangeListener $DataSource9 = new DataBindingListener(this, "save.enabled");

    /* begin raw body code */    
    
    /**
     * @return the editing bean of the content
     */
    public abstract B getBean();
    
    /**
     * Transfert incmoing {@code bean} into the editing bean.
     *
     * @param bean the incoming bean
     */
    protected abstract void updateBeanFromEntity(B bean);
    
    /**
     * Save the editing bean
     */
    public abstract void save();
    
    /**
     * Save the editing bean and unmodify the form
     */
    public void postSave(){
        save();
        setModified(false);
    }
    
    @Override
    public void openUI(NavigationTreeNode node) throws Exception {
        log.info("selected path " + getHelper().getSelectedPath(this));
        B bean = getSelectedEntity();
        log.info("selected bean " + bean);
        updateBeanFromEntity(bean);
        setEnabled(bean != null);
        // always reset to false since updateBean will update modified property
        setModified(false);
    }
    
    /**
     * @return the incoming bean to transfert to editing bean from selected bean
     */
    public B getSelectedEntity() {
        // obtain entity
        Object bean = getHelper().getSelectedBean(this);
        if (bean  instanceof java.util.List<?> || bean  == null) {
            bean  = null;
        }
        return (B) bean;
    }
    
    @Override
    public void closeUI(NavigationTreeNode node) throws Exception {
    }
    
    protected VradiNavigationTreeHelper getHelper() {
        return getContextValue(VradiNavigationTreeHelper.class);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected Icon updateCollapseIcon(boolean c) {
        String key = c ? "collapseIcon" : "expandIcon";
        Icon i = (Icon) getClientProperty(key);
        return i;
    }
    
    protected void addBeanModifiedPCS(VradiDTO bean) {
        bean.addPropertyChangeListener(new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (isEnabled()) {
                    setModified(true);
                }
            }
        });
    }
    
    protected void addBeanPCSLogger(VradiDTO bean) {
        bean.addPropertyChangeListener(new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug("bean." + evt.getPropertyName() + " <" + evt.getOldValue() + ":" + evt.getNewValue() + ">");
                }
            }
        });
    }
    
    protected void addPCSLogger() {
        addPropertyChangeListener(new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug("ui." + evt.getPropertyName() + " <" + evt.getOldValue() + ":" + evt.getNewValue() + ">");
                }
            }
        });
    }
    
    void $afterCompleteSetup() {
        SwingUtil.getLayer(body).setUI(blockLayerUI);
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public AdminContentUI() {
        $initialize();
    }

    public AdminContentUI(jaxx.runtime.JAXXContext parentContext) {
        jaxx.runtime.Util.initContext(this, parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ("blockLayerUI.block".equals($binding)) {    
            addPropertyChangeListener("enabled", $DataSource3);
        } else if ("cancel.enabled".equals($binding)) {    
            addPropertyChangeListener("enabled", $DataSource7);
        } else if ("save.enabled".equals($binding)) {    
            addPropertyChangeListener("modified", $DataSource9);
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("blockLayerUI.block".equals($dest)) {
                blockLayerUI.setBlock(!isEnabled());
            } else if ("cancel.enabled".equals($dest)) {
                cancel.setEnabled(isEnabled());
            } else if ("save.enabled".equals($dest)) {
                save.setEnabled(isModified());
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ("blockLayerUI.block".equals($binding)) {    
            removePropertyChangeListener("enabled", $DataSource3);
        } else if ("cancel.enabled".equals($binding)) {    
            removePropertyChangeListener("enabled", $DataSource7);
        } else if ("save.enabled".equals($binding)) {    
            removePropertyChangeListener("modified", $DataSource9);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return Util.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return Util.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        getHandler().cancel(this, getHelper());
    }

    public void doActionPerformed__on__save(java.awt.event.ActionEvent event) {
        postSave();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public jaxx.runtime.swing.BlockingLayerUI getBlockLayerUI() {
        return blockLayerUI;
    }

    public javax.swing.JPanel getBody() {
        return body;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public javax.swing.JPanel getToolbar() {
        return toolbar;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange("modified", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add(toolbar, BorderLayout.NORTH);
        add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(body), BorderLayout.CENTER);
        add($Table1, BorderLayout.SOUTH);
        // inline complete setup of $Table1
        $Table1.add(cancel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(save, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // init data bindings
        applyDataBinding("blockLayerUI.block");
        blockLayerUI.setBlockingColor(UIManager.getColor("BlockingLayerUI.blockingColor"));
        cancel.setIcon(jaxx.runtime.Util.getUIManagerActionIcon("cancel"));
        applyDataBinding("cancel.enabled");
        save.setIcon(jaxx.runtime.Util.getUIManagerActionIcon("save"));
        applyDataBinding("save.enabled");
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createModified();
        createBlockLayerUI();
        createToolbar();
        createBody();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        $Table1.setName("$Table1");
        createCancel();
        createSave();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        $JPanel0.putClientProperty("expandIcon", SwingUtil.createActionIcon("expand"));
        $JPanel0.putClientProperty("collapseIcon", SwingUtil.createActionIcon("collapse"));
        
        $completeSetup();
    }

    protected void createBlockLayerUI() {
        $objectMap.put("blockLayerUI", blockLayerUI = new jaxx.runtime.swing.BlockingLayerUI());
        blockLayerUI.setUseIcon(false);
    }

    protected void createBody() {
        $objectMap.put("body", body = new javax.swing.JPanel());
        body.setName("body");
        body.setLayout(new BorderLayout());
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createSave() {
        $objectMap.put("save", save = new javax.swing.JButton());
        save.setName("save");
        save.setText(_("vradi.common.save"));
        save.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new javax.swing.JPanel());
        toolbar.setName("toolbar");
    }

}