package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.ui.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.Util;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.VradiContext;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.EntityComboBox;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.n_;
import org.jdesktop.swingx.JXDatePicker;
import com.jurismarches.vradi.entities.Form;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.table.TableCellRenderer;
import com.jurismarches.vradi.VradiHelper;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.sharengo.wikitty.TreeNode;
import jaxx.runtime.DataBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OfferListUI extends javax.swing.JSplitPane implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.OfferListUI.class);
    private static String $jaxxObjectDescriptor = "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";
    private static final long serialVersionUID = 1L;
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected java.util.Map<?,?> $previousValues = new java.util.HashMap<Object,Object>();
    protected java.lang.Boolean advencedSearchCollapsed;
    protected javax.swing.JButton clear;
    protected javax.swing.JButton colapse;
    protected org.jdesktop.swingx.JXCollapsiblePane collapsiblePane;
    protected javax.swing.JPanel criteriaPanel;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();
    protected javax.swing.JTabbedPane editTabs;
    protected javax.swing.JLabel formNbLabel;
    protected javax.swing.JTable listTable;
    protected OfferListUI offerList = this;
    protected com.jurismarches.vradi.ui.OfferListTableModel offerListTableModel;
    protected javax.swing.JTextArea request;
    protected javax.swing.ComboBoxModel requestModel;
    protected javax.swing.JComboBox requests;
    protected javax.swing.JButton search;
    private jaxx.runtime.swing.HBox $HBox7;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane4;
    private javax.swing.JScrollPane $JScrollPane6;
    private jaxx.runtime.swing.Table $Table1;
    private jaxx.runtime.swing.Table $Table3;
    private jaxx.runtime.swing.Table $Table5;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    private PropertyChangeListener $DataSource14 = new DataBindingListener(this, "requests.model");
    private PropertyChangeListener $DataSource15 = new DataBindingListener(this, "colapse.text");
    private PropertyChangeListener $DataSource17 = new DataBindingListener(this, "collapsiblePane.collapsed");
    private PropertyChangeListener $DataSource21 = new DataBindingListener(this, "listTable.model");
    private PropertyChangeListener $DataSource22 = new DataBindingListener(this, "formNbLabel.text");

    /* begin raw body code */    
    
    public OfferListHandler getHandler() {
        return getContextValue(OfferListHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
    
        SwingUtil.fixTableColumnWidth(listTable, 2, 60);
    
        // Adding tooltip
        VradiHelper.setI18nTableHeaderRenderer(listTable,
                n_("vradi.offer.name"), n_("vradi.offer.name.tip"),
                n_("vradi.offerEdit.datePub"), n_("vradi.offerEdit.datePub.tip"),
                n_("vradi.offer.statut"), n_("vradi.offer.statut.tip"));
    
        listTable.setDefaultRenderer(JComponent.class, new TableCellRenderer() {
    
            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof JComponent) {
                    return (JComponent)value;
                }
                return new JLabel(value.toString());
            }
        });
    
        listTable.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    getHandler().selectOffer(offerList);
                }
            }
    
        });
        java.util.List<String> queries = getHandler().loadRequests();
        requests.removeAllItems();
        for(String query : queries) {
            requests.addItem(query);
        }
    //    getOfferListTableModel().addToolTip();
    
        JTableHeader header = listTable.getTableHeader();
        header.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == MouseEvent.BUTTON3){
    
                    // Get column selected
                    TableColumnModel columnModel = ((JTableHeader)e.getSource()).getColumnModel();
                    int columnIndex = columnModel.getColumnIndexAtX(e.getX());
                    TableColumn column = columnModel.getColumn(columnIndex);
    
                    if (columnIndex > 2){
                        final String name = (String)column.getHeaderValue();
    
                        // Popup
                        JPopupMenu popup = new JPopupMenu();
                        JMenuItem menuRemoveCriteria = new JMenuItem();
                        menuRemoveCriteria.setText(_("vradi.menu.removeColumn"));
                        menuRemoveCriteria.addActionListener(new ActionListener() {
    
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                removeColumn(name);
                            }
                        });
                        popup.add(menuRemoveCriteria);
    
                        // Show
                        popup.show(listTable, e.getX(), e.getY());
    
                    }
    
                }
            }
        });
        final OfferListUI offerListUI = this;
        request.addKeyListener(new KeyAdapter(){
                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if(keyEvent.getKeyCode() == KeyEvent.VK_ENTER) {
                        getHandler().executeQuery(offerListUI);   
                    }
                }
        });
    
        getHandler().executeQuery(this);
    
    }
    
    protected void removeColumn(String name){
        OfferListTableModel model = (OfferListTableModel)listTable.getModel();
        TreeNode thesaurus = model.getThesaurusByName(name);
        getHandler().removeColumn(OfferListUI.this, thesaurus);
    }
    
    public void updateTableModel(){
        setOfferListTableModel(getHandler().getOfferListTableModel());
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public OfferListUI() {
        $initialize();
    }

    public OfferListUI(jaxx.runtime.JAXXContext parentContext) {
        jaxx.runtime.Util.initContext(this, parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ("requests.model".equals($binding)) {    
            addPropertyChangeListener("requestModel", $DataSource14);
        } else if ("colapse.text".equals($binding)) {    
            addPropertyChangeListener("advencedSearchCollapsed", $DataSource15);
        } else if ("collapsiblePane.collapsed".equals($binding)) {    
            addPropertyChangeListener("advencedSearchCollapsed", $DataSource17);
        } else if ("listTable.model".equals($binding)) {    
            addPropertyChangeListener("offerListTableModel", $DataSource21);
        } else if ("formNbLabel.text".equals($binding)) {    
            addPropertyChangeListener("offerListTableModel", $DataSource22);
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("requests.model".equals($dest)) {
                requests.setModel(getRequestModel());
            } else if ("colapse.text".equals($dest)) {
                colapse.setText(isAdvencedSearchCollapsed() ? _("vradi.criteria.notCollapse") : _("vradi.criteria.collapse"));
            } else if ("collapsiblePane.collapsed".equals($dest)) {
                collapsiblePane.setCollapsed(isAdvencedSearchCollapsed());
            } else if ("listTable.model".equals($dest)) {
                listTable.setModel(getOfferListTableModel());
            } else if ("formNbLabel.text".equals($dest)) {
                formNbLabel.setText(_(getStringValue(getOfferListTableModel().getRowCount())));
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ("requests.model".equals($binding)) {    
            removePropertyChangeListener("requestModel", $DataSource14);
        } else if ("colapse.text".equals($binding)) {    
            removePropertyChangeListener("advencedSearchCollapsed", $DataSource15);
        } else if ("collapsiblePane.collapsed".equals($binding)) {    
            removePropertyChangeListener("advencedSearchCollapsed", $DataSource17);
        } else if ("listTable.model".equals($binding)) {    
            removePropertyChangeListener("offerListTableModel", $DataSource21);
        } else if ("formNbLabel.text".equals($binding)) {    
            removePropertyChangeListener("offerListTableModel", $DataSource22);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return Util.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return Util.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__clear(java.awt.event.ActionEvent event) {
        request.setText("");
    }

    public void doActionPerformed__on__colapse(java.awt.event.ActionEvent event) {
        setAdvencedSearchCollapsed(!isAdvencedSearchCollapsed());
    }

    public void doActionPerformed__on__requests(java.awt.event.ActionEvent event) {
        if(requests.getSelectedItem() != null) {request.setText(requests.getSelectedItem().toString());};
    }

    public void doActionPerformed__on__search(java.awt.event.ActionEvent event) {
        getHandler().executeQuery(this);validate();
    }

    public void doKeyReleased__on__request(java.awt.event.KeyEvent event) {
        {};
    }

    public void doTableChanged__on__offerListTableModel(javax.swing.event.TableModelEvent event) {
        {formNbLabel.setText(String.valueOf(offerListTableModel.getRowCount()));                                 if(offerListTableModel.getRowCount() > 0) {listTable.setAutoCreateRowSorter(true);}                                  else {listTable.setAutoCreateRowSorter(false);}};
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public java.lang.Boolean getAdvencedSearchCollapsed() {
        return advencedSearchCollapsed;
    }

    public javax.swing.JButton getClear() {
        return clear;
    }

    public javax.swing.JButton getColapse() {
        return colapse;
    }

    public org.jdesktop.swingx.JXCollapsiblePane getCollapsiblePane() {
        return collapsiblePane;
    }

    public javax.swing.JPanel getCriteriaPanel() {
        return criteriaPanel;
    }

    public javax.swing.JTabbedPane getEditTabs() {
        return editTabs;
    }

    public javax.swing.JLabel getFormNbLabel() {
        return formNbLabel;
    }

    public javax.swing.JTable getListTable() {
        return listTable;
    }

    public com.jurismarches.vradi.ui.OfferListTableModel getOfferListTableModel() {
        return offerListTableModel;
    }

    public javax.swing.JTextArea getRequest() {
        return request;
    }

    public javax.swing.ComboBoxModel getRequestModel() {
        return requestModel;
    }

    public javax.swing.JComboBox getRequests() {
        return requests;
    }

    public javax.swing.JButton getSearch() {
        return search;
    }

    public java.lang.Boolean isAdvencedSearchCollapsed() {
        return advencedSearchCollapsed !=null && advencedSearchCollapsed;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setAdvencedSearchCollapsed(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.advencedSearchCollapsed;
        this.advencedSearchCollapsed = newValue;
        firePropertyChange("advencedSearchCollapsed", oldValue, newValue);
    }

    public void setOfferListTableModel(com.jurismarches.vradi.ui.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.OfferListTableModel oldValue = this.offerListTableModel;
        this.offerListTableModel = newValue;
        firePropertyChange("offerListTableModel", oldValue, newValue);
    }

    public void setRequestModel(javax.swing.ComboBoxModel newValue) {
        javax.swing.ComboBoxModel oldValue = this.requestModel;
        this.requestModel = newValue;
        firePropertyChange("requestModel", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected jaxx.runtime.swing.HBox get$HBox7() {
        return $HBox7;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane4() {
        return $JScrollPane4;
    }

    protected javax.swing.JScrollPane get$JScrollPane6() {
        return $JScrollPane6;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected jaxx.runtime.swing.Table get$Table3() {
        return $Table3;
    }

    protected jaxx.runtime.swing.Table get$Table5() {
        return $Table5;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToOfferList();
        // inline complete setup of $JPanel0
        $JPanel0.add($Table1, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane6, BorderLayout.CENTER);
        $JPanel0.add($HBox7, BorderLayout.SOUTH);
        // inline complete setup of $Table1
        $Table1.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(requests, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($Table3, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(collapsiblePane, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table3
        $Table3.add($JScrollPane4, new GridBagConstraints(0, 0, 1, 1, 0.9, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table3.add($Table5, new GridBagConstraints(1, 0, 1, 1, 0.1, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JScrollPane4
        $JScrollPane4.getViewport().add(request);
        // inline complete setup of $Table5
        $Table5.add(search, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table5.add(clear, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table5.add(colapse, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToCollapsiblePane();
        // inline complete setup of $JScrollPane6
        $JScrollPane6.getViewport().add(listTable);
        // inline complete setup of $HBox7
        $HBox7.add(formNbLabel);
        $HBox7.add($JLabel8);
        // init data bindings
        setDividerLocation(Integer.MAX_VALUE);
        setDividerSize(0);
        setOrientation(JSplitPane.VERTICAL_SPLIT);
        setResizeWeight(1);
        applyDataBinding("requests.model");
        applyDataBinding("colapse.text");
        collapsiblePane.setAnimated(false);
        applyDataBinding("collapsiblePane.collapsed");
        listTable.setAutoResizeMode(2);
        applyDataBinding("listTable.model");
        applyDataBinding("formNbLabel.text");
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("offerList", this);
        createOfferListTableModel();
        createRequestModel();
        createAdvencedSearchCollapsed();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        $Table1.setName("$Table1");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.list.requests"));
        createRequests();
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new jaxx.runtime.swing.Table());
        $Table3.setName("$Table3");
        // inline creation of $JScrollPane4
        $objectMap.put("$JScrollPane4", $JScrollPane4 = new javax.swing.JScrollPane());
        $JScrollPane4.setName("$JScrollPane4");
        createRequest();
        // inline creation of $Table5
        $objectMap.put("$Table5", $Table5 = new jaxx.runtime.swing.Table());
        $Table5.setName("$Table5");
        createSearch();
        createClear();
        createColapse();
        createCollapsiblePane();
        createCriteriaPanel();
        // inline creation of $JScrollPane6
        $objectMap.put("$JScrollPane6", $JScrollPane6 = new javax.swing.JScrollPane());
        $JScrollPane6.setName("$JScrollPane6");
        createListTable();
        // inline creation of $HBox7
        $objectMap.put("$HBox7", $HBox7 = new jaxx.runtime.swing.HBox());
        $HBox7.setName("$HBox7");
        createFormNbLabel();
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new javax.swing.JLabel());
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("vradi.forms.returned"));
        createEditTabs();
        // inline creation of offerList
        setName("offerList");
        setOneTouchExpandable(true);
        setContinuousLayout(true);
        
        $completeSetup();
    }

    protected void addChildrenToCollapsiblePane() {
        if (!allComponentsCreated) {
            return;
        }
        collapsiblePane.add(criteriaPanel, BorderLayout.CENTER);
    }

    protected void addChildrenToOfferList() {
        if (!allComponentsCreated) {
            return;
        }
        add($JPanel0, JSplitPane.LEFT);
        add(editTabs, JSplitPane.RIGHT);
    }

    protected void createAdvencedSearchCollapsed() {
        $objectMap.put("advencedSearchCollapsed", advencedSearchCollapsed = false);
    }

    protected void createClear() {
        $objectMap.put("clear", clear = new javax.swing.JButton());
        clear.setName("clear");
        clear.setText(_("vradi.criteria.clear"));
        clear.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clear"));
    }

    protected void createColapse() {
        $objectMap.put("colapse", colapse = new javax.swing.JButton());
        colapse.setName("colapse");
        colapse.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__colapse"));
    }

    protected void createCollapsiblePane() {
        $objectMap.put("collapsiblePane", collapsiblePane = new org.jdesktop.swingx.JXCollapsiblePane());
        collapsiblePane.setName("collapsiblePane");
        collapsiblePane.setLayout(new BorderLayout());
    }

    protected void createCriteriaPanel() {
        $objectMap.put("criteriaPanel", criteriaPanel = new javax.swing.JPanel());
        criteriaPanel.setName("criteriaPanel");
        criteriaPanel.setLayout(new BorderLayout());
    }

    protected void createEditTabs() {
        $objectMap.put("editTabs", editTabs = new javax.swing.JTabbedPane());
        editTabs.setName("editTabs");
    }

    protected void createFormNbLabel() {
        $objectMap.put("formNbLabel", formNbLabel = new javax.swing.JLabel());
        formNbLabel.setName("formNbLabel");
    }

    protected void createListTable() {
        $objectMap.put("listTable", listTable = new javax.swing.JTable());
        listTable.setName("listTable");
    }

    protected void createOfferListTableModel() {
        $objectMap.put("offerListTableModel", offerListTableModel = getHandler().getOfferListTableModel());
        offerListTableModel.addTableModelListener(Util.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__offerListTableModel"));
    }

    protected void createRequest() {
        $objectMap.put("request", request = new javax.swing.JTextArea());
        request.setName("request");
        request.setColumns(15);
        request.setLineWrap(true);
        request.setWrapStyleWord(true);
        request.setRows(3);
        request.addKeyListener(Util.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__request"));
    }

    protected void createRequestModel() {
        $objectMap.put("requestModel", requestModel = getHandler().getRequestModel());
    }

    protected void createRequests() {
        $objectMap.put("requests", requests = new javax.swing.JComboBox());
        requests.setName("requests");
        requests.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__requests"));
    }

    protected void createSearch() {
        $objectMap.put("search", search = new javax.swing.JButton());
        search.setName("search");
        search.setText(_("vradi.criteria.search"));
        search.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__search"));
    }

}