/*
 * *##% 
 * vradi-swing
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

/**
 * @author letellier
 */
public class OfferListHandler {

    static private final Log log = LogFactory.getLog(OfferListHandler.class);

    /**
     * Methode pour initialiser l'ui principale sans l'afficher.
     *
     * @param rootContext le context applicatif
     * @param rootHandler
     * @return l'ui instancie et initialisee mais non visible encore
     */
    public OfferListUI initUI(JAXXContext rootContext, VradiMainUIHandler rootHandler) {

        JAXXInitialContext context = new JAXXInitialContext().add(rootContext);

        DateFormTypeFilterHandler criteriaHandler = new DateFormTypeFilterHandler();

        // Show criteria ui
        DateFormTypeFilterUI criteriaUI = criteriaHandler.initUI(rootContext);

        // show main ui
        context.add(this);
        context.add(criteriaHandler);
        context.add(criteriaUI);

        OfferListUI ui = new OfferListUI(context);

        ui.getCriteriaPanel().add(criteriaUI, BorderLayout.CENTER);

        // Saved in context
        VradiContext.OFFERT_LIST_UI_ENTRY_DEF.setContextValue(rootContext, ui);

        return ui;
    }

    public DateFormTypeFilterHandler getCriteriaHandler(JAXXContext context) {
        return context.getContextValue(DateFormTypeFilterHandler.class);
    }

    public OfferListTableModel getOfferListTableModel() {
        List<Form> forms = new ArrayList<Form>();
        Calendar now = new GregorianCalendar();
        now.set(Calendar.HOUR, 0);
        now.set(Calendar.MINUTE, 0);
        now.set(Calendar.MILLISECOND, 0);
        try {
            forms = ServiceHelper.getVradiStorageService().findForms(null, null, null, now.getTime(), now.getTime(), null);
        } catch (TechnicalException eee) {
            log.error("Cant find forms for this day ", eee);
            ErrorDialogUI.showError(eee);
        }
        OfferListTableModel model = new OfferListTableModel(forms);
        return model;
    }

    public void addEditPane(JAXXContext context, final Form data) {
        final OfferListUI ui = getUI(context);
        ui.setDividerLocation(0);
        ui.setResizeWeight(0);
        ui.setDividerSize(10);
        JTabbedPane contentTabbedPane = ui.getEditTabs();
        String id = data.getWikittyId();
        if (contentTabbedPane.indexOfTab(id) < 0) {
            final OfferEditHandler handler = new OfferEditHandler();
            final OfferEditUI editUi = handler.initUI(context, data);
            contentTabbedPane.add(id, editUi);

            final VradiTabHeader panel = new VradiTabHeader();
            panel.getLabel().setText(data.getName());
            panel.setId(id);

            contentTabbedPane.setTabComponentAt(contentTabbedPane.indexOfTab(id), panel);
            panel.getCloseTab().addMouseListener(new javax.swing.event.MouseInputAdapter() {

                @Override
                public void mouseClicked(MouseEvent e) {
                    closePane(panel);
                }
            });
            panel.getDetachTab().addMouseListener(new javax.swing.event.MouseInputAdapter() {

                @Override
                public void mouseClicked(MouseEvent e) {
                    detachPane(e);
                }
            });
            editUi.getAnnuler().addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent e) {
                    closePane(panel);
                }
            });
            editUi.getValidate().addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    handler.save(editUi, data);
                    closePane(panel);
                    ui.getHandler().executeQuery(ui);
                }
            });
        }

        contentTabbedPane.setSelectedIndex(contentTabbedPane.indexOfTab(id));
    }

    protected VradiTabHeader getTabHeader(MouseEvent e) {
        JButton button = (JButton) e.getSource();
        return (VradiTabHeader) button.getParent();
    }

    protected void closePane(VradiTabHeader mytab) {
//        VradiTabHeader mytab = getTabHeader(e);
        OfferListUI ui = mytab.getParentContainer(OfferListUI.class);
        String id = mytab.getId();
        JTabbedPane contentTabbedPane = getContentPane(ui);
        contentTabbedPane.remove(contentTabbedPane.indexOfTab(id));
        allEditPanelRemoved(contentTabbedPane, ui);
        //removeEditPaneFromRef(getOfferEdit(contentTabbedPane, id));
    }

    private void removeEditPaneFromRef(OfferEditUI ui) {
        VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(VradiContext.get()).remove(ui);
    }

    protected void detachPane(MouseEvent e) {
        VradiTabHeader mytab = getTabHeader(e);
        String id = mytab.getId();
        String name = mytab.getLabel().getText();

        OfferListUI ui = mytab.getParentContainer(OfferListUI.class);
        JTabbedPane contentTabbedPane = getContentPane(ui);
        final OfferEditUI content = getOfferEdit(contentTabbedPane, id);

        final JFrame frame = new JFrame(name);

        content.getValidate().addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                closeDetachedPane(frame, content);
            }
        });

        content.getAnnuler().addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                closeDetachedPane(frame, content);
            }
        });

        frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);

        frame.addWindowListener(new WindowAdapter() {

            @Override
            public void windowClosed(WindowEvent e) {
                closeDetachedPane(frame, content);
            }
        });

        frame.setLayout(new BorderLayout());
        frame.add(content, BorderLayout.CENTER);
        frame.setVisible(true);
        frame.setSize(new Dimension(800, 800));
        allEditPanelRemoved(contentTabbedPane, ui);
    }

    protected OfferEditUI getOfferEdit(JTabbedPane contentTabbedPane, String id) {
        return (OfferEditUI) contentTabbedPane.getComponentAt(contentTabbedPane.indexOfTab(id));
    }

    protected void closeDetachedPane(JFrame f, OfferEditUI ui) {
        f.dispose();
        removeEditPaneFromRef(ui);
    }

    public void addEditPane(JAXXContext context, List<Form> datas) {
        for (Form data : datas) {
            addEditPane(context, data);
        }
    }

    protected void allEditPanelRemoved(JTabbedPane contentTabbedPane, OfferListUI ui) {
        if (contentTabbedPane.getTabCount() == 0) {
            ui.setDividerLocation(Integer.MAX_VALUE);
            ui.setResizeWeight(1);
            ui.setDividerSize(0);
        }
    }

    OfferListUI getUI(JAXXContext context) {
        if (context instanceof OfferListUI) {
            return (OfferListUI) context;
        }
        OfferListUI ui = VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    JTabbedPane getContentPane(JAXXContext context) {
        OfferListUI ui = getUI(context);
        return ui.getEditTabs();
    }

    JTabbedPane getContentPane(OfferListUI ui) {
        return ui.getEditTabs();
    }

    protected void selectOffer(JAXXContext context) {
        JTable listTable = getUI(context).listTable;
        int selectedRow = listTable.getSelectedRow();
        selectedRow = listTable.convertRowIndexToModel(selectedRow);
        edit(context, selectedRow, getUI(context).offerListTableModel);
    }

    protected void edit(JAXXContext context, int i, OfferListTableModel model) {
        Form data = null;
        data = model.getDatas().get(i);
        log.debug("Form selected : " + data);
        if (data != null) {
            addEditPane(context, data);
        }
    }

    public void executeQuery(OfferListUI ui) {
        String query = ui.getRequest().getText().trim();
        DateFormTypeFilterUI criterias = null;
        DateFormTypeFilterHandler criteriasHandler = VradiContext.CRITERIA_HANDLER_ENTRY_DEF.getContextValue(ui);
        OfferListTableModel listTableModel = ui.getOfferListTableModel();
        JComboBox combo = ui.getRequests();
        if (!ui.isAdvencedSearchCollapsed()) {
            criterias = VradiContext.CRITERIA_UI_ENTRY_DEF.getContextValue(ui);
        }
        criteriasHandler.executeQuery(ui, criterias, listTableModel, combo, query);
    }

    public ComboBoxModel getRequestModel() {
        return new DefaultComboBoxModel();
    }

    public java.util.List<String> loadRequests() {
        return VradiHelper.loadRequests();
    }

    public void removeColumn(JAXXContext context, TreeNode thesaurus) {

        // Save in properties
        VradiHelper.removeVradiListColumns(thesaurus);

        // Refresh model
        getUI(context).updateTableModel();
    }
}
