/*
 * *##% 
 * vradi-swing
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

import javax.swing.*;
import java.awt.*;
import java.util.ArrayList;
import java.util.List;

/**
 * @author letellier
 */
public class DateFormTypeFilterHandler {

    static private final Log log = LogFactory.getLog(DateFormTypeFilterHandler.class);

    /**
     * Methode pour initialiser l'ui principale sans l'afficher.
     *
     * @param rootContext le context applicatif
     * @return l'ui instancie et initialisee mais non visible encore
     */
    public DateFormTypeFilterUI initUI(JAXXContext rootContext) {
        DateFormTypeFilterUI ui = getUI(rootContext);
        if (ui == null) {

            JAXXInitialContext context = new JAXXInitialContext().add(rootContext);

            // show main ui
            context.add(this);

            ui = new DateFormTypeFilterUI(context);

            initCriteria(ui);

            VradiContext.CRITERIA_UI_ENTRY_DEF.setContextValue(rootContext, ui);
            VradiContext.CRITERIA_HANDLER_ENTRY_DEF.setContextValue(rootContext, this);
        }

        return ui;
    }

    public DateFormTypeFilterUI initCloneUI(JAXXContext rootContext) {

        JAXXInitialContext context = new JAXXInitialContext().add(rootContext);

        // show main ui
        context.add(this);

        DateFormTypeFilterUI ui = new DateFormTypeFilterUI(context);

        initCriteria(ui);

        return ui;
    }

    public DateFormTypeFilterUI getUI(JAXXContext context) {
        if (context instanceof DateFormTypeFilterUI) {
            return (DateFormTypeFilterUI) context;
        }
        return VradiContext.CRITERIA_UI_ENTRY_DEF.getContextValue(context);
    }

    protected JPanel getCriteriaPanel(JAXXContext context) {
        return getUI(context).getCriterias();
    }

    public void initCriteria(JAXXContext context) {
        // Remove existing
        getCriteriaPanel(context).removeAll();

        // Adding root criteria
        TreeNode root = null;
        try {
            root = ServiceHelper.getVradiStorageService().getRootThesaurus();
        } catch (TechnicalException e) {
            log.error("Cant get rootThesaurus : ", e);
            ErrorDialogUI.showError(e);
        }
        addCriteria(context, root, false);

        // Adding saved criteria
        for (String value : VradiHelper.getVradiListCriteria()) {
            addCriteria(context, value, true);
        }
    }

    public void removeCriteria(JAXXContext context, VradiCriteriaField criteriaField) {
        getCriteriaPanel(context).remove(criteriaField);
        getUI(context).validate();
    }

    public void removeCriteriaAndPersist(JAXXContext context, TreeNode bean) {
        VradiCriteriaField criteriaField = ((VradiCriteriaField) context);
        VradiHelper.removeVradiListCriteria(bean);
        removeCriteria(context, criteriaField);
        getUI(context).validate();
    }

    public void addAndPersistCriteria(JAXXContext context, TreeNode node) {
        VradiHelper.addVradiListCriteria(node);
        addCriteria(context, node, true);
    }

    protected void addCriteria(JAXXContext context, String wikittyId, boolean deletable) {
        TreeNode criteria = null;
        try {
            criteria = ServiceHelper.getVradiStorageService().getThesaurus(wikittyId);
        } catch (TechnicalException e) {
            log.error("Cant get thesaurus : " + wikittyId, e);
            ErrorDialogUI.showError(e);
        }

        if (criteria != null) {
            addCriteria(context, criteria, deletable);
        }
    }

    protected void addCriteria(JAXXContext context, TreeNode criteria, boolean deletable) {
        Thesaurus thesCriteria = new Thesaurus(criteria);

        // New criteria field
        VradiCriteriaField criteriaField = new VradiCriteriaField(context);

        // Set Name
        criteriaField.setLabelName(criteria.getName());

        // Set bean
        criteriaField.setBean(criteria);

        // Deletable
        criteriaField.setDeletable(deletable);

        // Apply model
        JComboBox combo = criteriaField.getCombo();
        Thesaurus[] thesArray = new Thesaurus[thesCriteria.getChildren().size() + 1];
        for (int i = 1; i < thesArray.length; i++) {
            thesArray[i] = (Thesaurus) thesCriteria.getChildren().toArray()[i - 1];
        }
        combo.setModel(new DefaultComboBoxModel(thesArray));
        combo.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());

        // Adding to ui
        criteriaField.init();
        getCriteriaPanel(context).add(criteriaField);
        getUI(context).validate();
    }

    protected List<String> getDateFormType(WikittyExtension formType) {
        List<String> result = new ArrayList<String>();
        result.add(Form.FQ_FIELD_DATEPUB);
        result.add(Form.FQ_FIELD_DATEPEREMPTION);
        if (formType != null) {
            for (String name : formType.getFieldNames()) {
                FieldType type = formType.getFieldType(name);
                if (type.getType() == FieldType.TYPE.DATE) {
                    result.add(formType.getName() + "." + name);
                }
            }
        }
        return result;
    }


    public void updateDateSelectionModel(DateFormTypeFilterUI ui) {
        WikittyExtension value = (WikittyExtension) ui.getFormTypeSelection().getSelectedItem();
        List<String> datas = getDateFormType(value);
        ui.getDateTypeSelection().setModel(new DefaultComboBoxModel(datas.toArray()));
        ui.validate();
    }


    public void executeQuery(JAXXContext context, DateFormTypeFilterUI criterias, OfferListTableModel tableModel, JComboBox combo, String request) {
        String query = request.trim();
        List<Form> forms;
        if (criterias == null) {
            log.debug("filter collapsed");
            forms = VradiHelper.executeQuery(query, null, null, null, null, null);
        } else {
            Component[] thesaurusCriteria = criterias.getCriterias().getComponents();
            List<String>[] thesaurus = new ArrayList[thesaurusCriteria.length];
            for (int i = 0; i < thesaurus.length; i++) {
                Thesaurus th = (Thesaurus) ((VradiCriteriaField) thesaurusCriteria[i]).getCombo().getSelectedItem();
                if (th != null) {
                    thesaurus[i] = new ArrayList<String>();
                    thesaurus[i].add(th.getWikittyId());
                    VradiHelper.getThesaurusChildren(th, thesaurus[i]);
                }
            }
            forms = VradiHelper.executeQuery(query, (WikittyExtension) criterias.getFormTypeSelection().getSelectedItem(),
                    (String) criterias.getDateTypeSelection().getSelectedItem(),
                    criterias.getFromDate().getDate(), criterias.getToDate().getDate(), thesaurus);
        }
        if (log.isDebugEnabled()) {
            log.debug("Form found : " + forms.size());
        }

        if (context instanceof OfferListUI) {
            VradiHelper.addRequestToProperties(query);
        }

        // Update models
        if (combo != null) {
            ((DefaultComboBoxModel) combo.getModel()).removeElement(request);
            combo.insertItemAt(request, 0);
            combo.setSelectedIndex(0);
        }
        tableModel.setDatas(forms);
    }

}
