/* *##%
 * Copyright (c) 2009 poussin. All rights reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty;

import java.util.Collection;
import java.util.List;

/**
 * WikittyStorage is used to abstract data and extension storage in WikittyService.
 *
 * @author poussin
 * @version $Revision$
 *
 * Last update: $Date$
 * by : $Author$
 */
public interface WikittyStorage {

    /**
     * Prepare command's List needed to update the storage
     * @param wikitties
     * @param disableAutoVersionIncrement TODO 
     * @return
     */
    public List<Command> prepare(WikittyTransaction transaction, 
            Collection<Wikitty> wikitties, boolean disableAutoVersionIncrement)
            throws WikittyException;

    /**
     * Commit all modification command passed in argument
     * @param wikittyStorageCommandList
     * @return information usefull for client side update data
     */
    public UpdateResponse commit(WikittyTransaction transaction,
            List<Command> wikittyStorageCommandList);

    /**
     * Return true if id exists in storage
     * @param id
     * @return
     */
    public boolean exists(String id);

    /**
     * Return true if wikitty object with this id are marked deleted
     * @param id
     * @return
     */
    public boolean isDeleted(String id);

    /**
     * Restore one wikitty object, if wikitty not found an exception is throw
     * @param id wikitty id
     * @return
     */
    public Wikitty restore(String id, String ... fqFieldName) throws WikittyException;
    
    /**
     * Restore list of wikitty object, if wikitty not found an exception is throw
     * @param id list of wikitty id
     * @param fqFieldName list of field that must be loaded, other fields
     * can be not loaded
     * @return
     */
    public List<Wikitty> restore(Collection<String> id,
            String ... fqFieldName) throws WikittyException;

    /**
     * Delete all object with id argument. If id is not valid or don't exist
     * throw an exception
     * @param idList
     * @return
     */
    public List<Command> delete(List<String> idList) throws WikittyException;

    /**
     * Command update
     */
    static public interface Command {}

}
