/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlFieldBindingImpl;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.XmlStreamService;
import com.jurismarches.vradi.services.dto.VradiXmlStreamDTO;
import com.jurismarches.vradi.ui.DateFormTypeFilterHandler;
import com.jurismarches.vradi.ui.DateFormTypeFilterUI;
import com.jurismarches.vradi.ui.JListCellRenderer;
import com.jurismarches.vradi.ui.OfferEditHandler;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.OfferListTableModel;
import com.jurismarches.vradi.ui.Thesaurus;
import com.jurismarches.vradi.ui.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.admin.AdminContentUI;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.admin.AdminRequestUI;
import com.jurismarches.vradi.ui.admin.AdminThesaurusUI;
import com.jurismarches.vradi.ui.admin.FieldTypeModel;
import com.jurismarches.vradi.ui.admin.VradiNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI;
import com.jurismarches.vradi.ui.admin.content.FieldSelectUI;
import com.jurismarches.vradi.ui.admin.content.RequestSelectUI;
import com.jurismarches.vradi.ui.admin.content.XmlStreamFieldTableModel;
import com.jurismarches.vradi.ui.editors.JListCellEditor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.WikittyExtension;

public class AdminHandler {
    private static final Log log = LogFactory.getLog(AdminHandler.class);
    protected Map<String, List<String>> xmlStreamFields = new HashMap<String, List<String>>();
    protected static final Comparator<Client> CLIENT_COMPARATOR = new Comparator<Client>(){

        @Override
        public int compare(Client o1, Client o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<User> USER_COMPARATOR = new Comparator<User>(){

        @Override
        public int compare(User o1, User o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<Group> GROUP_COMPARATOR = new Comparator<Group>(){

        @Override
        public int compare(Group o1, Group o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<WikittyExtension> FORM_COMPARATOR = new Comparator<WikittyExtension>(){

        @Override
        public int compare(WikittyExtension o1, WikittyExtension o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<XmlStream> XML_STREAM_COMPARATOR = new Comparator<XmlStream>(){

        @Override
        public int compare(XmlStream o1, XmlStream o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    AdminPopupUI getUI(JAXXContext context) {
        if (context instanceof AdminPopupUI) {
            return (AdminPopupUI)context;
        }
        AdminPopupUI ui = (AdminPopupUI)VradiContext.ADMIN_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    void close(JAXXContext context) {
        AdminPopupUI ui = this.getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    protected VradiStorageService getVradiStorageService() {
        return ServiceHelper.getVradiStorageService();
    }

    protected XmlStreamService getXmlStreamService() {
        return ServiceHelper.getXmlStreamService();
    }

    protected boolean answerToDelete(JAXXContext context, String name) {
        AdminPopupUI ui = this.getUI(context);
        int n = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.admin.deleteAnswer") + name + " ?", I18n._((String)"vradi.admin.deleteTitle"), 0);
        return n == 0;
    }

    protected void repaintSelectedNode(JAXXContext context, VradiNavigationTreeHelper helper) {
        helper.repaintNode(context, this.getSelectedNode(context, helper));
    }

    protected NavigationTreeNode getSelectedNode(JAXXContext context, VradiNavigationTreeHelper helper) {
        return helper.getSelectedNode(context);
    }

    public void save(Object bean) {
        BusinessEntity entity = (BusinessEntity)bean;
        try {
            this.getVradiStorageService().updateEntity(entity);
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant saving bean : " + entity + " id : " + entity.getWikittyId() + " caused by : " + (Object)((Object)ex)));
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(JAXXContext context, VradiNavigationTreeHelper helper, Object ... beans) {
        try {
            for (Object bean : beans) {
                log.info((Object)("will save bean " + bean));
                this.save(bean);
            }
        }
        finally {
            this.repaintSelectedNode(context, helper);
        }
    }

    public boolean answerToSave(AdminThesaurusUI content) {
        if (content != null) {
            log.info((Object)("current content  to close " + ((Object)((Object)content)).getClass().getSimpleName() + " : " + content.isModified()));
            if (content.isModified().booleanValue()) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)content), I18n._((String)"vradi.admin.saveThesaurusAnswer") + " ?", I18n._((String)"vradi.admin.saveTitle"), 1);
                switch (n) {
                    case 1: {
                        this.cancelThesaurus((JAXXContext)content, content.getHelper());
                        break;
                    }
                    case 0: {
                        this.saveThesaurus((JAXXContext)content, content.getHelper());
                        break;
                    }
                    case 2: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean answerToSave(AdminContentUI<?> content) {
        if (content != null) {
            log.info((Object)("current content  to close " + content.getClass().getSimpleName() + " : " + content.isModified()));
            if (content.isModified().booleanValue()) {
                int n = JOptionPane.showConfirmDialog(content, I18n._((String)"vradi.admin.saveAnswer") + VradiHelper.getEntityName(content.getBean()) + " ?", I18n._((String)"vradi.admin.saveTitle"), 1);
                switch (n) {
                    case 1: {
                        this.cancel(content, content.getHelper());
                        break;
                    }
                    case 0: {
                        content.postSave();
                        break;
                    }
                    case 2: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(JAXXContext context, VradiNavigationTreeHelper helper, Object bean) {
        BusinessEntity entity = (BusinessEntity)bean;
        try {
            this.getVradiStorageService().deleteEntity(entity);
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant delete bean : " + entity + " id : " + entity.getWikittyId() + " caused by : " + (Object)((Object)ex)));
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        finally {
            NavigationTreeNode parent = helper.removeChildNode(helper.getSelectedNode(context));
            helper.selectNode(context, parent);
        }
    }

    protected <B> void cancel(AdminContentUI<B> content, VradiNavigationTreeHelper helper) {
        B selectedBean = content.getSelectedEntity();
        try {
            content.openUI(helper.getSelectedNode((JAXXContext)content));
        }
        catch (Exception e) {
            log.error((Object)("Cant cancel bean : " + selectedBean + " caused by : " + e), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
    }

    public OfferListTableModel getResultTableModel(List<Form> forms) {
        OfferListTableModel model = new OfferListTableModel(forms);
        return model;
    }

    public ComboBoxModel getTypesModel() {
        FieldTypeModel model = new FieldTypeModel();
        return model;
    }

    public void refreshAllThesaurus(JAXXContext context) {
        List editUIs = (List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refresh ui : " + (editUIs == null ? "is null" : Integer.valueOf(editUIs.size()))));
        }
        if (editUIs != null) {
            for (OfferEditUI editUI : editUIs) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Refresh ui : " + editUI.getData().getName()));
                }
                OfferEditHandler offerEditHandler = new OfferEditHandler();
                offerEditHandler.initThesaurus(context, editUI);
            }
        }
    }

    public Thesaurus getRootThesaurus() {
        try {
            return new Thesaurus(ServiceHelper.getVradiStorageService().getRootThesaurus());
        }
        catch (TechnicalException e) {
            log.error((Object)"Cant get root thesaurus : ", (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
            return null;
        }
    }

    protected NavigationTreeNode getSelectedNode(JAXXContext context, ThesaurusTreeHelper helper) {
        NavigationTreeNode selectedNode = helper.getSelectedNode(context);
        if (selectedNode == null) {
            selectedNode = helper.getRootNode();
        }
        return selectedNode;
    }

    public boolean addChildThesaurusToSelected(JAXXContext context, ThesaurusTreeHelper helper, boolean isRoot) {
        NavigationTreeNode parentNode = this.getSelectedNode(context, helper);
        if (isRoot) {
            parentNode = helper.getRootNode();
        }
        return this.addChildThesaurus(context, helper, parentNode);
    }

    public boolean renameThesaurusSelected(JAXXContext context, ThesaurusTreeHelper helper) {
        NavigationTreeNode selectedNode = this.getSelectedNode(context, helper);
        NavigationTreeNode parentNode = selectedNode.getParent();
        Thesaurus selected = (Thesaurus)selectedNode.getBean(context);
        String name = JOptionPane.showInputDialog(this.getUI(context), (Object)I18n._((String)"vradi.thesaurus.askRenameName"));
        if (name != null && !name.isEmpty()) {
            selected.setName(name);
            selected.setToSave(true);
            selectedNode.setBean((Object)selected);
            helper.repaintNode(context, selectedNode);
            helper.expendNode(context, selectedNode);
            return true;
        }
        return false;
    }

    public boolean deleteThesaurusSelected(JAXXContext context, ThesaurusTreeHelper helper) {
        NavigationTreeNode selectedNode = this.getSelectedNode(context, helper);
        Thesaurus selected = (Thesaurus)selectedNode.getBean(context);
        int result = JOptionPane.showConfirmDialog(this.getUI(context), I18n._((String)"vradi.thesaurus.askdeleteThesaurus") + selected.getRecursifName());
        if (result == 0) {
            selected.setToDelete(true);
            helper.getBuilder().removeNodeFromParent(context, selectedNode);
            return true;
        }
        return false;
    }

    protected void deleteThesaurus(Thesaurus toDelete) {
        try {
            ServiceHelper.getVradiStorageService().deleteEntity((BusinessEntity)toDelete.getBean());
        }
        catch (TechnicalException e) {
            log.error((Object)("Cant delete thesaurus : " + toDelete.getName() + " id : " + toDelete.getWikittyId()), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
    }

    protected boolean addChildThesaurus(JAXXContext context, ThesaurusTreeHelper helper, NavigationTreeNode parentNode) {
        String name = JOptionPane.showInputDialog(this.getUI(context), (Object)I18n._((String)"vradi.thesaurus.askName"));
        if (name != null && !name.isEmpty()) {
            return this.addChildThesaurus(context, helper, parentNode, name) != null;
        }
        return false;
    }

    protected NavigationTreeNode addChildThesaurus(JAXXContext context, ThesaurusTreeHelper helper, NavigationTreeNode parentNode, String name) {
        if (name != null && !name.isEmpty()) {
            Thesaurus thesaurusParent = (Thesaurus)parentNode.getBean(context);
            TreeNode treeNodeParent = thesaurusParent.getBean();
            TreeNodeImpl newTreeNode = new TreeNodeImpl();
            newTreeNode.setName(name);
            treeNodeParent.addChildren(newTreeNode.getWikittyId());
            newTreeNode.setParent(treeNodeParent.getWikittyId());
            Thesaurus newThesaurus = new Thesaurus((TreeNode)newTreeNode);
            newThesaurus.setParent(treeNodeParent);
            thesaurusParent.addChild(newThesaurus);
            newThesaurus.setToSave(true);
            NavigationTreeNode newNode = helper.getBuilder().addThesaurus(context, parentNode, newThesaurus);
            helper.expendNode(context, parentNode);
            return newNode;
        }
        return null;
    }

    public void cancelThesaurus(JAXXContext context, ThesaurusTreeHelper helper) {
        NavigationTreeNode node = helper.getRootNode();
        this.cancelThesaurus(context, helper, node);
    }

    public void cancelThesaurus(JAXXContext context, ThesaurusTreeHelper helper, NavigationTreeNode node) {
        Thesaurus bean = (Thesaurus)node.getBean();
        if (bean.isToSave()) {
            helper.getBuilder().removeNodeFromParent(context, node);
        } else {
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                NavigationTreeNode child = (NavigationTreeNode)children.nextElement();
                this.cancelThesaurus(context, helper, child);
            }
        }
    }

    public void saveThesaurus(JAXXContext context, ThesaurusTreeHelper helper) {
        Thesaurus root = (Thesaurus)helper.getRootNode().getBean(context);
        this.saveThesaurus(root);
        ((DateFormTypeFilterHandler)VradiContext.CRITERIA_HANDLER_ENTRY_DEF.getContextValue(context)).initCriteria(context);
        this.refreshAllThesaurus(context);
    }

    protected void saveThesaurus(Thesaurus toSave) {
        TreeNode bean = toSave.getBean();
        TreeNode parent = toSave.getParent();
        VradiStorageService service = ServiceHelper.getVradiStorageService();
        if (toSave.isToSave()) {
            log.debug((Object)(parent + " " + bean));
            parent.addChildren(bean.getWikittyId());
            try {
                bean = (TreeNode)service.updateEntity((BusinessEntity)bean);
                parent = (TreeNode)service.updateEntity((BusinessEntity)parent);
                log.debug((Object)("Saving thesaurus : " + bean.getName()));
            }
            catch (TechnicalException ex) {
                log.error((Object)("Cant save thesaurus : " + bean.getName() + " id : " + bean.getWikittyId() + " caused by : "), (Throwable)ex);
                ErrorDialogUI.showError((Exception)((Object)ex));
            }
            toSave.setToSave(false);
        } else if (toSave.isToDelete()) {
            parent.removeChildren(bean.getWikittyId());
            this.deleteThesaurus(toSave);
            log.debug((Object)("Saving thesaurus : " + bean.getName()));
        }
        Collection<Thesaurus> children = toSave.getChildren();
        if (children != null) {
            for (Thesaurus child : children) {
                this.saveThesaurus(child);
            }
        }
    }

    public void openRequest(JAXXContext rootContext, String request) {
        DateFormTypeFilterHandler criteriaHandler = (DateFormTypeFilterHandler)VradiContext.CRITERIA_HANDLER_ENTRY_DEF.getContextValue(rootContext);
        DateFormTypeFilterUI criterias = criteriaHandler.initCloneUI(rootContext);
        AdminRequestUI requestUI = new AdminRequestUI(rootContext);
        requestUI.setCriterias(criterias);
        requestUI.getCriteriaPanel().add((Component)criterias, "Center");
        requestUI.show(request);
        RequestSelectUI ui = (RequestSelectUI)rootContext;
        ui.setBean(requestUI.getBean());
    }

    public List<Client> getAllClients(JAXXContext context) {
        List values = (List)VradiNavigationTreeHelper.CLIENTS.getContextValue(context);
        return new ArrayList<Client>(values);
    }

    public List<User> getAllUsers(JAXXContext context) {
        List values = (List)VradiNavigationTreeHelper.USERS.getContextValue(context);
        return new ArrayList<User>(values);
    }

    public void createClient(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addClient = helper.addClient(context, this.getSelectedNode(context, helper), null);
        helper.selectNode(context, addClient);
    }

    public void createUser(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addUser = helper.addUser(context, this.getSelectedNode(context, helper), null);
        helper.selectNode(context, addUser);
    }

    public List<Group> getAllGroups(JAXXContext context) {
        List values = (List)VradiNavigationTreeHelper.GROUPS.getContextValue(context);
        return new ArrayList<Group>(values);
    }

    public void createGroup(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addGroup = helper.addGroup(context, this.getSelectedNode(context, helper), null);
        helper.selectNode(context, addGroup);
    }

    public List<WikittyExtension> getAllForms(JAXXContext context) {
        List values = (List)VradiNavigationTreeHelper.FORMS.getContextValue(context);
        return new ArrayList<WikittyExtension>(values);
    }

    public void createFormType(JAXXContext context, VradiNavigationTreeHelper helper) {
        String name = JOptionPane.showInputDialog(this.getUI(context), (Object)I18n._((String)"vradi.adminForm.askName"));
        if (name != null && !name.isEmpty()) {
            WikittyExtension formType = new WikittyExtension(name, "0.0", "Form", new LinkedHashMap());
            NavigationTreeNode addFormType = helper.addFormType(context, this.getSelectedNode(context, helper), formType);
            helper.selectNode(context, addFormType);
        }
    }

    public void createForms(XmlStream xmlStream) {
        if (xmlStream != null) {
            try {
                String lastItem = this.getVradiStorageService().getFormsFromXmlStream(xmlStream, VradiHelper.getLastItemOfXmlStream(xmlStream.getName()));
                log.info((Object)lastItem);
                VradiHelper.setLastItemOfXmlStream(xmlStream.getName(), lastItem);
            }
            catch (TechnicalException ex) {
                log.error((Object)("Cant create form : " + (Object)((Object)ex)));
                ErrorDialogUI.showError((Exception)((Object)ex));
            }
        }
    }

    public void saveFormType(JAXXContext context, VradiNavigationTreeHelper helper, List<FieldSelectUI> fields, WikittyExtension formType) {
        WikittyExtension newFormType = new WikittyExtension(formType.getName(), formType.getVersion(), formType.getRequires(), null);
        for (FieldSelectUI field : fields) {
            String name = field.getNameValue();
            log.debug((Object)name);
            if (name == null || field.getType() == null) continue;
            FieldType fieldType = field.getType().getFieldType();
            newFormType.addField(name, fieldType);
        }
        try {
            this.getVradiStorageService().updateFormType(newFormType);
            this.repaintSelectedNode(context, helper);
            ((DateFormTypeFilterUI)VradiContext.CRITERIA_UI_ENTRY_DEF.getContextValue(context)).getFormTypeSelection().setModel(new DefaultComboBoxModel<Object>(VradiHelper.getFormTypes()));
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant adding formType : " + formType.getName() + " id : " + formType.getId() + " caused by : " + (Object)((Object)ex)));
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
    }

    public List<Form> query(String query) {
        try {
            List result = this.getVradiStorageService().findForms(query);
            return result;
        }
        catch (TechnicalException eee) {
            log.error((Object)("Cant execute query : " + (Object)((Object)eee)));
            ErrorDialogUI.showError((Exception)((Object)eee));
            return null;
        }
    }

    public WikittyExtension getExtension(String extensionName) {
        try {
            return this.getVradiStorageService().getFormType(extensionName);
        }
        catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
                ErrorDialogUI.showError((Exception)((Object)e));
            }
            return null;
        }
    }

    public void createXmlStream(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addXmlStream = helper.addXmlStream(context, this.getSelectedNode(context, helper), null);
        helper.selectNode(context, addXmlStream);
    }

    public XmlStream saveXmlStream(JAXXContext context, VradiNavigationTreeHelper helper, XmlStream xmlStream, List<XmlFieldBinding> bindings) {
        XmlStream result = null;
        try {
            bindings = this.getVradiStorageService().updateXmlFieldBindings(bindings);
            xmlStream.clearXmlFieldBinding();
            for (XmlFieldBinding binding : bindings) {
                log.debug((Object)(binding.getFormField() + " : " + (binding.getXmlField() != null ? Integer.valueOf(binding.getXmlField().size()) : "null")));
                xmlStream.addXmlFieldBinding(binding.getWikittyId());
            }
            result = (XmlStream)this.getVradiStorageService().updateEntity((BusinessEntity)xmlStream);
            for (String s : result.getXmlFieldBinding()) {
                log.debug((Object)this.getVradiStorageService().getXmlFieldBinding(s).getXmlField());
            }
            this.repaintSelectedNode(context, helper);
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant adding client : " + xmlStream.getUrl() + " id : " + xmlStream.getWikittyId() + " caused by : " + (Object)((Object)ex)));
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        return result;
    }

    public List<XmlFieldBinding> getXmlStreamFields(XmlStream xmlStream) {
        ArrayList<XmlFieldBinding> result;
        try {
            result = this.getVradiStorageService().getXmlFieldBindings(xmlStream);
            for (XmlFieldBinding xmlFieldBinding : result) {
                log.debug((Object)(xmlFieldBinding.getFormField() + " : " + xmlFieldBinding.getXmlField()));
            }
        }
        catch (TechnicalException eee) {
            log.error((Object)"Cant get xml stream : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
            result = new ArrayList<XmlFieldBinding>();
        }
        return result;
    }

    public WikittyExtension getFormType(XmlStream xmlStream) {
        List<XmlFieldBinding> bindings = this.getXmlStreamFields(xmlStream);
        WikittyExtension result = null;
        for (XmlFieldBinding binding : bindings) {
            WikittyExtension formType;
            String formField = binding.getFormField();
            if (formField == null || (formType = this.getExtension(formField.substring(0, formField.lastIndexOf(46)))) == null || formType.getName().equals("Form")) continue;
            result = formType;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFieldsModel(AdminXmlStreamUI ui) {
        XmlStreamFieldTableModel fieldsModel = ui.getFieldsModel();
        fieldsModel.setValueIsAdjusting(true);
        try {
            fieldsModel.clear();
            VradiXmlStreamDTO bean = ui.getBean();
            List<XmlFieldBinding> bindings = this.getXmlStreamFields((XmlStream)bean);
            WikittyExtension formType = bean.getFormType();
            if (formType == null) {
                log.debug((Object)"No form type, stop update");
                return;
            }
            String url = bean.getUrl();
            if (url == null || url.trim().isEmpty()) {
                log.debug((Object)"No url, stop update");
                return;
            }
            List<Object> xmlFieldNames = new ArrayList();
            if (this.xmlStreamFields.get(url) == null) {
                try {
                    xmlFieldNames = this.getXmlStreamService().getRSSFields(url);
                    this.xmlStreamFields.put(url, xmlFieldNames);
                }
                catch (Exception eee) {
                    log.error((Object)("Can't bind xml stream : " + eee));
                    JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.adminXmlStream.badURL.message"), I18n._((String)"vradi.adminXmlStream.badURL.title"), 0);
                    xmlFieldNames = new ArrayList();
                }
            } else {
                xmlFieldNames = this.xmlStreamFields.get(url);
            }
            ui.getContextValue(JListCellEditor.class).updateUniverse(xmlFieldNames);
            ui.getContextValue(JListCellRenderer.class).updateUniverse(xmlFieldNames);
            if (xmlFieldNames.size() > 0) {
                ui.getFieldsTable().setRowHeight(19 * xmlFieldNames.size());
            }
            LinkedHashMap<String, Object> fieldNames = new LinkedHashMap<String, Object>();
            fieldNames.put("Form.id", new XmlFieldBindingImpl());
            fieldNames.put("Form.name", new XmlFieldBindingImpl());
            fieldNames.put("Form.datePub", new XmlFieldBindingImpl());
            fieldNames.put("Form.datePeremption", new XmlFieldBindingImpl());
            for (String fieldName : formType.getFieldNames()) {
                fieldNames.put(formType.getName() + "." + fieldName, new XmlFieldBindingImpl());
            }
            for (XmlFieldBinding binding : bindings) {
                String formField = binding.getFormField();
                log.debug((Object)formField);
                if (fieldNames.get(formField) == null) continue;
                fieldNames.put(formField, binding);
            }
            for (String fieldName : fieldNames.keySet()) {
                XmlFieldBinding binding = (XmlFieldBinding)fieldNames.get(fieldName);
                if (binding == null) continue;
                binding.setFormField(fieldName);
                fieldsModel.addEntry(binding);
            }
        }
        finally {
            fieldsModel.fireTableDataChanged();
            fieldsModel.setValueIsAdjusting(false);
        }
    }

    public void createModel(JAXXContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createModel");
        }
        try {
            List allForms = this.getVradiStorageService().getAllFormTypes();
            Collections.sort(allForms, FORM_COMPARATOR);
            VradiNavigationTreeHelper.FORMS.setContextValue(context, (Object)allForms);
            List allGroups = this.getVradiStorageService().getAllGroups();
            Collections.sort(allGroups, GROUP_COMPARATOR);
            VradiNavigationTreeHelper.GROUPS.setContextValue(context, (Object)allGroups);
            List clients = this.getVradiStorageService().getAllClients();
            Collections.sort(clients, CLIENT_COMPARATOR);
            VradiNavigationTreeHelper.CLIENTS.setContextValue(context, (Object)clients);
            List xmlStreams = this.getVradiStorageService().getAllXmlStreams();
            Collections.sort(xmlStreams, XML_STREAM_COMPARATOR);
            VradiNavigationTreeHelper.XMLSTREAMS.setContextValue(context, (Object)xmlStreams);
            ArrayList<User> users = new ArrayList<User>();
            for (Client c : clients) {
                Set usersId = c.getUser();
                if (usersId == null) continue;
                for (String userId : usersId) {
                    User user = this.getVradiStorageService().getUser(userId);
                    users.add(user);
                }
            }
            Collections.sort(users, USER_COMPARATOR);
            VradiNavigationTreeHelper.USERS.setContextValue(context, users);
        }
        catch (TechnicalException ex) {
            log.error((Object)ex);
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
    }

    public void executeQuery(AdminRequestUI ui) {
        String query = ui.getRequest().getText().trim();
        DateFormTypeFilterUI criterias = null;
        DateFormTypeFilterHandler criteriasHandler = (DateFormTypeFilterHandler)VradiContext.CRITERIA_HANDLER_ENTRY_DEF.getContextValue((JAXXContext)ui);
        OfferListTableModel listTableModel = ui.getResultTableModel();
        if (!ui.isAdvencedSearchCollapsed().booleanValue()) {
            criterias = ui.getCriterias();
        }
        criteriasHandler.executeQuery((JAXXContext)ui, criterias, listTableModel, null, query);
    }
}

