/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.config;

import java.awt.Component;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import jaxx.runtime.swing.editor.ClassCellEditor;
import jaxx.runtime.swing.editor.EnumEditor;
import jaxx.runtime.swing.editor.LocaleEditor;
import jaxx.runtime.swing.editor.config.model.ConfigTableModel;

public class ConfigTableEditor
implements TableCellEditor {
    protected TableCellEditor delegate;
    protected ConfigTableModel model;

    public ConfigTableEditor(ConfigTableModel model) {
        this.model = model;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.delegate = this.findDelegate(table, this.model.getEntry(row).getType());
        return this.delegate.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return !this.hasDelegate() ? null : this.delegate.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return !this.hasDelegate() || this.delegate.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.hasDelegate() && this.delegate.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return !this.hasDelegate() || this.delegate.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        if (this.hasDelegate()) {
            this.delegate.cancelCellEditing();
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        if (this.hasDelegate()) {
            this.delegate.addCellEditorListener(l);
        }
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        if (this.hasDelegate()) {
            this.delegate.removeCellEditorListener(l);
        }
    }

    protected TableCellEditor findDelegate(JTable table, Class<?> type) {
        TableCellEditor defaultEditor;
        TableCellEditor editor = table.getDefaultEditor(type);
        if (editor == (defaultEditor = table.getDefaultEditor(Object.class))) {
            if (type.isEnum()) {
                editor = new DefaultCellEditor((JComboBox<?>)EnumEditor.newEditor(type));
                table.setDefaultEditor(type, editor);
            } else if (type == Class.class) {
                editor = new ClassCellEditor();
                table.setDefaultEditor(type, editor);
            } else if (type.equals(Locale.class)) {
                editor = new DefaultCellEditor((JComboBox<?>)LocaleEditor.newEditor((Locale[])new Locale[0]));
                table.setDefaultEditor(Locale.class, editor);
            } else {
                editor = table.getDefaultEditor(String.class);
            }
        }
        if (editor == null) {
            throw new IllegalStateException("could not find a editor for type +" + type);
        }
        return editor;
    }

    protected boolean hasDelegate() {
        return this.delegate != null;
    }
}

