/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.log.LogSystem;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.store.DataPage;
import org.h2.store.PageInputStream;
import org.h2.store.PageOutputStream;
import org.h2.store.PageStore;
import org.h2.util.BitField;
import org.h2.value.Value;

public class PageLog {
    public static final int UNDO = 1;
    public static final int COMMIT = 2;
    public static final int ADD = 3;
    public static final int REMOVE = 4;
    private final PageStore store;
    private int id;
    private int pos;
    private Trace trace;
    private PageOutputStream pageOut;
    private DataOutputStream out;
    private DataInputStream in;
    private int firstPage;
    private DataPage data;
    private long operation;
    private BitField undo = new BitField();
    private int[] reservedPages = new int[3];

    PageLog(PageStore pageStore, int n) {
        this.store = pageStore;
        this.firstPage = n;
        this.data = pageStore.createDataPage();
        this.trace = pageStore.getTrace();
    }

    void openForWriting(int n) throws SQLException {
        this.id = n;
        this.trace.debug("log openForWriting " + n + " firstPage:" + this.firstPage);
        this.pageOut = new PageOutputStream(this.store, 0, this.firstPage, 8, n, true);
        this.out = new DataOutputStream(this.pageOut);
        try {
            this.out.writeInt(n);
            this.out.flush();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    int openForReading() {
        this.in = new DataInputStream(new PageInputStream(this.store, 0, this.firstPage, 8));
        try {
            this.id = this.in.readInt();
            this.trace.debug("log openForReading " + this.id + " firstPage:" + this.firstPage + " id:" + this.id);
            return this.id;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    void recover(boolean bl) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log recover " + this.id + " undo:" + bl);
        }
        DataPage dataPage = this.store.createDataPage();
        try {
            int n;
            this.pos = 0;
            while ((n = this.in.read()) >= 0) {
                int n2;
                ++this.pos;
                if (n == 1) {
                    n2 = this.in.readInt();
                    this.in.readFully(dataPage.getBytes(), 0, this.store.getPageSize());
                    if (!bl) continue;
                    if (this.trace.isDebugEnabled()) {
                        this.trace.debug("log undo " + n2);
                    }
                    this.store.writePage(n2, dataPage);
                    continue;
                }
                if (n == 3 || n == 4) {
                    n2 = this.in.readInt();
                    int n3 = this.in.readInt();
                    Row row = PageLog.readRow(this.in, dataPage);
                    if (bl) continue;
                    if (this.store.isSessionCommitted(n2, this.id, this.pos)) {
                        if (this.trace.isDebugEnabled()) {
                            this.trace.debug("log redo " + (n == 3 ? "+" : "-") + " table:" + n3 + " " + row);
                        }
                        this.store.redo(n3, row, n == 3);
                        continue;
                    }
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log ignore s:" + n2 + " " + (n == 3 ? "+" : "-") + " table:" + n3 + " " + row);
                    continue;
                }
                if (n == 2) {
                    n2 = this.in.readInt();
                    if (this.trace.isDebugEnabled()) {
                        this.trace.debug("log commit " + n2 + " id:" + this.id + " pos:" + this.pos);
                    }
                    if (!bl) continue;
                    this.store.setLastCommitForSession(n2, this.id, this.pos);
                    continue;
                }
                if (!this.trace.isDebugEnabled()) continue;
                this.trace.debug("log end");
                break;
            }
        }
        catch (EOFException eOFException) {
            this.trace.debug("log recovery stopped: " + eOFException.toString());
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, "recover");
        }
    }

    public static Row readRow(DataInputStream dataInputStream, DataPage dataPage) throws IOException, SQLException {
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        dataPage.reset();
        dataPage.checkCapacity(n2);
        dataInputStream.readFully(dataPage.getBytes(), 0, n2);
        int n3 = dataPage.readInt();
        Value[] valueArray = new Value[n3];
        for (int i = 0; i < n3; ++i) {
            valueArray[i] = dataPage.readValue();
        }
        Row row = new Row(valueArray, 0);
        row.setPos(n);
        return row;
    }

    void addUndo(int n, DataPage dataPage) throws SQLException {
        try {
            if (this.undo.get(n)) {
                return;
            }
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("log undo " + n);
            }
            this.undo.set(n);
            this.reservePages(3);
            this.out.write(1);
            this.out.writeInt(n);
            this.out.write(dataPage.getBytes(), 0, this.store.getPageSize());
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    private void reservePages(int n) throws SQLException {
        int n2;
        if (n > this.reservedPages.length) {
            this.reservedPages = new int[n];
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.reservedPages[n2] = this.store.allocatePage(true);
        }
        for (n2 = n - 1; n2 >= 0; --n2) {
            this.store.freePage(this.reservedPages[n2], false, null);
        }
    }

    void commit(Session session) throws SQLException {
        try {
            LogSystem logSystem;
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("log commit s:" + session.getId());
            }
            if ((logSystem = this.store.getDatabase().getLog()) == null) {
                return;
            }
            this.reservePages(1);
            this.out.write(2);
            this.out.writeInt(session.getId());
            if (logSystem.getFlushOnEachCommit()) {
                this.flush();
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    void logAddOrRemoveRow(Session session, int n, Row row, boolean bl) throws SQLException {
        try {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("log " + (bl ? "+" : "-") + " s:" + session.getId() + " table:" + n + " row:" + row);
            }
            session.addLogPos(0, (int)this.operation);
            row.setLastLog(0, (int)this.operation);
            this.data.reset();
            row.write(this.data);
            this.reservePages(3 + this.data.length() / (this.store.getPageSize() - 10));
            this.out.write(bl ? 3 : 4);
            this.out.writeInt(session.getId());
            this.out.writeInt(n);
            this.out.writeInt(row.getPos());
            this.out.writeInt(this.data.length());
            this.out.write(this.data.getBytes(), 0, this.data.length());
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    void close() throws SQLException {
        try {
            this.trace.debug("log close " + this.id);
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    private void reopen(int n) throws SQLException {
        try {
            this.trace.debug("log reopen");
            this.out.close();
            this.openForWriting(n);
            this.flush();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    void flush() throws SQLException {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    int getId() {
        return this.id;
    }
}

