/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiSegmentReader;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;

public class MultiReader
extends IndexReader {
    protected IndexReader[] subReaders;
    private int[] starts;
    private boolean[] decrefOnClose;
    private Hashtable normsCache = new Hashtable();
    private int maxDoc = 0;
    private int numDocs = -1;
    private boolean hasDeletions = false;
    private byte[] ones;

    public MultiReader(IndexReader[] subReaders) {
        this.initialize(subReaders, true);
    }

    public MultiReader(IndexReader[] subReaders, boolean closeSubReaders) {
        this.initialize(subReaders, closeSubReaders);
    }

    private void initialize(IndexReader[] subReaders, boolean closeSubReaders) {
        this.subReaders = (IndexReader[])subReaders.clone();
        this.starts = new int[subReaders.length + 1];
        this.decrefOnClose = new boolean[subReaders.length];
        for (int i = 0; i < subReaders.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += subReaders[i].maxDoc();
            if (!closeSubReaders) {
                subReaders[i].incRef();
                this.decrefOnClose[i] = true;
            } else {
                this.decrefOnClose[i] = false;
            }
            if (!subReaders[i].hasDeletions()) continue;
            this.hasDeletions = true;
        }
        this.starts[subReaders.length] = this.maxDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexReader reopen() throws CorruptIndexException, IOException {
        this.ensureOpen();
        boolean reopened = false;
        IndexReader[] newSubReaders = new IndexReader[this.subReaders.length];
        boolean[] newDecrefOnClose = new boolean[this.subReaders.length];
        boolean success = false;
        try {
            int i;
            for (i = 0; i < this.subReaders.length; ++i) {
                newSubReaders[i] = this.subReaders[i].reopen();
                if (newSubReaders[i] == this.subReaders[i]) continue;
                reopened = true;
                newDecrefOnClose[i] = false;
            }
            if (reopened) {
                for (i = 0; i < this.subReaders.length; ++i) {
                    if (newSubReaders[i] != this.subReaders[i]) continue;
                    newSubReaders[i].incRef();
                    newDecrefOnClose[i] = true;
                }
                MultiReader mr = new MultiReader(newSubReaders);
                mr.decrefOnClose = newDecrefOnClose;
                success = true;
                MultiReader multiReader = mr;
                return multiReader;
            }
            success = true;
            MultiReader multiReader = this;
            return multiReader;
        }
        finally {
            if (!success && reopened) {
                for (int i = 0; i < newSubReaders.length; ++i) {
                    if (newSubReaders[i] == null) continue;
                    try {
                        if (newDecrefOnClose[i]) {
                            newSubReaders[i].decRef();
                            continue;
                        }
                        newSubReaders[i].close();
                        continue;
                    }
                    catch (IOException ignore) {}
                }
            }
        }
    }

    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVectors(n - this.starts[i]);
    }

    public TermFreqVector getTermFreqVector(int n, String field) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVector(n - this.starts[i], field);
    }

    public void getTermFreqVector(int docNumber, String field, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(docNumber);
        this.subReaders[i].getTermFreqVector(docNumber - this.starts[i], field, mapper);
    }

    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(docNumber);
        this.subReaders[i].getTermFreqVector(docNumber - this.starts[i], mapper);
    }

    public boolean isOptimized() {
        return false;
    }

    public synchronized int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                n += this.subReaders[i].numDocs();
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].document(n - this.starts[i], fieldSelector);
    }

    public boolean isDeleted(int n) {
        int i = this.readerIndex(n);
        return this.subReaders[i].isDeleted(n - this.starts[i]);
    }

    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    protected void doDelete(int n) throws CorruptIndexException, IOException {
        this.numDocs = -1;
        int i = this.readerIndex(n);
        this.subReaders[i].deleteDocument(n - this.starts[i]);
        this.hasDeletions = true;
    }

    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].undeleteAll();
        }
        this.hasDeletions = false;
        this.numDocs = -1;
    }

    private int readerIndex(int n) {
        return MultiSegmentReader.readerIndex(n, this.starts, this.subReaders.length);
    }

    public boolean hasNorms(String field) throws IOException {
        this.ensureOpen();
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (!this.subReaders[i].hasNorms(field)) continue;
            return true;
        }
        return false;
    }

    private byte[] fakeNorms() {
        if (this.ones == null) {
            this.ones = SegmentReader.createFakeNorms(this.maxDoc());
        }
        return this.ones;
    }

    public synchronized byte[] norms(String field) throws IOException {
        this.ensureOpen();
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes != null) {
            return bytes;
        }
        if (!this.hasNorms(field)) {
            return this.fakeNorms();
        }
        bytes = new byte[this.maxDoc()];
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, bytes, this.starts[i]);
        }
        this.normsCache.put(field, bytes);
        return bytes;
    }

    public synchronized void norms(String field, byte[] result, int offset) throws IOException {
        this.ensureOpen();
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes == null && !this.hasNorms(field)) {
            bytes = this.fakeNorms();
        }
        if (bytes != null) {
            System.arraycopy(bytes, 0, result, offset, this.maxDoc());
        }
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, result, offset + this.starts[i]);
        }
    }

    protected void doSetNorm(int n, String field, byte value) throws CorruptIndexException, IOException {
        this.normsCache.remove(field);
        int i = this.readerIndex(n);
        this.subReaders[i].setNorm(n - this.starts[i], field, value);
    }

    public TermEnum terms() throws IOException {
        this.ensureOpen();
        return new MultiSegmentReader.MultiTermEnum(this.subReaders, this.starts, null);
    }

    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        return new MultiSegmentReader.MultiTermEnum(this.subReaders, this.starts, term);
    }

    public int docFreq(Term t) throws IOException {
        this.ensureOpen();
        int total = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            total += this.subReaders[i].docFreq(t);
        }
        return total;
    }

    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return new MultiSegmentReader.MultiTermDocs(this.subReaders, this.starts);
    }

    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return new MultiSegmentReader.MultiTermPositions(this.subReaders, this.starts);
    }

    protected void doCommit() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].commit();
        }
    }

    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (this.decrefOnClose[i]) {
                this.subReaders[i].decRef();
                continue;
            }
            this.subReaders[i].close();
        }
    }

    public Collection getFieldNames(IndexReader.FieldOption fieldNames) {
        this.ensureOpen();
        return MultiSegmentReader.getFieldNames(fieldNames, this.subReaders);
    }

    public boolean isCurrent() throws CorruptIndexException, IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (this.subReaders[i].isCurrent()) continue;
            return false;
        }
        return true;
    }

    public long getVersion() {
        throw new UnsupportedOperationException("MultiReader does not support this method.");
    }

    IndexReader[] getSubReaders() {
        return this.subReaders;
    }
}

